/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;

public class FinishedOnRestoreInput<IN>
implements Input<IN> {
    private final RecordWriterOutput<?>[] streamOutputs;
    private final int inputCount;
    private int watermarksSeen = 0;

    public FinishedOnRestoreInput(RecordWriterOutput<?>[] streamOutputs, int inputCount) {
        this.streamOutputs = streamOutputs;
        this.inputCount = inputCount;
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public void processWatermark(Watermark watermark) {
        if (watermark.getTimestamp() != Watermark.MAX_WATERMARK.getTimestamp()) {
            throw new IllegalStateException(String.format("We should not receive any watermarks [%s] other than the MAX_WATERMARK if finished on restore", watermark));
        }
        if (++this.watermarksSeen == this.inputCount) {
            for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                streamOutput.emitWatermark(watermark);
            }
        }
    }

    @Override
    public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public void setKeyContextElement(StreamRecord<IN> record) throws Exception {
        throw new IllegalStateException();
    }
}

