/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.insertupdate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateKeyField;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateMeta;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateValue;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class InsertUpdateDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = InsertUpdateMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TableView wKey;
    private TextVar wSchema;
    private TextVar wTable;
    private TableView wReturn;
    private TextVar wCommit;
    private Button wUpdateBypassed;
    private final InsertUpdateMeta input;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private final List<ColumnInfo> inputFieldColumns = new ArrayList<ColumnInfo>();

    public InsertUpdateDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (InsertUpdateMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertUpdateDialog.this.input.setChanged();
                InsertUpdateDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlCommit = new Label((Composite)this.shell, 131072);
        wlCommit.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.CommitSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdlCommit.right = new FormAttachment(middle, -margin);
        wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlUpdateBypassed = new Label((Composite)this.shell, 131072);
        wlUpdateBypassed.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.UpdateBypassed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUpdateBypassed);
        FormData fdlUpdateBypassed = new FormData();
        fdlUpdateBypassed.left = new FormAttachment(0, 0);
        fdlUpdateBypassed.top = new FormAttachment((Control)this.wCommit, margin);
        fdlUpdateBypassed.right = new FormAttachment(middle, -margin);
        wlUpdateBypassed.setLayoutData((Object)fdlUpdateBypassed);
        this.wUpdateBypassed = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wUpdateBypassed);
        FormData fdUpdateBypassed = new FormData();
        fdUpdateBypassed.left = new FormAttachment(middle, 0);
        fdUpdateBypassed.top = new FormAttachment((Control)wlUpdateBypassed, 0, 0x1000000);
        fdUpdateBypassed.right = new FormAttachment(100, 0);
        this.wUpdateBypassed.setLayoutData((Object)fdUpdateBypassed);
        this.wUpdateBypassed.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlKey = new Label((Composite)this.shell, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.Keys.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wUpdateBypassed, margin);
        wlKey.setLayoutData((Object)fdlKey);
        int nrKeyCols = 4;
        int nrKeyRows = this.input.getInsertUpdateLookupField().getLookupKeys() != null ? this.input.getInsertUpdateLookupField().getLookupKeys().size() : 1;
        ColumnInfo[] ciKey = new ColumnInfo[nrKeyCols];
        ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, new String[]{"=", "= ~NULL", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"});
        ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.ColumnInfo.StreamField1", (String[])new String[0]), 2, new String[]{""}, false);
        ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.ColumnInfo.StreamField2", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(ciKey[0]);
        this.inputFieldColumns.add(ciKey[2]);
        this.inputFieldColumns.add(ciKey[3]);
        this.wKey = new TableView(this.variables, (Composite)this.shell, 68354, ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(100, 0);
        this.fdGet.top = new FormAttachment((Control)wlKey, margin);
        this.wGet.setLayoutData((Object)this.fdGet);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment((Control)this.wGet, -margin);
        fdKey.bottom = new FormAttachment((Control)wlKey, 190);
        this.wKey.setLayoutData((Object)fdKey);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wSql = new Button((Composite)this.shell, 8);
        this.wSql.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.SQL.Button", (String[])new String[0]));
        this.wSql.addListener(13, e -> this.create());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wSql, this.wCancel}, margin, null);
        Label wlReturn = new Label((Composite)this.shell, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.UpdateFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)this.wKey, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 3;
        int upInsRows = this.input.getInsertUpdateLookupField().getValueFields() != null ? this.input.getInsertUpdateLookupField().getValueFields().size() : 1;
        ColumnInfo[] ciReturn = new ColumnInfo[upInsCols];
        ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.ColumnInfo.Update", (String[])new String[0]), 2, new String[]{"Y", "N"});
        this.tableFieldColumns.add(ciReturn[0]);
        this.inputFieldColumns.add(ciReturn[1]);
        this.wReturn = new TableView(this.variables, (Composite)this.shell, 68354, ciReturn, upInsRows, lsMod, this.props);
        Button wGetLU = new Button((Composite)this.shell, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.GetAndUpdateFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wlReturn, margin);
        fdGetLU.right = new FormAttachment(100, 0);
        wGetLU.setLayoutData((Object)fdGetLU);
        Button wDoMapping = new Button((Composite)this.shell, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wGetLU, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wDoMapping.addListener(13, arg0 -> this.generateMappings());
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)wGetLU, -margin);
        fdReturn.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        this.wGet.addListener(13, e -> this.get());
        wGetLU.addListener(13, e -> this.getUpdate());
        wbSchema.addListener(13, e -> this.getSchemaName());
        wbTable.addListener(13, e -> this.getTableName());
        this.getData();
        this.setInputFieldCombo();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setInputFieldCombo() {
        this.shell.getDisplay().asyncExec(() -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    String[] fieldNames = Const.sortStrings((String[])rowMeta.getFieldNames());
                    for (ColumnInfo colInfo : this.inputFieldColumns) {
                        colInfo.setComboValues(fieldNames);
                    }
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        });
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"InsertUpdateDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"InsertUpdateDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setConnection(this.wConnection.getText());
        this.input.getInsertUpdateLookupField().setTableName(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMetaInterface = this.transformMeta.getTransform();
        try {
            targetFields = transformMetaInterface.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"InsertUpdateDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"InsertUpdateDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        HashMap<String, String> targetUpdateStatus = new HashMap<String, String>();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            targetUpdateStatus.put(item.getText(1), item.getText(3));
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"InsertUpdateDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"InsertUpdateDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"InsertUpdateDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"InsertUpdateDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)292);
            boolean bl = goOn = (answer & 0x20) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
                if (targetUpdateStatus.get(item.getText(1)) == null) {
                    item.setText(3, "Y");
                    continue;
                }
                item.setText(3, (String)targetUpdateStatus.get(item.getText(1)));
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wCommit.setText(this.input.getCommitSize());
        this.wUpdateBypassed.setSelection(this.input.isUpdateBypassed());
        if (this.input.getInsertUpdateLookupField().getLookupKeys() != null) {
            for (i = 0; i < this.input.getInsertUpdateLookupField().getLookupKeys().size(); ++i) {
                InsertUpdateKeyField keyField = this.input.getInsertUpdateLookupField().getLookupKeys().get(i);
                item = this.wKey.table.getItem(i);
                if (keyField.getKeyLookup() != null) {
                    item.setText(1, keyField.getKeyLookup());
                }
                if (keyField.getKeyCondition() != null) {
                    item.setText(2, keyField.getKeyCondition());
                }
                if (keyField.getKeyStream() != null) {
                    item.setText(3, keyField.getKeyStream());
                }
                if (keyField.getKeyStream2() == null) continue;
                item.setText(4, keyField.getKeyStream2());
            }
        }
        if (this.input.getInsertUpdateLookupField().getValueFields() != null) {
            for (i = 0; i < this.input.getInsertUpdateLookupField().getValueFields().size(); ++i) {
                InsertUpdateValue valueField = this.input.getInsertUpdateLookupField().getValueFields().get(i);
                item = this.wReturn.table.getItem(i);
                if (valueField.getUpdateLookup() != null) {
                    item.setText(1, valueField.getUpdateLookup());
                }
                if (valueField.getUpdateStream() != null) {
                    item.setText(2, valueField.getUpdateStream());
                }
                item.setText(3, valueField.isUpdate() ? "Y" : "N");
            }
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(InsertUpdateMeta inf) {
        TableItem item;
        int i;
        int nrkeys = this.wKey.nrNonEmpty();
        int nrFields = this.wReturn.nrNonEmpty();
        inf.setCommitSize(this.wCommit.getText());
        inf.setUpdateBypassed(this.wUpdateBypassed.getSelection());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.Log.FoundKeys", (String[])new String[]{"" + nrkeys}));
        }
        inf.getInsertUpdateLookupField().getLookupKeys().clear();
        for (i = 0; i < nrkeys; ++i) {
            item = this.wKey.getNonEmpty(i);
            InsertUpdateKeyField keyField = new InsertUpdateKeyField(item.getText(3), item.getText(1), item.getText(2), item.getText(4));
            inf.getInsertUpdateLookupField().getLookupKeys().add(keyField);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.Log.FoundFields", (String[])new String[]{"" + nrFields}));
        }
        inf.getInsertUpdateLookupField().getValueFields().clear();
        for (i = 0; i < nrFields; ++i) {
            item = this.wReturn.getNonEmpty(i);
            InsertUpdateValue valueField = new InsertUpdateValue(item.getText(1), item.getText(2), !"N".equals(item.getText(3)));
            inf.getInsertUpdateLookupField().getValueFields().add(valueField);
        }
        inf.getInsertUpdateLookupField().setSchemaName(this.wSchema.getText());
        inf.getInsertUpdateLookupField().setTableName(this.wTable.getText());
        inf.setConnection(this.wConnection.getText());
        this.transformName = this.wTransformName.getText();
    }

    private void setTableFieldCombo() {
        this.shell.getDisplay().asyncExec(() -> {
            block12: {
                if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                    DatabaseMeta databaseMeta;
                    String tableName = this.wTable.getText();
                    String connectionName = this.wConnection.getText();
                    String schemaName = this.wSchema.getText();
                    for (ColumnInfo colInfo : this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables)) != null) {
                        try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                            String[] fieldNames;
                            database.connect();
                            IRowMeta rowMeta = database.getTableFieldsMeta(this.variables.resolve(schemaName), this.variables.resolve(tableName));
                            if (null == rowMeta || null == (fieldNames = Const.sortStrings((String[])rowMeta.getFieldNames()))) break block12;
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        });
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        if (Utils.isEmpty((CharSequence)this.wConnection.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getSchemaName() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"InsertUpDateDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"InsertUpDateDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"InsertUpDateDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"InsertUpDateDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"InsertUpDateDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
        }
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.Log.LookingAtConnection", (String[])new String[0]) + databaseMeta.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(2, "=");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)1, (int[])new int[]{1, 3}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"InsertUpdateDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"InsertUpdateDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(3, "Y");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"InsertUpdateDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"InsertUpdateDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            InsertUpdateMeta info = new InsertUpdateMeta();
            this.getInfo(info);
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(info.getConnection(), this.variables);
            String name = this.transformName;
            TransformMeta transformMeta = new TransformMeta(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.TransformMeta.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"InsertUpdateDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"InsertUpdateDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"InsertUpdateDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

