/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GroupByKeyViaGroupByKeyOnly<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final @UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> gbkTransform;

    public GroupByKeyViaGroupByKeyOnly(@UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> originalTransform) {
        this.gbkTransform = originalTransform;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
        WindowingStrategy windowingStrategy = input.getWindowingStrategy();
        return ((PCollection)((PCollection)((PCollection)input.apply(new GroupByKeyOnly())).apply(new SortValuesByTimestamp())).apply(new GroupAlsoByWindow(windowingStrategy))).setWindowingStrategyInternal(this.gbkTransform.updateWindowingStrategy(windowingStrategy));
    }

    public static class GroupAlsoByWindow<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, Iterable<WindowedValue<V>>>>, PCollection<KV<K, Iterable<V>>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;

        public GroupAlsoByWindow(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
            this.windowingStrategy = windowingStrategy;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowingStrategy() {
            return this.windowingStrategy;
        }

        private @UnknownKeyFor @NonNull @Initialized KvCoder<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>> getKvCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> inputCoder) {
            Preconditions.checkArgument((boolean)(inputCoder instanceof KvCoder), (String)"%s requires a %s<...> but got %s", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName(), inputCoder);
            KvCoder kvCoder = (KvCoder)inputCoder;
            return kvCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> inputCoder) {
            return this.getKvCoder(inputCoder).getKeyCoder();
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<V> getValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> inputCoder) {
            Coder iterableWindowedValueCoder = this.getKvCoder(inputCoder).getValueCoder();
            Preconditions.checkArgument((boolean)(iterableWindowedValueCoder instanceof IterableCoder), (String)"%s requires a %s<..., %s> but got a %s", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName(), (Object)IterableCoder.class.getSimpleName(), (Object)iterableWindowedValueCoder);
            IterableCoder iterableCoder = (IterableCoder)iterableWindowedValueCoder;
            Coder iterableElementCoder = iterableCoder.getElemCoder();
            Preconditions.checkArgument((boolean)(iterableElementCoder instanceof WindowedValue.WindowedValueCoder), (String)"%s requires a %s<..., %s<%s>> but got a %s", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), KvCoder.class.getSimpleName(), IterableCoder.class.getSimpleName(), WindowedValue.WindowedValueCoder.class.getSimpleName(), iterableElementCoder});
            WindowedValue.WindowedValueCoder windowedValueCoder = (WindowedValue.WindowedValueCoder)iterableElementCoder;
            return windowedValueCoder.getValueCoder();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> input) {
            KvCoder inputKvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = inputKvCoder.getKeyCoder();
            Coder inputValueCoder = inputKvCoder.getValueCoder();
            IterableCoder inputIterableValueCoder = (IterableCoder)inputValueCoder;
            Coder inputIterableElementCoder = inputIterableValueCoder.getElemCoder();
            WindowedValue.WindowedValueCoder inputIterableWindowedValueCoder = (WindowedValue.WindowedValueCoder)inputIterableElementCoder;
            Coder inputIterableElementValueCoder = inputIterableWindowedValueCoder.getValueCoder();
            IterableCoder outputValueCoder = IterableCoder.of((Coder)inputIterableElementValueCoder);
            KvCoder outputKvCoder = KvCoder.of((Coder)keyCoder, (Coder)outputValueCoder);
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), this.windowingStrategy, (PCollection.IsBounded)input.isBounded(), (Coder)outputKvCoder);
        }
    }

    private static class SortValuesByTimestamp<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, Iterable<WindowedValue<V>>>>, PCollection<KV<K, Iterable<WindowedValue<V>>>>> {
        private SortValuesByTimestamp() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> input) {
            return ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, Iterable<WindowedValue<V>>>, KV<K, Iterable<WindowedValue<V>>>>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    KV kvs = (KV)c.element();
                    Object key = kvs.getKey();
                    Iterable unsortedValues = (Iterable)kvs.getValue();
                    ArrayList<WindowedValue> sortedValues = new ArrayList<WindowedValue>();
                    for (WindowedValue value : unsortedValues) {
                        sortedValues.add(value);
                    }
                    sortedValues.sort(Comparator.comparing(WindowedValue::getTimestamp));
                    c.output((Object)KV.of((Object)key, sortedValues));
                }
            }))).setCoder(input.getCoder());
        }
    }

    public static class GroupByKeyOnly<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<WindowedValue<V>>>>> {
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), (Coder)GroupByKey.getOutputKvCoder((Coder)input.getCoder()));
        }
    }
}

