/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dimensionlookup;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IProvidesModelerMeta;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookup;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookupData;

@Transform(id="DimensionLookup", image="dimensionlookup.svg", name="i18n::DimensionUpdate.Name", description="i18n::DimensionUpdate.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.DataWarehouse", keywords={"i18n::DimensionLookupMeta.keyword"}, documentationUrl="/pipeline/transforms/dimensionlookup.html")
public class DimensionLookupMeta
extends BaseTransformMeta<DimensionLookup, DimensionLookupData>
implements IProvidesModelerMeta {
    private static final Class<?> PKG = DimensionLookupMeta.class;
    @HopMetadataProperty(key="schema", injectionKey="TARGET_SCHEMA", injectionKeyDescription="DimensionLookup.Injection.TARGET_SCHEMA")
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKey="TARGET_TABLE", injectionKeyDescription="DimensionLookup.Injection.TARGET_TABLE")
    private String tableName;
    @HopMetadataProperty(key="connection", storeWithName=true, injectionKey="CONNECTION_NAME", injectionKeyDescription="DimensionLookup.Injection.CONNECTION_NAME")
    private DatabaseMeta databaseMeta;
    @HopMetadataProperty(key="update", injectionKey="UPDATE_DIMENSION", injectionKeyDescription="DimensionLookup.Injection.UPDATE_DIMENSION")
    private boolean update;
    @HopMetadataProperty(key="fields", injectionGroupKey="FIELDS")
    private DLFields fields = new DLFields();
    @HopMetadataProperty(key="sequence", injectionKey="TECHNICAL_KEY_SEQUENCE", injectionKeyDescription="DimensionLookup.Injection.TECHNICAL_KEY_SEQUENCE")
    private String sequenceName;
    @HopMetadataProperty(key="commit", injectionKey="COMMIT_SIZE", injectionKeyDescription="DimensionLookup.Injection.COMMIT_SIZE")
    private int commitSize;
    @HopMetadataProperty(key="useBatch")
    private boolean useBatchUpdate;
    @HopMetadataProperty(key="min_year", injectionKey="MIN_YEAR", injectionKeyDescription="DimensionLookup.Injection.MIN_YEAR")
    private int minYear;
    @HopMetadataProperty(key="max_year", injectionKey="MAX_YEAR", injectionKeyDescription="DimensionLookup.Injection.MAX_YEAR")
    private int maxYear;
    @HopMetadataProperty(key="cache_size", injectionKey="CACHE_SIZE", injectionKeyDescription="DimensionLookup.Injection.CACHE_SIZE")
    private int cacheSize;
    @HopMetadataProperty(key="use_start_date_alternative", injectionKey="USE_ALTERNATIVE_START_DATE", injectionKeyDescription="DimensionLookup.Injection.USE_ALTERNATIVE_START_DATE")
    private boolean usingStartDateAlternative;
    @HopMetadataProperty(key="start_date_alternative", storeWithCode=true, injectionKey="ALTERNATIVE_START_OPTION", injectionKeyDescription="DimensionLookup.Injection.ALTERNATIVE_START_OPTION")
    private StartDateAlternative startDateAlternative;
    @HopMetadataProperty(key="start_date_field_name", injectionKey="ALTERNATIVE_START_COLUMN", injectionKeyDescription="DimensionLookup.Injection.ALTERNATIVE_START_COLUMN")
    private String startDateFieldName;
    @HopMetadataProperty(key="preload_cache", injectionKey="PRELOAD_CACHE", injectionKeyDescription="DimensionLookup.Injection.PRELOAD_CACHE")
    private boolean preloadingCache;

    public DimensionLookupMeta() {
    }

    public DimensionLookupMeta clone() {
        return new DimensionLookupMeta(this);
    }

    public DimensionLookupMeta(DimensionLookupMeta m) {
        this();
        this.schemaName = m.schemaName;
        this.tableName = m.tableName;
        this.databaseMeta = this.databaseMeta == null ? null : new DatabaseMeta(m.databaseMeta);
        this.update = m.update;
        this.fields = new DLFields(m.fields);
        this.sequenceName = m.sequenceName;
        this.commitSize = m.commitSize;
        this.useBatchUpdate = m.useBatchUpdate;
        this.minYear = m.minYear;
        this.maxYear = m.maxYear;
        this.cacheSize = m.cacheSize;
        this.usingStartDateAlternative = m.usingStartDateAlternative;
        this.startDateAlternative = m.startDateAlternative;
        this.startDateFieldName = m.startDateFieldName;
        this.preloadingCache = m.preloadingCache;
    }

    public void setDefault() {
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.DefaultTableName", (String[])new String[0]);
        this.databaseMeta = null;
        this.commitSize = 100;
        this.update = true;
        this.fields.date.name = "";
        this.fields.date.from = "date_from";
        this.fields.date.to = "date_to";
        this.minYear = 1900;
        this.maxYear = 2199;
        this.fields.returns.keyField = "";
        this.fields.returns.keyRename = "";
        this.fields.returns.versionField = "version";
        this.cacheSize = 5000;
        this.preloadingCache = false;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.databaseMeta == null) {
            String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToRetrieveDataTypeOfReturnField", (String[])new String[0]);
            this.logError(message);
            throw new HopTransformException(message);
        }
        for (IValueMeta valueMeta : row.getValueMetaList()) {
            valueMeta.setStorageType(0);
            valueMeta.setTrimType(0);
        }
        if (StringUtils.isEmpty((String)this.fields.returns.keyField)) {
            String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Error.NoTechnicalKeySpecified", (String[])new String[0]);
            this.logError(message);
            throw new HopTransformException(message);
        }
        ValueMetaInteger v = new ValueMetaInteger(this.fields.returns.keyField);
        if (StringUtils.isNotEmpty((String)this.fields.returns.keyRename)) {
            v.setName(this.fields.returns.keyRename);
        }
        v.setLength(9);
        v.setPrecision(0);
        v.setOrigin(name);
        row.addValueMeta((IValueMeta)v);
        if (this.update || this.fields.fields.isEmpty()) {
            return;
        }
        try (Database db = new Database(loggingObject, variables, this.databaseMeta);){
            IRowMeta extraFields = db.getTableFieldsMeta(this.schemaName, this.tableName);
            for (DLField field : this.fields.fields) {
                v = extraFields.searchValueMeta(field.getLookup());
                if (v == null) {
                    String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToFindReturnField", (String[])new String[]{field.getLookup()});
                    this.logError(message);
                    throw new HopTransformException(message);
                }
                if (StringUtils.isNotEmpty((String)field.getName())) {
                    v.setName(field.getName());
                }
                v.setOrigin(name);
                row.addValueMeta((IValueMeta)v);
            }
        }
        catch (Exception e) {
            String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToRetrieveDataTypeOfReturnField2", (String[])new String[0]);
            this.logError(message);
            throw new HopTransformException(message, (Throwable)e);
        }
    }

    public Date getMinDate() {
        Calendar mincal = Calendar.getInstance();
        mincal.set(1, this.minYear);
        mincal.set(2, 0);
        mincal.set(5, 1);
        mincal.set(11, 0);
        mincal.set(12, 0);
        mincal.set(13, 0);
        mincal.set(14, 0);
        return mincal.getTime();
    }

    public Date getMaxDate() {
        Calendar mincal = Calendar.getInstance();
        mincal.set(1, this.maxYear);
        mincal.set(2, 11);
        mincal.set(5, 31);
        mincal.set(11, 23);
        mincal.set(12, 59);
        mincal.set(13, 59);
        mincal.set(14, 999);
        return mincal.getTime();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta previousRowMeta, String[] input, String[] output, IRowMeta infoRowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ArrayList<ICheckResult> newRemarks = new ArrayList<ICheckResult>();
        this.checkDatabase(transformMeta, newRemarks);
        this.checkTable(transformMeta, variables, newRemarks);
        if (!newRemarks.isEmpty()) {
            remarks.addAll(newRemarks);
            return;
        }
        String realSchema = variables.resolve(this.schemaName);
        String realTable = variables.resolve(this.tableName);
        try (Database db = new Database(loggingObject, variables, this.databaseMeta);){
            db.connect();
            IRowMeta tableRowMeta = this.checkTableFields(transformMeta, db, realSchema, realTable, remarks);
            if (tableRowMeta != null) {
                this.checkKeys(transformMeta, variables, realSchema, realTable, tableRowMeta, previousRowMeta, remarks);
                this.checkReturns(transformMeta, tableRowMeta, remarks);
                this.checkDateFields(transformMeta, tableRowMeta, remarks);
            }
            this.checkPreviousFields(transformMeta, previousRowMeta, remarks);
            this.checkSequence(transformMeta, db, variables, remarks);
        }
        catch (HopException e) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotConectToDB", (String[])new String[0]) + e.getMessage(), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TransformReceiveInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.NoInputReceiveFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    private void checkSequence(TransformMeta transformMeta, Database db, IVariables variables, List<ICheckResult> remarks) throws HopDatabaseException {
        String sequence = variables.resolve(this.sequenceName);
        if (this.databaseMeta.supportsSequences() && this.fields.returns.creationMethod == TechnicalKeyCreationMethod.SEQUENCE && StringUtils.isNotEmpty((String)variables.resolve(sequence))) {
            if (db.checkSequenceExists(sequence)) {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.SequenceExists", (String[])new String[]{sequence}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.SequenceCouldNotFound", (String[])new String[]{sequence}), (ICheckResultSource)transformMeta));
            }
        }
    }

    private void checkPreviousFields(TransformMeta transformMeta, IRowMeta previousFields, List<ICheckResult> remarks) {
        if (previousFields == null) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]), (ICheckResultSource)transformMeta));
            return;
        }
        boolean allOk = true;
        for (DLField field : this.fields.fields) {
            IValueMeta valueMeta;
            DimensionUpdateType updateType = field.getUpdateType();
            if (updateType == null || !updateType.isWithArgument() || (valueMeta = previousFields.searchValueMeta(field.getName())) != null) continue;
            allOk = false;
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.MissingFields", (String[])new String[0]) + " " + field.getName(), (ICheckResultSource)transformMeta));
        }
        if (allOk) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    private void checkDateFields(TransformMeta transformMeta, IRowMeta tableRowMeta, List<ICheckResult> remarks) {
        if (StringUtils.isNotEmpty((String)this.fields.date.from)) {
            if (tableRowMeta.indexOfValue(this.fields.date.from) < 0) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartPointOfDaterangeNotFound", (String[])new String[]{this.fields.date.from}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartPointOfDaterangeFound", (String[])new String[]{this.fields.date.from}), (ICheckResultSource)transformMeta));
            }
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartKeyRequired", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        if (StringUtils.isNotEmpty((String)this.fields.date.to)) {
            if (tableRowMeta.indexOfValue(this.fields.date.to) < 0) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndPointOfDaterangeNotFound", (String[])new String[]{this.fields.date.to}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndPointOfDaterangeFound", (String[])new String[]{this.fields.date.to}), (ICheckResultSource)transformMeta));
            }
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndKeyRequired", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    private void checkReturns(TransformMeta transformMeta, IRowMeta tableRowMeta, List<ICheckResult> remarks) {
        if (StringUtils.isNotEmpty((String)this.fields.returns.keyField)) {
            if (tableRowMeta.indexOfValue(this.fields.returns.keyField) < 0) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyNotFound", (String[])new String[]{this.fields.returns.keyField}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyFound", (String[])new String[]{this.fields.returns.keyField}), (ICheckResultSource)transformMeta));
            }
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyRequired", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        if (StringUtils.isNotEmpty((String)this.fields.returns.versionField)) {
            if (tableRowMeta.indexOfValue(this.fields.returns.versionField) < 0) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldNotFound", (String[])new String[]{this.fields.returns.versionField}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldFound", (String[])new String[]{this.fields.returns.versionField}), (ICheckResultSource)transformMeta));
            }
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionKeyRequired", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        TechnicalKeyCreationMethod method = this.fields.returns.creationMethod;
        if (method == null) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.ErrorTechKeyCreation", (String[])new String[0]) + ": Not specified!", (ICheckResultSource)transformMeta));
        }
    }

    private IRowMeta checkTableFields(TransformMeta transformMeta, Database db, String schemaName, String tableName, List<ICheckResult> remarks) throws HopDatabaseException {
        IRowMeta rowMeta = db.getTableFieldsMeta(schemaName, tableName);
        if (rowMeta == null) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]), (ICheckResultSource)transformMeta));
            return null;
        }
        boolean allOk = true;
        for (DLField field : this.fields.getFields()) {
            IValueMeta v = rowMeta.searchValueMeta(field.getLookup());
            if (v == null) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + field.getName() + " --> " + field.getLookup(), (ICheckResultSource)transformMeta));
                allOk = false;
            }
            if (this.update) {
                if (field.getUpdateType() != null) continue;
                remarks.add((ICheckResult)new CheckResult(4, "The update type specified is not valid for field '" + Const.NVL((String)field.getName(), (String)field.getLookup()) + "' : '" + field.getUpdate() + "'", (ICheckResultSource)transformMeta));
                allOk = false;
                continue;
            }
            int type = ValueMetaFactory.getIdForValueMeta((String)field.getReturnType());
            if (type != 0) continue;
            remarks.add((ICheckResult)new CheckResult(4, "The return type specified is not valid for field '" + Const.NVL((String)field.getName(), (String)field.getLookup()) + "' : '" + field.getReturnType() + "'", (ICheckResultSource)transformMeta));
            allOk = false;
        }
        if (allOk) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllLookupFieldFound", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        return rowMeta;
    }

    private void checkTable(TransformMeta transformMeta, IVariables variables, List<ICheckResult> remarks) {
        if (StringUtils.isEmpty((String)variables.resolve(this.tableName))) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    private void checkDatabase(TransformMeta transformMeta, List<ICheckResult> remarks) {
        if (this.databaseMeta == null) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.InvalidConnectionName", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    private void checkKeys(TransformMeta transformMeta, IVariables variables, String schemaName, String tableName, IRowMeta tableRowMeta, IRowMeta previousRowMeta, List<ICheckResult> remarks) {
        boolean allOk = true;
        for (DLKey key : this.fields.keys) {
            IValueMeta tableValueMeta;
            IValueMeta prevValueMeta = previousRowMeta.searchValueMeta(key.getName());
            if (prevValueMeta == null) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyHasProblem", (String[])new String[0]) + " " + key.getName() + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotPresentInStream", (String[])new String[0]), (ICheckResultSource)transformMeta));
                allOk = false;
            }
            if ((tableValueMeta = tableRowMeta.searchValueMeta(key.getLookup())) == null) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyHasProblem", (String[])new String[0]) + " " + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotPresentInDimensionTable", (String[])new String[0]) + this.databaseMeta.getQuotedSchemaTableCombination(variables, schemaName, tableName), (ICheckResultSource)transformMeta));
                allOk = false;
            }
            if (prevValueMeta == null || tableValueMeta == null || prevValueMeta.getType() == tableValueMeta.getType()) continue;
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyHasProblem", (String[])new String[0]) + " " + prevValueMeta.getName() + " (" + prevValueMeta.getOrigin() + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotTheSameTypeAs", (String[])new String[0]) + tableValueMeta.getName() + " (" + this.databaseMeta.getQuotedSchemaTableCombination(variables, schemaName, tableName) + ")", (ICheckResultSource)transformMeta));
            allOk = false;
        }
        if (allOk) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllKeysFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    public IRowMeta getTableFields(IVariables variables) {
        IRowMeta tableRowMeta = null;
        if (this.databaseMeta != null) {
            try (Database db = this.createDatabaseObject(variables);){
                db.connect();
                tableRowMeta = db.getTableFieldsMeta(this.schemaName, this.tableName);
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.DatabaseErrorOccurred", (String[])new String[0]) + dbe.getMessage());
            }
        }
        return tableRowMeta;
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta previousRowMeta, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SqlStatement statement = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
        this.validateBasicSettings(variables, previousRowMeta);
        if (!this.update) {
            return statement;
        }
        String realSchema = variables.resolve(this.schemaName);
        String realTable = variables.resolve(this.tableName);
        if (StringUtils.isEmpty((String)realTable)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
        }
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, realSchema, realTable);
        try (Database db = new Database(loggingObject, variables, this.databaseMeta);){
            db.connect();
            IRowMeta tableRowMeta = this.buildTableFields(previousRowMeta, statement);
            Object sql = db.getDDL(schemaTable, tableRowMeta, StringUtils.isNotEmpty((String)this.sequenceName) ? null : this.fields.returns.keyField, this.fields.returns.creationMethod == TechnicalKeyCreationMethod.AUTO_INCREMENT, null, true);
            String[] idxFields = new String[this.fields.keys.size()];
            for (int i = 0; i < idxFields.length; ++i) {
                idxFields[i] = this.fields.keys.get(i).getLookup();
            }
            if (!db.checkIndexExists(schemaTable, idxFields)) {
                String indexname = "idx_" + this.tableName + "_lookup";
                sql = (String)sql + db.getCreateIndexStatement(schemaTable, indexname, idxFields, false, false, false, true);
            }
            if (!db.checkIndexExists(schemaTable, idxFields)) {
                String indexName = "idx_" + this.tableName + "_tk";
                sql = (String)sql + db.getCreateIndexStatement(schemaTable, indexName, new String[]{this.fields.returns.keyField}, true, false, true, true);
            }
            if (this.fields.returns.creationMethod == TechnicalKeyCreationMethod.SEQUENCE && StringUtils.isNotEmpty((String)this.sequenceName) && !db.checkSequenceExists(this.schemaName, this.sequenceName)) {
                sql = (String)sql + db.getCreateSequenceStatement(this.schemaName, this.sequenceName, 1L, 1L, -1L, true);
            }
            if (((String)sql).length() == 0) {
                statement.setSql(null);
            } else {
                statement.setSql(variables.resolve((String)sql));
            }
        }
        catch (HopDatabaseException dbe) {
            statement.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + dbe.getMessage());
        }
        return statement;
    }

    private void validateBasicSettings(IVariables variables, IRowMeta previousRowMeta) throws HopTransformException {
        if (this.databaseMeta == null) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoConnectionDefinedInTransform", (String[])new String[0]));
        }
        if (this.fields.keys.isEmpty()) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoKeyFieldsSpecified", (String[])new String[0]));
        }
        if (StringUtils.isEmpty((String)this.fields.returns.keyField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.TechnicalKeyFieldRequired", (String[])new String[0]));
        }
        if (previousRowMeta == null || previousRowMeta.isEmpty()) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
        }
        if (StringUtils.isEmpty((String)variables.resolve(this.tableName))) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
        }
    }

    private IRowMeta buildTableFields(IRowMeta prev, SqlStatement statement) {
        IRowMeta tableRowMeta = new RowMetaBuilder().addInteger(this.fields.returns.keyField, 10).addInteger(this.fields.returns.versionField, 5).addDate(this.fields.date.from).addDate(this.fields.date.to).build();
        ArrayList<Object> errorFields = new ArrayList<Object>();
        for (DLKey key : this.fields.keys) {
            IValueMeta prevValueMeta = prev.searchValueMeta(key.getName());
            if (prevValueMeta == null) {
                errorFields.add(key.getName());
                continue;
            }
            IValueMeta field = prevValueMeta.clone();
            field.setName(key.getLookup());
            tableRowMeta.addValueMeta(field);
        }
        block6: for (DLField field : this.fields.fields) {
            ValueMetaDate valueMeta = null;
            DimensionUpdateType updateType = field.getUpdateType();
            if (updateType == null) {
                errorFields.add("Unknown update type for field: " + field.getName() + " : '" + field.getUpdate());
                break;
            }
            switch (updateType) {
                case DATE_UPDATED: 
                case DATE_INSERTED: 
                case DATE_INSERTED_UPDATED: {
                    valueMeta = new ValueMetaDate(field.getLookup());
                    break;
                }
                case LAST_VERSION: {
                    valueMeta = new ValueMetaBoolean(field.getLookup());
                    break;
                }
                case INSERT: 
                case UPDATE: 
                case PUNCH_THROUGH: {
                    IValueMeta prevValueMeta = prev.searchValueMeta(field.getName());
                    if (prevValueMeta == null) {
                        errorFields.add(field.getName());
                        continue block6;
                    }
                    valueMeta = prevValueMeta.clone();
                    valueMeta.setName(field.getLookup());
                }
            }
            if (valueMeta == null) continue;
            tableRowMeta.addValueMeta(valueMeta);
        }
        if (!errorFields.isEmpty()) {
            statement.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.UnableToFindFields", (String[])new String[0]) + StringUtils.join(errorFields, (String)", "));
        }
        return tableRowMeta;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) {
        if (prev == null) {
            return;
        }
        if (this.update) {
            this.analyzeImpactUpdate(impact, pipelineMeta, transformMeta, prev);
        } else {
            this.analyzeImpactLookup(impact, pipelineMeta, transformMeta, prev);
        }
    }

    private void analyzeImpactUpdate(List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev) {
        DatabaseImpact ii;
        IValueMeta v;
        for (DLKey key : this.fields.keys) {
            v = prev.searchValueMeta(key.getName());
            ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, key.getLookup(), key.getName(), v == null ? "" : v.getOrigin(), "", (String)(v == null ? "" : "Type = " + v.toStringMeta()));
            impact.add(ii);
        }
        for (DLField field : this.fields.fields) {
            v = prev.searchValueMeta(field.getName());
            ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, field.getLookup(), field.getLookup(), v == null ? "" : v.getOrigin(), "", (String)(v == null ? "" : "Type = " + v.toStringMeta()));
            impact.add(ii);
        }
    }

    private void analyzeImpactLookup(List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev) {
        DatabaseImpact ii;
        IValueMeta v;
        for (DLKey key : this.fields.keys) {
            v = prev.searchValueMeta(key.getName());
            ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, key.getLookup(), key.getName(), v != null ? v.getOrigin() : "?", "", (String)(v == null ? "" : "Type = " + v.toStringMeta()));
            impact.add(ii);
        }
        for (DLField field : this.fields.fields) {
            v = prev.searchValueMeta(field.getName());
            ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, field.getLookup(), field.getLookup(), v == null ? "" : v.getOrigin(), "", (String)(v == null ? "" : "Type = " + v.toStringMeta()));
            impact.add(ii);
        }
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    Database createDatabaseObject(IVariables variables) {
        return new Database(loggingObject, variables, this.databaseMeta);
    }

    public IRowMeta getRowMeta(IVariables variables, ITransformData transformData) {
        IRowMeta iRowMeta;
        Database database = new Database(loggingObject, variables, this.databaseMeta);
        try {
            iRowMeta = database.getTableFieldsMeta(this.schemaName, this.tableName);
        }
        catch (Throwable throwable) {
            try {
                try {
                    database.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (HopDatabaseException e) {
                this.log.logError("", (Throwable)e);
                return new RowMeta();
            }
        }
        database.close();
        return iRowMeta;
    }

    public List<String> getDatabaseFields() {
        ArrayList<String> dbFields = new ArrayList<String>();
        this.fields.keys.forEach(key -> dbFields.add(key.getLookup()));
        this.fields.fields.forEach(field -> dbFields.add(field.getLookup()));
        return dbFields;
    }

    public List<String> getStreamFields() {
        ArrayList<String> streamFields = new ArrayList<String>();
        this.fields.fields.forEach(field -> streamFields.add(field.getName()));
        this.fields.keys.forEach(key -> streamFields.add(key.getName()));
        return streamFields;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public DLFields getFields() {
        return this.fields;
    }

    public void setFields(DLFields fields) {
        this.fields = fields;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public boolean isUseBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isUsingStartDateAlternative() {
        return this.usingStartDateAlternative;
    }

    public void setUsingStartDateAlternative(boolean usingStartDateAlternative) {
        this.usingStartDateAlternative = usingStartDateAlternative;
    }

    public StartDateAlternative getStartDateAlternative() {
        return this.startDateAlternative;
    }

    public void setStartDateAlternative(StartDateAlternative startDateAlternative) {
        this.startDateAlternative = startDateAlternative;
    }

    public String getStartDateFieldName() {
        return this.startDateFieldName;
    }

    public void setStartDateFieldName(String startDateFieldName) {
        this.startDateFieldName = startDateFieldName;
    }

    public boolean isPreloadingCache() {
        return this.preloadingCache;
    }

    public void setPreloadingCache(boolean preloadingCache) {
        this.preloadingCache = preloadingCache;
    }

    public static class DLDate {
        @HopMetadataProperty(injectionKey="STREAM_DATE_FIELD", injectionKeyDescription="DimensionLookup.Injection.STREAM_DATE_FIELD")
        private String name;
        @HopMetadataProperty(injectionKey="DATE_RANGE_START_FIELD", injectionKeyDescription="DimensionLookup.Injection.DATE_RANGE_START_FIELD")
        private String from;
        @HopMetadataProperty(injectionKey="DATE_RANGE_END_FIELD", injectionKeyDescription="DimensionLookup.Injection.DATE_RANGE_END_FIELD")
        private String to;

        public DLDate() {
        }

        public DLDate(DLDate d) {
            this.name = d.name;
            this.from = d.from;
            this.to = d.to;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }
    }

    public static class DLKey {
        @HopMetadataProperty(injectionKey="KEY_STREAM_FIELDNAME", injectionKeyDescription="DimensionLookup.Injection.KEY_STREAM_FIELDNAME")
        private String name;
        @HopMetadataProperty(injectionKey="KEY_DATABASE_FIELDNAME", injectionKeyDescription="DimensionLookup.Injection.KEY_DATABASE_FIELDNAME")
        private String lookup;

        public DLKey() {
        }

        public DLKey(DLKey k) {
            this.name = k.name;
            this.lookup = k.lookup;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLookup() {
            return this.lookup;
        }

        public void setLookup(String lookup) {
            this.lookup = lookup;
        }
    }

    public static class DLField {
        @HopMetadataProperty(key="name", injectionKey="STREAM_FIELDNAME", injectionKeyDescription="DimensionLookup.Injection.STREAM_FIELDNAME")
        private String name;
        @HopMetadataProperty(key="lookup", injectionKey="DATABASE_FIELDNAME", injectionKeyDescription="DimensionLookup.Injection.DATABASE_FIELDNAME")
        private String lookup;
        @HopMetadataProperty(key="update", injectionKey="UPDATE_TYPE", injectionKeyDescription="DimensionLookup.Injection.UPDATE_TYPE")
        private String update;
        @HopMetadataProperty(key="type", injectionKey="TYPE_OF_RETURN_FIELD", injectionKeyDescription="DimensionLookup.Injection.TYPE_OF_RETURN_FIELD")
        private String returnType;
        private DimensionUpdateType updateType;

        public DLField() {
            this.updateType = null;
            this.returnType = null;
        }

        public DLField(DLField f) {
            this.name = f.name;
            this.lookup = f.lookup;
            this.update = f.update;
            this.updateType = null;
            this.returnType = f.returnType;
        }

        public DimensionUpdateType getUpdateType() {
            if (this.updateType != null) {
                return this.updateType;
            }
            for (DimensionUpdateType type : DimensionUpdateType.values()) {
                if (!type.getCode().equals(this.update)) continue;
                this.updateType = type;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLookup() {
            return this.lookup;
        }

        public void setLookup(String lookup) {
            this.lookup = lookup;
        }

        public String getUpdate() {
            return this.update;
        }

        public void setUpdate(String update) {
            this.update = update;
            this.updateType = null;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public void setReturnType(String type) {
            this.returnType = type;
        }
    }

    public static class DLReturn {
        @HopMetadataProperty(key="name", injectionKey="TECHNICAL_KEY_FIELD", injectionKeyDescription="DimensionLookup.Injection.TECHNICAL_KEY_FIELD")
        private String keyField;
        @HopMetadataProperty(key="rename", injectionKey="TECHNICAL_KEY_NEW_NAME", injectionKeyDescription="DimensionLookup.Injection.TECHNICAL_KEY_NEW_NAME")
        private String keyRename;
        @HopMetadataProperty(key="creation_method", storeWithCode=true, injectionKey="TECHNICAL_KEY_CREATION", injectionKeyDescription="DimensionLookup.Injection.TECHNICAL_KEY_CREATION")
        private TechnicalKeyCreationMethod creationMethod;
        @HopMetadataProperty(key="version", injectionKey="VERSION_FIELD", injectionKeyDescription="DimensionLookup.Injection.VERSION_FIELD")
        private String versionField;

        public DLReturn() {
        }

        public DLReturn(DLReturn r) {
            this.keyField = r.keyField;
            this.keyRename = r.keyRename;
            this.creationMethod = r.creationMethod;
            this.versionField = r.versionField;
        }

        public String getKeyField() {
            return this.keyField;
        }

        public void setKeyField(String keyField) {
            this.keyField = keyField;
        }

        public String getKeyRename() {
            return this.keyRename;
        }

        public void setKeyRename(String keyRename) {
            this.keyRename = keyRename;
        }

        public TechnicalKeyCreationMethod getCreationMethod() {
            return this.creationMethod;
        }

        public void setCreationMethod(TechnicalKeyCreationMethod creationMethod) {
            this.creationMethod = creationMethod;
        }

        public String getVersionField() {
            return this.versionField;
        }

        public void setVersionField(String versionField) {
            this.versionField = versionField;
        }
    }

    public static class DLFields {
        @HopMetadataProperty(key="key")
        private List<DLKey> keys = new ArrayList<DLKey>();
        @HopMetadataProperty(key="date")
        private DLDate date = new DLDate();
        @HopMetadataProperty(key="field")
        private List<DLField> fields = new ArrayList<DLField>();
        @HopMetadataProperty(key="return")
        private DLReturn returns = new DLReturn();

        public DLFields() {
        }

        public DLFields(DLFields f) {
            this();
            for (DLKey key : f.keys) {
                this.keys.add(new DLKey(key));
            }
            this.date = new DLDate(f.date);
            for (DLField field : f.fields) {
                this.fields.add(new DLField(field));
            }
            this.returns = new DLReturn(f.returns);
        }

        public List<DLKey> getKeys() {
            return this.keys;
        }

        public void setKeys(List<DLKey> keys) {
            this.keys = keys;
        }

        public DLDate getDate() {
            return this.date;
        }

        public void setDate(DLDate date) {
            this.date = date;
        }

        public List<DLField> getFields() {
            return this.fields;
        }

        public void setFields(List<DLField> fields) {
            this.fields = fields;
        }

        public DLReturn getReturns() {
            return this.returns;
        }

        public void setReturns(DLReturn returns) {
            this.returns = returns;
        }
    }

    public static enum StartDateAlternative implements IEnumHasCodeAndDescription
    {
        NONE("none", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.None.Label", (String[])new String[0])),
        SYSTEM_DATE("sysdate", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.Sysdate.Label", (String[])new String[0])),
        PIPELINE_START("pipeline_start", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.PipelineStart.Label", (String[])new String[0])),
        NULL("null", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.Null.Label", (String[])new String[0])),
        COLUMN_VALUE("column_value", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.ColumnValue.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private StartDateAlternative(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            String[] descriptions = new String[StartDateAlternative.values().length];
            for (int i = 0; i < descriptions.length; ++i) {
                descriptions[i] = StartDateAlternative.values()[i].description;
            }
            return descriptions;
        }

        public static StartDateAlternative lookupWithDescription(String description) {
            for (StartDateAlternative value : StartDateAlternative.values()) {
                if (!value.description.equalsIgnoreCase(description)) continue;
                return value;
            }
            return null;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum DimensionUpdateType implements IEnumHasCodeAndDescription
    {
        INSERT("Insert", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.Insert", (String[])new String[0]), true),
        UPDATE("Update", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.Update", (String[])new String[0]), true),
        PUNCH_THROUGH("Punch through", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.PunchThrough", (String[])new String[0]), true),
        DATE_INSERTED_UPDATED("DateInsertedOrUpdated", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateInsertedOrUpdated", (String[])new String[0]), false),
        DATE_INSERTED("DateInserted", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateInserted", (String[])new String[0]), false),
        DATE_UPDATED("DateUpdated", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateUpdated", (String[])new String[0]), false),
        LAST_VERSION("LastVersion", BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.LastVersion", (String[])new String[0]), false);

        private final String code;
        private final String description;
        private final boolean isWithArgument;

        private DimensionUpdateType(String code, String description, boolean isWithArgument) {
            this.code = code;
            this.description = description;
            this.isWithArgument = isWithArgument;
        }

        public static String[] getDescriptions() {
            String[] descriptions = new String[DimensionUpdateType.values().length];
            for (int i = 0; i < descriptions.length; ++i) {
                descriptions[i] = DimensionUpdateType.values()[i].description;
            }
            return descriptions;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isWithArgument() {
            return this.isWithArgument;
        }

        public static DimensionUpdateType lookupDescription(String description) {
            return (DimensionUpdateType)IEnumHasCodeAndDescription.lookupDescription(DimensionUpdateType.class, (String)description, null);
        }
    }

    public static enum TechnicalKeyCreationMethod implements IEnumHasCode
    {
        AUTO_INCREMENT("autoinc"),
        SEQUENCE("sequence"),
        TABLE_MAXIMUM("tablemax");

        private final String code;

        private TechnicalKeyCreationMethod(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

