/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;

public enum LogLevel implements IEnumHasCodeAndDescription
{
    NOTHING(0, "Nothing"),
    ERROR(1, "Error"),
    MINIMAL(2, "Minimal"),
    BASIC(3, "Basic"),
    DETAILED(4, "Detailed"),
    DEBUG(5, "Debug"),
    ROWLEVEL(6, "Rowlevel");

    private static final Class<?> PKG;
    public static final String[] logLevelDescriptions;
    private final int level;
    private final String code;

    private LogLevel(int level, String code) {
        this.level = level;
        this.code = code;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return logLevelDescriptions[this.level];
    }

    @Deprecated
    public static LogLevel getLogLevelForCode(String code) {
        return IEnumHasCode.lookupCode(LogLevel.class, code, BASIC);
    }

    public static LogLevel lookupCode(String code) {
        return IEnumHasCode.lookupCode(LogLevel.class, code, BASIC);
    }

    public static LogLevel lookupDescription(String description) {
        return IEnumHasCodeAndDescription.lookupDescription(LogLevel.class, description, BASIC);
    }

    public boolean isVisible(LogLevel filterLogLevel) {
        return this.getLevel() <= filterLogLevel.getLevel();
    }

    public boolean isError() {
        return this == ERROR;
    }

    public boolean isNothing() {
        return this.level >= LogLevel.NOTHING.level;
    }

    public boolean isMinimal() {
        return this.level >= LogLevel.MINIMAL.level;
    }

    public boolean isBasic() {
        return this.level >= LogLevel.BASIC.level;
    }

    public boolean isDetailed() {
        return this.level >= LogLevel.DETAILED.level;
    }

    public boolean isDebug() {
        return this.level >= LogLevel.DEBUG.level;
    }

    public boolean isRowlevel() {
        return this.level >= LogLevel.ROWLEVEL.level;
    }

    public static String[] getLogLevelDescriptions() {
        return IEnumHasCodeAndDescription.getDescriptions(LogLevel.class);
    }

    public static String[] logLogLevelCodes() {
        return IEnumHasCode.getCodes(LogLevel.class);
    }

    static {
        PKG = LogLevel.class;
        logLevelDescriptions = new String[]{BaseMessages.getString(PKG, "LogWriter.Level.Nothing.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Error.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Minimal.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Basic.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Detailed.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Debug.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Rowlevel.LongDesc", new String[0])};
    }
}

