/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.IConfigFile;
import org.apache.hop.core.config.plugin.ConfigFile;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.DescribedVariable;

public class HopConfig
extends ConfigFile
implements IConfigFile {
    private static final String HOP_GUI_PROPERTIES_KEY = "guiProperties";
    private String configFilename;
    @JsonIgnore
    private static HopConfig instance;

    private HopConfig() {
        try {
            this.configFilename = Const.HOP_CONFIG_FOLDER + Const.FILE_SEPARATOR + "hop-config.json";
            this.readFromFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading the hop config file '" + this.configFilename + "'", e);
        }
    }

    public static HopConfig getInstance() {
        if (instance == null) {
            instance = new HopConfig();
        }
        return instance;
    }

    public synchronized void saveOption(String optionKey, Object optionValue) {
        try {
            HopConfig hopConfig = HopConfig.getInstance();
            hopConfig.configMap.put(optionKey, optionValue);
            this.saveToFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving configuration option '" + optionKey + "'", e);
        }
    }

    public static synchronized void saveOptions(Map<String, Object> extraOptions) {
        try {
            HopConfig hopConfig = HopConfig.getInstance();
            hopConfig.configMap.putAll(extraOptions);
            hopConfig.saveToFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving configuration options", e);
        }
    }

    public static Object readOption(String optionKey) {
        try {
            HopConfig hopConfig = HopConfig.getInstance();
            return hopConfig.configMap.get(optionKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading option '" + optionKey + "'", e);
        }
    }

    public static String readOptionString(String optionKey, String defaultValue) {
        try {
            Object value = HopConfig.readOption(optionKey);
            if (value == null) {
                return defaultValue;
            }
            if (Utils.isEmpty(value.toString())) {
                return defaultValue;
            }
            return value.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading option '" + optionKey + "'", e);
        }
    }

    public static int readOptionInteger(String optionKey, int defaultValue) {
        Object value = HopConfig.readOption(optionKey);
        if (value == null) {
            return defaultValue;
        }
        if (Utils.isEmpty(value.toString())) {
            return defaultValue;
        }
        return Integer.parseInt(value.toString());
    }

    public static boolean readOptionBoolean(String optionKey, boolean defaultValue) {
        Object value = HopConfig.readOption(optionKey);
        if (value == null) {
            return defaultValue;
        }
        if (Utils.isEmpty(value.toString())) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        String str = value.toString();
        return Const.toBoolean(str);
    }

    public static List<String> getSortedKeys() {
        try {
            ArrayList<String> keys = new ArrayList<String>(HopConfig.getInstance().configMap.keySet());
            Collections.sort(keys);
            return keys;
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting a list of sorted configuration keys", e);
        }
    }

    public static Map<String, String> readGuiProperties() {
        try {
            Object propertiesObject = HopConfig.getInstance().configMap.get(HOP_GUI_PROPERTIES_KEY);
            if (propertiesObject == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                HopConfig.getInstance().configMap.put(HOP_GUI_PROPERTIES_KEY, map);
                return map;
            }
            return (Map)propertiesObject;
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting GUI properties from the Hop configuration");
        }
    }

    public static String readStringVariable(String key, String defaultValue) {
        String value = null;
        ArrayList variables = (ArrayList)HopConfig.getInstance().configMap.get("variables");
        if (variables != null) {
            Iterator i = variables.iterator();
            while (i.hasNext() && value == null) {
                DescribedVariable v = (DescribedVariable)i.next();
                if (!v.getName().equals(key)) continue;
                value = v.getValue();
            }
        }
        return value == null ? defaultValue : value;
    }

    public static void setGuiProperty(String key, String value) {
        HopConfig.readGuiProperties().put(key, value);
    }

    public static String getGuiProperty(String key) {
        return HopConfig.readGuiProperties().get(key);
    }

    public static void setGuiProperties(Map<String, String> map) {
        HopConfig.readGuiProperties().putAll(map);
    }

    @Override
    public String getConfigFilename() {
        return this.configFilename;
    }

    @Override
    public void setConfigFilename(String configFilename) {
        this.configFilename = configFilename;
    }
}

