/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfig;

public class ExplorerPerspectiveConfigSingleton {
    private static ExplorerPerspectiveConfigSingleton configSingleton;
    private ExplorerPerspectiveConfig explorerPerspectiveConfig;

    private ExplorerPerspectiveConfigSingleton() {
        Object configObject = HopConfig.getInstance().getConfigMap().get("explorer-perspective");
        if (configObject == null) {
            this.explorerPerspectiveConfig = new ExplorerPerspectiveConfig();
        } else {
            try {
                ObjectMapper mapper = HopJson.newMapper();
                this.explorerPerspectiveConfig = (ExplorerPerspectiveConfig)mapper.readValue(new Gson().toJson(configObject), ExplorerPerspectiveConfig.class);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error reading explorer perspective configuration, please check property 'explorer-perspective' in the Hop config json file", (Throwable)e);
                this.explorerPerspectiveConfig = new ExplorerPerspectiveConfig();
            }
        }
        HopConfig.getInstance().getConfigMap().put("explorer-perspective", this.explorerPerspectiveConfig);
    }

    public static ExplorerPerspectiveConfigSingleton getInstance() {
        return configSingleton;
    }

    public static ExplorerPerspectiveConfig getConfig() {
        if (configSingleton == null) {
            configSingleton = new ExplorerPerspectiveConfigSingleton();
        }
        return ExplorerPerspectiveConfigSingleton.configSingleton.explorerPerspectiveConfig;
    }

    public static void saveConfig() throws HopException {
        HopConfig.getInstance().saveOption("explorer-perspective", (Object)ExplorerPerspectiveConfigSingleton.configSingleton.explorerPerspectiveConfig);
        HopConfig.getInstance().saveToFile();
    }
}

