/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.http.HttpMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class HttpDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = HttpMeta.class;
    private Label wlUrl;
    private TextVar wUrl;
    private TextVar wResult;
    private TableView wFields;
    private TableView wHeaders;
    private Button wUrlInField;
    private Button wIgnoreSsl;
    private Label wlUrlField;
    private ComboVar wUrlField;
    private ComboVar wEncoding;
    private TextVar wHttpLogin;
    private TextVar wHttpPassword;
    private TextVar wProxyHost;
    private TextVar wProxyPort;
    private TextVar wResultCode;
    private TextVar wResponseTime;
    private TextVar wResponseHeader;
    private final HttpMeta input;
    private ColumnInfo[] colinf;
    private ColumnInfo[] colinfHeaders;
    private final List<String> inputFields = new ArrayList<String>();
    private boolean gotEncodings = false;
    private TextVar wConnectionTimeOut;
    private TextVar wSocketTimeOut;
    private TextVar wCloseIdleConnectionsTime;

    public HttpDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (HttpMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Shell.Title", (String[])new String[0]));
        int margin = PropsUi.getMargin();
        this.setupButtons();
        Control lastControl = this.setupTransformNameField(lsMod);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.GeneralTab.Title", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)fileLayout);
        Group gSettings = this.setupSettingGroup(wGeneralComp);
        lastControl = this.setupUrlLine(lsMod, lastControl, gSettings);
        lastControl = this.setupUrlInFieldLine(lastControl, gSettings);
        lastControl = this.setupIgnoreSslLine(lastControl, gSettings);
        lastControl = this.setupUrlFieldNameLine(lsMod, lastControl, gSettings);
        lastControl = this.setupEncodingLine(lsMod, lastControl, gSettings);
        this.setupConnectionTimeoutLine(lsMod, gSettings);
        this.setupSocketTimeoutLine(lsMod, gSettings);
        this.setupCloseWaitTimeLine(lsMod, gSettings);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, 0);
        fdSettings.right = new FormAttachment(100, 0);
        fdSettings.top = new FormAttachment(lastControl, margin);
        gSettings.setLayoutData((Object)fdSettings);
        lastControl = gSettings;
        Group gOutputFields = this.setupOutputFieldGroup(wGeneralComp);
        this.setupResultLine(lsMod, lastControl, gOutputFields);
        this.setupStatusCodeLine(lsMod, gOutputFields);
        this.setupResponseTimeLine(lsMod, gOutputFields);
        this.setupResponseHeaderLine(lsMod, gOutputFields);
        FormData fdOutputFields = new FormData();
        fdOutputFields.left = new FormAttachment(0, 0);
        fdOutputFields.right = new FormAttachment(100, 0);
        fdOutputFields.top = new FormAttachment(lastControl);
        gOutputFields.setLayoutData((Object)fdOutputFields);
        lastControl = gOutputFields;
        Group gHttpAuth = this.setupHttpAuthGroup(wGeneralComp);
        this.setupHttpLoginLine(lsMod, gHttpAuth);
        this.setupHttpPasswordLine(lsMod, gHttpAuth);
        FormData fdHttpAuth = new FormData();
        fdHttpAuth.left = new FormAttachment(0, 0);
        fdHttpAuth.right = new FormAttachment(100, 0);
        fdHttpAuth.top = new FormAttachment(lastControl, margin);
        gHttpAuth.setLayoutData((Object)fdHttpAuth);
        lastControl = gHttpAuth;
        Group gProxy = this.setupProxyGroup(wGeneralComp);
        this.setupProxyHost(lsMod, gProxy);
        this.setupProxyPort(lsMod, lastControl, gProxy);
        lastControl = gProxy;
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wAdditionalTab = new CTabItem(wTabFolder, 0);
        wAdditionalTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdditionalTab.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.FieldsTab.Title", (String[])new String[0]));
        FormLayout addLayout = new FormLayout();
        addLayout.marginWidth = PropsUi.getFormMargin();
        addLayout.marginHeight = PropsUi.getFormMargin();
        Composite wAdditionalComp = new Composite((Composite)wTabFolder, 0);
        wAdditionalComp.setLayout((Layout)addLayout);
        PropsUi.setLook((Widget)wAdditionalComp);
        this.setupParamBlock(lsMod, lastControl, wAdditionalComp);
        this.setupHeadBlock(lsMod, wAdditionalComp);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdAdditionalComp = new FormData();
        fdAdditionalComp.left = new FormAttachment(0, 0);
        fdAdditionalComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdAdditionalComp.right = new FormAttachment(100, 0);
        fdAdditionalComp.bottom = new FormAttachment(100, 0);
        wAdditionalComp.setLayoutData((Object)fdAdditionalComp);
        wAdditionalComp.layout();
        wAdditionalTab.setControl((Control)wAdditionalComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        this.getData();
        wTabFolder.setSelection(0);
        this.activeUrlInfield();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setupHeadBlock(ModifyListener lsMod, Composite wAdditionalComp) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        Label wlHeaders = new Label(wAdditionalComp, 0);
        wlHeaders.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Headers.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHeaders);
        FormData fdlHeaders = new FormData();
        fdlHeaders.left = new FormAttachment(0, 0);
        fdlHeaders.top = new FormAttachment((Control)this.wFields, margin);
        wlHeaders.setLayoutData((Object)fdlHeaders);
        int HeadersRows = this.input.getHeaderParameter().length;
        this.colinfHeaders = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPDialog.ColumnInfo.Field", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPDialog.ColumnInfo.Header", (String[])new String[0]), 1, false)};
        this.colinfHeaders[1].setUsingVariables(true);
        this.wHeaders = new TableView(this.variables, wAdditionalComp, 67586, this.colinfHeaders, HeadersRows, lsMod, this.props);
        Button wGetHeaders = new Button(wAdditionalComp, 8);
        wGetHeaders.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.GetHeaders.Button", (String[])new String[0]));
        FormData fdGetHeaders = new FormData();
        fdGetHeaders.top = new FormAttachment((Control)wlHeaders, margin);
        fdGetHeaders.right = new FormAttachment(100, 0);
        wGetHeaders.setLayoutData((Object)fdGetHeaders);
        wGetHeaders.addListener(13, e -> this.getHeadersFields());
        FormData fdHeaders = new FormData();
        fdHeaders.left = new FormAttachment(0, 0);
        fdHeaders.top = new FormAttachment((Control)wlHeaders, margin);
        fdHeaders.right = new FormAttachment((Control)wGetHeaders, -margin);
        fdHeaders.bottom = new FormAttachment(100, -margin);
        this.wHeaders.setLayoutData((Object)fdHeaders);
    }

    private void setupParamBlock(ModifyListener lsMod, Control lastControl, Composite wAdditionalComp) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        Label wlFields = new Label(wAdditionalComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Parameters.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(lastControl, margin);
        wlFields.setLayoutData((Object)fdlFields);
        lastControl = wlFields;
        Button wGet = new Button(wAdditionalComp, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)wlFields, margin);
        fdGet.right = new FormAttachment(100, 0);
        wGet.setLayoutData((Object)fdGet);
        wGet.addListener(13, e -> this.get());
        int FieldsRows = this.input.getArgumentField().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPDialog.ColumnInfo.Name", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HTTPDialog.ColumnInfo.Parameter", (String[])new String[0]), 1, false)};
        this.wFields = new TableView(this.variables, wAdditionalComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)wGet, -margin);
        fdFields.bottom = new FormAttachment((Control)wlFields, 200);
        this.wFields.setLayoutData((Object)fdFields);
    }

    private void setupProxyPort(ModifyListener lsMod, Control lastControl, Group gProxy) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlProxyPort = new Label((Composite)gProxy, 131072);
        wlProxyPort.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyPort.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProxyPort);
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.right = new FormAttachment(middle, -margin);
        wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar(this.variables, (Composite)gProxy, 18436);
        this.wProxyPort.addModifyListener(lsMod);
        this.wProxyPort.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyPort.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wProxyPort);
        FormData fdProxyPort = new FormData();
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.left = new FormAttachment(middle, 0);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
        FormData fdProxy = new FormData();
        fdProxy.left = new FormAttachment(0, 0);
        fdProxy.right = new FormAttachment(100, 0);
        fdProxy.top = new FormAttachment(lastControl, margin);
        gProxy.setLayoutData((Object)fdProxy);
    }

    private void setupProxyHost(ModifyListener lsMod, Group gProxy) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlProxyHost = new Label((Composite)gProxy, 131072);
        wlProxyHost.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyHost.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProxyHost);
        FormData fdlProxyHost = new FormData();
        fdlProxyHost.top = new FormAttachment(0, margin);
        fdlProxyHost.left = new FormAttachment(0, 0);
        fdlProxyHost.right = new FormAttachment(middle, -margin);
        wlProxyHost.setLayoutData((Object)fdlProxyHost);
        this.wProxyHost = new TextVar(this.variables, (Composite)gProxy, 18436);
        this.wProxyHost.addModifyListener(lsMod);
        this.wProxyHost.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyHost.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wProxyHost);
        FormData fdProxyHost = new FormData();
        fdProxyHost.top = new FormAttachment(0, margin);
        fdProxyHost.left = new FormAttachment(middle, 0);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
    }

    private Group setupProxyGroup(Composite wGeneralComp) {
        Group gProxy = new Group(wGeneralComp, 16);
        gProxy.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ProxyGroup.Label", (String[])new String[0]));
        FormLayout proxyLayout = new FormLayout();
        proxyLayout.marginWidth = 3;
        proxyLayout.marginHeight = 3;
        gProxy.setLayout((Layout)proxyLayout);
        PropsUi.setLook((Widget)gProxy);
        return gProxy;
    }

    private void setupHttpPasswordLine(ModifyListener lsMod, Group gHttpAuth) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlHttpPassword = new Label((Composite)gHttpAuth, 131072);
        wlHttpPassword.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpPassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHttpPassword);
        FormData fdlHttpPassword = new FormData();
        fdlHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdlHttpPassword.left = new FormAttachment(0, 0);
        fdlHttpPassword.right = new FormAttachment(middle, -margin);
        wlHttpPassword.setLayoutData((Object)fdlHttpPassword);
        this.wHttpPassword = new PasswordTextVar(this.variables, (Composite)gHttpAuth, 18436);
        this.wHttpPassword.addModifyListener(lsMod);
        this.wHttpPassword.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpPassword.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHttpPassword);
        FormData fdHttpPassword = new FormData();
        fdHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdHttpPassword.left = new FormAttachment(middle, 0);
        fdHttpPassword.right = new FormAttachment(100, 0);
        this.wHttpPassword.setLayoutData((Object)fdHttpPassword);
    }

    private void setupHttpLoginLine(ModifyListener lsMod, Group gHttpAuth) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlHttpLogin = new Label((Composite)gHttpAuth, 131072);
        wlHttpLogin.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpLogin.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHttpLogin);
        FormData fdlHttpLogin = new FormData();
        fdlHttpLogin.top = new FormAttachment(0, margin);
        fdlHttpLogin.left = new FormAttachment(0, 0);
        fdlHttpLogin.right = new FormAttachment(middle, -margin);
        wlHttpLogin.setLayoutData((Object)fdlHttpLogin);
        this.wHttpLogin = new TextVar(this.variables, (Composite)gHttpAuth, 18436);
        this.wHttpLogin.addModifyListener(lsMod);
        this.wHttpLogin.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpLogin.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHttpLogin);
        FormData fdHttpLogin = new FormData();
        fdHttpLogin.top = new FormAttachment(0, margin);
        fdHttpLogin.left = new FormAttachment(middle, 0);
        fdHttpLogin.right = new FormAttachment(100, 0);
        this.wHttpLogin.setLayoutData((Object)fdHttpLogin);
    }

    private Group setupHttpAuthGroup(Composite wGeneralComp) {
        Group gHttpAuth = new Group(wGeneralComp, 16);
        gHttpAuth.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.HttpAuthGroup.Label", (String[])new String[0]));
        FormLayout httpAuthLayout = new FormLayout();
        httpAuthLayout.marginWidth = 3;
        httpAuthLayout.marginHeight = 3;
        gHttpAuth.setLayout((Layout)httpAuthLayout);
        PropsUi.setLook((Widget)gHttpAuth);
        return gHttpAuth;
    }

    private void setupResponseHeaderLine(ModifyListener lsMod, Group gOutputFields) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlResponseHeader = new Label((Composite)gOutputFields, 131072);
        wlResponseHeader.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ResponseHeader.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResponseHeader);
        FormData fdlResponseHeader = new FormData();
        fdlResponseHeader.left = new FormAttachment(0, 0);
        fdlResponseHeader.right = new FormAttachment(middle, -margin);
        fdlResponseHeader.top = new FormAttachment((Control)this.wResponseTime, margin);
        wlResponseHeader.setLayoutData((Object)fdlResponseHeader);
        this.wResponseHeader = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        PropsUi.setLook((Widget)this.wResponseHeader);
        this.wResponseHeader.addModifyListener(lsMod);
        FormData fdResponseHeader = new FormData();
        fdResponseHeader.left = new FormAttachment(middle, 0);
        fdResponseHeader.top = new FormAttachment((Control)this.wResponseTime, margin);
        fdResponseHeader.right = new FormAttachment(100, 0);
        this.wResponseHeader.setLayoutData((Object)fdResponseHeader);
    }

    private void setupResponseTimeLine(ModifyListener lsMod, Group gOutputFields) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlResponseTime = new Label((Composite)gOutputFields, 131072);
        wlResponseTime.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ResponseTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResponseTime);
        FormData fdlResponseTime = new FormData();
        fdlResponseTime.left = new FormAttachment(0, 0);
        fdlResponseTime.right = new FormAttachment(middle, -margin);
        fdlResponseTime.top = new FormAttachment((Control)this.wResultCode, margin);
        wlResponseTime.setLayoutData((Object)fdlResponseTime);
        this.wResponseTime = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        PropsUi.setLook((Widget)this.wResponseTime);
        this.wResponseTime.addModifyListener(lsMod);
        FormData fdResponseTime = new FormData();
        fdResponseTime.left = new FormAttachment(middle, 0);
        fdResponseTime.top = new FormAttachment((Control)this.wResultCode, margin);
        fdResponseTime.right = new FormAttachment(100, 0);
        this.wResponseTime.setLayoutData((Object)fdResponseTime);
    }

    private void setupStatusCodeLine(ModifyListener lsMod, Group gOutputFields) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlResultCode = new Label((Composite)gOutputFields, 131072);
        wlResultCode.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ResultCode.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResultCode);
        FormData fdlResultCode = new FormData();
        fdlResultCode.left = new FormAttachment(0, 0);
        fdlResultCode.right = new FormAttachment(middle, -margin);
        fdlResultCode.top = new FormAttachment((Control)this.wResult, margin);
        wlResultCode.setLayoutData((Object)fdlResultCode);
        this.wResultCode = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        PropsUi.setLook((Widget)this.wResultCode);
        this.wResultCode.addModifyListener(lsMod);
        FormData fdResultCode = new FormData();
        fdResultCode.left = new FormAttachment(middle, 0);
        fdResultCode.top = new FormAttachment((Control)this.wResult, margin);
        fdResultCode.right = new FormAttachment(100, 0);
        this.wResultCode.setLayoutData((Object)fdResultCode);
    }

    private void setupResultLine(ModifyListener lsMod, Control lastControl, Group gOutputFields) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlResult = new Label((Composite)gOutputFields, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Result.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment(lastControl, margin);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment(lastControl, margin);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
    }

    private Group setupOutputFieldGroup(Composite wGeneralComp) {
        Group gOutputFields = new Group(wGeneralComp, 16);
        gOutputFields.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.OutputFieldsGroup.Label", (String[])new String[0]));
        FormLayout outputFieldsLayout = new FormLayout();
        outputFieldsLayout.marginWidth = 3;
        outputFieldsLayout.marginHeight = 3;
        gOutputFields.setLayout((Layout)outputFieldsLayout);
        PropsUi.setLook((Widget)gOutputFields);
        return gOutputFields;
    }

    private void setupCloseWaitTimeLine(ModifyListener lsMod, Group gSettings) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlCloseIdleConnectionsTime = new Label((Composite)gSettings, 131072);
        wlCloseIdleConnectionsTime.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.CloseIdleConnectionsTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCloseIdleConnectionsTime);
        FormData fdlCloseIdleConnectionsTime = new FormData();
        fdlCloseIdleConnectionsTime.top = new FormAttachment((Control)this.wSocketTimeOut, margin);
        fdlCloseIdleConnectionsTime.left = new FormAttachment(0, 0);
        fdlCloseIdleConnectionsTime.right = new FormAttachment(middle, -margin);
        wlCloseIdleConnectionsTime.setLayoutData((Object)fdlCloseIdleConnectionsTime);
        this.wCloseIdleConnectionsTime = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.wCloseIdleConnectionsTime.addModifyListener(lsMod);
        this.wCloseIdleConnectionsTime.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.CloseIdleConnectionsTime.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCloseIdleConnectionsTime);
        FormData fdCloseIdleConnectionsTime = new FormData();
        fdCloseIdleConnectionsTime.top = new FormAttachment((Control)this.wSocketTimeOut, margin);
        fdCloseIdleConnectionsTime.left = new FormAttachment(middle, 0);
        fdCloseIdleConnectionsTime.right = new FormAttachment(100, 0);
        this.wCloseIdleConnectionsTime.setLayoutData((Object)fdCloseIdleConnectionsTime);
    }

    private void setupSocketTimeoutLine(ModifyListener lsMod, Group gSettings) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlSocketTimeOut = new Label((Composite)gSettings, 131072);
        wlSocketTimeOut.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.SocketTimeOut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSocketTimeOut);
        FormData fdlSocketTimeOut = new FormData();
        fdlSocketTimeOut.top = new FormAttachment((Control)this.wConnectionTimeOut, margin);
        fdlSocketTimeOut.left = new FormAttachment(0, 0);
        fdlSocketTimeOut.right = new FormAttachment(middle, -margin);
        wlSocketTimeOut.setLayoutData((Object)fdlSocketTimeOut);
        this.wSocketTimeOut = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.wSocketTimeOut.addModifyListener(lsMod);
        this.wSocketTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.SocketTimeOut.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSocketTimeOut);
        FormData fdSocketTimeOut = new FormData();
        fdSocketTimeOut.top = new FormAttachment((Control)this.wConnectionTimeOut, margin);
        fdSocketTimeOut.left = new FormAttachment(middle, 0);
        fdSocketTimeOut.right = new FormAttachment(100, 0);
        this.wSocketTimeOut.setLayoutData((Object)fdSocketTimeOut);
    }

    private void setupConnectionTimeoutLine(ModifyListener lsMod, Group gSettings) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlConnectionTimeOut = new Label((Composite)gSettings, 131072);
        wlConnectionTimeOut.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.ConnectionTimeOut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConnectionTimeOut);
        FormData fdlConnectionTimeOut = new FormData();
        fdlConnectionTimeOut.top = new FormAttachment((Control)this.wEncoding, margin);
        fdlConnectionTimeOut.left = new FormAttachment(0, 0);
        fdlConnectionTimeOut.right = new FormAttachment(middle, -margin);
        wlConnectionTimeOut.setLayoutData((Object)fdlConnectionTimeOut);
        this.wConnectionTimeOut = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.wConnectionTimeOut.addModifyListener(lsMod);
        this.wConnectionTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.ConnectionTimeOut.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wConnectionTimeOut);
        FormData fdConnectionTimeOut = new FormData();
        fdConnectionTimeOut.top = new FormAttachment((Control)this.wEncoding, margin);
        fdConnectionTimeOut.left = new FormAttachment(middle, 0);
        fdConnectionTimeOut.right = new FormAttachment(100, 0);
        this.wConnectionTimeOut.setLayoutData((Object)fdConnectionTimeOut);
    }

    private Control setupEncodingLine(ModifyListener lsMod, Control lastControl, Group gSettings) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlEncoding = new Label((Composite)gSettings, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.top = new FormAttachment(lastControl, margin);
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new ComboVar(this.variables, (Composite)gSettings, 18436);
        PropsUi.setLook((Widget)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.top = new FormAttachment(lastControl, margin);
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)HttpDialog.this.shell.getDisplay(), 1);
                HttpDialog.this.shell.setCursor(busy);
                HttpDialog.this.setEncodings();
                HttpDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        lastControl = this.wEncoding;
        return lastControl;
    }

    private Control setupUrlFieldNameLine(ModifyListener lsMod, Control lastControl, Group gSettings) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        this.wlUrlField = new Label((Composite)gSettings, 131072);
        this.wlUrlField.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.UrlField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUrlField);
        FormData fdlUrlField = new FormData();
        fdlUrlField.left = new FormAttachment(0, 0);
        fdlUrlField.right = new FormAttachment(middle, -margin);
        fdlUrlField.top = new FormAttachment(lastControl, margin);
        this.wlUrlField.setLayoutData((Object)fdlUrlField);
        this.wUrlField = new ComboVar(this.variables, (Composite)gSettings, 18436);
        this.wUrlField.setToolTipText(BaseMessages.getString(PKG, (String)"HTTPDialog.UrlField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUrlField);
        this.wUrlField.addModifyListener(lsMod);
        FormData fdUrlField = new FormData();
        fdUrlField.left = new FormAttachment(middle, 0);
        fdUrlField.top = new FormAttachment(lastControl, margin);
        fdUrlField.right = new FormAttachment(100, 0);
        this.wUrlField.setLayoutData((Object)fdUrlField);
        this.wUrlField.setEnabled(false);
        this.wUrlField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)HttpDialog.this.shell.getDisplay(), 1);
                HttpDialog.this.shell.setCursor(busy);
                BaseTransformDialog.getFieldsFromPrevious((IVariables)HttpDialog.this.variables, (ComboVar)HttpDialog.this.wUrlField, (PipelineMeta)HttpDialog.this.pipelineMeta, (TransformMeta)HttpDialog.this.transformMeta);
                HttpDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        lastControl = this.wUrlField;
        return lastControl;
    }

    private Control setupUrlInFieldLine(Control lastControl, Group gSettings) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlUrlInField = new Label((Composite)gSettings, 131072);
        wlUrlInField.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.UrlInField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUrlInField);
        FormData fdlUrlInField = new FormData();
        fdlUrlInField.left = new FormAttachment(0, 0);
        fdlUrlInField.top = new FormAttachment(lastControl, margin);
        fdlUrlInField.right = new FormAttachment(middle, -margin);
        wlUrlInField.setLayoutData((Object)fdlUrlInField);
        this.wUrlInField = new Button((Composite)gSettings, 32);
        PropsUi.setLook((Widget)this.wUrlInField);
        FormData fdUrlInField = new FormData();
        fdUrlInField.left = new FormAttachment(middle, 0);
        fdUrlInField.top = new FormAttachment((Control)wlUrlInField, 0, 0x1000000);
        fdUrlInField.right = new FormAttachment(100, 0);
        this.wUrlInField.setLayoutData((Object)fdUrlInField);
        this.wUrlInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HttpDialog.this.input.setChanged();
                HttpDialog.this.activeUrlInfield();
            }
        });
        lastControl = this.wUrlInField;
        return lastControl;
    }

    private Control setupIgnoreSslLine(Control lastControl, Group gSettings) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlIgnoreSsl = new Label((Composite)gSettings, 131072);
        wlIgnoreSsl.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.IgnoreSsl.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnoreSsl);
        FormData fdlIgnoreSsl = new FormData();
        fdlIgnoreSsl.left = new FormAttachment(0, 0);
        fdlIgnoreSsl.top = new FormAttachment(lastControl, margin);
        fdlIgnoreSsl.right = new FormAttachment(middle, -margin);
        wlIgnoreSsl.setLayoutData((Object)fdlIgnoreSsl);
        this.wIgnoreSsl = new Button((Composite)gSettings, 32);
        PropsUi.setLook((Widget)this.wIgnoreSsl);
        FormData fdIgnoreSsl = new FormData();
        fdIgnoreSsl.left = new FormAttachment(middle, 0);
        fdIgnoreSsl.top = new FormAttachment((Control)wlIgnoreSsl, 0, 0x1000000);
        fdIgnoreSsl.right = new FormAttachment(100, 0);
        this.wIgnoreSsl.setLayoutData((Object)fdIgnoreSsl);
        this.wIgnoreSsl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HttpDialog.this.input.setChanged();
            }
        });
        lastControl = this.wIgnoreSsl;
        return lastControl;
    }

    private Control setupUrlLine(ModifyListener lsMod, Control transformNameControl, Group gSettings) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        this.wlUrl = new Label((Composite)gSettings, 131072);
        this.wlUrl.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.URL.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUrl);
        FormData fdlUrl = new FormData();
        fdlUrl.left = new FormAttachment(0, 0);
        fdlUrl.right = new FormAttachment(middle, -margin);
        fdlUrl.top = new FormAttachment(transformNameControl, margin);
        this.wlUrl.setLayoutData((Object)fdlUrl);
        this.wUrl = new TextVar(this.variables, (Composite)gSettings, 18436);
        PropsUi.setLook((Widget)this.wUrl);
        this.wUrl.addModifyListener(lsMod);
        FormData fdUrl = new FormData();
        fdUrl.left = new FormAttachment(middle, 0);
        fdUrl.top = new FormAttachment(transformNameControl, margin);
        fdUrl.right = new FormAttachment(100, 0);
        this.wUrl.setLayoutData((Object)fdUrl);
        transformNameControl = this.wUrl;
        return transformNameControl;
    }

    private Group setupSettingGroup(Composite wGeneralComp) {
        Group gSettings = new Group(wGeneralComp, 16);
        gSettings.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        gSettings.setLayout((Layout)settingsLayout);
        PropsUi.setLook((Widget)gSettings);
        return gSettings;
    }

    private Control setupTransformNameField(ModifyListener lsMod) {
        HttpDialog httpDialog = this;
        int margin = httpDialog.props.getMargin();
        int middle = this.props.getMiddlePct();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"HTTPDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        return lastControl;
    }

    private void setupButtons() {
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        HttpDialog httpDialog = this;
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, httpDialog.props.getMargin(), null);
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
        this.colinfHeaders[0].setComboValues(fieldNames);
    }

    private void activeUrlInfield() {
        this.wlUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wlUrl.setEnabled(!this.wUrlInField.getSelection());
        this.wUrl.setEnabled(!this.wUrlInField.getSelection());
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getArgumentField() != null) {
            for (i = 0; i < this.input.getArgumentField().length; ++i) {
                item = this.wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)this.input.getArgumentField()[i], (String)""));
                item.setText(2, Const.NVL((String)this.input.getArgumentParameter()[i], (String)""));
            }
        }
        if (this.input.getHeaderField() != null) {
            for (i = 0; i < this.input.getHeaderField().length; ++i) {
                item = this.wHeaders.table.getItem(i);
                if (this.input.getHeaderField()[i] != null) {
                    item.setText(1, this.input.getHeaderField()[i]);
                }
                if (this.input.getHeaderParameter()[i] == null) continue;
                item.setText(2, this.input.getHeaderParameter()[i]);
            }
        }
        this.wSocketTimeOut.setText(Const.NVL((String)this.input.getSocketTimeout(), (String)""));
        this.wConnectionTimeOut.setText(Const.NVL((String)this.input.getConnectionTimeout(), (String)""));
        this.wCloseIdleConnectionsTime.setText(Const.NVL((String)this.input.getCloseIdleConnectionsTime(), (String)""));
        this.wUrl.setText(Const.NVL((String)this.input.getUrl(), (String)""));
        this.wUrlInField.setSelection(this.input.isUrlInField());
        this.wIgnoreSsl.setSelection(this.input.isIgnoreSsl());
        this.wUrlField.setText(Const.NVL((String)this.input.getUrlField(), (String)""));
        this.wEncoding.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wResult.setText(Const.NVL((String)this.input.getFieldName(), (String)""));
        if (this.input.getHttpLogin() != null) {
            this.wHttpLogin.setText(this.input.getHttpLogin());
        }
        if (this.input.getHttpPassword() != null) {
            this.wHttpPassword.setText(this.input.getHttpPassword());
        }
        if (this.input.getProxyHost() != null) {
            this.wProxyHost.setText(this.input.getProxyHost());
        }
        if (this.input.getProxyPort() != null) {
            this.wProxyPort.setText(this.input.getProxyPort());
        }
        if (this.input.getResultCodeFieldName() != null) {
            this.wResultCode.setText(this.input.getResultCodeFieldName());
        }
        if (this.input.getResponseTimeFieldName() != null) {
            this.wResponseTime.setText(this.input.getResponseTimeFieldName());
        }
        if (this.input.getResponseHeaderFieldName() != null) {
            this.wResponseHeader.setText(this.input.getResponseHeaderFieldName());
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wHeaders.setRowNums();
        this.wHeaders.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int nrargs = this.wFields.nrNonEmpty();
        int nrheaders = this.wHeaders.nrNonEmpty();
        this.input.allocate(nrargs, nrheaders);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.FoundArguments", (String[])new String[]{String.valueOf(nrargs)}));
        }
        for (i = 0; i < nrargs; ++i) {
            item = this.wFields.getNonEmpty(i);
            this.input.getArgumentField()[i] = item.getText(1);
            this.input.getArgumentParameter()[i] = item.getText(2);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.FoundHeaders", (String[])new String[]{String.valueOf(nrheaders)}));
        }
        for (i = 0; i < nrheaders; ++i) {
            item = this.wHeaders.getNonEmpty(i);
            this.input.getHeaderField()[i] = item.getText(1);
            this.input.getHeaderParameter()[i] = item.getText(2);
        }
        this.input.setUrl(this.wUrl.getText());
        this.input.setUrlField(this.wUrlField.getText());
        this.input.setUrlInField(this.wUrlInField.getSelection());
        this.input.setIgnoreSsl(this.wIgnoreSsl.getSelection());
        this.input.setFieldName(this.wResult.getText());
        this.input.setEncoding(this.wEncoding.getText());
        this.input.setHttpLogin(this.wHttpLogin.getText());
        this.input.setHttpPassword(this.wHttpPassword.getText());
        this.input.setProxyHost(this.wProxyHost.getText());
        this.input.setProxyPort(this.wProxyPort.getText());
        this.input.setResultCodeFieldName(this.wResultCode.getText());
        this.input.setResponseTimeFieldName(this.wResponseTime.getText());
        this.input.setResponseHeaderFieldName(this.wResponseHeader.getText());
        this.input.setSocketTimeout(this.wSocketTimeOut.getText());
        this.input.setConnectionTimeout(this.wConnectionTimeOut.getText());
        this.input.setCloseIdleConnectionsTime(this.wCloseIdleConnectionsTime.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"HTTPDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HTTPDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getHeadersFields() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wHeaders, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"HTTPDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HTTPDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

