/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.io.ConsoleIO;
import org.apache.beam.runners.spark.io.CreateStream;
import org.apache.beam.runners.spark.io.SparkUnboundedSource;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.stateful.SparkGroupAlsoByWindowViaWindowSet;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.GroupCombineFunctions;
import org.apache.beam.runners.spark.translation.MultiDoFnFunction;
import org.apache.beam.runners.spark.translation.SparkAssignWindowFn;
import org.apache.beam.runners.spark.translation.SparkCombineFn;
import org.apache.beam.runners.spark.translation.SparkPCollectionView;
import org.apache.beam.runners.spark.translation.SparkPipelineTranslator;
import org.apache.beam.runners.spark.translation.TransformEvaluator;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.streaming.TestDStream;
import org.apache.beam.runners.spark.translation.streaming.UnboundedDataset;
import org.apache.beam.runners.spark.translation.streaming.WatermarkSyncedDStream;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ConstantInputDStream;
import org.apache.spark.streaming.dstream.DStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class StreamingTransformTranslator {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> EVALUATORS = new HashMap();

    private StreamingTransformTranslator() {
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator< @UnknownKeyFor @NonNull @Initialized ConsoleIO.Write.Unbound<T>> print() {
        return new TransformEvaluator<ConsoleIO.Write.Unbound<T>>(){

            @Override
            public void evaluate( @UnknownKeyFor @NonNull @Initialized ConsoleIO.Write.Unbound<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                JavaDStream dstream = ((UnboundedDataset)context.borrowDataset(transform)).getDStream();
                dstream.map(WindowedValue::getValue).print(transform.getNum());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return ".print(...)";
            }
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized Impulse> impulse() {
        return new TransformEvaluator<Impulse>(){

            @Override
            public void evaluate(@UnknownKeyFor @NonNull @Initialized Impulse transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                ClassTag classTag = ClassTag$.MODULE$.apply(WindowedValue.class);
                JavaRDD rdd = context.getSparkContext().parallelize(Collections.singletonList(WindowedValue.valueInGlobalWindow((Object)new byte[0])));
                ConstantInputDStream inputStream = new ConstantInputDStream(context.getStreamingContext().ssc(), rdd.rdd(), classTag);
                JavaDStream stream = new JavaDStream((DStream)inputStream, classTag);
                UnboundedDataset output = new UnboundedDataset(stream, Collections.singletonList(inputStream.id()));
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)output);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "streamingContext.<impulse>()";
            }
        };
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveUnboundedRead<T>> readUnbounded() {
        return new TransformEvaluator<SplittableParDo.PrimitiveUnboundedRead<T>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized SplittableParDo.PrimitiveUnboundedRead<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                String stepName = context.getCurrentTransform().getFullName();
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)SparkUnboundedSource.read(context.getStreamingContext(), context.getSerializableOptions(), transform.getSource(), stepName));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "streamingContext.<readFrom(<source>)>()";
            }
        };
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized TestStream<T>> createFromTestStream() {
        return new TransformEvaluator<TestStream<T>>(){

            @Override
            public void evaluate(@UnknownKeyFor @NonNull @Initialized TestStream<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                TestDStream dStream = new TestDStream(transform, context.getStreamingContext().ssc());
                JavaInputDStream javaDStream = new JavaInputDStream(dStream, JavaSparkContext$.MODULE$.fakeClassTag());
                UnboundedDataset dataset = new UnboundedDataset(javaDStream, Collections.singletonList(dStream.id()));
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)dataset);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "streamingContext.testStream(...)";
            }
        };
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized CreateStream<T>> createFromQueue() {
        return new TransformEvaluator<CreateStream<T>>(){

            @Override
            public void evaluate(@UnknownKeyFor @NonNull @Initialized CreateStream<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                Queue rddQueue = this.buildRdds(transform.getBatches(), context.getStreamingContext(), ((PCollection)context.getOutput(transform)).getCoder());
                JavaInputDStream javaInputDStream = this.buildInputStream(rddQueue, transform, context);
                UnboundedDataset unboundedDataset = new UnboundedDataset(javaInputDStream, Collections.singletonList(javaInputDStream.inputDStream().id()));
                GlobalWatermarkHolder.addAll((Map<Integer, Queue<GlobalWatermarkHolder.SparkWatermarks>>)ImmutableMap.of((Object)unboundedDataset.getStreamSources().get(0), transform.getTimes()));
                context.putDataset(transform, unboundedDataset);
            }

            private @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>>> buildRdds(@UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>>> batches, @UnknownKeyFor @NonNull @Initialized JavaStreamingContext jssc, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
                WindowedValue.FullWindowedValueCoder windowCoder = WindowedValue.FullWindowedValueCoder.of(coder, (Coder)GlobalWindow.Coder.INSTANCE);
                LinkedBlockingQueue rddQueue = new LinkedBlockingQueue();
                for (Iterable iterable : batches) {
                    Iterable windowedValues = StreamSupport.stream(iterable.spliterator(), false).map(timestampedValue -> WindowedValue.of((Object)timestampedValue.getValue(), (Instant)timestampedValue.getTimestamp(), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING)).collect(Collectors.toList());
                    JavaRDD rdd = jssc.sparkContext().parallelize(CoderHelpers.toByteArrays(windowedValues, windowCoder)).map(CoderHelpers.fromByteFunction(windowCoder));
                    rddQueue.offer(rdd);
                }
                return rddQueue;
            }

            private @UnknownKeyFor @NonNull @Initialized JavaInputDStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> buildInputStream(@UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>>> rddQueue, @UnknownKeyFor @NonNull @Initialized CreateStream<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                return transform.isForceWatermarkSync() ? new JavaInputDStream(new WatermarkSyncedDStream(rddQueue, transform.getBatchDuration(), context.getStreamingContext().ssc()), JavaSparkContext$.MODULE$.fakeClassTag()) : context.getStreamingContext().queueStream(rddQueue, true);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "streamingContext.queueStream(...)";
            }
        };
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Flatten.PCollections<T>> flattenPColl() {
        return new TransformEvaluator<Flatten.PCollections<T>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Flatten.PCollections<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                Map<TupleTag<?>, PCollection<?>> pcs = context.getInputs((PTransform<?, ?>)transform);
                ArrayList<Object> dStreams = new ArrayList<Object>();
                ArrayList<Integer> streamingSources = new ArrayList<Integer>();
                for (PValue pValue : pcs.values()) {
                    Preconditions.checkArgument((boolean)(pValue instanceof PCollection), (String)"Flatten had non-PCollection value in input: %s of type %s", (Object)pValue, (Object)pValue.getClass().getSimpleName());
                    PCollection pcol = (PCollection)pValue;
                    Dataset dataset = context.borrowDataset((PValue)pcol);
                    if (dataset instanceof UnboundedDataset) {
                        UnboundedDataset unboundedDataset = (UnboundedDataset)dataset;
                        streamingSources.addAll(unboundedDataset.getStreamSources());
                        dStreams.add(unboundedDataset.getDStream());
                        continue;
                    }
                    LinkedBlockingQueue q = new LinkedBlockingQueue();
                    q.offer(((BoundedDataset)dataset).getRDD());
                    JavaDStream dStream = context.getStreamingContext().queueStream(q);
                    dStreams.add(dStream);
                }
                JavaDStream unifiedStreams = context.getStreamingContext().union((Seq)JavaConverters.asScalaBuffer(dStreams));
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new UnboundedDataset(unifiedStreams, streamingSources));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "streamingContext.union(...)";
            }
        };
    }

    private static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Window.Assign<T>> window() {
        return new TransformEvaluator<Window.Assign<T>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Window.Assign<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                UnboundedDataset unboundedDataset = (UnboundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform);
                JavaDStream dStream = unboundedDataset.getDStream();
                JavaDStream outputStream = TranslationUtils.skipAssignWindows(transform, context) ? dStream : dStream.transform((Function & Serializable)rdd -> rdd.map(new SparkAssignWindowFn(transform.getWindowFn())));
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new UnboundedDataset(outputStream, unboundedDataset.getStreamSources()));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "map(new <windowFn>())";
            }
        };
    }

    private static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized GroupByKey<K, V>> groupByKey() {
        return new TransformEvaluator<GroupByKey<K, V>>(){

            @Override
            public void evaluate(@UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                UnboundedDataset inputDataset = (UnboundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform);
                List<Integer> streamSources = inputDataset.getStreamSources();
                JavaDStream dStream = inputDataset.getDStream();
                KvCoder coder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                WindowFn windowFn = windowingStrategy.getWindowFn();
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder.getValueCoder(), (Coder)windowFn.windowCoder());
                JavaDStream outStream = SparkGroupAlsoByWindowViaWindowSet.groupByKeyAndWindow(dStream, coder.getKeyCoder(), wvCoder, windowingStrategy, context.getSerializableOptions(), streamSources, context.getCurrentTransform().getFullName());
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new UnboundedDataset(outStream, streamSources));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "groupByKey()";
            }
        };
    }

    private static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<K, InputT, OutputT>> combineGrouped() {
        return new TransformEvaluator<Combine.GroupedValues<K, InputT, OutputT>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<K, InputT, OutputT> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                PCollection input = (PCollection)context.getInput(transform);
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                CombineWithContext.CombineFnWithContext fn = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)transform.getFn());
                UnboundedDataset unboundedDataset = (UnboundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform);
                JavaDStream dStream = unboundedDataset.getDStream();
                SerializablePipelineOptions options = context.getSerializableOptions();
                SparkPCollectionView pviews = context.getPViews();
                JavaDStream outStream = dStream.transform((Function & Serializable)rdd -> {
                    SparkCombineFn combineFnWithContext = SparkCombineFn.keyed(fn, options, TranslationUtils.getSideInputs(transform.getSideInputs(), new JavaSparkContext(rdd.context()), pviews), windowingStrategy);
                    return rdd.map(new TranslationUtils.CombineGroupedValues(combineFnWithContext));
                });
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new UnboundedDataset(outStream, unboundedDataset.getStreamSources()));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "map(new <fn>())";
            }
        };
    }

    private static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT>> parDo() {
        return new TransformEvaluator<ParDo.MultiOutput<InputT, OutputT>>(){

            @Override
            public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                DoFn doFn = transform.getFn();
                Preconditions.checkArgument((!DoFnSignatures.signatureForDoFn((DoFn)doFn).processElement().isSplittable() ? 1 : 0) != 0, (String)"Splittable DoFn not yet supported in streaming mode: %s", (Object)doFn);
                TranslationUtils.rejectStateAndTimers(doFn);
                SerializablePipelineOptions options = context.getSerializableOptions();
                SparkPCollectionView pviews = context.getPViews();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                Coder inputCoder = ((PCollection)context.getInput(transform)).getCoder();
                Map<TupleTag<?>, Coder<?>> outputCoders = context.getOutputCoders();
                UnboundedDataset unboundedDataset = (UnboundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform);
                JavaDStream dStream = unboundedDataset.getDStream();
                DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
                Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
                String stepName = context.getCurrentTransform().getFullName();
                JavaPairDStream all = dStream.transformToPair((Function & Serializable)rdd -> {
                    MetricsContainerStepMapAccumulator metricsAccum = MetricsAccumulator.getInstance();
                    Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs = TranslationUtils.getSideInputs(transform.getSideInputs().values(), JavaSparkContext.fromSparkContext((SparkContext)rdd.context()), pviews);
                    return rdd.mapPartitionsToPair(new MultiDoFnFunction(metricsAccum, stepName, doFn, options, transform.getMainOutputTag(), transform.getAdditionalOutputTags().getAll(), inputCoder, outputCoders, sideInputs, windowingStrategy, false, doFnSchemaInformation, sideInputMapping, false));
                });
                Map<TupleTag<?>, PCollection<?>> outputs = context.getOutputs((PTransform<?, ?>)transform);
                if (outputs.size() > 1) {
                    Map<TupleTag<?>, Coder<WindowedValue<?>>> coderMap = TranslationUtils.getTupleTagCoders(outputs);
                    all = all.mapToPair(TranslationUtils.getTupleTagEncodeFunction(coderMap)).cache().mapToPair(TranslationUtils.getTupleTagDecodeFunction(coderMap));
                }
                for (Map.Entry<TupleTag<?>, PCollection<?>> output : outputs.entrySet()) {
                    JavaPairDStream filtered = all.filter(new TranslationUtils.TupleTagFilter(output.getKey()));
                    JavaDStream values = TranslationUtils.dStreamValues(filtered);
                    context.putDataset((PValue)output.getValue(), new UnboundedDataset(values, unboundedDataset.getStreamSources()));
                }
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "mapPartitions(new <fn>())";
            }
        };
    }

    private static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized Reshuffle<K, V>> reshuffle() {
        return new TransformEvaluator<Reshuffle<K, V>>(){

            @Override
            public void evaluate(@UnknownKeyFor @NonNull @Initialized Reshuffle<K, V> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
                UnboundedDataset inputDataset = (UnboundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform);
                List<Integer> streamSources = inputDataset.getStreamSources();
                JavaDStream dStream = inputDataset.getDStream();
                KvCoder coder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                WindowFn windowFn = windowingStrategy.getWindowFn();
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder, (Coder)windowFn.windowCoder());
                JavaDStream reshuffledStream = dStream.transform(arg_0 -> 11.lambda$evaluate$7bc3c981$1((WindowedValue.WindowedValueCoder)wvCoder, arg_0));
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new UnboundedDataset(reshuffledStream, streamSources));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toNativeString() {
                return "repartition(...)";
            }

            private static /* synthetic */ JavaRDD lambda$evaluate$7bc3c981$1(WindowedValue.WindowedValueCoder wvCoder, JavaRDD rdd) throws Exception {
                return GroupCombineFunctions.reshuffle(rdd, wvCoder);
            }
        };
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized TransformEvaluator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getTranslator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        @Nullable String urn = PTransformTranslation.urnForTransformOrNull(transform);
        return urn == null ? null : EVALUATORS.get(urn);
    }

    static {
        EVALUATORS.put("beam:transform:impulse:v1", StreamingTransformTranslator.impulse());
        EVALUATORS.put("beam:transform:read:v1", StreamingTransformTranslator.readUnbounded());
        EVALUATORS.put("beam:transform:group_by_key:v1", StreamingTransformTranslator.groupByKey());
        EVALUATORS.put("beam:transform:combine_grouped_values:v1", StreamingTransformTranslator.combineGrouped());
        EVALUATORS.put("beam:transform:pardo:v1", StreamingTransformTranslator.parDo());
        EVALUATORS.put("beam:transform:spark:consoleio_write_unbound:v1", StreamingTransformTranslator.print());
        EVALUATORS.put("beam:transform:window_into:v1", StreamingTransformTranslator.window());
        EVALUATORS.put("beam:transform:flatten:v1", StreamingTransformTranslator.flattenPColl());
        EVALUATORS.put("beam:transform:reshuffle:v1", StreamingTransformTranslator.reshuffle());
        EVALUATORS.put("beam:transform:spark:createstream:v1", StreamingTransformTranslator.createFromQueue());
        EVALUATORS.put("beam:transform:teststream:v1", StreamingTransformTranslator.createFromTestStream());
    }

    private static class SparkCreateStreamPayloadTranslator
    extends PTransformTranslation.TransformPayloadTranslator.NotSerializable<CreateStream<?>> {
        private SparkCreateStreamPayloadTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CreateStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            return "beam:transform:spark:createstream:v1";
        }
    }

    private static class SparkConsoleIOWriteUnboundedPayloadTranslator
    extends PTransformTranslation.TransformPayloadTranslator.NotSerializable<ConsoleIO.Write.Unbound<?>> {
        private SparkConsoleIOWriteUnboundedPayloadTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getUrn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @NonNull @Initialized ConsoleIO.Write.Unbound<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            return "beam:transform:spark:consoleio_write_unbound:v1";
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class SparkTransformsRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.of(ConsoleIO.Write.Unbound.class, (Object)((Object)new SparkConsoleIOWriteUnboundedPayloadTranslator()), CreateStream.class, (Object)((Object)new SparkCreateStreamPayloadTranslator()));
        }
    }

    public static class Translator
    implements SparkPipelineTranslator {
        private final @UnknownKeyFor @NonNull @Initialized SparkPipelineTranslator batchTranslator;

        public Translator(@UnknownKeyFor @NonNull @Initialized SparkPipelineTranslator batchTranslator) {
            this.batchTranslator = batchTranslator;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean hasTranslation(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            return EVALUATORS.containsKey(PTransformTranslation.urnForTransformOrNull(transform));
        }

        @Override
        public <TransformT extends PTransform<?, ?>> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<TransformT> translateBounded(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            TransformEvaluator transformEvaluator = this.batchTranslator.translateBounded(transform);
            Preconditions.checkState((transformEvaluator != null ? 1 : 0) != 0, (String)"No TransformEvaluator registered for BOUNDED transform %s", transform);
            return transformEvaluator;
        }

        @Override
        public <TransformT extends PTransform<?, ?>> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<TransformT> translateUnbounded(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            TransformEvaluator transformEvaluator = StreamingTransformTranslator.getTranslator(transform);
            Preconditions.checkState((transformEvaluator != null ? 1 : 0) != 0, (String)"No TransformEvaluator registered for UNBOUNDED transform %s", transform);
            return transformEvaluator;
        }
    }
}

