/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.GroupNonMergingWindowsFunctions;
import org.apache.beam.runners.spark.translation.ReifyTimestampsAndWindowsFunction;
import org.apache.beam.runners.spark.translation.SparkCombineFn;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.ValueAndCoderLazySerializable;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Tuple2;

public class GroupCombineFunctions {
    public static <K, V> @UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<V>>>> groupByKeyOnly(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> rdd, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder, @Nullable @UnknownKeyFor @Initialized Partitioner partitioner) {
        JavaPairRDD pairRDD = rdd.map(new ReifyTimestampsAndWindowsFunction()).mapToPair(TranslationUtils.toPairFunction()).mapToPair(CoderHelpers.toByteFunction(keyCoder, wvCoder));
        JavaPairRDD groupedRDD = partitioner != null ? pairRDD.groupByKey(partitioner) : pairRDD.groupByKey();
        return groupedRDD.mapToPair(CoderHelpers.fromByteFunctionIterable(keyCoder, wvCoder)).map(new TranslationUtils.FromPairFunction());
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized JavaPairRDD<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>>> groupByKeyPair(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> rdd, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder) {
        JavaPairRDD pairRDD = rdd.map(new ReifyTimestampsAndWindowsFunction()).mapToPair(TranslationUtils.toPairFunction()).mapToPair(CoderHelpers.toByteFunction(keyCoder, wvCoder));
        JavaPairRDD groupedRDD = pairRDD.groupBy((Function & Serializable)value -> (ByteArray)value._1);
        return groupedRDD.mapValues((Function & Serializable)it -> Iterables.transform((Iterable)it, new CoderHelpers.FromByteFunction(keyCoder, wvCoder))).mapValues((Function & Serializable)it -> Iterables.transform((Iterable)it, new TranslationUtils.FromPairFunction())).mapValues((Function & Serializable)it -> Iterables.transform((Iterable)it, new TranslationUtils.ToKVByWindowInValueFunction()));
    }

    public static <InputT, OutputT, AccumT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SparkCombineFn.WindowedAccumulator<InputT, InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> combineGlobally(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> rdd, @UnknownKeyFor @NonNull @Initialized SparkCombineFn<InputT, InputT, AccumT, OutputT> sparkCombineFn, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> aCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        Coder windowCoder = windowingStrategy.getWindowFn().windowCoder();
        SparkCombineFn.WindowedAccumulatorCoder waCoder = sparkCombineFn.accumulatorCoder((Coder<BoundedWindow>)windowCoder, aCoder, windowingStrategy);
        ValueAndCoderLazySerializable accumulatedResult = (ValueAndCoderLazySerializable)rdd.aggregate(ValueAndCoderLazySerializable.of(sparkCombineFn.createCombiner(), waCoder), (Function2 & Serializable)(ab, ib) -> {
            SparkCombineFn.WindowedAccumulator merged = sparkCombineFn.mergeValue((SparkCombineFn.WindowedAccumulator)ab.getOrDecode(waCoder), (WindowedValue)ib);
            return ValueAndCoderLazySerializable.of(merged, waCoder);
        }, (Function2 & Serializable)(a1b, a2b) -> {
            SparkCombineFn.WindowedAccumulator merged = sparkCombineFn.mergeCombiners((SparkCombineFn.WindowedAccumulator)a1b.getOrDecode(waCoder), (SparkCombineFn.WindowedAccumulator)a2b.getOrDecode(waCoder));
            return ValueAndCoderLazySerializable.of(merged, waCoder);
        });
        return (SparkCombineFn.WindowedAccumulator)accumulatedResult.getOrDecode(waCoder);
    }

    public static <K, V, AccumT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JavaPairRDD<K, @UnknownKeyFor @NonNull @Initialized SparkCombineFn.WindowedAccumulator<@UnknownKeyFor @NonNull @Initialized KV<K, V>, V, AccumT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> combinePerKey(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> rdd, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SparkCombineFn<@UnknownKeyFor @NonNull @Initialized KV<K, V>, V, AccumT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> sparkCombineFn, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> aCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        boolean mustBringWindowToKey = sparkCombineFn.mustBringWindowToKey();
        Coder windowCoder = windowingStrategy.getWindowFn().windowCoder();
        SparkCombineFn.WindowedAccumulatorCoder waCoder = sparkCombineFn.accumulatorCoder((Coder<BoundedWindow>)windowCoder, aCoder, windowingStrategy);
        JavaPairRDD<ByteArray, WindowedValue<KV<K, V>>> inRddDuplicatedKeyPair = !mustBringWindowToKey ? rdd.mapToPair(TranslationUtils.toPairByKeyInWindowedValue(keyCoder)) : GroupNonMergingWindowsFunctions.bringWindowToKey(rdd, keyCoder, windowCoder);
        JavaPairRDD accumulatedResult = inRddDuplicatedKeyPair.combineByKey((Function & Serializable)input -> ValueAndCoderLazySerializable.of(sparkCombineFn.createCombiner((WindowedValue)input), waCoder), (Function2 & Serializable)(acc, input) -> ValueAndCoderLazySerializable.of(sparkCombineFn.mergeValue((SparkCombineFn.WindowedAccumulator)acc.getOrDecode(waCoder), (WindowedValue)input), waCoder), (Function2 & Serializable)(acc1, acc2) -> ValueAndCoderLazySerializable.of(sparkCombineFn.mergeCombiners((SparkCombineFn.WindowedAccumulator)acc1.getOrDecode(waCoder), (SparkCombineFn.WindowedAccumulator)acc2.getOrDecode(waCoder)), waCoder));
        return accumulatedResult.mapToPair((PairFunction & Serializable)i -> new Tuple2(CoderHelpers.fromByteArray(((ByteArray)i._1).getValue(), keyCoder), (Object)((SparkCombineFn.WindowedAccumulator)((ValueAndCoderLazySerializable)i._2).getOrDecode(waCoder))));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> reshuffle(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> rdd, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<T> wvCoder) {
        return rdd.map(CoderHelpers.toByteFunction(wvCoder)).repartition(Math.max(rdd.context().defaultParallelism(), rdd.getNumPartitions())).map(CoderHelpers.fromByteFunction(wvCoder));
    }
}

