/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.regexeval;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.regexeval.RegexEvalHelperDialog;
import org.apache.hop.pipeline.transforms.regexeval.RegexEvalMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RegexEvalDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = RegexEvalMeta.class;
    private StyledTextComp wScript;
    private LabelTextVar wResultField;
    private CCombo wFieldEvaluate;
    private final RegexEvalMeta input;
    private Label wlReplaceFields;
    private Button wCanonEq;
    private Button wCaseInsensitive;
    private Button wComment;
    private Button wDotAll;
    private Button wMultiline;
    private Button wUnicode;
    private Button wUnix;
    private Button wUseVar;
    private Button wAllowCaptureGroups;
    private Button wReplaceFields;
    private Label wlFields;
    private TableView wFields;

    public RegexEvalDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (RegexEvalMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegexEvalDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        RegexEvalDialog regexEvalDialog = this;
        int margin = regexEvalDialog.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        SashForm wSash = new SashForm((Composite)this.shell, 512);
        CTabFolder wTabFolder = new CTabFolder((Composite)wSash, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.GeneralTab.TabTitle", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wTransformSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wTransformSettings);
        wTransformSettings.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Group.TransformSettings.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wTransformSettings.setLayout((Layout)groupLayout);
        Label wlfieldevaluate = new Label((Composite)wTransformSettings, 131072);
        wlfieldevaluate.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Matcher.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlfieldevaluate);
        FormData fdlfieldevaluate = new FormData();
        fdlfieldevaluate.left = new FormAttachment(0, 0);
        fdlfieldevaluate.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlfieldevaluate.right = new FormAttachment(middle, -margin);
        wlfieldevaluate.setLayoutData((Object)fdlfieldevaluate);
        this.wFieldEvaluate = new CCombo((Composite)wTransformSettings, 2056);
        this.wFieldEvaluate.setEditable(true);
        PropsUi.setLook((Widget)this.wFieldEvaluate);
        this.wFieldEvaluate.addModifyListener(lsMod);
        FormData fdfieldevaluate = new FormData();
        fdfieldevaluate.left = new FormAttachment(middle, margin);
        fdfieldevaluate.top = new FormAttachment((Control)this.wTransformName, margin);
        fdfieldevaluate.right = new FormAttachment(100, -margin);
        this.wFieldEvaluate.setLayoutData((Object)fdfieldevaluate);
        this.wFieldEvaluate.addSelectionListener((SelectionListener)lsSel);
        this.wFieldEvaluate.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)RegexEvalDialog.this.shell.getDisplay(), 1);
                RegexEvalDialog.this.shell.setCursor(busy);
                RegexEvalDialog.this.getPreviousFields();
                RegexEvalDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wResultField = new LabelTextVar(this.variables, (Composite)wTransformSettings, BaseMessages.getString(PKG, (String)"RegexEvalDialog.ResultField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RegexEvalDialog.ResultField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResultField);
        this.wResultField.addModifyListener(lsMod);
        FormData fdResultField = new FormData();
        fdResultField.left = new FormAttachment(0, 0);
        fdResultField.top = new FormAttachment((Control)this.wFieldEvaluate, margin);
        fdResultField.right = new FormAttachment(100, 0);
        this.wResultField.setLayoutData((Object)fdResultField);
        Label wlAllowCaptureGroups = new Label((Composite)wTransformSettings, 131072);
        wlAllowCaptureGroups.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.AllowCaptureGroups.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAllowCaptureGroups);
        FormData fdlAllowCaptureGroups = new FormData();
        fdlAllowCaptureGroups.left = new FormAttachment(0, 0);
        fdlAllowCaptureGroups.top = new FormAttachment((Control)this.wResultField, margin);
        fdlAllowCaptureGroups.right = new FormAttachment(middle, -margin);
        wlAllowCaptureGroups.setLayoutData((Object)fdlAllowCaptureGroups);
        this.wAllowCaptureGroups = new Button((Composite)wTransformSettings, 32);
        this.wAllowCaptureGroups.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.AllowCaptureGroups.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAllowCaptureGroups);
        FormData fdAllowCaptureGroups = new FormData();
        fdAllowCaptureGroups.left = new FormAttachment(middle, margin);
        fdAllowCaptureGroups.top = new FormAttachment((Control)wlAllowCaptureGroups, 0, 0x1000000);
        fdAllowCaptureGroups.right = new FormAttachment(100, 0);
        this.wAllowCaptureGroups.setLayoutData((Object)fdAllowCaptureGroups);
        this.wAllowCaptureGroups.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegexEvalDialog.this.setFieldsEnabledStatus();
                RegexEvalDialog.this.input.setChanged();
            }
        });
        this.wlReplaceFields = new Label((Composite)wTransformSettings, 131072);
        this.wlReplaceFields.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ReplaceFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlReplaceFields);
        FormData fdlReplaceFields = new FormData();
        fdlReplaceFields.left = new FormAttachment(0, 0);
        fdlReplaceFields.top = new FormAttachment((Control)this.wAllowCaptureGroups, margin);
        fdlReplaceFields.right = new FormAttachment(middle, -margin);
        this.wlReplaceFields.setLayoutData((Object)fdlReplaceFields);
        this.wReplaceFields = new Button((Composite)wTransformSettings, 32);
        this.wReplaceFields.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ReplaceFields.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wReplaceFields);
        FormData fdReplaceFields = new FormData();
        fdReplaceFields.left = new FormAttachment(middle, margin);
        fdReplaceFields.top = new FormAttachment((Control)this.wlReplaceFields, 0, 0x1000000);
        fdReplaceFields.right = new FormAttachment(100, 0);
        this.wReplaceFields.setLayoutData((Object)fdReplaceFields);
        this.wReplaceFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegexEvalDialog.this.input.setChanged();
            }
        });
        FormData fdTransformSettings = new FormData();
        fdTransformSettings.left = new FormAttachment(0, margin);
        fdTransformSettings.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTransformSettings.right = new FormAttachment(100, -margin);
        wTransformSettings.setLayoutData((Object)fdTransformSettings);
        Label wlScript = new Label(wGeneralComp, 0);
        wlScript.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Javascript.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScript);
        FormData fdlScript = new FormData();
        fdlScript.left = new FormAttachment(0, 0);
        fdlScript.top = new FormAttachment((Control)wTransformSettings, margin);
        wlScript.setLayoutData((Object)fdlScript);
        Button wbTestRegExScript = new Button(wGeneralComp, 0x1000008);
        PropsUi.setLook((Widget)wbTestRegExScript);
        wbTestRegExScript.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.TestScript.Label", (String[])new String[0]));
        FormData fdbTestRegExScript = new FormData();
        fdbTestRegExScript.right = new FormAttachment(100, -margin);
        fdbTestRegExScript.top = new FormAttachment((Control)wTransformSettings, margin);
        wbTestRegExScript.setLayoutData((Object)fdbTestRegExScript);
        wbTestRegExScript.addListener(13, e -> this.testRegExScript());
        Label wlUseVar = new Label(wGeneralComp, 0);
        wlUseVar.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.UseVar.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseVar);
        FormData fdlUseVar = new FormData();
        fdlUseVar.left = new FormAttachment(0, margin);
        fdlUseVar.bottom = new FormAttachment(100, 0);
        wlUseVar.setLayoutData((Object)fdlUseVar);
        this.wUseVar = new Button(wGeneralComp, 32);
        this.wUseVar.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.UseVar.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUseVar);
        FormData fdUseVar = new FormData();
        fdUseVar.left = new FormAttachment((Control)wlUseVar, margin);
        fdUseVar.top = new FormAttachment((Control)wlUseVar, 0, 0x1000000);
        this.wUseVar.setLayoutData((Object)fdUseVar);
        this.wUseVar.addSelectionListener((SelectionListener)lsSel);
        Composite wBottom = new Composite((Composite)wSash, 0);
        PropsUi.setLook((Widget)wBottom);
        this.wScript = new StyledTextComp(this.variables, wGeneralComp, 19202);
        this.wScript.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Script.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wScript, (int)1);
        this.wScript.addModifyListener(lsMod);
        FormData fdScript = new FormData();
        fdScript.left = new FormAttachment(0, 0);
        fdScript.top = new FormAttachment((Control)wbTestRegExScript, margin);
        fdScript.right = new FormAttachment(100, -10);
        fdScript.bottom = new FormAttachment((Control)this.wUseVar, -2 * margin);
        this.wScript.setLayoutData((Object)fdScript);
        FormLayout bottomLayout = new FormLayout();
        bottomLayout.marginWidth = PropsUi.getFormMargin();
        bottomLayout.marginHeight = PropsUi.getFormMargin();
        wBottom.setLayout((Layout)bottomLayout);
        Label wSeparator = new Label(wBottom, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(0, 0);
        fdSeparator.right = new FormAttachment(100, 0);
        fdSeparator.top = new FormAttachment(0, -margin + 2);
        wSeparator.setLayoutData((Object)fdSeparator);
        this.wlFields = new Label(wBottom, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Fields.Label", (String[])new String[0]));
        this.wlFields.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Fields.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)wSeparator, 0);
        this.wlFields.setLayoutData((Object)fdlFields);
        int fieldsRows = this.input.getFieldName().length;
        ColumnInfo[] columnInfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.NewField", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.Format", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.Nullif", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.IfNull", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ColumnInfo.TrimType", (String[])new String[0]), 2, ValueMetaString.trimTypeDesc, true)};
        this.wFields = new TableView(this.variables, wBottom, 67586, columnInfo, fieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        this.wFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{2, 20, 10, 5, 5, 10, 8, 8, 8, 8, 8, 8}));
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        CTabItem wContentTab = new CTabItem(wTabFolder, 0);
        wContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wContentTab.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Group wRegexSettings = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wRegexSettings);
        wRegexSettings.setText("Regex Settings");
        FormLayout regexLayout = new FormLayout();
        regexLayout.marginWidth = 10;
        regexLayout.marginHeight = 10;
        wRegexSettings.setLayout((Layout)regexLayout);
        Label wlCanonEq = new Label((Composite)wRegexSettings, 131072);
        wlCanonEq.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.CanonEq.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCanonEq);
        FormData fdlCanonEq = new FormData();
        fdlCanonEq.left = new FormAttachment(0, 0);
        fdlCanonEq.top = new FormAttachment((Control)wTransformSettings, margin);
        fdlCanonEq.right = new FormAttachment(middle, -margin);
        wlCanonEq.setLayoutData((Object)fdlCanonEq);
        this.wCanonEq = new Button((Composite)wRegexSettings, 32);
        this.wCanonEq.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.CanonEq.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCanonEq);
        FormData fdCanonEq = new FormData();
        fdCanonEq.left = new FormAttachment(middle, 0);
        fdCanonEq.top = new FormAttachment((Control)wlCanonEq, 0, 0x1000000);
        fdCanonEq.right = new FormAttachment(100, 0);
        this.wCanonEq.setLayoutData((Object)fdCanonEq);
        this.wCanonEq.addSelectionListener((SelectionListener)lsSel);
        Label wlCaseInsensitive = new Label((Composite)wRegexSettings, 131072);
        wlCaseInsensitive.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.CaseInsensitive.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCaseInsensitive);
        FormData fdlCaseInsensitive = new FormData();
        fdlCaseInsensitive.left = new FormAttachment(0, 0);
        fdlCaseInsensitive.top = new FormAttachment((Control)this.wCanonEq, margin);
        fdlCaseInsensitive.right = new FormAttachment(middle, -margin);
        wlCaseInsensitive.setLayoutData((Object)fdlCaseInsensitive);
        this.wCaseInsensitive = new Button((Composite)wRegexSettings, 32);
        this.wCaseInsensitive.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.CaseInsensitive.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCaseInsensitive);
        FormData fdCaseInsensitive = new FormData();
        fdCaseInsensitive.left = new FormAttachment(middle, 0);
        fdCaseInsensitive.top = new FormAttachment((Control)wlCaseInsensitive, 0, 0x1000000);
        fdCaseInsensitive.right = new FormAttachment(100, 0);
        this.wCaseInsensitive.setLayoutData((Object)fdCaseInsensitive);
        this.wCaseInsensitive.addSelectionListener((SelectionListener)lsSel);
        Label wlComment = new Label((Composite)wRegexSettings, 131072);
        wlComment.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Comment.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlComment);
        FormData fdlComment = new FormData();
        fdlComment.left = new FormAttachment(0, 0);
        fdlComment.top = new FormAttachment((Control)this.wCaseInsensitive, margin);
        fdlComment.right = new FormAttachment(middle, -margin);
        wlComment.setLayoutData((Object)fdlComment);
        this.wComment = new Button((Composite)wRegexSettings, 32);
        this.wComment.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Comment.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wComment);
        FormData fdComment = new FormData();
        fdComment.left = new FormAttachment(middle, 0);
        fdComment.top = new FormAttachment((Control)wlComment, 0, 0x1000000);
        fdComment.right = new FormAttachment(100, 0);
        this.wComment.setLayoutData((Object)fdComment);
        this.wComment.addSelectionListener((SelectionListener)lsSel);
        Label wlDotAll = new Label((Composite)wRegexSettings, 131072);
        wlDotAll.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.DotAll.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDotAll);
        FormData fdlDotAll = new FormData();
        fdlDotAll.left = new FormAttachment(0, 0);
        fdlDotAll.top = new FormAttachment((Control)this.wComment, margin);
        fdlDotAll.right = new FormAttachment(middle, -margin);
        wlDotAll.setLayoutData((Object)fdlDotAll);
        this.wDotAll = new Button((Composite)wRegexSettings, 32);
        this.wDotAll.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.DotAll.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDotAll);
        FormData fdDotAll = new FormData();
        fdDotAll.left = new FormAttachment(middle, 0);
        fdDotAll.top = new FormAttachment((Control)wlDotAll, 0, 0x1000000);
        fdDotAll.right = new FormAttachment(100, 0);
        this.wDotAll.setLayoutData((Object)fdDotAll);
        this.wDotAll.addSelectionListener((SelectionListener)lsSel);
        Label wlMultiline = new Label((Composite)wRegexSettings, 131072);
        wlMultiline.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Multiline.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMultiline);
        FormData fdlMultiline = new FormData();
        fdlMultiline.left = new FormAttachment(0, 0);
        fdlMultiline.top = new FormAttachment((Control)this.wDotAll, margin);
        fdlMultiline.right = new FormAttachment(middle, -margin);
        wlMultiline.setLayoutData((Object)fdlMultiline);
        this.wMultiline = new Button((Composite)wRegexSettings, 32);
        this.wMultiline.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Multiline.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wMultiline);
        FormData fdMultiline = new FormData();
        fdMultiline.left = new FormAttachment(middle, 0);
        fdMultiline.top = new FormAttachment((Control)wlMultiline, 0, 0x1000000);
        fdMultiline.right = new FormAttachment(100, 0);
        this.wMultiline.setLayoutData((Object)fdMultiline);
        this.wMultiline.addSelectionListener((SelectionListener)lsSel);
        Label wlUnicode = new Label((Composite)wRegexSettings, 131072);
        wlUnicode.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Unicode.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUnicode);
        FormData fdlUnicode = new FormData();
        fdlUnicode.left = new FormAttachment(0, 0);
        fdlUnicode.top = new FormAttachment((Control)this.wMultiline, margin);
        fdlUnicode.right = new FormAttachment(middle, -margin);
        wlUnicode.setLayoutData((Object)fdlUnicode);
        this.wUnicode = new Button((Composite)wRegexSettings, 32);
        this.wUnicode.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Unicode.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUnicode);
        FormData fdUnicode = new FormData();
        fdUnicode.left = new FormAttachment(middle, 0);
        fdUnicode.top = new FormAttachment((Control)wlUnicode, 0, 0x1000000);
        fdUnicode.right = new FormAttachment(100, 0);
        this.wUnicode.setLayoutData((Object)fdUnicode);
        this.wUnicode.addSelectionListener((SelectionListener)lsSel);
        Label wlUnix = new Label((Composite)wRegexSettings, 131072);
        wlUnix.setText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Unix.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUnix);
        FormData fdlUnix = new FormData();
        fdlUnix.left = new FormAttachment(0, 0);
        fdlUnix.top = new FormAttachment((Control)this.wUnicode, margin);
        fdlUnix.right = new FormAttachment(middle, -margin);
        wlUnix.setLayoutData((Object)fdlUnix);
        this.wUnix = new Button((Composite)wRegexSettings, 32);
        this.wUnix.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalDialog.Unix.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUnix);
        FormData fdUnix = new FormData();
        fdUnix.left = new FormAttachment(middle, 0);
        fdUnix.top = new FormAttachment((Control)wlUnix, 0, 0x1000000);
        fdUnix.right = new FormAttachment(100, 0);
        this.wUnix.setLayoutData((Object)fdUnix);
        this.wUnix.addSelectionListener((SelectionListener)lsSel);
        FormData fdRegexSettings = new FormData();
        fdRegexSettings.left = new FormAttachment(0, margin);
        fdRegexSettings.top = new FormAttachment((Control)wTransformSettings, margin);
        fdRegexSettings.right = new FormAttachment(100, -margin);
        wRegexSettings.setLayoutData((Object)fdRegexSettings);
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)wContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment(0, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        wBottom.setLayoutData((Object)fdBottom);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment((Control)this.wTransformName, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment((Control)this.wOk, -margin);
        wSash.setLayoutData((Object)fdSash);
        wSash.setWeights(new int[]{60, 40});
        wTabFolder.setSelection(0);
        this.getData();
        this.setFieldsEnabledStatus();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getPreviousFields() {
        String selectedValue = this.wFieldEvaluate.getText();
        this.wFieldEvaluate.removeAll();
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                for (String item : r.getFieldNames()) {
                    this.wFieldEvaluate.add(item);
                }
            }
            if (!Utils.isEmpty((CharSequence)selectedValue)) {
                this.wFieldEvaluate.select(this.wFieldEvaluate.indexOf(selectedValue));
            } else {
                this.wFieldEvaluate.select(0);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RegexEvalDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RegexEvalDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        if (this.input.getScript() != null) {
            this.wScript.setText(this.input.getScript());
        }
        if (this.input.getResultFieldName() != null) {
            this.wResultField.setText(this.input.getResultFieldName());
        }
        if (this.input.getMatcher() != null) {
            this.wFieldEvaluate.setText(this.input.getMatcher());
        }
        this.wUseVar.setSelection(this.input.isUseVariableInterpolationFlagSet());
        this.wReplaceFields.setSelection(this.input.isReplacefields());
        this.wAllowCaptureGroups.setSelection(this.input.isAllowCaptureGroupsFlagSet());
        this.wCanonEq.setSelection(this.input.isCanonicalEqualityFlagSet());
        this.wCaseInsensitive.setSelection(this.input.isCaseInsensitiveFlagSet());
        this.wComment.setSelection(this.input.isCommentFlagSet());
        this.wDotAll.setSelection(this.input.isDotAllFlagSet());
        this.wMultiline.setSelection(this.input.isMultilineFlagSet());
        this.wUnicode.setSelection(this.input.isUnicodeFlagSet());
        this.wUnix.setSelection(this.input.isUnixLineEndingsFlagSet());
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = this.wFields.table.getItem(i);
            if (this.input.getFieldName()[i] != null) {
                ti.setText(1, this.input.getFieldName()[i]);
            }
            ti.setText(2, ValueMetaFactory.getValueMetaName((int)this.input.getFieldType()[i]));
            ti.setText(3, (String)(this.input.getFieldLength()[i] >= 0 ? "" + this.input.getFieldLength()[i] : ""));
            ti.setText(4, (String)(this.input.getFieldPrecision()[i] >= 0 ? "" + this.input.getFieldPrecision()[i] : ""));
            if (this.input.getFieldFormat()[i] != null) {
                ti.setText(5, this.input.getFieldFormat()[i]);
            }
            if (this.input.getFieldGroup()[i] != null) {
                ti.setText(6, this.input.getFieldGroup()[i]);
            }
            if (this.input.getFieldDecimal()[i] != null) {
                ti.setText(7, this.input.getFieldDecimal()[i]);
            }
            if (this.input.getFieldCurrency()[i] != null) {
                ti.setText(8, this.input.getFieldCurrency()[i]);
            }
            if (this.input.getFieldNullIf()[i] != null) {
                ti.setText(9, this.input.getFieldNullIf()[i]);
            }
            if (this.input.getFieldIfNull()[i] != null) {
                ti.setText(10, this.input.getFieldIfNull()[i]);
            }
            ti.setText(11, ValueMetaString.getTrimTypeDesc((int)this.input.getFieldTrimType()[i]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.setRegexOptions(this.input);
        int nrFields = this.wFields.nrNonEmpty();
        this.input.allocate(nrFields);
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = ti.getText(1);
            this.input.getFieldType()[i] = ValueMetaFactory.getIdForValueMeta((String)ti.getText(2));
            this.input.getFieldLength()[i] = Const.toInt((String)ti.getText(3), (int)-1);
            this.input.getFieldPrecision()[i] = Const.toInt((String)ti.getText(4), (int)-1);
            this.input.getFieldFormat()[i] = ti.getText(5);
            this.input.getFieldGroup()[i] = ti.getText(6);
            this.input.getFieldDecimal()[i] = ti.getText(7);
            this.input.getFieldCurrency()[i] = ti.getText(8);
            this.input.getFieldNullIf()[i] = ti.getText(9);
            this.input.getFieldIfNull()[i] = ti.getText(10);
            this.input.getFieldTrimType()[i] = ValueMetaString.getTrimTypeByDesc((String)ti.getText(11));
        }
        this.dispose();
    }

    private void setFieldsEnabledStatus() {
        this.wlFields.setEnabled(this.wAllowCaptureGroups.getSelection());
        this.wFields.setEnabled(this.wAllowCaptureGroups.getSelection());
        this.wlReplaceFields.setEnabled(this.wAllowCaptureGroups.getSelection());
        this.wReplaceFields.setEnabled(this.wAllowCaptureGroups.getSelection());
    }

    private void setRegexOptions(RegexEvalMeta input) {
        input.setScript(this.wScript.getText());
        input.setResultFieldName(this.wResultField.getText());
        input.setMatcher(this.wFieldEvaluate.getText());
        input.setUseVariableInterpolationFlag(this.wUseVar.getSelection());
        input.setAllowCaptureGroupsFlag(this.wAllowCaptureGroups.getSelection());
        input.setReplacefields(this.wReplaceFields.getSelection());
        input.setCanonicalEqualityFlag(this.wCanonEq.getSelection());
        input.setCaseInsensitiveFlag(this.wCaseInsensitive.getSelection());
        input.setCommentFlag(this.wComment.getSelection());
        input.setDotAllFlag(this.wDotAll.getSelection());
        input.setMultilineFlag(this.wMultiline.getSelection());
        input.setUnicodeFlag(this.wUnicode.getSelection());
        input.setUnixLineEndingsFlag(this.wUnix.getSelection());
    }

    private void testRegExScript() {
        RegexEvalMeta meta = new RegexEvalMeta();
        this.setRegexOptions(meta);
        RegexEvalHelperDialog d = new RegexEvalHelperDialog(this.shell, (IVariables)new Variables(), meta.getScript(), meta.getRegexOptions(), meta.isCanonicalEqualityFlagSet());
        this.wScript.setText(d.open());
    }
}

