/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.util.Preconditions;

public class IntermediateDataSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IntermediateDataSetID id;
    private final JobVertex producer;
    private final List<JobEdge> consumers = new ArrayList<JobEdge>();
    private final ResultPartitionType resultType;
    private DistributionPattern distributionPattern;
    private boolean isBroadcast;

    public IntermediateDataSet(IntermediateDataSetID id, ResultPartitionType resultType, JobVertex producer) {
        this.id = (IntermediateDataSetID)Preconditions.checkNotNull((Object)id);
        this.producer = (JobVertex)Preconditions.checkNotNull((Object)producer);
        this.resultType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)resultType)));
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public JobVertex getProducer() {
        return this.producer;
    }

    public List<JobEdge> getConsumers() {
        return this.consumers;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public DistributionPattern getDistributionPattern() {
        return this.distributionPattern;
    }

    public ResultPartitionType getResultType() {
        return this.resultType;
    }

    public void addConsumer(JobEdge edge) {
        Preconditions.checkState((boolean)this.id.equals(edge.getSourceId()), (Object)"Incompatible dataset id.");
        if (this.consumers.isEmpty()) {
            this.distributionPattern = edge.getDistributionPattern();
            this.isBroadcast = edge.isBroadcast();
        } else {
            Preconditions.checkState((this.distributionPattern == edge.getDistributionPattern() ? 1 : 0) != 0, (Object)"Incompatible distribution pattern.");
            Preconditions.checkState((this.isBroadcast == edge.isBroadcast() ? 1 : 0) != 0, (Object)"Incompatible broadcast type.");
        }
        this.consumers.add(edge);
    }

    public String toString() {
        return "Intermediate Data Set (" + this.id + ")";
    }
}

