/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigTableReadSchemaTransformProvider_BigTableReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class BigTableReadSchemaTransformProvider
extends TypedSchemaTransformProvider<BigTableReadSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "output";
    public static final @UnknownKeyFor @NonNull @Initialized Schema CELL_SCHEMA = Schema.builder().addStringField("value").addInt64Field("timestamp").addArrayField("labels", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).build();
    public static final @UnknownKeyFor @NonNull @Initialized Schema ROW_SCHEMA = Schema.builder().addStringField("key").addMapField("families", Schema.FieldType.STRING, Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)CELL_SCHEMA)))).build();

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigTableReadSchemaTransformConfiguration> configurationClass() {
        return BigTableReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigTableReadSchemaTransformConfiguration configuration) {
        return new BigTableReadSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:bigtable_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_TAG);
    }

    public static class BigTableRowToBeamRow
    extends SimpleFunction<Row, org.apache.beam.sdk.values.Row> {
        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row apply(@UnknownKeyFor @NonNull @Initialized Row bigtableRow) {
            HashMap families = new HashMap();
            for (Family fam : bigtableRow.getFamiliesList()) {
                HashMap columns = new HashMap();
                for (Column col : fam.getColumnsList()) {
                    ArrayList<org.apache.beam.sdk.values.Row> cells = new ArrayList<org.apache.beam.sdk.values.Row>();
                    for (Cell cell : col.getCellsList()) {
                        org.apache.beam.sdk.values.Row cellRow = org.apache.beam.sdk.values.Row.withSchema((Schema)CELL_SCHEMA).withFieldValue("value", (Object)cell.getValue().toStringUtf8()).withFieldValue("timestamp", (Object)cell.getTimestampMicros()).withFieldValue("labels", (Object)cell.getLabelsList()).build();
                        cells.add(cellRow);
                    }
                    columns.put(col.getQualifier().toStringUtf8(), cells);
                }
                families.put(fam.getName(), columns);
            }
            org.apache.beam.sdk.values.Row beamRow = org.apache.beam.sdk.values.Row.withSchema((Schema)ROW_SCHEMA).withFieldValue("key", (Object)bigtableRow.getKey().toStringUtf8()).withFieldValue("families", families).build();
            return beamRow;
        }
    }

    private static class BigTableReadSchemaTransform
    extends PTransform<PCollectionRowTuple, PCollectionRowTuple>
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigTableReadSchemaTransformConfiguration configuration;

        BigTableReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigTableReadSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.getAll().isEmpty(), (Object)String.format("Input to %s is expected to be empty, but is not.", ((Object)((Object)this)).getClass().getSimpleName()));
            PCollection bigtableRows = (PCollection)input.getPipeline().apply((PTransform)BigtableIO.read().withTableId(this.configuration.getTable()).withInstanceId(this.configuration.getInstance()).withProjectId(this.configuration.getProject()));
            PCollection beamRows = ((PCollection)bigtableRows.apply((PTransform)MapElements.via((SimpleFunction)new BigTableRowToBeamRow()))).setRowSchema(ROW_SCHEMA);
            return PCollectionRowTuple.of((String)BigTableReadSchemaTransformProvider.OUTPUT_TAG, (PCollection)beamRows);
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return this;
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class BigTableReadSchemaTransformConfiguration {
        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigTableReadSchemaTransformProvider_BigTableReadSchemaTransformConfiguration.Builder();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getTable();

        public abstract @UnknownKeyFor @NonNull @Initialized String getInstance();

        public abstract @UnknownKeyFor @NonNull @Initialized String getProject();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTable(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInstance(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProject(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized BigTableReadSchemaTransformConfiguration autoBuild();

            public @UnknownKeyFor @NonNull @Initialized BigTableReadSchemaTransformConfiguration build() {
                BigTableReadSchemaTransformConfiguration config = this.autoBuild();
                String invalidConfigMessage = "Invalid BigTable Read configuration: %s should not be a non-empty String";
                Preconditions.checkArgument((!config.getTable().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "table"));
                Preconditions.checkArgument((!config.getInstance().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "instance"));
                Preconditions.checkArgument((!config.getProject().isEmpty() ? 1 : 0) != 0, (Object)String.format(invalidConfigMessage, "project"));
                return config;
            }
        }
    }
}

