/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.AvroRows;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReader;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BigQueryStorageAvroReader
implements BigQueryStorageReader {
    private final @UnknownKeyFor @NonNull @Initialized Schema avroSchema;
    private final @UnknownKeyFor @NonNull @Initialized DatumReader<@UnknownKeyFor @NonNull @Initialized GenericRecord> datumReader;
    private @Nullable @UnknownKeyFor @Initialized BinaryDecoder decoder;
    private @UnknownKeyFor @NonNull @Initialized long rowCount;

    BigQueryStorageAvroReader(@UnknownKeyFor @NonNull @Initialized ReadSession readSession) {
        this.avroSchema = new Schema.Parser().parse(readSession.getAvroSchema().getSchema());
        this.datumReader = new GenericDatumReader(this.avroSchema);
        this.rowCount = 0L;
        this.decoder = null;
    }

    @Override
    public void processReadRowsResponse(@UnknownKeyFor @NonNull @Initialized ReadRowsResponse readRowsResponse) {
        BinaryDecoder newDecoder;
        AvroRows avroRows = readRowsResponse.getAvroRows();
        this.rowCount = avroRows.getRowCount();
        this.decoder = newDecoder = DecoderFactory.get().binaryDecoder(avroRows.getSerializedBinaryRows().toByteArray(), this.decoder);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getRowCount() {
        return this.rowCount;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized GenericRecord readSingleRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkStateNotNull((Object)this.decoder);
        GenericRecord newRecord = (GenericRecord)this.datumReader.read(null, (Decoder)this.decoder);
        return newRecord;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean readyForNextReadResponse() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decoder == null || this.decoder.isEnd();
    }

    @Override
    public void resetBuffer() {
        this.decoder = null;
    }

    @Override
    public void close() {
    }
}

