/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyIntValueHashMap
extends BaseHashMap
implements Map<Long, Integer> {
    private Set<Long> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<Long, Integer>> entries;

    public LongKeyIntValueHashMap() {
        this(8);
    }

    public LongKeyIntValueHashMap(boolean bl) {
        this(8);
        this.minimizeOnEmpty = bl;
    }

    public LongKeyIntValueHashMap(int n) throws IllegalArgumentException {
        super(n, 2, 1, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            return super.containsKey(l);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(long l) {
        return super.containsKey(l);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return super.containsValue(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int n) {
        return super.containsValue(n);
    }

    @Override
    public Integer get(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            try {
                int n = this.get(l);
                return n;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public int get(long l) throws NoSuchElementException {
        int n = this.getLookup(l);
        if (n != -1) {
            return this.intValueTable[n];
        }
        throw new NoSuchElementException();
    }

    public int get(long l, int n) {
        int n2 = this.getLookup(l);
        if (n2 != -1) {
            return this.intValueTable[n2];
        }
        return n;
    }

    public boolean get(long l, int[] nArray) {
        int n = this.getLookup(l);
        if (n != -1) {
            nArray[0] = this.intValueTable[n];
            return true;
        }
        return false;
    }

    @Override
    public int getLookup(long l) {
        return super.getLookup(l);
    }

    @Override
    public Integer put(Long l, Integer n) {
        if (l == null || n == null) {
            throw new NullPointerException();
        }
        int n2 = this.size();
        super.addOrUpdate(l, n.intValue(), null, null);
        if (n2 == this.size()) {
            return null;
        }
        return n;
    }

    @Override
    public boolean put(long l, int n) {
        int n2 = this.size();
        super.addOrUpdate(l, n, null, null);
        return n2 != this.size();
    }

    @Override
    public Integer remove(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            return (Integer)super.remove(l, 0L, null, null, false, false);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(long l) {
        Integer n = (Integer)super.remove(l, 0L, null, null, false, false);
        return n != null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Integer> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            long l2 = l;
            Integer n = map.get(l);
            int n2 = n;
            this.put(l2, n2);
        }
    }

    public void putAll(LongKeyIntValueHashMap longKeyIntValueHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)longKeyIntValueHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            long l = primitiveIterator.nextLong();
            int n = longKeyIntValueHashMap.get(l);
            this.put(l, n);
        }
    }

    public long[] keysToArray(long[] lArray) {
        return this.toLongArray(lArray, true);
    }

    public int[] valuesToArray(int[] nArray) {
        return this.toIntArray(nArray, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values<Integer>();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Integer>
    extends AbstractReadOnlyCollection<Integer> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            Objects.requireNonNull(longKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            Objects.requireNonNull(longKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongKeyIntValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, Integer> next() {
            Long l = super.nextLong();
            Integer n = LongKeyIntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Long, Integer>(l, n);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, Integer>>
    implements Set<Map.Entry<Long, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

