/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.Collections;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PCollection<@UnknownKeyFor T>
extends PValueBase
implements PValue {
    private @UnknownKeyFor @NonNull @Initialized CoderOrFailure<T> coderOrFailure = new CoderOrFailure(null, "No Coder was specified, and Coder Inference did not occur");
    private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> typeDescriptor;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
    private @UnknownKeyFor @NonNull @Initialized IsBounded isBounded;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> tag;

    @Override
    public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        this.coderOrFailure = this.inferCoderOrFail(input, transform, this.getPipeline().getCoderRegistry(), this.getPipeline().getSchemaRegistry());
        super.finishSpecifyingOutput(transformName, input, transform);
    }

    @Override
    public void finishSpecifying(@UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        if (this.isFinishedSpecifying()) {
            return;
        }
        this.coderOrFailure = this.inferCoderOrFail(input, transform, this.getPipeline().getCoderRegistry(), this.getPipeline().getSchemaRegistry());
        this.getCoder();
        super.finishSpecifying(input, transform);
    }

    public @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> getTypeDescriptor() {
        if (this.typeDescriptor != null) {
            return this.typeDescriptor;
        }
        if (((CoderOrFailure)this.coderOrFailure).coder != null) {
            return ((CoderOrFailure)this.coderOrFailure).coder.getEncodedTypeDescriptor();
        }
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized CoderOrFailure<T> inferCoderOrFail(@UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry, @UnknownKeyFor @NonNull @Initialized SchemaRegistry schemaRegistry) {
        if (((CoderOrFailure)this.coderOrFailure).coder != null) {
            return this.coderOrFailure;
        }
        try {
            return new CoderOrFailure(transform.getDefaultOutputCoder(input, this), null);
        }
        catch (CannotProvideCoderException exc) {
            CannotProvideCoderException inferFromTokenException;
            CannotProvideCoderException inputCoderException;
            block11: {
                inputCoderException = exc;
                TypeDescriptor<T> token = this.getTypeDescriptor();
                if (token != null) {
                    try {
                        SchemaCoder<T> schemaCoder = SchemaCoder.of(schemaRegistry.getSchema(token), token, schemaRegistry.getToRowFunction(token), schemaRegistry.getFromRowFunction(token));
                        return new CoderOrFailure<T>(schemaCoder, null);
                    }
                    catch (NoSuchSchemaException schemaCoder) {
                        // empty catch block
                    }
                }
                inferFromTokenException = null;
                if (token != null) {
                    try {
                        return new CoderOrFailure<T>(coderRegistry.getCoder(token), null);
                    }
                    catch (CannotProvideCoderException exc2) {
                        inferFromTokenException = exc2;
                        if (!(transform instanceof ParDo.MultiOutput) || exc2.getReason() != CannotProvideCoderException.ReasonCode.TYPE_ERASURE) break block11;
                        inferFromTokenException = new CannotProvideCoderException(exc2.getMessage() + " If this error occurs for an output of the producing ParDo, verify that the TupleTag for this output is constructed with proper type information (see TupleTag Javadoc) or explicitly set the Coder to use if this is not possible.");
                    }
                }
            }
            StringBuilder messageBuilder = new StringBuilder().append("Unable to return a default Coder for ").append(this).append(". Correct one of the following root causes:");
            messageBuilder.append("\n  No Coder has been manually specified; ").append(" you may do so using .setCoder().");
            if (inferFromTokenException != null) {
                messageBuilder.append("\n  Inferring a Coder from the CoderRegistry failed: ").append(inferFromTokenException.getMessage());
            }
            if (inputCoderException != null) {
                messageBuilder.append("\n  Using the default output Coder from the producing PTransform failed: ").append(inputCoderException.getMessage());
            }
            return new CoderOrFailure(null, messageBuilder.toString());
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return super.getName();
    }

    @Override
    public final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
        return Collections.singletonMap(this.tag, this);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> setName(@UnknownKeyFor @NonNull @Initialized String name) {
        super.setName(name);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getCoder() {
        return org.apache.beam.sdk.util.Preconditions.checkStateNotNull(((CoderOrFailure)this.coderOrFailure).coder, ((CoderOrFailure)this.coderOrFailure).failure);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        Preconditions.checkState((!this.isFinishedSpecifying() ? 1 : 0) != 0, (String)"cannot change the Coder of %s once it's been used", (Object)this);
        Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"Cannot setCoder(null)");
        this.coderOrFailure = new CoderOrFailure<T>(coder, null);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> setRowSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return this.setCoder(SchemaCoder.of(schema));
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> setSchema(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction) {
        return this.setCoder(SchemaCoder.of(schema, typeDescriptor, toRowFunction, fromRowFunction));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasSchema() {
        return ((CoderOrFailure)this.coderOrFailure).coder != null && ((CoderOrFailure)this.coderOrFailure).coder instanceof SchemaCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
        if (!this.hasSchema()) {
            throw new IllegalStateException("Cannot call getSchema when there is no schema");
        }
        return ((SchemaCoder)this.getCoder()).getSchema();
    }

    public @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> getToRowFunction() {
        if (!this.hasSchema()) {
            throw new IllegalStateException("Cannot call getToRowFunction when there is no schema");
        }
        return ((SchemaCoder)this.getCoder()).getToRowFunction();
    }

    public @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> getFromRowFunction() {
        if (!this.hasSchema()) {
            throw new IllegalStateException("Cannot call getFromRowFunction when there is no schema");
        }
        return ((SchemaCoder)this.getCoder()).getFromRowFunction();
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super @UnknownKeyFor @NonNull @Initialized PCollection<T>, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super @UnknownKeyFor @NonNull @Initialized PCollection<T>, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowingStrategy() {
        return this.windowingStrategy;
    }

    public @UnknownKeyFor @NonNull @Initialized IsBounded isBounded() {
        return this.isBounded;
    }

    private PCollection(@UnknownKeyFor @NonNull @Initialized Pipeline p, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized IsBounded isBounded) {
        super(p);
        this.windowingStrategy = windowingStrategy;
        this.isBounded = isBounded;
        this.tag = new TupleTag();
    }

    private PCollection(@UnknownKeyFor @NonNull @Initialized Pipeline p, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized IsBounded isBounded, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> tag) {
        super(p);
        this.windowingStrategy = windowingStrategy;
        this.isBounded = isBounded;
        this.tag = tag;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> setTypeDescriptor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
        return this;
    }

    @Internal
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> setWindowingStrategyInternal(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        this.windowingStrategy = windowingStrategy;
        return this;
    }

    @Internal
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> setIsBoundedInternal(@UnknownKeyFor @NonNull @Initialized IsBounded isBounded) {
        this.isBounded = isBounded;
        return this;
    }

    @Internal
    public static <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> createPrimitiveOutputInternal(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized IsBounded isBounded, @Nullable @UnknownKeyFor @Initialized Coder<T> coder) {
        PCollection<T> res = new PCollection<T>(pipeline, windowingStrategy, isBounded);
        if (coder != null) {
            res.setCoder(coder);
        }
        return res;
    }

    @Internal
    public static <T> @UnknownKeyFor @NonNull @Initialized PCollection<T> createPrimitiveOutputInternal(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized IsBounded isBounded, @Nullable @UnknownKeyFor @Initialized Coder<T> coder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> tag) {
        PCollection<T> res = new PCollection<T>(pipeline, windowingStrategy, isBounded, tag);
        if (coder != null) {
            res.setCoder(coder);
        }
        return res;
    }

    private static class CoderOrFailure<@UnknownKeyFor T> {
        private final @Nullable @UnknownKeyFor @Initialized Coder<T> coder;
        private final @Nullable @UnknownKeyFor @Initialized String failure;

        public CoderOrFailure(@Nullable @UnknownKeyFor @Initialized Coder<T> coder, @Nullable @UnknownKeyFor @Initialized String failure) {
            this.coder = coder;
            this.failure = failure;
        }
    }

    public static enum IsBounded {
        BOUNDED,
        UNBOUNDED;


        public @UnknownKeyFor @NonNull @Initialized IsBounded and(@UnknownKeyFor @NonNull @Initialized IsBounded that) {
            if (this == BOUNDED && that == BOUNDED) {
                return BOUNDED;
            }
            return UNBOUNDED;
        }
    }
}

