/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class Mean {
    private Mean() {
    }

    public static <NumT extends Number> @UnknownKeyFor @NonNull @Initialized Combine.Globally<NumT, @UnknownKeyFor @NonNull @Initialized Double> globally() {
        return Combine.globally(Mean.of());
    }

    public static <K, NumT extends Number> @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, NumT, @UnknownKeyFor @NonNull @Initialized Double> perKey() {
        return Combine.perKey(Mean.of());
    }

    public static <NumT extends Number> @UnknownKeyFor @NonNull @Initialized Combine.AccumulatingCombineFn<NumT, @UnknownKeyFor @NonNull @Initialized CountSum<NumT>, @UnknownKeyFor @NonNull @Initialized Double> of() {
        return new MeanFn();
    }

    static class CountSumCoder<@UnknownKeyFor NumT extends @UnknownKeyFor @NonNull @Initialized Number>
    extends AtomicCoder<CountSum<NumT>> {
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Long> LONG_CODER = BigEndianLongCoder.of();
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Double> DOUBLE_CODER = DoubleCoder.of();

        CountSumCoder() {
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized CountSum<NumT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            LONG_CODER.encode(value.count, outStream);
            DOUBLE_CODER.encode(value.sum, outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CountSum<NumT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return new CountSum(LONG_CODER.decode(inStream), DOUBLE_CODER.decode(inStream));
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            LONG_CODER.verifyDeterministic();
            DOUBLE_CODER.verifyDeterministic();
        }
    }

    static class CountSum<@UnknownKeyFor NumT extends @UnknownKeyFor @NonNull @Initialized Number>
    implements Combine.AccumulatingCombineFn.Accumulator<NumT, CountSum<NumT>, Double> {
        @UnknownKeyFor @NonNull @Initialized long count = 0L;
        @UnknownKeyFor @NonNull @Initialized double sum = 0.0;

        public CountSum() {
            this(0L, 0.0);
        }

        public CountSum(@UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized double sum) {
            this.count = count;
            this.sum = sum;
        }

        @Override
        public void addInput(NumT element) {
            ++this.count;
            this.sum += ((Number)element).doubleValue();
        }

        @Override
        public void mergeAccumulator(@UnknownKeyFor @NonNull @Initialized CountSum<NumT> accumulator) {
            this.count += accumulator.count;
            this.sum += accumulator.sum;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Double extractOutput() {
            return this.count == 0L ? Double.NaN : this.sum / (double)this.count;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (!(other instanceof CountSum)) {
                return false;
            }
            CountSum otherCountSum = (CountSum)other;
            return this.count == otherCountSum.count && this.sum == otherCountSum.sum;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.count, this.sum);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("sum", this.sum).toString();
        }
    }

    private static class MeanFn<@UnknownKeyFor NumT extends @UnknownKeyFor @NonNull @Initialized Number>
    extends Combine.AccumulatingCombineFn<NumT, CountSum<NumT>, Double> {
        private MeanFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CountSum<NumT> createAccumulator() {
            return new CountSum();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized CountSum<NumT>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<NumT> inputCoder) {
            return new CountSumCoder();
        }
    }
}

