/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.UnownedInputStream;
import org.apache.beam.sdk.util.UnownedOutputStream;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CountingInputStream;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CountingOutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CoderProperties {
    public static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder.Context> ALL_CONTEXTS = ImmutableList.of((Object)Coder.Context.OUTER, (Object)Coder.Context.NESTED);
    private static final @UnknownKeyFor @NonNull @Initialized String DECODING_WIRE_FORMAT_MESSAGE = "Decoded value from known wire format does not match expected value. This probably means that this Coder no longer correctly decodes a prior wire format. Changing the wire formats this Coder can read should be avoided, as it is likely to cause breakage.";
    private static final @UnknownKeyFor @NonNull @Initialized String ENCODING_WIRE_FORMAT_MESSAGE = "Encoded value does not match expected wire format. Changing the wire format should be avoided, as it is likely to cause breakage. If you truly intend to change the wire format for this Coder, See org.apache.beam.sdk.coders.PrintBase64Encoding for how to generate new test data.";

    public static <T> void coderDeterministic(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value1, T value2) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDeterministicInContext(coder, context, value1, value2);
        }
    }

    public static <T> void coderDeterministicInContext(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value1, T value2) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            coder.verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            throw new AssertionError("Expected that the coder is deterministic", e);
        }
        MatcherAssert.assertThat((String)"Expected that the passed in values are equal()", value1, (Matcher)Matchers.equalTo(value2));
        MatcherAssert.assertThat((Object)CoderProperties.encode(coder, context, value1), (Matcher)Matchers.equalTo((Object)CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void coderDecodeEncodeEqual(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeEqualInContext(coder, context, value);
        }
    }

    public static <T> void coderDecodeEncodeEqualInContext(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MatcherAssert.assertThat(CoderProperties.decodeEncode(coder, context, value), (Matcher)Matchers.equalTo(value));
    }

    public static <T> void coderDecodeEncodeInContext(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value, @UnknownKeyFor @NonNull @Initialized Matcher<T> matcher) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MatcherAssert.assertThat(CoderProperties.decodeEncode(coder, context, value), matcher);
    }

    public static <T, CollectionT extends Collection<T>> void coderDecodeEncodeContentsEqual(@UnknownKeyFor @NonNull @Initialized Coder<CollectionT> coder, CollectionT value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeContentsEqualInContext(coder, context, value);
        }
    }

    public static <T, CollectionT extends Collection<T>> void coderDecodeEncodeContentsEqualInContext(@UnknownKeyFor @NonNull @Initialized Coder<CollectionT> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, CollectionT value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Collection result = (Collection)CoderProperties.decodeEncode(coder, context, value);
        if (value.isEmpty()) {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])value.toArray()));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodeEncodeContentsInSameOrder(@UnknownKeyFor @NonNull @Initialized Coder<IterableT> coder, IterableT value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderDecodeEncodeContentsInSameOrderInContext(coder, context, value);
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodeEncodeContentsInSameOrderInContext(@UnknownKeyFor @NonNull @Initialized Coder<IterableT> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, IterableT value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Iterable result = (Iterable)CoderProperties.decodeEncode(coder, context, value);
        if (Iterables.isEmpty(value)) {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])Iterables.toArray(value, Object.class)));
        }
    }

    public static <T> void coderSerializable(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        SerializableUtils.ensureSerializable(coder);
    }

    public static <T> void coderConsistentWithEquals(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value1, T value2) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.coderConsistentWithEqualsInContext(coder, context, value1, value2);
        }
    }

    public static <T> void coderConsistentWithEqualsInContext(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value1, T value2) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Assert.assertEquals((Object)value1.equals(value2), (Object)Arrays.equals(CoderProperties.encode(coder, context, value1), CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void structuralValueConsistentWithEquals(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value1, T value2) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.structuralValueConsistentWithEqualsInContext(coder, context, value1, value2);
        }
    }

    public static <T> void structuralValueConsistentWithEqualsInContext(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value1, T value2) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Assert.assertEquals((Object)coder.structuralValue(value1).equals(coder.structuralValue(value2)), (Object)Arrays.equals(CoderProperties.encode(coder, context, value1), CoderProperties.encode(coder, context, value2)));
    }

    public static <T> void structuralValueDecodeEncodeEqual(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.structuralValueDecodeEncodeEqualInContext(coder, context, value);
        }
    }

    public static <T extends Iterable<?>> void structuralValueDecodeEncodeEqualIterable(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (Coder.Context context : ALL_CONTEXTS) {
            CoderProperties.structuralValueDecodeEncodeEqualIterableInContext(coder, context, value);
        }
    }

    public static <T> void structuralValueDecodeEncodeEqualInContext(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Assert.assertEquals((Object)coder.structuralValue(value), (Object)coder.structuralValue(CoderProperties.decodeEncode(coder, context, value)));
    }

    public static <T extends Iterable<?>> void structuralValueDecodeEncodeEqualIterableInContext(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MatcherAssert.assertThat((String)"The original value changed after, encoding and decoding.", (boolean)Iterables.elementsEqual((Iterable)((Iterable)coder.structuralValue(value)), (Iterable)((Iterable)coder.structuralValue((Iterable)CoderProperties.decodeEncode(coder, context, value)))));
    }

    public static <T> void coderDecodesBase64(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized String base64Encoding, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MatcherAssert.assertThat((String)DECODING_WIRE_FORMAT_MESSAGE, CoderUtils.decodeFromBase64(coder, base64Encoding), (Matcher)Matchers.equalTo(value));
    }

    public static <T> void coderDecodesBase64(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> base64Encodings, @UnknownKeyFor @NonNull @Initialized List<T> values) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MatcherAssert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)values.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderDecodesBase64(coder, base64Encodings.get(i), values.get(i));
        }
    }

    public static <T> void coderEncodesBase64(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, T value, @UnknownKeyFor @NonNull @Initialized String base64Encoding) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MatcherAssert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)CoderUtils.encodeToBase64(coder, value), (Matcher)Matchers.equalTo((Object)base64Encoding));
    }

    public static <T> void coderEncodesBase64(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized List<T> values, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> base64Encodings) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MatcherAssert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)values.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderEncodesBase64(coder, values.get(i), base64Encodings.get(i));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodesBase64ContentsEqual(@UnknownKeyFor @NonNull @Initialized Coder<IterableT> coder, @UnknownKeyFor @NonNull @Initialized String base64Encoding, IterableT expected) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Iterable result = (Iterable)CoderUtils.decodeFromBase64(coder, base64Encoding);
        if (Iterables.isEmpty(expected)) {
            MatcherAssert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)result, (Matcher)Matchers.emptyIterable());
        } else {
            MatcherAssert.assertThat((String)ENCODING_WIRE_FORMAT_MESSAGE, (Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])Iterables.toArray(expected, Object.class)));
        }
    }

    public static <T, IterableT extends Iterable<T>> void coderDecodesBase64ContentsEqual(@UnknownKeyFor @NonNull @Initialized Coder<IterableT> coder, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> base64Encodings, @UnknownKeyFor @NonNull @Initialized List<IterableT> expected) throws @UnknownKeyFor @NonNull @Initialized Exception {
        MatcherAssert.assertThat((String)"List of base64 encodings has different size than List of values", (Object)base64Encodings.size(), (Matcher)Matchers.equalTo((Object)expected.size()));
        for (int i = 0; i < base64Encodings.size(); ++i) {
            CoderProperties.coderDecodesBase64ContentsEqual(coder, base64Encodings.get(i), (Iterable)expected.get(i));
        }
    }

    @VisibleForTesting
    static <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encode(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        Coder<T> deserializedCoder = SerializableUtils.clone(coder);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        deserializedCoder.encode(value, new UnownedOutputStream(os), context);
        return os.toByteArray();
    }

    @VisibleForTesting
    static <T> T decode(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] buffer;
        Coder<T> deserializedCoder = SerializableUtils.clone(coder);
        if (Objects.equals(context, Coder.Context.NESTED)) {
            buffer = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, buffer, 0, bytes.length);
            buffer[bytes.length] = 1;
        } else {
            buffer = bytes;
        }
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(buffer));
        T value = deserializedCoder.decode(new UnownedInputStream((InputStream)cis), context);
        MatcherAssert.assertThat((String)"consumed bytes equal to encoded bytes", (Object)cis.getCount(), (Matcher)Matchers.equalTo((Object)bytes.length));
        return value;
    }

    private static <T> T decodeEncode(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T value) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return CoderProperties.decode(coder, context, CoderProperties.encode(coder, context, value));
    }

    public static <T> void testByteCount(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized Coder.Context context, T @UnknownKeyFor @NonNull @Initialized [] elements) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TestElementByteSizeObserver observer = new TestElementByteSizeObserver();
        try (CountingOutputStream os = new CountingOutputStream(ByteStreams.nullOutputStream());){
            for (T elem : elements) {
                coder.registerByteSizeObserver(elem, observer);
                coder.encode(elem, (OutputStream)os, context);
                observer.advance();
            }
            long expectedLength = os.getCount();
            if (!context.isWholeStream) {
                Assert.assertEquals((long)expectedLength, (long)observer.getSum());
            }
            Assert.assertEquals((long)elements.length, (long)observer.getCount());
        }
    }

    public static class TestElementByteSizeObserver
    extends ElementByteSizeObserver {
        private @UnknownKeyFor @NonNull @Initialized long currentSum = 0L;
        private @UnknownKeyFor @NonNull @Initialized long count = 0L;

        @Override
        protected void reportElementSize(@UnknownKeyFor @NonNull @Initialized long elementByteSize) {
            ++this.count;
            this.currentSum += elementByteSize;
        }

        public @UnknownKeyFor @NonNull @Initialized double getMean() {
            return (double)this.currentSum / (double)this.count;
        }

        public @UnknownKeyFor @NonNull @Initialized long getSum() {
            return this.currentSum;
        }

        public @UnknownKeyFor @NonNull @Initialized long getCount() {
            return this.count;
        }

        public void reset() {
            this.currentSum = 0L;
            this.count = 0L;
        }

        public @UnknownKeyFor @NonNull @Initialized long getSumAndReset() {
            long returnValue = this.currentSum;
            this.reset();
            return returnValue;
        }
    }
}

