/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.AutoValue_GenerateSequence;
import org.apache.beam.sdk.io.BoundedReadFromUnboundedSource;
import org.apache.beam.sdk.io.CountingSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;

@AutoValue
public abstract class GenerateSequence
extends PTransform<PBegin, PCollection<Long>> {
    @Pure
    abstract @UnknownKeyFor @NonNull @Initialized long getFrom();

    @Pure
    abstract @UnknownKeyFor @NonNull @Initialized long getTo();

    @Pure
    @Nullable
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Instant> getTimestampFn();

    @Pure
    abstract @UnknownKeyFor @NonNull @Initialized long getElementsPerPeriod();

    @Pure
    @Nullable
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration getPeriod();

    @Pure
    @Nullable
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration getMaxReadTime();

    @Pure
    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized GenerateSequence from(@UnknownKeyFor @NonNull @Initialized long from) {
        Preconditions.checkArgument((from >= 0L ? 1 : 0) != 0, (String)"Value of from must be non-negative, but was: %s", (long)from);
        return new AutoValue_GenerateSequence.Builder().setFrom(from).setTo(-1L).setElementsPerPeriod(0L).build();
    }

    public @UnknownKeyFor @NonNull @Initialized GenerateSequence to(@UnknownKeyFor @NonNull @Initialized long to) {
        Preconditions.checkArgument((this.getTo() == -1L || this.getTo() >= this.getFrom() ? 1 : 0) != 0, (String)"Degenerate range [%s, %s)", (long)this.getFrom(), (long)this.getTo());
        return this.toBuilder().setTo(to).build();
    }

    public @UnknownKeyFor @NonNull @Initialized GenerateSequence withTimestampFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Instant> timestampFn) {
        return this.toBuilder().setTimestampFn(timestampFn).build();
    }

    public @UnknownKeyFor @NonNull @Initialized GenerateSequence withRate(@UnknownKeyFor @NonNull @Initialized long numElements, @UnknownKeyFor @NonNull @Initialized Duration periodLength) {
        Preconditions.checkArgument((numElements > 0L ? 1 : 0) != 0, (String)"Number of elements in withRate must be positive, but was: %s", (long)numElements);
        Preconditions.checkArgument((periodLength != null ? 1 : 0) != 0, (Object)"periodLength can not be null");
        return this.toBuilder().setElementsPerPeriod(numElements).setPeriod(periodLength).build();
    }

    public @UnknownKeyFor @NonNull @Initialized GenerateSequence withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
        return this.toBuilder().setMaxReadTime(maxReadTime).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Long> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        boolean usesUnboundedFeatures;
        boolean isRangeUnbounded = this.getTo() < 0L;
        boolean bl = usesUnboundedFeatures = this.getTimestampFn() != null || this.getElementsPerPeriod() > 0L || this.getMaxReadTime() != null;
        if (!isRangeUnbounded && !usesUnboundedFeatures) {
            return (PCollection)input.apply(Read.from(CountingSource.createSourceForSubrange(this.getFrom(), this.getTo())));
        }
        CountingSource.UnboundedCountingSource source = CountingSource.createUnboundedFrom(this.getFrom());
        if (this.getTimestampFn() != null) {
            source = source.withTimestampFn(this.getTimestampFn());
        }
        if (this.getPeriod() != null || this.getElementsPerPeriod() > 0L) {
            Duration period = org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull(this.getPeriod(), "elements per period specified, but no period specified");
            Preconditions.checkArgument((this.getElementsPerPeriod() > 0L ? 1 : 0) != 0, (Object)"elements per period not specified, but period specified");
            source = source.withRate(this.getElementsPerPeriod(), period);
        }
        Read.Unbounded<Long> readUnbounded = Read.from(source);
        if (this.getMaxReadTime() == null) {
            if (isRangeUnbounded) {
                return (PCollection)input.apply(readUnbounded);
            }
            return (PCollection)input.apply(readUnbounded.withMaxNumRecords(this.getTo() - this.getFrom()));
        }
        BoundedReadFromUnboundedSource<Long> withMaxReadTime = readUnbounded.withMaxReadTime(this.getMaxReadTime());
        if (isRangeUnbounded) {
            return (PCollection)input.apply(withMaxReadTime);
        }
        return (PCollection)input.apply(withMaxReadTime.withMaxNumRecords(this.getTo() - this.getFrom()));
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.add(DisplayData.item("from", this.getFrom()).withLabel("Generate sequence from"));
        builder.addIfNotDefault(DisplayData.item("to", this.getTo()).withLabel("Generate sequence to (exclusive)"), -1L);
        builder.addIfNotNull(DisplayData.item("timestampFn", this.getTimestampFn() == null ? null : this.getTimestampFn().getClass()).withLabel("Timestamp Function"));
        builder.addIfNotNull(DisplayData.item("maxReadTime", this.getMaxReadTime()).withLabel("Maximum Read Time"));
        if (this.getElementsPerPeriod() > 0L) {
            builder.add(DisplayData.item("elementsPerPeriod", this.getElementsPerPeriod()).withLabel("Elements per period"));
            builder.add(DisplayData.item("period", this.getPeriod()).withLabel("Period"));
        }
    }

    @AutoService(value={ExternalTransformRegistrar.class})
    public static class External
    implements ExternalTransformRegistrar {
        public static final @UnknownKeyFor @NonNull @Initialized String URN = "beam:external:java:generate_sequence:v1";

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExternalTransformBuilder<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> knownBuilders() {
            return ImmutableMap.of((Object)URN, AutoValue_GenerateSequence.Builder.class);
        }

        public static class ExternalConfiguration {
            private @UnknownKeyFor @NonNull @Initialized Long start = 0L;
            @Nullable
            private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long stop;
            @Nullable
            private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long period;
            @Nullable
            private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long maxReadTime;
            @Nullable
            private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long elementsPerPeriod;

            public void setStart(@UnknownKeyFor @NonNull @Initialized Long start) {
                this.start = start;
            }

            public void setStop(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long stop) {
                this.stop = stop;
            }

            public void setPeriod(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long period) {
                this.period = period;
            }

            public void setMaxReadTime(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long maxReadTime) {
                this.maxReadTime = maxReadTime;
            }

            public void setElementsPerPeriod(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long elementsPerPeriod) {
                this.elementsPerPeriod = elementsPerPeriod;
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder
    implements ExternalTransformBuilder<External.ExternalConfiguration, PBegin, PCollection<Long>> {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setFrom(@UnknownKeyFor @NonNull @Initialized long var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTo(@UnknownKeyFor @NonNull @Initialized long var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampFn(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Instant> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setElementsPerPeriod(@UnknownKeyFor @NonNull @Initialized long var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setPeriod(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxReadTime(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Duration var1);

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized GenerateSequence build();

        public @UnknownKeyFor @NonNull @Initialized GenerateSequence buildExternal(@UnknownKeyFor @NonNull @Initialized External.ExternalConfiguration config) {
            Preconditions.checkNotNull((Object)config.start, (Object)"Parameters 'from' must not be null.");
            this.setFrom(config.start);
            this.setTo(-1L);
            this.setElementsPerPeriod(0L);
            if (config.stop != null) {
                this.setTo(config.stop);
            }
            if (config.period != null) {
                this.setPeriod(Duration.millis((long)config.period));
            }
            if (config.maxReadTime != null) {
                this.setMaxReadTime(Duration.millis((long)config.maxReadTime));
            }
            if (config.elementsPerPeriod != null) {
                this.setElementsPerPeriod(config.elementsPerPeriod);
            }
            return this.build();
        }
    }
}

