/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform.errorhandling;

import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.errorhandling.AbstractFileErrorHandler;

public class FileErrorHandlerContentLineNumber
extends AbstractFileErrorHandler {
    private static final Class<?> PKG = FileErrorHandlerContentLineNumber.class;

    public FileErrorHandlerContentLineNumber(Date date, String destinationDirectory, String fileExtension, String encoding, BaseTransform baseTransform) {
        super(date, destinationDirectory, fileExtension, encoding, baseTransform);
    }

    @Override
    public void handleLineError(long lineNr, String filePart) throws HopException {
        try {
            this.getWriter(filePart).write(String.valueOf(lineNr));
            this.getWriter(filePart).write(Const.CR);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"FileErrorHandlerContentLineNumber.Exception.CouldNotCreateWriteLine", (String[])new String[0]) + lineNr, (Throwable)e);
        }
    }

    @Override
    public void handleNonExistantFile(FileObject file) {
    }

    @Override
    public void handleNonAccessibleFile(FileObject file) {
    }
}

