/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class InMemoryTimerInternals
implements TimerInternals {
    @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized StateNamespace, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> existingTimers = HashBasedTable.create();
    private final @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> watermarkTimers = new TreeSet<TimerInternals.TimerData>();
    private final @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> processingTimers = new TreeSet<TimerInternals.TimerData>();
    private final @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> synchronizedProcessingTimers = new TreeSet<TimerInternals.TimerData>();
    private @UnknownKeyFor @NonNull @Initialized Instant inputWatermarkTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
    private @Nullable @UnknownKeyFor @Initialized Instant outputWatermarkTime = null;
    private @UnknownKeyFor @NonNull @Initialized Instant processingTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
    private @UnknownKeyFor @NonNull @Initialized Instant synchronizedProcessingTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
    private static final @UnknownKeyFor @NonNull @Initialized String SIMPLE_NAME = InMemoryTimerInternals.class.getSimpleName();

    @Override
    public @Nullable @UnknownKeyFor @Initialized Instant currentOutputWatermarkTime() {
        return this.outputWatermarkTime;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasPendingTimers() {
        return !this.existingTimers.isEmpty();
    }

    public @Nullable @UnknownKeyFor @Initialized Instant getNextTimer(@UnknownKeyFor @NonNull @Initialized TimeDomain domain) {
        try {
            switch (domain) {
                case EVENT_TIME: {
                    return ((TimerInternals.TimerData)this.watermarkTimers.first()).getTimestamp();
                }
                case PROCESSING_TIME: {
                    return ((TimerInternals.TimerData)this.processingTimers.first()).getTimestamp();
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    return ((TimerInternals.TimerData)this.synchronizedProcessingTimers.first()).getTimestamp();
                }
            }
            throw new IllegalArgumentException("Unexpected time domain: " + domain);
        }
        catch (NoSuchElementException exc) {
            return null;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timersForDomain(@UnknownKeyFor @NonNull @Initialized TimeDomain domain) {
        switch (domain) {
            case EVENT_TIME: {
                return this.watermarkTimers;
            }
            case PROCESSING_TIME: {
                return this.processingTimers;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                return this.synchronizedProcessingTimers;
            }
        }
        throw new IllegalArgumentException("Unexpected time domain: " + domain);
    }

    @Override
    public void setTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized Instant target, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        this.setTimer(TimerInternals.TimerData.of(timerId, timerFamilyId, namespace, target, outputTimestamp, timeDomain));
    }

    @Override
    @Deprecated
    public void setTimer(@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        WindowTracing.trace((String)"{}.setTimer: {}", (Object[])new Object[]{SIMPLE_NAME, timerData});
        @Nullable String colKey = timerData.getTimerId() + '+' + timerData.getTimerFamilyId();
        TimerInternals.TimerData existing = (TimerInternals.TimerData)this.existingTimers.get((Object)timerData.getNamespace(), (Object)colKey);
        if (existing == null) {
            this.existingTimers.put((Object)timerData.getNamespace(), (Object)colKey, (Object)timerData);
            this.timersForDomain(timerData.getDomain()).add(timerData);
        } else {
            Preconditions.checkArgument((boolean)timerData.getDomain().equals((Object)existing.getDomain()), (String)"Attempt to set %s for time domain %s, but it is already set for time domain %s", (Object)timerData.getTimerId(), (Object)timerData.getDomain(), (Object)existing.getDomain());
            if (!timerData.getTimestamp().equals((Object)existing.getTimestamp())) {
                NavigableSet<TimerInternals.TimerData> timers = this.timersForDomain(timerData.getDomain());
                timers.remove(existing);
                timers.add(timerData);
                this.existingTimers.put((Object)timerData.getNamespace(), (Object)colKey, (Object)timerData);
            }
        }
    }

    @Override
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        TimerInternals.TimerData removedTimer = (TimerInternals.TimerData)this.existingTimers.remove((Object)namespace, (Object)(timerId + '+' + timerFamilyId));
        if (removedTimer != null) {
            Preconditions.checkState((boolean)removedTimer.getDomain().equals((Object)timeDomain), (String)"%s doesn't match time domain %s of timer", (Object)timeDomain, (Object)removedTimer.getDomain());
            this.timersForDomain(timeDomain).remove(removedTimer);
        }
    }

    @Override
    @Deprecated
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
        TimerInternals.TimerData removedTimer = (TimerInternals.TimerData)this.existingTimers.remove((Object)namespace, (Object)(timerId + '+' + timerFamilyId));
        if (removedTimer != null) {
            this.timersForDomain(removedTimer.getDomain()).remove(removedTimer);
        }
    }

    @Override
    @Deprecated
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
        this.deleteTimer(timer.getNamespace(), timer.getTimerId(), timer.getTimerFamilyId(), timer.getDomain());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime() {
        return this.processingTime;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime() {
        return this.synchronizedProcessingTime;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant currentInputWatermarkTime() {
        return this.inputWatermarkTime;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("watermarkTimers", this.watermarkTimers).add("processingTimers", this.processingTimers).add("synchronizedProcessingTimers", this.synchronizedProcessingTimers).add("inputWatermarkTime", (Object)this.inputWatermarkTime).add("outputWatermarkTime", (Object)this.outputWatermarkTime).add("processingTime", (Object)this.processingTime).toString();
    }

    public void advanceInputWatermark(@UnknownKeyFor @NonNull @Initialized Instant newInputWatermark) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkNotNull((Object)newInputWatermark);
        Preconditions.checkState((!newInputWatermark.isBefore((ReadableInstant)this.inputWatermarkTime) ? 1 : 0) != 0, (String)"Cannot move input watermark time backwards from %s to %s", (Object)this.inputWatermarkTime, (Object)newInputWatermark);
        WindowTracing.trace((String)"{}.advanceInputWatermark: from {} to {}", (Object[])new Object[]{SIMPLE_NAME, this.inputWatermarkTime, newInputWatermark});
        this.inputWatermarkTime = newInputWatermark;
    }

    public void advanceOutputWatermark(@UnknownKeyFor @NonNull @Initialized Instant newOutputWatermark) {
        Instant adjustedOutputWatermark;
        Preconditions.checkNotNull((Object)newOutputWatermark);
        if (newOutputWatermark.isAfter((ReadableInstant)this.inputWatermarkTime)) {
            WindowTracing.trace((String)"{}.advanceOutputWatermark: clipping output watermark from {} to {}", (Object[])new Object[]{SIMPLE_NAME, newOutputWatermark, this.inputWatermarkTime});
            adjustedOutputWatermark = this.inputWatermarkTime;
        } else {
            adjustedOutputWatermark = newOutputWatermark;
        }
        Preconditions.checkState((this.outputWatermarkTime == null || !adjustedOutputWatermark.isBefore((ReadableInstant)this.outputWatermarkTime) ? 1 : 0) != 0, (String)"Cannot move output watermark time backwards from %s to %s", (Object)this.outputWatermarkTime, (Object)adjustedOutputWatermark);
        WindowTracing.trace((String)"{}.advanceOutputWatermark: from {} to {}", (Object[])new Object[]{SIMPLE_NAME, this.outputWatermarkTime, adjustedOutputWatermark});
        this.outputWatermarkTime = adjustedOutputWatermark;
    }

    public void advanceProcessingTime(@UnknownKeyFor @NonNull @Initialized Instant newProcessingTime) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkNotNull((Object)newProcessingTime);
        Preconditions.checkState((!newProcessingTime.isBefore((ReadableInstant)this.processingTime) ? 1 : 0) != 0, (String)"Cannot move processing time backwards from %s to %s", (Object)this.processingTime, (Object)newProcessingTime);
        WindowTracing.trace((String)"{}.advanceProcessingTime: from {} to {}", (Object[])new Object[]{SIMPLE_NAME, this.processingTime, newProcessingTime});
        this.processingTime = newProcessingTime;
    }

    public void advanceSynchronizedProcessingTime(@UnknownKeyFor @NonNull @Initialized Instant newSynchronizedProcessingTime) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkNotNull((Object)newSynchronizedProcessingTime);
        Preconditions.checkState((!newSynchronizedProcessingTime.isBefore((ReadableInstant)this.synchronizedProcessingTime) ? 1 : 0) != 0, (String)"Cannot move processing time backwards from %s to %s", (Object)this.synchronizedProcessingTime, (Object)newSynchronizedProcessingTime);
        WindowTracing.trace((String)"{}.advanceProcessingTime: from {} to {}", (Object[])new Object[]{SIMPLE_NAME, this.synchronizedProcessingTime, newSynchronizedProcessingTime});
        this.synchronizedProcessingTime = newSynchronizedProcessingTime;
    }

    public @Nullable @UnknownKeyFor @Initialized TimerInternals.TimerData removeNextEventTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.inputWatermarkTime, TimeDomain.EVENT_TIME);
        if (timer != null) {
            WindowTracing.trace((String)"{}.removeNextEventTimer: firing {} at {}", (Object[])new Object[]{SIMPLE_NAME, timer, this.inputWatermarkTime});
        }
        return timer;
    }

    public @Nullable @UnknownKeyFor @Initialized TimerInternals.TimerData removeNextProcessingTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.processingTime, TimeDomain.PROCESSING_TIME);
        if (timer != null) {
            WindowTracing.trace((String)"{}.removeNextProcessingTimer: firing {} at {}", (Object[])new Object[]{SIMPLE_NAME, timer, this.processingTime});
        }
        return timer;
    }

    public @Nullable @UnknownKeyFor @Initialized TimerInternals.TimerData removeNextSynchronizedProcessingTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.synchronizedProcessingTime, TimeDomain.SYNCHRONIZED_PROCESSING_TIME);
        if (timer != null) {
            WindowTracing.trace((String)"{}.removeNextSynchronizedProcessingTimer: firing {} at {}", (Object[])new Object[]{SIMPLE_NAME, timer, this.synchronizedProcessingTime});
        }
        return timer;
    }

    private @Nullable @UnknownKeyFor @Initialized TimerInternals.TimerData removeNextTimer(@UnknownKeyFor @NonNull @Initialized Instant currentTime, @UnknownKeyFor @NonNull @Initialized TimeDomain domain) {
        NavigableSet<TimerInternals.TimerData> timers = this.timersForDomain(domain);
        if (!timers.isEmpty() && currentTime.isAfter((ReadableInstant)((TimerInternals.TimerData)timers.first()).getTimestamp())) {
            TimerInternals.TimerData timer = timers.pollFirst();
            this.existingTimers.remove((Object)timer.getNamespace(), (Object)(timer.getTimerId() + '+' + timer.getTimerFamilyId()));
            return timer;
        }
        return null;
    }
}

