/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class FlinkStreamingTranslationContext {
    private final @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment env;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dataStreams = new HashMap();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> producers = new HashMap();
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> currentTransform;

    public FlinkStreamingTranslationContext(@UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment env, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.env = (StreamExecutionEnvironment)Preconditions.checkNotNull((Object)env);
        this.options = (PipelineOptions)Preconditions.checkNotNull((Object)options);
    }

    public @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment getExecutionEnvironment() {
        return this.env;
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
        return this.options;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized DataStream<T> getInputDataStream(@UnknownKeyFor @NonNull @Initialized PValue value) {
        return this.dataStreams.get(value);
    }

    public void setOutputDataStream(@UnknownKeyFor @NonNull @Initialized PValue value, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DataStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> set) {
        PTransform previousProducer = this.producers.put(value, this.currentTransform.getTransform());
        Preconditions.checkArgument((previousProducer == null ? 1 : 0) != 0, (Object)"PValue can only have a single producer.");
        if (!this.dataStreams.containsKey(value)) {
            this.dataStreams.put(value, set);
        }
    }

    <T extends PValue> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, T> getProducer(T value) {
        return this.producers.get(value);
    }

    public void setCurrentTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> currentTransform) {
        this.currentTransform = currentTransform;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getWindowedInputCoder(@UnknownKeyFor @NonNull @Initialized PCollection<T> collection) {
        Coder valueCoder = collection.getCoder();
        return WindowedValue.getFullCoder((Coder)valueCoder, (Coder)collection.getWindowingStrategy().getWindowFn().windowCoder());
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> getInputCoder(@UnknownKeyFor @NonNull @Initialized PCollection<T> collection) {
        return collection.getCoder();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputCoders() {
        return this.currentTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized TypeInformation<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getTypeInfo(@UnknownKeyFor @NonNull @Initialized PCollection<T> collection) {
        return new CoderTypeInformation<WindowedValue<T>>(this.getWindowedInputCoder(collection), this.options);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public <T extends PValue> T getInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        return (T)((PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.currentTransform)));
    }

    public <T extends PInput> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        return this.currentTransform.getInputs();
    }

    public <T extends PValue> T getOutput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, T> transform) {
        return (T)((PValue)Iterables.getOnlyElement(this.currentTransform.getOutputs().values()));
    }

    public <OutputT extends POutput> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, OutputT> transform) {
        return this.currentTransform.getOutputs();
    }
}

