/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import org.apache.cassandra.config.CassandraRelevantEnv;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HeapUtils {
    private static final Logger logger = LoggerFactory.getLogger(HeapUtils.class);

    public static void logHeapHistogram() {
        try {
            logger.info("Trying to log the heap histogram using jcmd");
            Long processId = HeapUtils.getProcessId();
            if (processId == null) {
                logger.error("The process ID could not be retrieved. Skipping heap histogram generation.");
                return;
            }
            String jcmdPath = HeapUtils.getJcmdPath();
            String jcmdCommand = jcmdPath == null ? "jcmd" : jcmdPath;
            String[] histoCommands = new String[]{jcmdCommand, processId.toString(), "GC.class_histogram"};
            HeapUtils.logProcessOutput(Runtime.getRuntime().exec(histoCommands));
        }
        catch (Throwable e) {
            logger.error("The heap histogram could not be generated due to the following error: ", e);
        }
    }

    private static String getJcmdPath() {
        String javaHome = CassandraRelevantEnv.JAVA_HOME.getString();
        if (javaHome == null) {
            return null;
        }
        File javaBinDirectory = new File(javaHome, "bin");
        Object[] files = javaBinDirectory.tryList((dir, name) -> name.startsWith("jcmd"));
        return ArrayUtils.isEmpty((Object[])files) ? null : ((File)files[0]).path();
    }

    private static void logProcessOutput(Process p) throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            StrBuilder builder = new StrBuilder();
            while ((line = input.readLine()) != null) {
                builder.appendln(line);
            }
            logger.info(builder.toString());
        }
    }

    private static Long getProcessId() {
        long pid = NativeLibrary.getProcessID();
        if (pid >= 0L) {
            return pid;
        }
        return HeapUtils.getProcessIdFromJvmName();
    }

    private static Long getProcessIdFromJvmName() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.valueOf(jvmName.split("@")[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private HeapUtils() {
    }
}

