/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.security.FileBasedSslContextFactory;
import org.apache.cassandra.security.PEMReader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PEMBasedSslContextFactory
extends FileBasedSslContextFactory {
    public static final String DEFAULT_TARGET_STORETYPE = "PKCS12";
    private static final Logger logger = LoggerFactory.getLogger(PEMBasedSslContextFactory.class);
    private String pemEncodedKey;
    private String keyPassword;
    private String pemEncodedCertificates;
    private boolean maybeFileBasedPrivateKey;
    private boolean maybeFileBasedTrustedCertificates;

    public PEMBasedSslContextFactory() {
    }

    public PEMBasedSslContextFactory(Map<String, Object> parameters) {
        super(parameters);
        this.pemEncodedKey = this.getString(ConfigKey.ENCODED_KEY.getKeyName());
        this.keyPassword = this.getString(ConfigKey.KEY_PASSWORD.getKeyName());
        if (StringUtils.isEmpty((CharSequence)this.keyPassword)) {
            this.keyPassword = this.keystore_password;
        } else {
            if (!StringUtils.isEmpty((CharSequence)this.keystore_password) && !this.keyPassword.equals(this.keystore_password)) {
                throw new IllegalArgumentException("'keystore_password' and 'key_password' both configurations are given and the values do not match");
            }
            logger.warn("'keystore_password' and 'key_password' both are configured but since the values match it's okay. Ideally you should only specify one of them.");
        }
        if (!StringUtils.isEmpty((CharSequence)this.truststore_password)) {
            logger.warn("PEM based truststore should not be using password. Ignoring the given value in 'truststore_password' configuration.");
        }
        this.pemEncodedCertificates = this.getString(ConfigKey.ENCODED_CERTIFICATES.getKeyName());
        this.maybeFileBasedPrivateKey = StringUtils.isEmpty((CharSequence)this.pemEncodedKey);
        this.maybeFileBasedTrustedCertificates = StringUtils.isEmpty((CharSequence)this.pemEncodedCertificates);
        this.enforceSinglePrivateKeySource();
        this.enforceSingleTurstedCertificatesSource();
    }

    @Override
    public boolean hasKeystore() {
        return this.maybeFileBasedPrivateKey ? this.keystoreFileExists() : !StringUtils.isEmpty((CharSequence)this.pemEncodedKey);
    }

    private boolean keystoreFileExists() {
        return this.keystore != null && new File(this.keystore).exists();
    }

    private boolean hasTruststore() {
        return this.maybeFileBasedTrustedCertificates ? this.truststoreFileExists() : !StringUtils.isEmpty((CharSequence)this.pemEncodedCertificates);
    }

    private boolean truststoreFileExists() {
        return this.truststore != null && new File(this.truststore).exists();
    }

    @Override
    public synchronized void initHotReloading() {
        ArrayList<FileBasedSslContextFactory.HotReloadableFile> fileList = new ArrayList<FileBasedSslContextFactory.HotReloadableFile>();
        if (this.maybeFileBasedPrivateKey && this.hasKeystore()) {
            fileList.add(new FileBasedSslContextFactory.HotReloadableFile(this.keystore));
        }
        if (this.maybeFileBasedTrustedCertificates && this.hasTruststore()) {
            fileList.add(new FileBasedSslContextFactory.HotReloadableFile(this.truststore));
        }
        if (!fileList.isEmpty()) {
            this.hotReloadableFiles = fileList;
        }
    }

    @Override
    protected KeyManagerFactory buildKeyManagerFactory() throws SSLException {
        try {
            if (this.hasKeystore()) {
                if (this.maybeFileBasedPrivateKey) {
                    this.pemEncodedKey = this.readPEMFile(this.keystore);
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.algorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : this.algorithm);
                KeyStore ks = this.buildKeyStore();
                if (!this.checkedExpiry) {
                    this.checkExpiredCerts(ks);
                    this.checkedExpiry = true;
                }
                kmf.init(ks, this.keyPassword != null ? this.keyPassword.toCharArray() : null);
                return kmf;
            }
            throw new SSLException("Must provide keystore or private_key in configuration for PEMBasedSSlContextFactory");
        }
        catch (Exception e) {
            throw new SSLException("Failed to build key manager store for secure connections", e);
        }
    }

    @Override
    protected TrustManagerFactory buildTrustManagerFactory() throws SSLException {
        try {
            if (this.hasTruststore()) {
                if (this.maybeFileBasedTrustedCertificates) {
                    this.pemEncodedCertificates = this.readPEMFile(this.truststore);
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.algorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : this.algorithm);
                KeyStore ts = this.buildTrustStore();
                tmf.init(ts);
                return tmf;
            }
            throw new SSLException("Must provide truststore or trusted_certificates in configuration for PEMBasedSSlContextFactory");
        }
        catch (Exception e) {
            throw new SSLException("Failed to build trust manager store for secure connections", e);
        }
    }

    private String readPEMFile(String file) throws IOException {
        return new String(Files.readAllBytes(Paths.get(file, new String[0])));
    }

    private KeyStore buildKeyStore() throws GeneralSecurityException, IOException {
        char[] keyPasswordArray = this.keyPassword != null ? this.keyPassword.toCharArray() : null;
        PrivateKey privateKey = PEMReader.extractPrivateKey(this.pemEncodedKey, this.keyPassword);
        Certificate[] certChainArray = PEMReader.extractCertificates(this.pemEncodedKey);
        if (certChainArray == null || certChainArray.length == 0) {
            throw new SSLException("Could not read any certificates for the certChain for the private key");
        }
        KeyStore keyStore = KeyStore.getInstance(DEFAULT_TARGET_STORETYPE);
        keyStore.load(null, null);
        keyStore.setKeyEntry("cassandra-ssl-keystore", privateKey, keyPasswordArray, certChainArray);
        return keyStore;
    }

    private KeyStore buildTrustStore() throws GeneralSecurityException, IOException {
        Certificate[] certChainArray = PEMReader.extractCertificates(this.pemEncodedCertificates);
        if (certChainArray == null || certChainArray.length == 0) {
            throw new SSLException("Could not read any certificates from the given PEM");
        }
        KeyStore keyStore = KeyStore.getInstance(DEFAULT_TARGET_STORETYPE);
        keyStore.load(null, null);
        for (int i = 0; i < certChainArray.length; ++i) {
            keyStore.setCertificateEntry("cassandra-ssl-trusted-cert-" + (i + 1), certChainArray[i]);
        }
        return keyStore;
    }

    private void enforceSinglePrivateKeySource() {
        if (this.keystoreFileExists() && !StringUtils.isEmpty((CharSequence)this.pemEncodedKey)) {
            throw new IllegalArgumentException("Configuration must specify value for either keystore or private_key, not both for PEMBasedSSlContextFactory");
        }
    }

    private void enforceSingleTurstedCertificatesSource() {
        if (this.truststoreFileExists() && !StringUtils.isEmpty((CharSequence)this.pemEncodedCertificates)) {
            throw new IllegalArgumentException("Configuration must specify value for either truststore or trusted_certificates, not both for PEMBasedSSlContextFactory");
        }
    }

    public static enum ConfigKey {
        ENCODED_KEY("private_key"),
        KEY_PASSWORD("private_key_password"),
        ENCODED_CERTIFICATES("trusted_certificates");

        final String keyName;

        private ConfigKey(String keyName) {
            this.keyName = keyName;
        }

        String getKeyName() {
            return this.keyName;
        }
    }
}

