/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.ResizableThreadPool;
import org.apache.cassandra.concurrent.ThreadPoolExecutorBuilder;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

public class ThreadPoolExecutorBase
extends ThreadPoolExecutor
implements ResizableThreadPool {
    public static final RejectedExecutionHandler blockingExecutionHandler = (task, executor) -> {
        BlockingQueue<Runnable> queue = executor.getQueue();
        try {
            try {
                do {
                    if (!executor.isShutdown()) continue;
                    throw new RejectedExecutionException(executor + " has shut down");
                } while (!queue.offer(task, 1L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
        }
        catch (Throwable t) {
            if (task instanceof Future) {
                ((Future)((Object)task)).cancel(false);
            }
            throw t;
        }
    };
    private Runnable onShutdown;

    public ThreadPoolExecutorBase(ThreadPoolExecutorBuilder<?> builder) {
        super(builder.coreThreads(), builder.maxThreads(), builder.keepAlive(), builder.keepAliveUnits(), builder.newQueue(), builder.newThreadFactory());
        this.allowCoreThreadTimeOut(builder.allowCoreThreadTimeouts());
        this.setRejectedExecutionHandler(builder.rejectedExecutionHandler(blockingExecutionHandler));
    }

    public ThreadPoolExecutorBase(int threads, int keepAlive, TimeUnit keepAliveUnits, BlockingQueue<Runnable> queue, NamedThreadFactory threadFactory) {
        super(threads, threads, (long)keepAlive, keepAliveUnits, queue, threadFactory);
        assert (queue.isEmpty()) : "Executor initialized with non-empty task queue";
        this.allowCoreThreadTimeOut(true);
    }

    public void onShutdown(Runnable onShutdown) {
        this.onShutdown = onShutdown;
    }

    public Runnable onShutdown() {
        return this.onShutdown;
    }

    @Override
    protected void terminated() {
        this.getThreadFactory().close();
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            if (this.onShutdown != null) {
                this.onShutdown.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        try {
            List<Runnable> cancelled = super.shutdownNow();
            for (Runnable c : cancelled) {
                if (!(c instanceof Future)) continue;
                ((Future)((Object)c)).cancel(true);
            }
            List<Runnable> list = cancelled;
            return list;
        }
        finally {
            if (this.onShutdown != null) {
                this.onShutdown.run();
            }
        }
    }

    @Override
    public int getActiveTaskCount() {
        return this.getActiveCount();
    }

    @Override
    public int getPendingTaskCount() {
        return this.getQueue().size();
    }

    public int getCoreThreads() {
        return this.getCorePoolSize();
    }

    public void setCoreThreads(int number) {
        this.setCorePoolSize(number);
    }

    public int getMaximumThreads() {
        return this.getMaximumPoolSize();
    }

    public void setMaximumThreads(int number) {
        this.setMaximumPoolSize(number);
    }

    @Override
    public NamedThreadFactory getThreadFactory() {
        return (NamedThreadFactory)super.getThreadFactory();
    }

    @Override
    public String toString() {
        return this.getThreadFactory().id;
    }
}

