/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.graph.SimpleTransformationTranslator;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.InputFormatOperatorFactory;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class LegacySourceTransformationTranslator<OUT>
extends SimpleTransformationTranslator<OUT, LegacySourceTransformation<OUT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(LegacySourceTransformation<OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(LegacySourceTransformation<OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    private Collection<Integer> translateInternal(LegacySourceTransformation<OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        StreamGraph streamGraph = context.getStreamGraph();
        String slotSharingGroup = context.getSlotSharingGroup();
        int transformationId = transformation.getId();
        ExecutionConfig executionConfig = streamGraph.getExecutionConfig();
        streamGraph.addLegacySource(transformationId, slotSharingGroup, transformation.getCoLocationGroupKey(), transformation.getOperatorFactory(), null, transformation.getOutputType(), "Source: " + transformation.getName());
        if (transformation.getOperatorFactory() instanceof InputFormatOperatorFactory) {
            streamGraph.setInputFormat(transformationId, ((InputFormatOperatorFactory)transformation.getOperatorFactory()).getInputFormat());
        }
        int parallelism = transformation.getParallelism() != -1 ? transformation.getParallelism() : executionConfig.getParallelism();
        streamGraph.setParallelism(transformationId, parallelism);
        streamGraph.setMaxParallelism(transformationId, transformation.getMaxParallelism());
        return Collections.singleton(transformationId);
    }
}

