/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.control;

import java.util.Collection;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.repackaged.direct_java.runners.core.StateInternals;
import org.apache.beam.repackaged.direct_java.runners.core.StateInternalsFactory;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespace;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternalsFactory;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.BundleCheckpointHandler;
import org.apache.beam.repackaged.direct_java.sdk.fn.IdGenerator;
import org.apache.beam.repackaged.direct_java.sdk.fn.IdGenerators;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.Timestamp;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class BundleCheckpointHandlers {

    public static class StateAndTimerBundleCheckpointHandler<@UnknownKeyFor T>
    implements BundleCheckpointHandler {
        private final @UnknownKeyFor @NonNull @Initialized TimerInternalsFactory<T> timerInternalsFactory;
        private final @UnknownKeyFor @NonNull @Initialized StateInternalsFactory<T> stateInternalsFactory;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> residualCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder windowCoder;
        private final @UnknownKeyFor @NonNull @Initialized IdGenerator idGenerator = IdGenerators.incrementingLongs();
        public static final @UnknownKeyFor @NonNull @Initialized String SDF_PREFIX = "sdf_checkpoint";

        public StateAndTimerBundleCheckpointHandler(@UnknownKeyFor @NonNull @Initialized TimerInternalsFactory<T> timerInternalsFactory, @UnknownKeyFor @NonNull @Initialized StateInternalsFactory<T> stateInternalsFactory, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> residualCoder, @UnknownKeyFor @NonNull @Initialized Coder windowCoder) {
            this.residualCoder = residualCoder;
            this.windowCoder = windowCoder;
            this.timerInternalsFactory = timerInternalsFactory;
            this.stateInternalsFactory = stateInternalsFactory;
        }

        public static @UnknownKeyFor @NonNull @Initialized boolean isSdfTimer(@UnknownKeyFor @NonNull @Initialized String timerId) {
            return timerId.startsWith(SDF_PREFIX);
        }

        private static @UnknownKeyFor @NonNull @Initialized String constructSdfCheckpointId(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized int index) {
            return "sdf_checkpoint:" + id + ":" + index;
        }

        @Override
        public void onCheckpoint(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.ProcessBundleResponse response) {
            String id = this.idGenerator.getId();
            for (int index = 0; index < response.getResidualRootsCount(); ++index) {
                BeamFnApi.DelayedBundleApplication residual = response.getResidualRoots(index);
                if (!residual.hasApplication()) continue;
                String tag = StateAndTimerBundleCheckpointHandler.constructSdfCheckpointId(id, index);
                try {
                    WindowedValue stateValue = (WindowedValue)CoderUtils.decodeFromByteArray(this.residualCoder, (byte[])residual.getApplication().getElement().toByteArray());
                    TimerInternals timerInternals = this.timerInternalsFactory.timerInternalsForKey(stateValue.getValue());
                    StateInternals stateInternals = this.stateInternalsFactory.stateInternalsForKey(stateValue.getValue());
                    Instant timestamp = Instant.now();
                    if (residual.hasRequestedTimeDelay()) {
                        timestamp = timestamp.plus((ReadableDuration)Duration.millis((long)(residual.getRequestedTimeDelay().getSeconds() * 1000L)));
                    }
                    long outputTimestamp = BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis();
                    if (!residual.getApplication().getOutputWatermarksMap().isEmpty()) {
                        for (Timestamp outputWatermark : residual.getApplication().getOutputWatermarksMap().values()) {
                            outputTimestamp = Math.min(outputTimestamp, outputWatermark.getSeconds() * 1000L);
                        }
                    } else {
                        outputTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
                    }
                    for (BoundedWindow window : stateValue.getWindows()) {
                        StateNamespace stateNamespace = StateNamespaces.window(this.windowCoder, window);
                        timerInternals.setTimer(stateNamespace, tag, "", timestamp, Instant.ofEpochMilli((long)outputTimestamp), TimeDomain.PROCESSING_TIME);
                        stateInternals.state(stateNamespace, StateTags.value(tag, this.residualCoder)).write((Object)WindowedValue.of((Object)stateValue.getValue(), (Instant)stateValue.getTimestamp(), (Collection)ImmutableList.of((Object)window), (PaneInfo)stateValue.getPane()));
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set timer/state for the residual", e);
                }
            }
        }
    }
}

