/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.LeaseWorkItemRequest;
import com.google.api.services.dataflow.model.LeaseWorkItemResponse;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import com.google.api.services.dataflow.model.ListJobsResponse;
import com.google.api.services.dataflow.model.ReportWorkItemStatusRequest;
import com.google.api.services.dataflow.model.ReportWorkItemStatusResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DataflowClient {
    private final @UnknownKeyFor @NonNull @Initialized Dataflow dataflow;
    private final @UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options;

    public static @UnknownKeyFor @NonNull @Initialized DataflowClient create(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        return new DataflowClient(options.getDataflowClient(), options);
    }

    private DataflowClient(@UnknownKeyFor @NonNull @Initialized Dataflow dataflow, @UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        this.dataflow = (Dataflow)Preconditions.checkNotNull((Object)dataflow, (Object)"dataflow");
        this.options = (DataflowPipelineOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
    }

    public @UnknownKeyFor @NonNull @Initialized Job createJob(@Nonnull @UnknownKeyFor @NonNull @Initialized Job job) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)job, (Object)"job");
        Dataflow.Projects.Locations.Jobs.Create jobsCreate = this.dataflow.projects().locations().jobs().create(this.options.getProject(), this.options.getRegion(), job);
        return (Job)jobsCreate.execute();
    }

    public @UnknownKeyFor @NonNull @Initialized ListJobsResponse listJobs(@Nullable @UnknownKeyFor @Initialized String pageToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Dataflow.Projects.Locations.Jobs.List jobsList = this.dataflow.projects().locations().jobs().list(this.options.getProject(), this.options.getRegion()).setPageToken(pageToken);
        return (ListJobsResponse)jobsList.execute();
    }

    public @UnknownKeyFor @NonNull @Initialized Job updateJob(@Nonnull @UnknownKeyFor @NonNull @Initialized String jobId, @Nonnull @UnknownKeyFor @NonNull @Initialized Job content) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"jobId");
        Preconditions.checkNotNull((Object)content, (Object)"content");
        Dataflow.Projects.Locations.Jobs.Update jobsUpdate = this.dataflow.projects().locations().jobs().update(this.options.getProject(), this.options.getRegion(), jobId, content);
        return (Job)jobsUpdate.execute();
    }

    public @UnknownKeyFor @NonNull @Initialized Job getJob(@Nonnull @UnknownKeyFor @NonNull @Initialized String jobId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"jobId");
        Dataflow.Projects.Locations.Jobs.Get jobsGet = this.dataflow.projects().locations().jobs().get(this.options.getProject(), this.options.getRegion(), jobId);
        return (Job)jobsGet.execute();
    }

    public @UnknownKeyFor @NonNull @Initialized JobMetrics getJobMetrics(@Nonnull @UnknownKeyFor @NonNull @Initialized String jobId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"jobId");
        Dataflow.Projects.Locations.Jobs.GetMetrics jobsGetMetrics = this.dataflow.projects().locations().jobs().getMetrics(this.options.getProject(), this.options.getRegion(), jobId);
        return (JobMetrics)jobsGetMetrics.execute();
    }

    public @UnknownKeyFor @NonNull @Initialized ListJobMessagesResponse listJobMessages(@Nonnull @UnknownKeyFor @NonNull @Initialized String jobId, @Nullable @UnknownKeyFor @Initialized String pageToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"jobId");
        Dataflow.Projects.Locations.Jobs.Messages.List jobMessagesList = this.dataflow.projects().locations().jobs().messages().list(this.options.getProject(), this.options.getRegion(), jobId).setPageToken(pageToken);
        return (ListJobMessagesResponse)jobMessagesList.execute();
    }

    public @UnknownKeyFor @NonNull @Initialized LeaseWorkItemResponse leaseWorkItem(@Nonnull @UnknownKeyFor @NonNull @Initialized String jobId, @Nonnull @UnknownKeyFor @NonNull @Initialized LeaseWorkItemRequest request) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"jobId");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Dataflow.Projects.Locations.Jobs.WorkItems.Lease jobWorkItemsLease = this.dataflow.projects().locations().jobs().workItems().lease(this.options.getProject(), this.options.getRegion(), jobId, request);
        return (LeaseWorkItemResponse)jobWorkItemsLease.execute();
    }

    public @UnknownKeyFor @NonNull @Initialized ReportWorkItemStatusResponse reportWorkItemStatus(@Nonnull @UnknownKeyFor @NonNull @Initialized String jobId, @Nonnull @UnknownKeyFor @NonNull @Initialized ReportWorkItemStatusRequest request) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"jobId");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Dataflow.Projects.Locations.Jobs.WorkItems.ReportStatus jobWorkItemsReportStatus = this.dataflow.projects().locations().jobs().workItems().reportStatus(this.options.getProject(), this.options.getRegion(), jobId, request);
        return (ReportWorkItemStatusResponse)jobWorkItemsReportStatus.execute();
    }
}

