/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.plugins;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.DefaultLogLevel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.plugins.HopURLClassLoader;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.plugins.ParentFirst;
import org.apache.hop.core.plugins.Plugin;
import org.apache.hop.core.plugins.PluginClassFile;
import org.apache.hop.core.plugins.PluginMainClassType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.i18n.GlobalMessageUtil;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class BasePluginType<T extends Annotation>
implements IPluginType<T> {
    protected static Class<?> classFromResourcesPackage = BasePluginType.class;
    protected final PluginRegistry registry;
    private String id;
    private String name;
    private LogChannel log;
    private Map<Class<?>, String> objectTypes = new HashMap();
    private Class<T> pluginClass;
    private List<String> extraLibraryFolders;

    public BasePluginType(Class<T> pluginClazz) {
        this.log = new LogChannel("Plugin type");
        this.registry = PluginRegistry.getInstance();
        this.pluginClass = pluginClazz;
        this.extraLibraryFolders = new ArrayList<String>();
    }

    public BasePluginType(Class<T> pluginType, String id, String name) {
        this(pluginType);
        this.id = id;
        this.name = name;
    }

    public Map<Class<?>, String> getAdditionalRuntimeObjectTypes() {
        return this.objectTypes;
    }

    @Override
    public void addObjectType(Class<?> clz, String xmlNodeName) {
        this.objectTypes.put(clz, xmlNodeName);
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }

    @Override
    public void searchPlugins() throws HopPluginException {
        StopWatch watch = new StopWatch();
        if (this.log.isDebug()) {
            watch.start();
        }
        this.registerNatives();
        this.registerPluginJars();
        if (this.log.isDebug()) {
            watch.stop();
            List plugins = this.registry.getPlugins(this.getClass());
            this.log.logBasic(this.pluginClass.getSimpleName() + " register " + plugins.size() + " plugins (Time Elapsed: " + watch.getTime() + "ms)");
        }
    }

    protected void registerNatives() throws HopPluginException {
        try {
            JarCache cache = JarCache.getInstance();
            for (File jarFile : cache.getNativeJars()) {
                Index index = cache.getIndex(jarFile);
                for (AnnotationInstance instance : index.getAnnotations(this.pluginClass)) {
                    if (!(instance.target() instanceof ClassInfo)) continue;
                    ClassInfo classInfo = instance.target().asClass();
                    String className = classInfo.name().toString();
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                    if (clazz == null) {
                        throw new HopPluginException("Unable to load class: " + className);
                    }
                    T annotation = clazz.getAnnotation(this.pluginClass);
                    ArrayList<String> libraries = new ArrayList<String>();
                    this.handlePluginAnnotation(clazz, annotation, libraries, true, null);
                }
            }
        }
        catch (Exception e) {
            throw new HopPluginException("Error registering native plugins", e);
        }
    }

    @VisibleForTesting
    protected String getPropertyExternal(String key, String def) {
        return System.getProperty(key, def);
    }

    @VisibleForTesting
    protected InputStream getResAsStreamExternal(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    @VisibleForTesting
    protected InputStream getFileInputStreamExternal(String name) throws FileNotFoundException {
        return new FileInputStream(name);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected static String getCodedTranslation(String codedString) {
        if (codedString == null) {
            return null;
        }
        if (codedString.startsWith("i18n:")) {
            String[] parts = codedString.split(":");
            if (parts.length != 3) {
                return codedString;
            }
            return BaseMessages.getString(parts[1], parts[2]);
        }
        return codedString;
    }

    protected static String[] getTranslations(String[] strings, String packageName, Class<?> resourceClass) {
        if (strings == null) {
            return null;
        }
        String[] translations = new String[strings.length];
        for (int i = 0; i < translations.length; ++i) {
            translations[i] = BasePluginType.getTranslation(strings[i], packageName, resourceClass);
        }
        return translations;
    }

    protected static String getTranslation(String string, String packageName, Class<?> resourceClass) {
        String translation;
        if (string == null) {
            return null;
        }
        if (string.startsWith("i18n:")) {
            String i18nKey;
            String translation2;
            String[] parts = string.split(":");
            if (parts.length != 3) {
                return string;
            }
            String i18nPackage = parts[1];
            if (StringUtils.isEmpty((String)i18nPackage)) {
                i18nPackage = packageName;
            }
            if ((translation2 = BaseMessages.getString(i18nPackage, i18nKey = parts[2], resourceClass, new String[0])).startsWith("!") && translation2.endsWith("!")) {
                translation2 = BaseMessages.getString(i18nPackage, i18nKey);
            }
            return translation2;
        }
        if (!Utils.isEmpty(packageName)) {
            LogLevel oldLogLevel = DefaultLogLevel.getLogLevel();
            DefaultLogLevel.setLogLevel(LogLevel.BASIC);
            translation = BaseMessages.getString(packageName, string, resourceClass, new String[0]);
            DefaultLogLevel.setLogLevel(oldLogLevel);
            if (translation.startsWith("!") && translation.endsWith("!")) {
                translation = BaseMessages.getString(classFromResourcesPackage, string, resourceClass, new String[0]);
            }
            if (translation.startsWith("!") && translation.endsWith("!")) {
                translation = string;
            }
        } else {
            translation = string;
        }
        return translation;
    }

    protected List<PluginClassFile> findAnnotatedClassFiles(String annotationClassName) throws HopPluginException {
        JarCache cache = JarCache.getInstance();
        ArrayList<PluginClassFile> classFiles = new ArrayList<PluginClassFile>();
        try {
            for (File jarFile : cache.getPluginJars()) {
                Index index = cache.getIndex(jarFile);
                for (AnnotationInstance instance : index.getAnnotations(this.pluginClass)) {
                    if (!(instance.target() instanceof ClassInfo)) continue;
                    try {
                        ClassInfo classInfo = instance.target().asClass();
                        String className = classInfo.name().toString();
                        File folder = jarFile.getParentFile();
                        classFiles.add(new PluginClassFile(className, jarFile.toURI().toURL(), folder.toURI().toURL()));
                    }
                    catch (Exception e) {
                        System.out.println("Error searching annotation for " + String.valueOf(this.pluginClass) + " in " + String.valueOf(jarFile));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HopPluginException("Error finding plugin annotation " + annotationClassName, e);
        }
        return classFiles;
    }

    public void registerCustom(Class<?> clazz, String cat, String id, String name, String desc, String image) throws HopPluginException {
        Class<?> pluginType = this.getClass();
        HashMap classMap = new HashMap();
        PluginMainClassType mainClassTypesAnnotation = pluginType.getAnnotation(PluginMainClassType.class);
        classMap.put(mainClassTypesAnnotation.value(), clazz.getName());
        Plugin plugin = new Plugin(new String[]{id}, pluginType, mainClassTypesAnnotation.value(), cat, name, desc, image, false, false, classMap, new ArrayList<String>(), null, null, null, false, null, null, null);
        this.registry.registerPlugin(pluginType, plugin);
    }

    private List<String> addExtraJarFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (String extraLibraryFolder : this.extraLibraryFolders) {
            File folder = new File(extraLibraryFolder);
            if (!folder.exists()) continue;
            Collection jarFiles = FileUtils.listFiles((File)folder, (String[])new String[]{"jar", "JAR"}, (boolean)true);
            jarFiles.stream().forEach(file -> files.add(file.getPath()));
        }
        return files;
    }

    protected String getAlternativeTranslation(String input, Map<String, String> localizedMap) {
        if (Utils.isEmpty(input)) {
            return null;
        }
        if (input.startsWith("i18n")) {
            return BasePluginType.getCodedTranslation(input);
        }
        for (Locale locale : GlobalMessageUtil.getActiveLocales()) {
            String alt = localizedMap.get(locale.toString().toLowerCase());
            if (Utils.isEmpty(alt)) continue;
            return alt;
        }
        return input;
    }

    protected URLClassLoader createUrlClassLoader(URL jarFileUrl, ClassLoader classLoader) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            String dependenciesFileName;
            File dependenciesFile;
            JarCache jarCache = JarCache.getInstance();
            String parentFolderName = new File(URLDecoder.decode(jarFileUrl.getFile(), "UTF-8")).getParent();
            File libFolder = new File(parentFolderName + Const.FILE_SEPARATOR + "lib");
            if (libFolder.exists()) {
                for (File libFile : jarCache.findJarFiles(libFolder)) {
                    urls.add(libFile.toURI().toURL());
                }
            }
            if ((dependenciesFile = new File(dependenciesFileName = parentFolderName + Const.FILE_SEPARATOR + "dependencies.xml")).exists()) {
                Document document = XmlHandler.loadXmlFile(dependenciesFile);
                Node dependenciesNode = XmlHandler.getSubNode(document, "dependencies");
                List<Node> folderNodes = XmlHandler.getNodes(dependenciesNode, "folder");
                for (Node folderNode : folderNodes) {
                    String relativeFolderName = XmlHandler.getNodeValue(folderNode);
                    String dependenciesFolderName = parentFolderName + Const.FILE_SEPARATOR + relativeFolderName;
                    File dependenciesFolder = new File(dependenciesFolderName);
                    if (!dependenciesFolder.exists()) continue;
                    for (File libFile : jarCache.findJarFiles(dependenciesFolder)) {
                        urls.add(libFile.toURI().toURL());
                    }
                }
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Unexpected error searching for plugin jar files in lib/ folder and dependencies for jar file '" + String.valueOf(jarFileUrl) + "'", e);
        }
        urls.add(jarFileUrl);
        return new HopURLClassLoader(urls.toArray(new URL[urls.size()]), classLoader);
    }

    protected String extractCategory(T annotation) {
        return null;
    }

    protected abstract String extractID(T var1);

    protected abstract String extractName(T var1);

    protected abstract String extractDesc(T var1);

    protected String extractClassLoaderGroup(T annotation) {
        return null;
    }

    protected String extractImageFile(T annotation) {
        return null;
    }

    protected boolean extractSeparateClassLoader(T annotation) {
        return false;
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, T annotation) {
    }

    protected String extractDocumentationUrl(T annotation) {
        return null;
    }

    protected String extractCasesUrl(T annotation) {
        return null;
    }

    protected String extractForumUrl(T annotation) {
        return null;
    }

    protected String extractSuggestion(T annotation) {
        return null;
    }

    protected String[] extractKeywords(T annotation) {
        return new String[0];
    }

    protected void registerPluginJars() throws HopPluginException {
        List<PluginClassFile> pluginClassFiles = this.findAnnotatedClassFiles(this.pluginClass.getName());
        for (PluginClassFile pluginClassFile : pluginClassFiles) {
            URLClassLoader urlClassLoader = this.createUrlClassLoader(pluginClassFile.getJarFile(), this.getClass().getClassLoader());
            try {
                Class<?> clazz = urlClassLoader.loadClass(pluginClassFile.getClassName());
                if (clazz == null) {
                    throw new HopPluginException("Unable to load class: " + pluginClassFile.getClassName());
                }
                List<String> libraries = Arrays.stream(urlClassLoader.getURLs()).map(URL::getFile).collect(Collectors.toList());
                T annotation = clazz.getAnnotation(this.pluginClass);
                this.handlePluginAnnotation(clazz, annotation, libraries, false, pluginClassFile.getFolder());
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Unexpected error registering jar plugin file: " + String.valueOf(pluginClassFile.getJarFile()), e);
            }
        }
    }

    @Override
    public void handlePluginAnnotation(Class<?> clazz, T annotation, List<String> libraries, boolean nativePluginType, URL pluginFolder) throws HopPluginException {
        String idList = this.extractID(annotation);
        if (Utils.isEmpty(idList)) {
            idList = clazz.getName();
        }
        String[] ids = idList.split(",");
        String packageName = clazz.getPackage().getName();
        Object pluginName = BasePluginType.getTranslation(this.extractName(annotation), packageName, clazz);
        String description = BasePluginType.getTranslation(this.extractDesc(annotation), packageName, clazz);
        String category = BasePluginType.getTranslation(this.extractCategory(annotation), packageName, clazz);
        String imageFile = this.extractImageFile(annotation);
        boolean separateClassLoader = this.extractSeparateClassLoader(annotation);
        String documentationUrl = this.extractDocumentationUrl(annotation);
        String casesUrl = this.extractCasesUrl(annotation);
        String forumUrl = this.extractForumUrl(annotation);
        String suggestion = BasePluginType.getTranslation(this.extractSuggestion(annotation), packageName, clazz);
        String classLoaderGroup = this.extractClassLoaderGroup(annotation);
        String[] keywords = BasePluginType.getTranslations(this.extractKeywords(annotation), packageName, clazz);
        HashMap classMap = new HashMap();
        PluginMainClassType mainType = this.getClass().getAnnotation(PluginMainClassType.class);
        Class<?> mainClass = mainType != null ? mainType.value() : clazz;
        classMap.put(mainClass, clazz.getName());
        this.addExtraClasses(classMap, clazz, annotation);
        Deprecated deprecated = clazz.getDeclaredAnnotation(Deprecated.class);
        if (deprecated != null) {
            String str = BaseMessages.getString(classFromResourcesPackage, "System.Deprecated", new String[0]).toLowerCase();
            pluginName = (String)pluginName + " (" + str + ")";
        }
        List<String> extraJarFiles = this.addExtraJarFiles();
        libraries.addAll(extraJarFiles);
        boolean usingLibrariesOutsidePluginFolder = !extraJarFiles.isEmpty();
        Plugin plugin = new Plugin(ids, this.getClass(), mainClass, category, (String)pluginName, description, imageFile, separateClassLoader, classLoaderGroup, nativePluginType, classMap, libraries, null, keywords, pluginFolder, usingLibrariesOutsidePluginFolder, documentationUrl, casesUrl, forumUrl, suggestion);
        ParentFirst parentFirstAnnotation = clazz.getAnnotation(ParentFirst.class);
        if (parentFirstAnnotation != null) {
            this.registry.addParentClassLoaderPatterns(plugin, parentFirstAnnotation.patterns());
        }
        this.registry.registerPlugin(this.getClass(), plugin);
        if (libraries != null && !libraries.isEmpty()) {
            LogChannel.GENERAL.logDetailed("Plugin with id [" + ids[0] + "] has " + libraries.size() + " libaries in its private class path");
        }
    }

    public List<String> getExtraLibraryFolders() {
        return this.extraLibraryFolders;
    }

    public void setExtraLibraryFolders(List<String> extraLibraryFolders) {
        this.extraLibraryFolders = extraLibraryFolders;
    }

    public void registerClassPathPlugin(Class<?> clazz) throws HopPluginException {
        T annotation = clazz.getAnnotation(this.pluginClass);
        this.handlePluginAnnotation(clazz, annotation, new ArrayList<String>(), true, null);
    }
}

