/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.database;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabasePluginType;
import org.apache.hop.core.database.DatabaseTestResults;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.database.IDatabaseFactory;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginTypeListener;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.ExecutorUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;

@HopMetadata(key="rdbms", name="Relational Database Connection", description="This contains all the metadata needed to connect to a relational database", image="ui/images/database.svg", documentationUrl="/metadata-types/rdbms-connection.html")
public class DatabaseMeta
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    private static final Class<?> PKG = Database.class;
    public static final String XML_TAG = "connection";
    public static final String GUI_PLUGIN_ELEMENT_PARENT_ID = "DatabaseMeta-PluginSpecific-Options";
    public static final Comparator<DatabaseMeta> comparator = (dbm1, dbm2) -> dbm1.getName().compareToIgnoreCase(dbm2.getName());
    @HopMetadataProperty(key="rdbms")
    private IDatabase iDatabase;
    private static volatile Future<Map<String, IDatabase>> allDatabaseInterfaces;
    private boolean readOnly = false;
    public static final int TYPE_ACCESS_NATIVE = 0;
    public static final String[] dbAccessTypeCode;
    public static final String[] dbAccessTypeDesc;
    public static final int CLOB_LENGTH = 9999999;
    public static final String EMPTY_OPTIONS_STRING = "><EMPTY><";

    public static void init() {
        PluginRegistry.getInstance().addPluginListener(DatabasePluginType.class, new IPluginTypeListener(){

            @Override
            public void pluginAdded(Object serviceObject) {
                DatabaseMeta.clearDatabaseInterfacesMap();
            }

            @Override
            public void pluginRemoved(Object serviceObject) {
                DatabaseMeta.clearDatabaseInterfacesMap();
            }

            @Override
            public void pluginChanged(Object serviceObject) {
                DatabaseMeta.clearDatabaseInterfacesMap();
            }
        });
    }

    public DatabaseMeta(String name, String type, String access, String host, String db, String port, String user, String pass) {
        this.setValues(name, type, access, host, db, port, user, pass);
        this.addOptions();
    }

    public DatabaseMeta() {
        this.setDefault();
        this.addOptions();
    }

    public static DatabaseMeta loadDatabase(IHopMetadataProvider metadataProvider, String connectionName) throws HopXmlException {
        if (metadataProvider == null || StringUtils.isEmpty((String)connectionName)) {
            return null;
        }
        try {
            return metadataProvider.getSerializer(DatabaseMeta.class).load(connectionName);
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load relational database connection '" + connectionName + "'", e);
        }
    }

    public void setDefault() {
        this.setValues("", "NONE", "Native", "", "", "", "", "");
    }

    public void addOptions() {
        this.iDatabase.addDefaultOptions();
        this.setSupportsBooleanDataType(true);
        this.setSupportsTimestampDataType(true);
    }

    public DatabaseMeta(DatabaseMeta databaseMeta) {
        this();
        this.replaceMeta(databaseMeta);
    }

    public IDatabase getIDatabase() {
        return this.iDatabase;
    }

    public void setIDatabase(IDatabase iDatabase) {
        this.iDatabase = iDatabase;
    }

    public static final IDatabase getIDatabase(String databaseType) throws HopDatabaseException {
        IDatabase di = DatabaseMeta.findIDatabase(databaseType);
        if (di == null) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, "DatabaseMeta.Error.DatabaseInterfaceNotFound", databaseType));
        }
        return (IDatabase)di.clone();
    }

    private static final IDatabase findIDatabase(String databaseTypeDesc) throws HopDatabaseException {
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.getPlugin(DatabasePluginType.class, databaseTypeDesc);
        if (plugin == null) {
            plugin = registry.findPluginWithName(DatabasePluginType.class, databaseTypeDesc);
        }
        if (plugin == null) {
            throw new HopDatabaseException("database type with plugin id [" + databaseTypeDesc + "] couldn't be found!");
        }
        return DatabaseMeta.getIDatabaseMap().get(plugin.getIds()[0]);
    }

    public Object clone() {
        return new DatabaseMeta(this);
    }

    public void replaceMeta(DatabaseMeta databaseMeta) {
        this.setValues(databaseMeta.getName(), databaseMeta.getPluginId(), databaseMeta.getAccessTypeDesc(), databaseMeta.getHostname(), databaseMeta.getDatabaseName(), databaseMeta.getPort(), databaseMeta.getUsername(), databaseMeta.getPassword());
        this.setServername(databaseMeta.getServername());
        this.setDataTablespace(databaseMeta.getDataTablespace());
        this.setIndexTablespace(databaseMeta.getIndexTablespace());
        this.iDatabase = (IDatabase)databaseMeta.iDatabase.clone();
        this.getAttributes().putAll(databaseMeta.getAttributes());
        this.setChanged();
    }

    public void setValues(String name, String type, String access, String host, String db, String port, String user, String pass) {
        try {
            this.iDatabase = DatabaseMeta.getIDatabase(type);
        }
        catch (HopDatabaseException kde) {
            throw new RuntimeException("Database type not found!", kde);
        }
        this.setName(name);
        this.setAccessType(DatabaseMeta.getAccessType(access));
        this.setHostname(host);
        this.setDBName(db);
        this.setPort(port);
        this.setUsername(user);
        this.setPassword(pass);
        this.setServername(null);
        this.setChanged(false);
    }

    public void setDatabaseType(String type) {
        IDatabase oldInterface = this.iDatabase;
        try {
            this.iDatabase = DatabaseMeta.getIDatabase(type);
        }
        catch (HopDatabaseException kde) {
            throw new RuntimeException("Database type [" + type + "] not found!", kde);
        }
        this.setAccessType(oldInterface.getAccessType());
        this.setHostname(oldInterface.getHostname());
        this.setDBName(oldInterface.getDatabaseName());
        this.setPort(oldInterface.getPort());
        this.setUsername(oldInterface.getUsername());
        this.setPassword(oldInterface.getPassword());
        this.setServername(oldInterface.getServername());
        this.setDataTablespace(oldInterface.getDataTablespace());
        this.setIndexTablespace(oldInterface.getIndexTablespace());
        this.setChanged(oldInterface.isChanged());
    }

    public void setValues(DatabaseMeta info) {
        this.iDatabase = (IDatabase)info.iDatabase.clone();
    }

    public String getPluginId() {
        return this.iDatabase.getPluginId();
    }

    public String getPluginName() {
        return this.iDatabase.getPluginName();
    }

    public int getAccessType() {
        return this.iDatabase.getAccessType();
    }

    public void setAccessType(int accessType) {
        this.iDatabase.setAccessType(accessType);
    }

    public String getAccessTypeDesc() {
        return dbAccessTypeCode[this.getAccessType()];
    }

    public String getHostname() {
        return this.iDatabase.getHostname();
    }

    public void setHostname(String hostname) {
        this.iDatabase.setHostname(hostname);
    }

    public String getPort() {
        return this.iDatabase.getPort();
    }

    public void setPort(String port) {
        this.iDatabase.setPort(port);
    }

    public String getDatabaseName() {
        return this.iDatabase.getDatabaseName();
    }

    public void setDBName(String databaseName) {
        this.iDatabase.setDatabaseName(databaseName);
    }

    public String getUsername() {
        return this.iDatabase.getUsername();
    }

    public void setUsername(String username) {
        this.iDatabase.setUsername(username);
    }

    public String getPassword() {
        return this.iDatabase.getPassword();
    }

    public void setPassword(String password) {
        this.iDatabase.setPassword(password);
    }

    public void setServername(String servername) {
        this.iDatabase.setServername(servername);
    }

    public String getServername() {
        return this.iDatabase.getServername();
    }

    public String getDataTablespace() {
        return this.iDatabase.getDataTablespace();
    }

    public void setDataTablespace(String dataTablespace) {
        this.iDatabase.setDataTablespace(dataTablespace);
    }

    public String getIndexTablespace() {
        return this.iDatabase.getIndexTablespace();
    }

    public void setIndexTablespace(String indexTablespace) {
        this.iDatabase.setIndexTablespace(indexTablespace);
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.iDatabase.setChanged(ch);
    }

    public boolean hasChanged() {
        return this.iDatabase.isChanged();
    }

    public void clearChanged() {
        this.iDatabase.setChanged(false);
    }

    public String getManualUrl() {
        return this.iDatabase.getManualUrl();
    }

    public void setManualUrl(String manualUrl) {
        this.iDatabase.setManualUrl(manualUrl);
    }

    public String toString() {
        return this.getName();
    }

    public Map<String, String> getAttributes() {
        return this.iDatabase.getAttributes();
    }

    public void setAttributes(Map<String, String> attributes) {
        this.iDatabase.setAttributes(attributes);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DatabaseMeta && this.getName().equals(((DatabaseMeta)obj).getName());
    }

    public String getURL(IVariables variables) throws HopDatabaseException {
        if (StringUtils.isNotEmpty((String)this.getManualUrl()) && StringUtils.isNotBlank((String)this.getManualUrl())) {
            return this.getManualUrl();
        }
        String hostname = variables.resolve(this.getHostname());
        String port = variables.resolve(this.getPort());
        String databaseName = variables.resolve(this.getDatabaseName());
        String baseUrl = this.iDatabase.getURL(variables.resolve(hostname), variables.resolve(port), variables.resolve(databaseName));
        String url = variables.resolve(baseUrl);
        if (this.iDatabase.isSupportsOptionsInURL()) {
            url = this.appendExtraOptions(variables, url, this.getExtraOptions());
        }
        return url;
    }

    protected String appendExtraOptions(IVariables variables, String url, Map<String, String> extraOptions) {
        if (extraOptions.isEmpty()) {
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url);
        String optionIndicator = this.getExtraOptionIndicator();
        String optionSeparator = this.getExtraOptionSeparator();
        String valueSeparator = this.getExtraOptionValueSeparator();
        Iterator<String> iterator = extraOptions.keySet().iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            String value;
            String typedParameter = iterator.next();
            int dotIndex = typedParameter.indexOf(46);
            if (dotIndex == -1 || Utils.isEmpty(value = extraOptions.get(typedParameter)) || value.equals(EMPTY_OPTIONS_STRING)) continue;
            String typeCode = typedParameter.substring(0, dotIndex);
            String parameter = typedParameter.substring(dotIndex + 1);
            boolean dbForBothDbInterfacesIsSame = false;
            try {
                IDatabase primaryDb = this.getDbInterface(typeCode);
                dbForBothDbInterfacesIsSame = this.databaseForBothDbInterfacesIsTheSame(primaryDb, this.getIDatabase());
            }
            catch (HopDatabaseException e) {
                this.getGeneralLogger().logError("IDatabase with " + typeCode + " database type is not found! Parameter " + parameter + "won't be appended to URL");
            }
            if (!dbForBothDbInterfacesIsSame) continue;
            if (first && url.indexOf(valueSeparator) == -1) {
                urlBuilder.append(optionIndicator);
            } else {
                urlBuilder.append(optionSeparator);
            }
            urlBuilder.append(variables.resolve(parameter)).append(valueSeparator).append(variables.resolve(value));
            first = false;
        }
        return urlBuilder.toString();
    }

    protected boolean databaseForBothDbInterfacesIsTheSame(IDatabase primary, IDatabase secondary) {
        if (primary == null || secondary == null) {
            throw new IllegalArgumentException("IDatabase shouldn't be null!");
        }
        if (primary.getPluginId() == null || secondary.getPluginId() == null) {
            return false;
        }
        if (primary.getPluginId().equals(secondary.getPluginId())) {
            return true;
        }
        return primary.getClass().isAssignableFrom(secondary.getClass());
    }

    public Properties getConnectionProperties(IVariables variables) {
        Properties properties = new Properties();
        Map<String, String> map = this.getExtraOptionsMap();
        for (String option : map.keySet()) {
            String value = map.get(option);
            properties.put(variables.resolve(option), variables.resolve(Const.NVL(value, "")));
        }
        return properties;
    }

    public String getExtraOptionIndicator() {
        return this.getIDatabase().getExtraOptionIndicator();
    }

    public String getExtraOptionSeparator() {
        return this.getIDatabase().getExtraOptionSeparator();
    }

    public String getExtraOptionValueSeparator() {
        return this.getIDatabase().getExtraOptionValueSeparator();
    }

    public Map<String, String> getExtraOptionsMap() {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        Map<String, String> map = this.getExtraOptions();
        if (map.size() > 0) {
            for (String typedParameter : map.keySet()) {
                int dotIndex = typedParameter.indexOf(46);
                if (dotIndex < 0) continue;
                String typeCode = typedParameter.substring(0, dotIndex);
                String parameter = typedParameter.substring(dotIndex + 1);
                String value = map.get(typedParameter);
                if (!this.iDatabase.getPluginId().equals(typeCode)) continue;
                if (value != null && value.equals(EMPTY_OPTIONS_STRING)) {
                    value = "";
                }
                optionsMap.put(parameter, value);
            }
        }
        return optionsMap;
    }

    public void addExtraOption(String databaseTypeCode, String option, String value) {
        this.iDatabase.addExtraOption(databaseTypeCode, option, value);
    }

    public void applyDefaultOptions(IDatabase iDatabase) {
        Map<String, String> extraOptions = this.getExtraOptions();
        Map<String, String> defaultOptions = iDatabase.getDefaultOptions();
        for (String option : defaultOptions.keySet()) {
            String value = defaultOptions.get(option);
            String[] split = option.split("[.]", 2);
            if (extraOptions.containsKey(option) || split.length != 2) continue;
            this.addExtraOption(split[0], split[1], value);
        }
    }

    public boolean supportsAutoinc() {
        return this.iDatabase.isSupportsAutoInc();
    }

    public boolean supportsSequences() {
        return this.iDatabase.isSupportsSequences();
    }

    public String getSqlSequenceExists(String sequenceName) {
        return this.iDatabase.getSqlSequenceExists(sequenceName);
    }

    public boolean supportsBitmapIndex() {
        return this.iDatabase.isSupportsBitmapIndex();
    }

    public boolean supportsSetLong() {
        return this.iDatabase.isSupportsSetLong();
    }

    public boolean supportsSchemas() {
        return this.iDatabase.isSupportsSchemas();
    }

    public boolean supportsCatalogs() {
        return this.iDatabase.isSupportsCatalogs();
    }

    public boolean supportsEmptyTransactions() {
        return this.iDatabase.isSupportsEmptyTransactions();
    }

    public boolean supportsSetCharacterStream() {
        return this.iDatabase.isSupportsSetCharacterStream();
    }

    public int getMaxTextFieldLength() {
        return this.iDatabase.getMaxTextFieldLength();
    }

    public static final int getAccessType(String dbaccess) {
        int i;
        if (dbaccess == null) {
            return 0;
        }
        for (i = 0; i < dbAccessTypeCode.length; ++i) {
            if (!dbAccessTypeCode[i].equalsIgnoreCase(dbaccess)) continue;
            return i;
        }
        for (i = 0; i < dbAccessTypeDesc.length; ++i) {
            if (!dbAccessTypeDesc[i].equalsIgnoreCase(dbaccess)) continue;
            return i;
        }
        return 0;
    }

    public static final String getAccessTypeDesc(int dbaccess) {
        if (dbaccess < 0) {
            return null;
        }
        if (dbaccess > dbAccessTypeCode.length) {
            return null;
        }
        return dbAccessTypeCode[dbaccess];
    }

    public static final String getAccessTypeDescLong(int dbaccess) {
        if (dbaccess < 0) {
            return null;
        }
        if (dbaccess > dbAccessTypeDesc.length) {
            return null;
        }
        return dbAccessTypeDesc[dbaccess];
    }

    public static final IDatabase[] getDatabaseInterfaces() {
        ArrayList<IDatabase> list = new ArrayList<IDatabase>(DatabaseMeta.getIDatabaseMap().values());
        return list.toArray(new IDatabase[list.size()]);
    }

    public static final void clearDatabaseInterfacesMap() {
        allDatabaseInterfaces = null;
    }

    private static final Future<Map<String, IDatabase>> createDatabaseInterfacesMap() {
        return ExecutorUtil.getExecutor().submit(new Callable<Map<String, IDatabase>>(){

            private Map<String, IDatabase> doCreate() {
                ILogChannel log = LogChannel.GENERAL;
                PluginRegistry registry = PluginRegistry.getInstance();
                List plugins = registry.getPlugins(DatabasePluginType.class);
                HashMap<String, IDatabase> tmpAllDatabaseInterfaces = new HashMap<String, IDatabase>();
                for (IPlugin plugin : plugins) {
                    try {
                        IDatabase iDatabase = (IDatabase)registry.loadClass(plugin);
                        iDatabase.setPluginId(plugin.getIds()[0]);
                        iDatabase.setPluginName(plugin.getName());
                        tmpAllDatabaseInterfaces.put(plugin.getIds()[0], iDatabase);
                    }
                    catch (HopPluginException cnfe) {
                        log.logError("Could not create connection entry for " + plugin.getName() + ".  " + cnfe.getCause().getClass().getName());
                        if (!log.isDebug()) continue;
                        log.logDebug("Debug-Error loading plugin: " + String.valueOf(plugin), cnfe);
                    }
                    catch (Exception e) {
                        log.logError("Error loading plugin: " + String.valueOf(plugin), e);
                    }
                }
                return Collections.unmodifiableMap(tmpAllDatabaseInterfaces);
            }

            @Override
            public Map<String, IDatabase> call() throws Exception {
                return this.doCreate();
            }
        });
    }

    public static final Map<String, IDatabase> getIDatabaseMap() {
        Future<Map<String, IDatabase>> allDatabaseInterfaces = DatabaseMeta.allDatabaseInterfaces;
        while (allDatabaseInterfaces == null) {
            allDatabaseInterfaces = DatabaseMeta.allDatabaseInterfaces = DatabaseMeta.createDatabaseInterfacesMap();
        }
        try {
            return allDatabaseInterfaces.get();
        }
        catch (Exception e) {
            DatabaseMeta.clearDatabaseInterfacesMap();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static final int[] getAccessTypeList(String dbTypeDesc) {
        try {
            IDatabase di = DatabaseMeta.findIDatabase(dbTypeDesc);
            return di.getAccessTypeList();
        }
        catch (HopDatabaseException kde) {
            return null;
        }
    }

    public static final int getPortForDBType(String strtype, String straccess) {
        try {
            IDatabase di = DatabaseMeta.getIDatabase(strtype);
            di.setAccessType(DatabaseMeta.getAccessType(straccess));
            return di.getDefaultDatabasePort();
        }
        catch (HopDatabaseException kde) {
            return -1;
        }
    }

    public int getDefaultDatabasePort() {
        return this.iDatabase.getDefaultDatabasePort();
    }

    public int getNotFoundTK(boolean useAutoIncrement) {
        return this.iDatabase.getNotFoundTK(useAutoIncrement);
    }

    public String getDriverClass(IVariables variables) {
        return variables.resolve(this.iDatabase.getDriverClass());
    }

    public String stripCR(String sbsql) {
        if (sbsql == null) {
            return null;
        }
        return this.stripCR(new StringBuilder(sbsql));
    }

    public String stripCR(StringBuffer sbsql) {
        if (!this.supportsNewLinesInSql()) {
            for (int i = sbsql.length() - 1; i >= 0; --i) {
                if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
                sbsql.setCharAt(i, ' ');
            }
        }
        return sbsql.toString();
    }

    public String stripCR(StringBuilder sbsql) {
        if (!this.supportsNewLinesInSql()) {
            for (int i = sbsql.length() - 1; i >= 0; --i) {
                if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
                sbsql.setCharAt(i, ' ');
            }
        }
        return sbsql.toString();
    }

    public String getSeqNextvalSql(String sequenceName) {
        return this.iDatabase.getSqlNextSequenceValue(sequenceName);
    }

    public String getSqlCurrentSequenceValue(String sequenceName) {
        return this.iDatabase.getSqlCurrentSequenceValue(sequenceName);
    }

    public boolean isFetchSizeSupported() {
        return this.iDatabase.isFetchSizeSupported();
    }

    public boolean needsPlaceHolder() {
        return this.iDatabase.isNeedsPlaceHolder();
    }

    public String getFunctionSum() {
        return this.iDatabase.getFunctionSum();
    }

    public String getFunctionAverage() {
        return this.iDatabase.getFunctionAverage();
    }

    public String getFunctionMaximum() {
        return this.iDatabase.getFunctionMaximum();
    }

    public String getFunctionMinimum() {
        return this.iDatabase.getFunctionMinimum();
    }

    public String getFunctionCount() {
        return this.iDatabase.getFunctionCount();
    }

    public String[] checkParameters() {
        ArrayList<String> remarks = new ArrayList<String>();
        if (this.getIDatabase() == null) {
            remarks.add(BaseMessages.getString(PKG, "DatabaseMeta.BadInterface", new String[0]));
        }
        if (this.getName() == null || this.getName().length() == 0) {
            remarks.add(BaseMessages.getString(PKG, "DatabaseMeta.BadConnectionName", new String[0]));
        }
        if (this.getIDatabase().isRequiresName() && (this.getDatabaseName() == null || this.getDatabaseName().length() == 0)) {
            remarks.add(BaseMessages.getString(PKG, "DatabaseMeta.BadDatabaseName", new String[0]));
        }
        return remarks.toArray(new String[remarks.size()]);
    }

    public String getQuotedSchemaTableCombination(IVariables variables, String schemaName, String tableName) {
        if (Utils.isEmpty(schemaName)) {
            if (Utils.isEmpty(this.getPreferredSchemaName())) {
                return this.quoteField(variables.resolve(tableName));
            }
            return this.iDatabase.getSchemaTableCombination(this.quoteField(variables.resolve(this.getPreferredSchemaName())), this.quoteField(variables.resolve(tableName)));
        }
        return this.iDatabase.getSchemaTableCombination(this.quoteField(variables.resolve(schemaName)), this.quoteField(variables.resolve(tableName)));
    }

    public boolean isClob(IValueMeta v) {
        boolean retval = true;
        if (v != null && v.getLength() >= 9999999) {
            return true;
        }
        retval = false;
        return retval;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoIncrement) {
        return this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, true);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoIncrement, boolean addFieldname, boolean addCr) {
        String definition = v.getDatabaseColumnTypeDefinition(this.iDatabase, tk, pk, useAutoIncrement, addFieldname, addCr);
        if (!Utils.isEmpty(definition)) {
            return definition;
        }
        return this.iDatabase.getFieldDefinition(v, tk, pk, useAutoIncrement, addFieldname, addCr);
    }

    public String getLimitClause(int nrRows) {
        return this.iDatabase.getLimitClause(nrRows);
    }

    public String getSqlQueryFields(String tableName) {
        return this.iDatabase.getSqlQueryFields(tableName);
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        Object retval = this.iDatabase.getAddColumnStatement(tableName, v, tk, useAutoIncrement, pk, semicolon);
        retval = (String)retval + Const.CR;
        if (semicolon) {
            retval = (String)retval + ";" + Const.CR;
        }
        return retval;
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        Object retval = this.iDatabase.getDropColumnStatement(tableName, v, tk, useAutoIncrement, pk, semicolon);
        retval = (String)retval + Const.CR;
        if (semicolon) {
            retval = (String)retval + ";" + Const.CR;
        }
        return retval;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        Object retval = this.iDatabase.getModifyColumnStatement(tableName, v, tk, useAutoIncrement, pk, semicolon);
        retval = (String)retval + Const.CR;
        if (semicolon) {
            retval = (String)retval + ";" + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return this.iDatabase.getReservedWords();
    }

    public boolean quoteReservedWords() {
        return this.iDatabase.isQuoteReservedWords();
    }

    public String getStartQuote() {
        return this.iDatabase.getStartQuote();
    }

    public String getEndQuote() {
        return this.iDatabase.getEndQuote();
    }

    public String quoteField(String field) {
        if (Utils.isEmpty(field)) {
            return null;
        }
        if (this.isForcingIdentifiersToLowerCase()) {
            field = field.toLowerCase();
        } else if (this.isForcingIdentifiersToUpperCase()) {
            field = field.toUpperCase();
        }
        if (field.indexOf(this.getStartQuote()) >= 0 || field.indexOf(this.getEndQuote()) >= 0) {
            return field;
        }
        if (this.isReservedWord(field) && this.quoteReservedWords()) {
            return this.handleCase(this.getStartQuote() + field + this.getEndQuote());
        }
        if (this.iDatabase.isQuoteAllFields() || this.hasSpacesInField(field) || this.hasSpecialCharInField(field) || this.hasDotInField(field)) {
            return this.getStartQuote() + field + this.getEndQuote();
        }
        return field;
    }

    private String handleCase(String field) {
        if (this.preserveReservedCase()) {
            return field;
        }
        if (this.iDatabase.isDefaultingToUppercase()) {
            return field.toUpperCase();
        }
        return field.toLowerCase();
    }

    public boolean isInNeedOfQuoting(String fieldname) {
        return this.isReservedWord(fieldname) || this.hasSpacesInField(fieldname);
    }

    public boolean isReservedWord(String word) {
        String[] reserved = this.getReservedWords();
        return Const.indexOfString(word, reserved) >= 0;
    }

    public boolean hasSpacesInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        return fieldname.indexOf(32) >= 0;
    }

    public boolean hasSpecialCharInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        if (fieldname.indexOf(47) >= 0) {
            return true;
        }
        if (fieldname.indexOf(45) >= 0) {
            return true;
        }
        if (fieldname.indexOf(43) >= 0) {
            return true;
        }
        if (fieldname.indexOf(44) >= 0) {
            return true;
        }
        if (fieldname.indexOf(42) >= 0) {
            return true;
        }
        if (fieldname.indexOf(40) >= 0) {
            return true;
        }
        if (fieldname.indexOf(41) >= 0) {
            return true;
        }
        if (fieldname.indexOf(123) >= 0) {
            return true;
        }
        if (fieldname.indexOf(125) >= 0) {
            return true;
        }
        if (fieldname.indexOf(91) >= 0) {
            return true;
        }
        if (fieldname.indexOf(93) >= 0) {
            return true;
        }
        if (fieldname.indexOf(37) >= 0) {
            return true;
        }
        if (fieldname.indexOf(64) >= 0) {
            return true;
        }
        return fieldname.indexOf(63) >= 0;
    }

    public boolean hasDotInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        return fieldname.indexOf(46) >= 0;
    }

    public boolean replaceReservedWords(IRowMeta fields) {
        boolean hasReservedWords = false;
        for (int i = 0; i < fields.size(); ++i) {
            IValueMeta v = fields.getValueMeta(i);
            if (!this.isReservedWord(v.getName())) continue;
            hasReservedWords = true;
            v.setName(this.quoteField(v.getName()));
        }
        return hasReservedWords;
    }

    public int getNrReservedWords(IRowMeta fields) {
        int nrReservedWords = 0;
        for (int i = 0; i < fields.size(); ++i) {
            IValueMeta v = fields.getValueMeta(i);
            if (!this.isReservedWord(v.getName())) continue;
            ++nrReservedWords;
        }
        return nrReservedWords;
    }

    public String[] getTableTypes() {
        return this.iDatabase.getTableTypes();
    }

    public String[] getViewTypes() {
        return this.iDatabase.getViewTypes();
    }

    public String[] getSynonymTypes() {
        return this.iDatabase.getSynonymTypes();
    }

    public boolean useSchemaNameForTableList() {
        return this.iDatabase.useSchemaNameForTableList();
    }

    public boolean supportsViews() {
        return this.iDatabase.isSupportsViews();
    }

    public boolean supportsSynonyms() {
        return this.iDatabase.isSupportsSynonyms();
    }

    public String getSqlListOfProcedures() {
        return this.iDatabase.getSqlListOfProcedures();
    }

    public String getTruncateTableStatement(IVariables variables, String schema, String tableName) {
        return this.iDatabase.getTruncateTableStatement(this.getQuotedSchemaTableCombination(variables, schema, tableName));
    }

    public boolean supportsFloatRoundingOnUpdate() {
        return this.iDatabase.isSupportsFloatRoundingOnUpdate();
    }

    public String getSqlLockTables(String[] tableNames) {
        return this.iDatabase.getSqlLockTables(tableNames);
    }

    public String getSqlUnlockTables(String[] tableNames) {
        return this.iDatabase.getSqlUnlockTables(tableNames);
    }

    public List<RowMetaAndData> getFeatureSummary(IVariables variables) {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaAndData r = null;
        String par = "Parameter";
        String val = "Value";
        ValueMetaString testValue = new ValueMetaString("FIELD");
        testValue.setLength(30);
        if (this.iDatabase != null) {
            int i;
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Database type");
            r.addValue("Value", 2, this.getPluginId());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Access type");
            r.addValue("Value", 2, this.getAccessTypeDesc());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Database name");
            r.addValue("Value", 2, this.getDatabaseName());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Server hostname");
            r.addValue("Value", 2, this.getHostname());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Service port");
            r.addValue("Value", 2, this.getPort());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Username");
            r.addValue("Value", 2, this.getUsername());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Informix server name");
            r.addValue("Value", 2, this.getServername());
            list.add(r);
            for (String key : this.getAttributes().keySet()) {
                String value = this.getAttributes().get(key);
                r = new RowMetaAndData();
                r.addValue("Parameter", 2, "Extra attribute [" + key + "]");
                r.addValue("Value", 2, value);
                list.add(r);
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Driver class");
            r.addValue("Value", 2, this.getDriverClass(variables));
            list.add(r);
            String pwd = this.getPassword();
            this.setPassword("password");
            String url = "";
            try {
                url = this.getURL(variables);
            }
            catch (Exception e) {
                url = "";
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "URL");
            r.addValue("Value", 2, url);
            list.add(r);
            this.setPassword(pwd);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "SQL: next sequence value");
            r.addValue("Value", 2, this.getSeqNextvalSql("SEQUENCE"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supported: set fetch size");
            r.addValue("Value", 2, this.isFetchSizeSupported() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "auto increment field needs placeholder");
            r.addValue("Value", 2, this.needsPlaceHolder() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "SUM aggregate function");
            r.addValue("Value", 2, this.getFunctionSum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "AVG aggregate function");
            r.addValue("Value", 2, this.getFunctionAverage());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "MIN aggregate function");
            r.addValue("Value", 2, this.getFunctionMinimum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "MAX aggregate function");
            r.addValue("Value", 2, this.getFunctionMaximum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "COUNT aggregate function");
            r.addValue("Value", 2, this.getFunctionCount());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Schema / Table combination");
            r.addValue("Value", 2, this.getQuotedSchemaTableCombination(variables, "SCHEMA", "TABLE"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "LIMIT clause for 100 rows");
            r.addValue("Value", 2, this.getLimitClause(100));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Add column statement");
            r.addValue("Value", 2, this.getAddColumnStatement("TABLE", testValue, null, false, null, false));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Drop column statement");
            r.addValue("Value", 2, this.getDropColumnStatement("TABLE", testValue, null, false, null, false));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Modify column statement");
            r.addValue("Value", 2, this.getModifyColumnStatement("TABLE", testValue, null, false, null, false));
            list.add(r);
            Object reserved = "";
            if (this.getReservedWords() != null) {
                for (int i2 = 0; i2 < this.getReservedWords().length; ++i2) {
                    reserved = (String)reserved + (i2 > 0 ? ", " : "") + this.getReservedWords()[i2];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "List of reserved words");
            r.addValue("Value", 2, reserved);
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Quote reserved words?");
            r.addValue("Value", 2, this.quoteReservedWords() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Start quote for reserved words");
            r.addValue("Value", 2, this.getStartQuote());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "End quote for reserved words");
            r.addValue("Value", 2, this.getEndQuote());
            list.add(r);
            Object types = "";
            String[] slist = this.getTableTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = (String)types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "List of JDBC table types");
            r.addValue("Value", 2, types);
            list.add(r);
            types = "";
            slist = this.getViewTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = (String)types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "List of JDBC view types");
            r.addValue("Value", 2, types);
            list.add(r);
            types = "";
            slist = this.getSynonymTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = (String)types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "List of JDBC synonym types");
            r.addValue("Value", 2, types);
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "use schema name to get table list?");
            r.addValue("Value", 2, this.useSchemaNameForTableList() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports views?");
            r.addValue("Value", 2, this.supportsViews() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports synonyms?");
            r.addValue("Value", 2, this.supportsSynonyms() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "SQL: list of procedures");
            r.addValue("Value", 2, this.getSqlListOfProcedures());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "SQL: truncate table");
            String truncateStatement = this.getTruncateTableStatement(variables, "SCHEMA", "TABLE");
            r.addValue("Value", 2, truncateStatement != null ? truncateStatement : "Not supported by this database type");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports floating point rounding on update/insert");
            r.addValue("Value", 2, this.supportsFloatRoundingOnUpdate() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports timestamp-date conversion");
            r.addValue("Value", 2, this.supportsTimeStampToDateConversion() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports batch updates");
            r.addValue("Value", 2, this.supportsBatchUpdates() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports boolean data type");
            r.addValue("Value", 2, this.supportsBooleanDataType() ? "Y" : "N");
            list.add(r);
        }
        return list;
    }

    public boolean supportsTimeStampToDateConversion() {
        return this.iDatabase.isSupportsTimeStampToDateConversion();
    }

    public boolean supportsBatchUpdates() {
        return this.iDatabase.isSupportsBatchUpdates();
    }

    public boolean supportsBooleanDataType() {
        return this.iDatabase.isSupportsBooleanDataType();
    }

    public void setSupportsBooleanDataType(boolean b) {
        this.iDatabase.setSupportsBooleanDataType(b);
    }

    public boolean supportsTimestampDataType() {
        return this.iDatabase.isSupportsTimestampDataType();
    }

    public void setSupportsTimestampDataType(boolean b) {
        this.iDatabase.setSupportsTimestampDataType(b);
    }

    public boolean preserveReservedCase() {
        return this.iDatabase.isPreserveReservedCase();
    }

    public void setPreserveReservedCase(boolean b) {
        this.iDatabase.setPreserveReservedCase(b);
    }

    public void quoteReservedWords(IRowMeta fields) {
        for (int i = 0; i < fields.size(); ++i) {
            IValueMeta v = fields.getValueMeta(i);
            v.setName(this.quoteField(v.getName()));
        }
    }

    public Map<String, String> getExtraOptions() {
        return this.iDatabase.getExtraOptions();
    }

    public boolean supportsOptionsInURL() {
        return this.iDatabase.isSupportsOptionsInURL();
    }

    public String getExtraOptionsHelpText() {
        return this.iDatabase.getExtraOptionsHelpText();
    }

    public boolean supportsGetBlob() {
        return this.iDatabase.isSupportsGetBlob();
    }

    public String getConnectSql() {
        return this.iDatabase.getConnectSql();
    }

    public void setConnectSql(String sql) {
        this.iDatabase.setConnectSql(sql);
    }

    public boolean supportsSetMaxRows() {
        return this.iDatabase.isSupportsSetMaxRows();
    }

    public String verifyAndModifyDatabaseName(List<DatabaseMeta> databases, String oldname) {
        String name = this.getName();
        if (name.equalsIgnoreCase(oldname)) {
            return name;
        }
        int nr = 2;
        while (DatabaseMeta.findDatabase(databases, this.getName()) != null) {
            this.setName(name + " " + nr);
            ++nr;
        }
        return this.getName();
    }

    public String getSqlTableExists(String tableName) {
        return this.iDatabase.getSqlTableExists(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.iDatabase.getSqlColumnExists(columnname, tableName);
    }

    public String getSqlDeleteStmt(String tableName) {
        return this.iDatabase.getSqlDeleteStmt(tableName);
    }

    public String getSqlUpdateStmt(String tableName) {
        return this.iDatabase.getSqlUpdateStmt(tableName);
    }

    public boolean isSupportsCustomDeleteStmt() {
        return this.iDatabase.isSupportsCustomDeleteStmt();
    }

    public boolean isSupportsCustomUpdateStmt() {
        return this.iDatabase.isSupportsCustomUpdateStmt();
    }

    public boolean isStreamingResults() {
        return this.iDatabase.isStreamingResults();
    }

    public void setStreamingResults(boolean useStreaming) {
        this.iDatabase.setStreamingResults(useStreaming);
    }

    public boolean isQuoteAllFields() {
        return this.iDatabase.isQuoteAllFields();
    }

    public void setQuoteAllFields(boolean quoteAllFields) {
        this.iDatabase.setQuoteAllFields(quoteAllFields);
    }

    public boolean isForcingIdentifiersToLowerCase() {
        return this.iDatabase.isForcingIdentifiersToLowerCase();
    }

    public void setForcingIdentifiersToLowerCase(boolean forceLowerCase) {
        this.iDatabase.setForcingIdentifiersToLowerCase(forceLowerCase);
    }

    public boolean isForcingIdentifiersToUpperCase() {
        return this.iDatabase.isForcingIdentifiersToUpperCase();
    }

    public void setForcingIdentifiersToUpperCase(boolean forceUpperCase) {
        this.iDatabase.setForcingIdentifiersToUpperCase(forceUpperCase);
    }

    public static final DatabaseMeta findDatabase(List<DatabaseMeta> databases, String dbname) {
        if (databases == null || dbname == null) {
            return null;
        }
        for (int i = 0; i < databases.size(); ++i) {
            DatabaseMeta ci = databases.get(i);
            if (!ci.getName().trim().equalsIgnoreCase(dbname.trim())) continue;
            return ci;
        }
        return null;
    }

    public static int indexOfName(String[] databaseNames, String name) {
        if (databaseNames == null || name == null) {
            return -1;
        }
        for (int i = 0; i < databaseNames.length; ++i) {
            String databaseName = databaseNames[i];
            if (!name.equalsIgnoreCase(databaseName)) continue;
            return i;
        }
        return -1;
    }

    public String getSqlServerInstance() {
        return this.getExtraOptions().get(this.getPluginId() + ".instance");
    }

    public void setSqlServerInstance(String instanceName) {
        if (instanceName != null && instanceName.length() > 0) {
            this.addExtraOption(this.getPluginId(), "instance", instanceName);
        }
    }

    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        return this.iDatabase.isUsingDoubleDecimalAsSchemaTableSeparator();
    }

    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean useDoubleDecimalSeparator) {
        this.iDatabase.setUsingDoubleDecimalAsSchemaTableSeparator(useDoubleDecimalSeparator);
    }

    public boolean isRequiringTransactionsOnQueries() {
        return this.iDatabase.isRequiringTransactionsOnQueries();
    }

    public String testConnection(IVariables variables) {
        StringBuilder report = new StringBuilder();
        try {
            IDatabaseFactory factory = this.getDatabaseFactory();
            return factory.getConnectionTestReport(variables, this);
        }
        catch (ClassNotFoundException e) {
            report.append(BaseMessages.getString(PKG, "BaseDatabaseMeta.TestConnectionReportNotImplemented.Message", new String[0])).append(Const.CR);
            report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionError", this.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker(e) + Const.CR);
        }
        catch (Exception e) {
            report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionError", this.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker(e) + Const.CR);
        }
        return report.toString();
    }

    public DatabaseTestResults testConnectionSuccess(IVariables variables) {
        StringBuilder report = new StringBuilder();
        DatabaseTestResults databaseTestResults = new DatabaseTestResults();
        try {
            IDatabaseFactory factory = this.getDatabaseFactory();
            databaseTestResults = factory.getConnectionTestResults(variables, this);
        }
        catch (ClassNotFoundException e) {
            report.append(BaseMessages.getString(PKG, "BaseDatabaseMeta.TestConnectionReportNotImplemented.Message", new String[0])).append(Const.CR);
            report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionError", this.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker(e) + Const.CR);
            databaseTestResults.setMessage(report.toString());
            databaseTestResults.setSuccess(false);
        }
        catch (Exception e) {
            report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionError", this.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker(e) + Const.CR);
            databaseTestResults.setMessage(report.toString());
            databaseTestResults.setSuccess(false);
        }
        return databaseTestResults;
    }

    public IDatabaseFactory getDatabaseFactory() throws Exception {
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.getPlugin(DatabasePluginType.class, this.iDatabase.getPluginId());
        if (plugin == null) {
            throw new HopDatabaseException("database type with plugin id [" + this.iDatabase.getPluginId() + "] couldn't be found!");
        }
        ClassLoader loader = registry.getClassLoader(plugin);
        Class<?> clazz = Class.forName(this.iDatabase.getDatabaseFactoryName(), true, loader);
        return (IDatabaseFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public String getPreferredSchemaName() {
        return this.iDatabase.getPreferredSchemaName();
    }

    public void setPreferredSchemaName(String preferredSchemaName) {
        this.iDatabase.setPreferredSchemaName(preferredSchemaName);
    }

    public boolean supportsSequenceNoMaxValueOption() {
        return this.iDatabase.isSupportsSequenceNoMaxValueOption();
    }

    public boolean requiresCreateTablePrimaryKeyAppend() {
        return this.iDatabase.isRequiresCreateTablePrimaryKeyAppend();
    }

    public boolean requiresCastToVariousForIsNull() {
        return this.iDatabase.isRequiresCastToVariousForIsNull();
    }

    public boolean isDisplaySizeTwiceThePrecision() {
        return this.iDatabase.isDisplaySizeTwiceThePrecision();
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return this.iDatabase.isSupportsPreparedStatementMetadataRetrieval();
    }

    public boolean isSystemTable(String tableName) {
        return this.iDatabase.isSystemTable(tableName);
    }

    private boolean supportsNewLinesInSql() {
        return this.iDatabase.isSupportsNewLinesInSql();
    }

    public String getSqlListOfSchemas() {
        return this.iDatabase.getSqlListOfSchemas();
    }

    public int getMaxColumnsInIndex() {
        return this.iDatabase.getMaxColumnsInIndex();
    }

    public boolean supportsErrorHandlingOnBatchUpdates() {
        return this.iDatabase.IsSupportsErrorHandlingOnBatchUpdates();
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return this.iDatabase.getSqlInsertAutoIncUnknownDimensionRow(schemaTable, keyField, versionField);
    }

    public boolean isExplorable() {
        return this.iDatabase.isExplorable();
    }

    public String getSqlListOfSequences() {
        return this.iDatabase.getSqlListOfSequences();
    }

    public String quoteSqlString(String string) {
        return this.iDatabase.quoteSqlString(string);
    }

    public String generateColumnAlias(int columnIndex, String suggestedName) {
        return this.iDatabase.generateColumnAlias(columnIndex, suggestedName);
    }

    public boolean isMySqlVariant() {
        return this.iDatabase.isMySqlVariant();
    }

    public Object getValueFromResultSet(ResultSet rs, IValueMeta val, int i) throws HopDatabaseException {
        return this.iDatabase.getValueFromResultSet(rs, val, i);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getSequenceNoMaxValueOption() {
        return this.iDatabase.getSequenceNoMaxValueOption();
    }

    public boolean supportsAutoGeneratedKeys() {
        return this.iDatabase.isSupportsAutoGeneratedKeys();
    }

    public String getCreateTableStatement() {
        return this.iDatabase.getCreateTableStatement();
    }

    public String getDropTableIfExistsStatement(String tableName) {
        return this.iDatabase.getDropTableIfExistsStatement(tableName);
    }

    protected ILogChannel getGeneralLogger() {
        return LogChannel.GENERAL;
    }

    protected IDatabase getDbInterface(String typeCode) throws HopDatabaseException {
        return DatabaseMeta.getIDatabase(typeCode);
    }

    static {
        DatabaseMeta.init();
        dbAccessTypeCode = new String[]{"Native"};
        dbAccessTypeDesc = new String[]{"Native (JDBC)"};
    }
}

