/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.imports.kettle;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.SingletonUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.imports.kettle.KettleImport;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.shared.AuditManagerGuiUtil;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class KettleImportDialog
extends Dialog {
    private static final Class<?> PKG = KettleImportDialog.class;
    public static final String LAST_USED_IMPORT_SOURCE_FOLDER = "ImportFolder";
    public static final String LAST_USED_IMPORT_INTO_PROJECT = "ImportInProject";
    public static final String LAST_USED_IMPORT_TARGET_PROJECT = "ImportProject";
    public static final String LAST_USED_IMPORT_TARGET_FOLDER = "ImportTarget";
    public static final String LAST_USED_IMPORT_PROPS_FILE = "ImportPropertiesFile";
    public static final String LAST_USED_IMPORT_SHARED_FILE = "ImportSharedFile";
    public static final String LAST_USED_IMPORT_JDBC_FILE = "ImportJdbcFile";
    public static final String LAST_USED_IMPORT_CONFIG_FILE = "ImportConfigFile";
    public static final String LAST_USED_IMPORT_SKIP_EXISTING = "ImportSkipExisting";
    public static final String LAST_USED_IMPORT_SKIP_HIDDEN = "ImportSkipHidden";
    public static final String LAST_USED_IMPORT_SKIP_FOLDERS = "ImportSkipFolders";
    public static final String LAST_USED_IMPORT_PIPELINE_RUN_CONFIGURATION = "ImportPipelineRunConfiguration";
    public static final String LAST_USED_IMPORT_WORKFLOW_RUN_CONFIGURATION = "ImportWorkflowRunConfiguration";
    private final IVariables variables;
    private Shell shell;
    private final PropsUi props = PropsUi.getInstance();
    private final KettleImport kettleImport;
    private final List<String> projectNames;
    private TextVar wImportFrom;
    private TextVar wImportPath;
    private TextVar wKettleProps;
    private TextVar wShared;
    private TextVar wJdbcProps;
    private TextVar wTargetConfigFile;
    private Combo wPipelineRunConfiguration;
    private Combo wWorkflowRunConfiguration;
    private Combo wImportProject;
    private Button wImportInExisting;
    private Button wbImportPath;
    private Button wSkipExisting;
    private Button wSkipHidden;
    private Button wSkipFolders;

    public KettleImportDialog(Shell parent, IVariables variables, KettleImport kettleImport) throws HopException {
        super(parent, 67696);
        this.variables = variables;
        this.kettleImport = kettleImport;
        try {
            this.projectNames = SingletonUtil.getValuesList((String)"org.apache.hop.projects.gui.ProjectsGuiPlugin", (String)"org.apache.hop.projects.config.ProjectsConfigSingleton", (String)"listProjectNames");
        }
        catch (HopException e) {
            throw new HopException("Error getting project names list", (Throwable)e);
        }
    }

    public void open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        PropsUi.setLook((Widget)this.shell);
        int margin = PropsUi.getMargin() + 2;
        int middle = this.props.getMiddlePct();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Shell.Name", (String[])new String[0]));
        Label wlImportFrom = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlImportFrom);
        wlImportFrom.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.ImportFrom", (String[])new String[0]));
        FormData fdlImportFrom = new FormData();
        fdlImportFrom.left = new FormAttachment(0, 0);
        fdlImportFrom.right = new FormAttachment(middle, 0);
        fdlImportFrom.top = new FormAttachment(0, margin);
        wlImportFrom.setLayoutData((Object)fdlImportFrom);
        Button wbImportFrom = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbImportFrom);
        wbImportFrom.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Button.Browse", (String[])new String[0]));
        FormData fdbImportFrom = new FormData();
        fdbImportFrom.right = new FormAttachment(100, 0);
        fdbImportFrom.top = new FormAttachment((Control)wlImportFrom, 0, 0x1000000);
        wbImportFrom.setLayoutData((Object)fdbImportFrom);
        wbImportFrom.addListener(13, this::browseHomeFolder);
        this.wImportFrom = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wImportFrom);
        FormData fdImportFrom = new FormData();
        fdImportFrom.left = new FormAttachment(middle, margin);
        fdImportFrom.right = new FormAttachment((Control)wbImportFrom, -margin);
        fdImportFrom.top = new FormAttachment((Control)wlImportFrom, 0, 0x1000000);
        this.wImportFrom.setLayoutData((Object)fdImportFrom);
        TextVar lastControl = this.wImportFrom;
        Label wlImportInExisting = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlImportInExisting);
        wlImportInExisting.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.ImportInExistingProject", (String[])new String[0]));
        FormData fdlImportInExisting = new FormData();
        fdlImportInExisting.left = new FormAttachment(0, 0);
        fdlImportInExisting.right = new FormAttachment(middle, 0);
        fdlImportInExisting.top = new FormAttachment((Control)lastControl, margin);
        wlImportInExisting.setLayoutData((Object)fdlImportInExisting);
        this.wImportInExisting = new Button((Composite)this.shell, 32);
        this.wImportInExisting.setSelection(true);
        PropsUi.setLook((Widget)this.wImportInExisting);
        FormData fdcbImportInExisting = new FormData();
        fdcbImportInExisting.left = new FormAttachment(middle, margin);
        fdcbImportInExisting.right = new FormAttachment(100, 0);
        fdcbImportInExisting.top = new FormAttachment((Control)wlImportInExisting, 0, 0x1000000);
        this.wImportInExisting.setLayoutData((Object)fdcbImportInExisting);
        this.wImportInExisting.setSelection(true);
        this.wImportInExisting.addListener(13, this::showHideProjectFields);
        lastControl = wlImportInExisting;
        Label wlImportProject = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlImportProject);
        wlImportProject.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.ImportInProject", (String[])new String[0]));
        FormData fdlImportProject = new FormData();
        fdlImportProject.left = new FormAttachment(0, 0);
        fdlImportProject.right = new FormAttachment(middle, 0);
        fdlImportProject.top = new FormAttachment((Control)lastControl, margin);
        wlImportProject.setLayoutData((Object)fdlImportProject);
        this.wImportProject = new Combo((Composite)this.shell, 8);
        this.wImportProject.setItems(this.projectNames.toArray(new String[this.projectNames.size()]));
        PropsUi.setLook((Widget)this.wImportProject);
        FormData fdImportProject = new FormData();
        fdImportProject.left = new FormAttachment(middle, margin);
        fdImportProject.right = new FormAttachment(100, 0);
        fdImportProject.top = new FormAttachment((Control)wlImportProject, 0, 0x1000000);
        this.wImportProject.setLayoutData((Object)fdImportProject);
        lastControl = wlImportProject;
        Label wlImportPath = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlImportPath);
        wlImportPath.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.ImportToFolder", (String[])new String[0]));
        FormData fdlImportPath = new FormData();
        fdlImportPath.left = new FormAttachment(0, 0);
        fdlImportPath.right = new FormAttachment(middle, 0);
        fdlImportPath.top = new FormAttachment((Control)lastControl, margin);
        wlImportPath.setLayoutData((Object)fdlImportPath);
        this.wbImportPath = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)this.wbImportPath);
        this.wbImportPath.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Button.Browse", (String[])new String[0]));
        FormData fdbImportPath = new FormData();
        fdbImportPath.right = new FormAttachment(100, 0);
        fdbImportPath.top = new FormAttachment((Control)wlImportPath, 0, 0x1000000);
        this.wbImportPath.setLayoutData((Object)fdbImportPath);
        this.wbImportPath.setEnabled(false);
        this.wbImportPath.addListener(13, this::browseTargetFolder);
        this.wImportPath = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wImportPath);
        FormData fdImportPath = new FormData();
        fdImportPath.left = new FormAttachment(middle, margin);
        fdImportPath.right = new FormAttachment((Control)this.wbImportPath, -margin);
        fdImportPath.top = new FormAttachment((Control)wlImportPath, 0, 0x1000000);
        this.wImportPath.setLayoutData((Object)fdImportPath);
        this.wImportPath.setEditable(false);
        lastControl = this.wImportPath;
        Label wlKettleProps = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlKettleProps);
        wlKettleProps.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.PathToKettleProperties", (String[])new String[0]));
        FormData fdlKettleProps = new FormData();
        fdlKettleProps.left = new FormAttachment(0, 0);
        fdlKettleProps.right = new FormAttachment(middle, 0);
        fdlKettleProps.top = new FormAttachment((Control)lastControl, margin);
        wlKettleProps.setLayoutData((Object)fdlKettleProps);
        Button wbKettleProps = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbKettleProps);
        wbKettleProps.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Button.Browse", (String[])new String[0]));
        FormData fdbKettleProps = new FormData();
        fdbKettleProps.right = new FormAttachment(100, 0);
        fdbKettleProps.top = new FormAttachment((Control)wlKettleProps, 0, 0x1000000);
        wbKettleProps.setLayoutData((Object)fdbKettleProps);
        wbKettleProps.addListener(13, this::browseKettlePropsFile);
        this.wKettleProps = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wKettleProps);
        FormData fdKettleProps = new FormData();
        fdKettleProps.left = new FormAttachment(middle, margin);
        fdKettleProps.right = new FormAttachment((Control)wbKettleProps, -margin);
        fdKettleProps.top = new FormAttachment((Control)wlKettleProps, 0, 0x1000000);
        this.wKettleProps.setLayoutData((Object)fdKettleProps);
        lastControl = this.wKettleProps;
        Label wlShared = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlShared);
        wlShared.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.PathToSharedXml", (String[])new String[0]));
        FormData fdlShared = new FormData();
        fdlShared.left = new FormAttachment(0, 0);
        fdlShared.right = new FormAttachment(middle, 0);
        fdlShared.top = new FormAttachment((Control)lastControl, margin);
        wlShared.setLayoutData((Object)fdlShared);
        Button wbShared = new Button((Composite)this.shell, 8);
        wbShared.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Button.Browse", (String[])new String[0]));
        FormData fdbShared = new FormData();
        fdbShared.right = new FormAttachment(100, 0);
        fdbShared.top = new FormAttachment((Control)wlShared, 0, 0x1000000);
        wbShared.setLayoutData((Object)fdbShared);
        wbShared.addListener(13, this::browseXmlFile);
        this.wShared = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wShared);
        FormData fdShared = new FormData();
        fdShared.left = new FormAttachment(middle, margin);
        fdShared.right = new FormAttachment((Control)wbShared, -margin);
        fdShared.top = new FormAttachment((Control)wlShared, 0, 0x1000000);
        this.wShared.setLayoutData((Object)fdShared);
        lastControl = this.wShared;
        Label wlJdbcProps = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlJdbcProps);
        wlJdbcProps.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.PathToJDBCProperties", (String[])new String[0]));
        FormData fdlJdbcProps = new FormData();
        fdlJdbcProps.left = new FormAttachment(0, 0);
        fdlJdbcProps.right = new FormAttachment(middle, 0);
        fdlJdbcProps.top = new FormAttachment((Control)lastControl, margin);
        wlJdbcProps.setLayoutData((Object)fdlJdbcProps);
        Button wbJdbcProps = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbJdbcProps);
        wbJdbcProps.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Button.Browse", (String[])new String[0]));
        FormData fdbJdbcProps = new FormData();
        fdbJdbcProps.right = new FormAttachment(100, 0);
        fdbJdbcProps.top = new FormAttachment((Control)wlJdbcProps, 0, 0x1000000);
        wbJdbcProps.setLayoutData((Object)fdbJdbcProps);
        wbJdbcProps.addListener(13, this::browseJdbcPropsFile);
        this.wJdbcProps = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wJdbcProps);
        FormData fdJdbcProps = new FormData();
        fdJdbcProps.left = new FormAttachment(middle, margin);
        fdJdbcProps.right = new FormAttachment((Control)wbJdbcProps, -margin);
        fdJdbcProps.top = new FormAttachment((Control)wlJdbcProps, 0, 0x1000000);
        this.wJdbcProps.setLayoutData((Object)fdJdbcProps);
        lastControl = this.wJdbcProps;
        Label wlSkipExisting = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlSkipExisting);
        wlSkipExisting.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.SkipExistingTargetFiles", (String[])new String[0]));
        FormData fdlSkipExisting = new FormData();
        fdlSkipExisting.left = new FormAttachment(0, 0);
        fdlSkipExisting.right = new FormAttachment(middle, 0);
        fdlSkipExisting.top = new FormAttachment((Control)lastControl, margin);
        wlSkipExisting.setLayoutData((Object)fdlSkipExisting);
        this.wSkipExisting = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSkipExisting);
        FormData fdSkipExisting = new FormData();
        fdSkipExisting.left = new FormAttachment(middle, margin);
        fdSkipExisting.right = new FormAttachment(100, 0);
        fdSkipExisting.top = new FormAttachment((Control)wlSkipExisting, 0, 0x1000000);
        this.wSkipExisting.setLayoutData((Object)fdSkipExisting);
        this.wSkipExisting.setSelection(true);
        lastControl = wlSkipExisting;
        Label wlSkipHidden = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlSkipHidden);
        wlSkipHidden.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.SkipHiddenFiles", (String[])new String[0]));
        FormData fdlSkipHidden = new FormData();
        fdlSkipHidden.left = new FormAttachment(0, 0);
        fdlSkipHidden.right = new FormAttachment(middle, 0);
        fdlSkipHidden.top = new FormAttachment((Control)lastControl, margin);
        wlSkipHidden.setLayoutData((Object)fdlSkipHidden);
        this.wSkipHidden = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSkipHidden);
        FormData fdSkipHidden = new FormData();
        fdSkipHidden.left = new FormAttachment(middle, margin);
        fdSkipHidden.right = new FormAttachment(100, 0);
        fdSkipHidden.top = new FormAttachment((Control)wlSkipHidden, 0, 0x1000000);
        this.wSkipHidden.setLayoutData((Object)fdSkipHidden);
        this.wSkipHidden.setSelection(true);
        lastControl = wlSkipHidden;
        Label wlSkipFolders = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlSkipFolders);
        wlSkipFolders.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.SkipFolders", (String[])new String[0]));
        FormData fdlSkipFolders = new FormData();
        fdlSkipFolders.left = new FormAttachment(0, 0);
        fdlSkipFolders.right = new FormAttachment(middle, 0);
        fdlSkipFolders.top = new FormAttachment((Control)lastControl, margin);
        wlSkipFolders.setLayoutData((Object)fdlSkipFolders);
        this.wSkipFolders = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSkipFolders);
        FormData fdSkipFolders = new FormData();
        fdSkipFolders.left = new FormAttachment(middle, margin);
        fdSkipFolders.right = new FormAttachment(100, 0);
        fdSkipFolders.top = new FormAttachment((Control)wlSkipFolders, 0, 0x1000000);
        this.wSkipFolders.setLayoutData((Object)fdSkipFolders);
        this.wSkipFolders.setSelection(true);
        this.wSkipFolders.addListener(13, this::showHideProjectFields);
        lastControl = wlSkipFolders;
        Label wlTargetConfigFile = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlTargetConfigFile);
        wlTargetConfigFile.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Label.TargetConfigFile", (String[])new String[0]));
        FormData fdlTargetConfigFile = new FormData();
        fdlTargetConfigFile.left = new FormAttachment(0, 0);
        fdlTargetConfigFile.right = new FormAttachment(middle, 0);
        fdlTargetConfigFile.top = new FormAttachment((Control)lastControl, margin);
        wlTargetConfigFile.setLayoutData((Object)fdlTargetConfigFile);
        this.wTargetConfigFile = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTargetConfigFile);
        FormData fdTargetConfigFile = new FormData();
        fdTargetConfigFile.left = new FormAttachment(middle, margin);
        fdTargetConfigFile.right = new FormAttachment(100, 0);
        fdTargetConfigFile.top = new FormAttachment((Control)wlTargetConfigFile, 0, 0x1000000);
        this.wTargetConfigFile.setLayoutData((Object)fdTargetConfigFile);
        this.wTargetConfigFile.setEditable(false);
        lastControl = this.wTargetConfigFile;
        Label wlPipelineRunConfiguration = new Label((Composite)this.shell, 131072);
        wlPipelineRunConfiguration.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Pipeline.RunConfiguration.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPipelineRunConfiguration);
        FormData fdlPipelineRunConfiguration = new FormData();
        fdlPipelineRunConfiguration.left = new FormAttachment(0, 0);
        fdlPipelineRunConfiguration.right = new FormAttachment(middle, 0);
        fdlPipelineRunConfiguration.top = new FormAttachment((Control)lastControl, margin);
        wlPipelineRunConfiguration.setLayoutData((Object)fdlPipelineRunConfiguration);
        this.wPipelineRunConfiguration = new Combo((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wlPipelineRunConfiguration);
        FormData fdPipelineRunConfiguration = new FormData();
        fdPipelineRunConfiguration.left = new FormAttachment(middle, margin);
        fdPipelineRunConfiguration.top = new FormAttachment((Control)wlPipelineRunConfiguration, 0, 0x1000000);
        fdPipelineRunConfiguration.right = new FormAttachment(100, 0);
        this.wPipelineRunConfiguration.setLayoutData((Object)fdPipelineRunConfiguration);
        PropsUi.setLook((Widget)this.wPipelineRunConfiguration);
        HopGui hopGui = HopGui.getInstance();
        MultiMetadataProvider metadataProvider = hopGui.getMetadataProvider();
        try {
            List runConfigurations = metadataProvider.getSerializer(PipelineRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "pipeline"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wPipelineRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting pipeline run configurations", (Throwable)e);
        }
        lastControl = this.wPipelineRunConfiguration;
        Label wlWorkflowRunConfiguration = new Label((Composite)this.shell, 131072);
        wlWorkflowRunConfiguration.setText(BaseMessages.getString(PKG, (String)"KettleImportDialog.Workflow.RunConfiguration.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWorkflowRunConfiguration);
        FormData fdlWorkflowRunConfiguration = new FormData();
        fdlWorkflowRunConfiguration.left = new FormAttachment(0, 0);
        fdlWorkflowRunConfiguration.right = new FormAttachment(middle, 0);
        fdlWorkflowRunConfiguration.top = new FormAttachment((Control)lastControl, margin);
        wlWorkflowRunConfiguration.setLayoutData((Object)fdlWorkflowRunConfiguration);
        this.wWorkflowRunConfiguration = new Combo((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wlWorkflowRunConfiguration);
        FormData fdWorkflowRunConfiguration = new FormData();
        fdWorkflowRunConfiguration.left = new FormAttachment(middle, margin);
        fdWorkflowRunConfiguration.top = new FormAttachment((Control)wlWorkflowRunConfiguration, 0, 0x1000000);
        fdWorkflowRunConfiguration.right = new FormAttachment(100, 0);
        this.wWorkflowRunConfiguration.setLayoutData((Object)fdWorkflowRunConfiguration);
        PropsUi.setLook((Widget)this.wWorkflowRunConfiguration);
        try {
            List runConfigurations = metadataProvider.getSerializer(WorkflowRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "pipeline"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wWorkflowRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting workflow run configurations", (Throwable)e);
        }
        lastControl = this.wWorkflowRunConfiguration;
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdLine = new FormData();
        fdLine.height = 5;
        fdLine.left = new FormAttachment(0, 0);
        fdLine.right = new FormAttachment(100, 0);
        fdLine.top = new FormAttachment((Control)lastControl, margin);
        separator.setLayoutData((Object)fdLine);
        lastControl = separator;
        Button wImport = new Button((Composite)this.shell, 8);
        wImport.setText("Import");
        wImport.addListener(13, event -> this.doImport());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, event -> this.dispose());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wImport, wCancel}, (int)margin, (Control)lastControl);
        this.wImportFrom.setText(Const.NVL((String)AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_SOURCE_FOLDER), (String)Const.NVL((String)this.kettleImport.getInputFolderName(), (String)"")));
        this.wImportInExisting.setSelection(!"false".equalsIgnoreCase(AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_INTO_PROJECT)));
        this.wImportProject.setText(Const.NVL((String)AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_TARGET_PROJECT), (String)""));
        this.wImportPath.setText(Const.NVL((String)AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_TARGET_FOLDER), (String)Const.NVL((String)this.kettleImport.getOutputFolderName(), (String)"")));
        this.wKettleProps.setText(Const.NVL((String)AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_PROPS_FILE), (String)Const.NVL((String)this.kettleImport.getKettlePropertiesFilename(), (String)"")));
        this.wShared.setText(Const.NVL((String)AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_SHARED_FILE), (String)Const.NVL((String)this.kettleImport.getSharedXmlFilename(), (String)"")));
        this.wJdbcProps.setText(Const.NVL((String)AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_JDBC_FILE), (String)Const.NVL((String)this.kettleImport.getJdbcPropertiesFilename(), (String)"")));
        this.wTargetConfigFile.setText(Const.NVL((String)AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_CONFIG_FILE), (String)Const.NVL((String)this.kettleImport.getTargetConfigFilename(), (String)"")));
        this.wSkipExisting.setSelection(!"false".equalsIgnoreCase(AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_SKIP_EXISTING)));
        this.wSkipHidden.setSelection(!"false".equalsIgnoreCase(AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_SKIP_HIDDEN)));
        this.wSkipFolders.setSelection(!"false".equalsIgnoreCase(AuditManagerGuiUtil.getLastUsedValue((String)LAST_USED_IMPORT_SKIP_FOLDERS)));
        this.wImportFrom.setFocus();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.dispose(), c -> this.dispose());
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_SOURCE_FOLDER, (String)this.wImportFrom.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_INTO_PROJECT, (String)(this.wImportInExisting.getSelection() ? "true" : "false"));
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_TARGET_PROJECT, (String)this.wImportProject.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_TARGET_FOLDER, (String)this.wImportPath.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_PROPS_FILE, (String)this.wKettleProps.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_SHARED_FILE, (String)this.wShared.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_JDBC_FILE, (String)this.wJdbcProps.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_CONFIG_FILE, (String)this.wTargetConfigFile.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_PIPELINE_RUN_CONFIGURATION, (String)this.wPipelineRunConfiguration.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_WORKFLOW_RUN_CONFIGURATION, (String)this.wWorkflowRunConfiguration.getText());
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_SKIP_EXISTING, (String)(this.wSkipExisting.getSelection() ? "true" : "false"));
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_SKIP_HIDDEN, (String)(this.wSkipHidden.getSelection() ? "true" : "false"));
        AuditManagerGuiUtil.addLastUsedValue((String)LAST_USED_IMPORT_SKIP_FOLDERS, (String)(this.wSkipFolders.getSelection() ? "true" : "false"));
        this.shell.dispose();
    }

    private void browseHomeFolder(Event event) {
        BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wImportFrom, (IVariables)this.variables);
    }

    private void browseTargetFolder(Event event) {
        BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wImportPath, (IVariables)this.variables);
    }

    private void browseKettlePropsFile(Event event) {
        BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wKettleProps, (IVariables)this.variables, (String[])new String[]{"*.properties", "*.*"}, (String[])new String[]{"Properties files (*.properties)", "All Files (*.*)"}, (boolean)true);
    }

    private void browseJdbcPropsFile(Event event) {
        BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wJdbcProps, (IVariables)this.variables, (String[])new String[]{"*.properties", "*.*"}, (String[])new String[]{"Properties files (*.properties)", "All Files (*.*)"}, (boolean)true);
    }

    private void browseXmlFile(Event event) {
        BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wShared, (IVariables)this.variables, (String[])new String[]{"*.xml", "*.*"}, (String[])new String[]{"XML files (*.xml)", "All Files (*.*)"}, (boolean)true);
    }

    private void doImport() {
        try {
            String projectName = "";
            if (!this.wImportInExisting.getSelection()) {
                projectName = "Hop Import Project";
                try {
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)"HopImportCreateProject", (Object)this.wImportPath.getText());
                }
                catch (HopException e) {
                    throw new HopException("Error creating project", (Throwable)e);
                }
            } else {
                projectName = this.wImportProject.getText();
            }
            String sourceFolder = this.wImportFrom.getText();
            String targetFolder = this.wImportPath.getText();
            if (this.wImportInExisting.getSelection()) {
                Object[] objects = new Object[]{projectName, targetFolder};
                try {
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)"ProjectHome", (Object)objects);
                    targetFolder = (String)objects[1];
                }
                catch (HopException e) {
                    throw new HopException("Error getting home folder of project " + projectName, (Throwable)e);
                }
            }
            this.kettleImport.setValidateInputFolder(sourceFolder);
            this.kettleImport.setValidateOutputFolder(targetFolder);
            this.kettleImport.setSharedXmlFilename(this.wShared.getText());
            this.kettleImport.setKettlePropertiesFilename(this.wKettleProps.getText());
            this.kettleImport.setJdbcPropertiesFilename(this.wJdbcProps.getText());
            this.kettleImport.setSkippingExistingTargetFiles(this.wSkipExisting.getSelection());
            this.kettleImport.setSkippingHiddenFilesAndFolders(this.wSkipHidden.getSelection());
            this.kettleImport.setSkippingFolders(this.wSkipFolders.getSelection());
            this.kettleImport.setDefaultPipelineRunConfiguration(Const.NVL((String)this.wPipelineRunConfiguration.getText(), (String)""));
            this.kettleImport.setDefaultWorkflowRunConfiguration(Const.NVL((String)this.wWorkflowRunConfiguration.getText(), (String)""));
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(HopGui.getInstance().getShell());
            monitorDialog.run(true, monitor -> {
                try {
                    monitor.beginTask("Importing files", 4);
                    this.kettleImport.runImport(monitor);
                    monitor.done();
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e, "Error importing " + Const.getStackTracker((Throwable)e));
                }
            });
            MessageBox box = new MessageBox(this.shell, 34);
            box.setText("Import summary");
            box.setMessage(this.kettleImport.getImportReport());
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error importing", e);
        }
    }

    private void showHideProjectFields(Event event) {
        if (this.wImportInExisting.getSelection()) {
            this.wImportProject.setEnabled(true);
            this.wImportPath.setEditable(false);
            this.wbImportPath.setEnabled(false);
        } else {
            this.wImportProject.setEnabled(false);
            this.wImportPath.setEditable(true);
            this.wbImportPath.setEnabled(true);
        }
    }
}

