/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DataBindingException;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.WorkflowMap;

@HopServerServlet(id="getExecInfo", name="Get execution information")
public class GetExecutionInfoServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = GetExecutionInfoServlet.class;
    private static final long serialVersionUID = -1624876141322415729L;
    public static final String CONTEXT_PATH = "/hop/getExecInfo";
    public static final String PARAMETER_TYPE = "type";
    public static final String PARAMETER_LOCATION = "location";
    public static final String PARAMETER_CHILDREN = "children";
    public static final String PARAMETER_LIMIT = "limit";
    public static final String PARAMETER_ID = "id";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_EXEC_TYPE = "execType";
    public static final String PARAMETER_PARENT_ID = "parentId";

    public GetExecutionInfoServlet() {
    }

    public GetExecutionInfoServlet(WorkflowMap workflowMap) {
        super(workflowMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetWorkflowStatusServlet.Log.WorkflowStatusRequested", (String[])new String[0]));
        }
        PrintWriter out = response.getWriter();
        String typeString = request.getParameter(PARAMETER_TYPE);
        String locationName = request.getParameter(PARAMETER_LOCATION);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            MultiMetadataProvider provider;
            IHopMetadataSerializer serializer;
            ExecutionInfoLocation location;
            if (StringUtils.isEmpty((String)typeString)) {
                throw new HopException("Please specify the type of execution information to register with parameter 'type'");
            }
            Type type = Type.valueOf(typeString);
            if (StringUtils.isEmpty((String)locationName)) {
                throw new HopException("Please specify the name of the execution information location to register at with parameter 'location'");
            }
            if (this.log.isDebug()) {
                this.logDebug("Execution information requested of type " + typeString + " and location " + locationName);
            }
            if ((location = (ExecutionInfoLocation)(serializer = (provider = this.pipelineMap.getHopServerConfig().getMetadataProvider()).getSerializer(ExecutionInfoLocation.class)).load(locationName)) == null) {
                throw new HopException("Unable to find execution information location " + locationName);
            }
            iLocation.initialize(this.variables, (IHopMetadataProvider)provider);
            try (IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();){
                switch (type) {
                    case STATE: {
                        String id = request.getParameter(PARAMETER_ID);
                        if (StringUtils.isEmpty((String)id)) {
                            throw new HopException("Please specify the ID of execution state with parameter 'id'");
                        }
                        ExecutionState executionState = location.getExecutionInfoLocation().getExecutionState(id);
                        this.outputExecutionStateAsJson(out, executionState);
                        return;
                    }
                    case IDS: {
                        String children = request.getParameter(PARAMETER_CHILDREN);
                        boolean includeChildren = "Y".equalsIgnoreCase(children) || "true".equalsIgnoreCase(children);
                        String limit = request.getParameter(PARAMETER_LIMIT);
                        int limitNr = Const.toInt((String)limit, (int)100);
                        List<String> ids = location.getExecutionInfoLocation().getExecutionIds(includeChildren, limitNr);
                        this.outputExecutionIdsAsJson(out, ids);
                        return;
                    }
                    case EXECUTION: {
                        String id = request.getParameter(PARAMETER_ID);
                        if (StringUtils.isEmpty((String)id)) {
                            throw new HopException("Please specify the execution ID with parameter 'id'");
                        }
                        Execution execution = location.getExecutionInfoLocation().getExecution(id);
                        this.outputExecutionAsJson(out, execution);
                        return;
                    }
                    case CHILDREN: {
                        String id = request.getParameter(PARAMETER_ID);
                        if (StringUtils.isEmpty((String)id)) {
                            throw new HopException("Please specify the parent execution ID with parameter 'id'");
                        }
                        List<Execution> children = location.getExecutionInfoLocation().findExecutions(id);
                        this.outputExecutionChildrenAsJson(out, children);
                        return;
                    }
                    case DATA: {
                        String parentId = request.getParameter(PARAMETER_PARENT_ID);
                        if (StringUtils.isEmpty((String)parentId)) {
                            throw new HopException("Please specify the parent execution ID with parameter 'parentId'");
                        }
                        String id = request.getParameter(PARAMETER_ID);
                        if (StringUtils.isEmpty((String)id)) {
                            throw new HopException("Please specify the execution ID with parameter 'id'");
                        }
                        ExecutionData data = location.getExecutionInfoLocation().getExecutionData(parentId, id);
                        this.outputExecutionDataAsJson(out, data);
                        return;
                    }
                    case LAST_EXECUTION: {
                        String name = request.getParameter(PARAMETER_NAME);
                        if (StringUtils.isEmpty((String)name)) {
                            throw new HopException("Please specify the name of the last execution to find with parameter 'name'");
                        }
                        String execType = request.getParameter(PARAMETER_EXEC_TYPE);
                        if (StringUtils.isEmpty((String)execType)) {
                            throw new HopException("Please specify the type of the last execution to find with parameter 'execType'");
                        }
                        ExecutionType executionType = ExecutionType.valueOf(execType);
                        Execution execution = location.getExecutionInfoLocation().findLastExecution(executionType, name);
                        this.outputExecutionAsJson(out, execution);
                        return;
                    }
                    case CHILD_IDS: {
                        String execType = request.getParameter(PARAMETER_EXEC_TYPE);
                        if (StringUtils.isEmpty((String)execType)) {
                            throw new HopException("Please specify the type of execution to find children for with parameter 'execType'");
                        }
                        ExecutionType executionType = ExecutionType.valueOf(execType);
                        String id = request.getParameter(PARAMETER_ID);
                        if (StringUtils.isEmpty((String)id)) {
                            throw new HopException("Please specify the ID of execution to find children for with parameter 'id'");
                        }
                        List<String> ids = location.getExecutionInfoLocation().findChildIds(executionType, id);
                        this.outputExecutionIdsAsJson(out, ids);
                        return;
                    }
                    case PARENT_ID: {
                        String id = request.getParameter(PARAMETER_ID);
                        if (StringUtils.isEmpty((String)id)) {
                            throw new HopException("Please specify the child execution ID to find the parent for with parameter 'id'");
                        }
                        String parentId = location.getExecutionInfoLocation().findParentId(id);
                        this.outputIdAsJson(out, parentId);
                        return;
                    }
                    default: {
                        StringBuilder message = new StringBuilder("Unknown update type: " + String.valueOf((Object)type) + ". Allowed values are: ");
                        for (Type typeValue : Type.values()) {
                            message.append(typeValue.name()).append(" ");
                        }
                        throw new HopException(message.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            String message = Const.getStackTracker((Throwable)e);
            try {
                HopJson.newMapper().writeValue((Writer)out, (Object)message);
            }
            catch (IOException | DataBindingException ex) {
                throw new ServletException("Error writing execution state as JSON to servlet output stream", ex);
            }
            response.setStatus(500);
        }
    }

    private void outputIdAsJson(PrintWriter out, String parentId) throws HopException {
        try {
            HopJson.newMapper().writeValue((Writer)out, (Object)parentId);
        }
        catch (IOException | DataBindingException e) {
            throw new HopException("Error writing execution ID as JSON to servlet output stream", e);
        }
    }

    private void outputExecutionDataAsJson(PrintWriter out, ExecutionData data) throws HopException {
        try {
            HopJson.newMapper().writeValue((Writer)out, (Object)data);
        }
        catch (IOException | DataBindingException e) {
            throw new HopException("Error writing execution data as JSON to servlet output stream", e);
        }
    }

    private void outputExecutionChildrenAsJson(PrintWriter out, List<Execution> children) throws HopException {
        try {
            HopJson.newMapper().writeValue((Writer)out, children);
        }
        catch (IOException | DataBindingException e) {
            throw new HopException("Error writing execution children as JSON to servlet output stream", e);
        }
    }

    private void outputExecutionAsJson(PrintWriter out, Execution execution) throws HopException {
        try {
            HopJson.newMapper().writeValue((Writer)out, (Object)execution);
        }
        catch (IOException | DataBindingException e) {
            throw new HopException("Error writing execution as JSON to servlet output stream", e);
        }
    }

    private void outputExecutionIdsAsJson(PrintWriter out, List<String> ids) throws HopException {
        try {
            HopJson.newMapper().writeValue((Writer)out, ids);
        }
        catch (IOException | DataBindingException e) {
            throw new HopException("Error writing execution IDs as JSON to servlet output stream", e);
        }
    }

    private void outputExecutionStateAsJson(PrintWriter out, ExecutionState executionState) throws HopException {
        try {
            HopJson.newMapper().writeValue((Writer)out, (Object)executionState);
        }
        catch (IOException | DataBindingException e) {
            throw new HopException("Error writing execution state as JSON to servlet output stream", e);
        }
    }

    public String toString() {
        return "Workflow Status IHandler";
    }

    @Override
    public String getService() {
        return "/hop/getExecInfo (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    public static enum Type {
        STATE,
        IDS,
        EXECUTION,
        CHILDREN,
        DATA,
        LAST_EXECUTION,
        CHILD_IDS,
        PARENT_ID;

    }
}

