/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins.dataprof;

import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerPlugin;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.plugins.dataprof.BasicDataProfilingDataSamplerStore;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.transform.stream.IStream;

@GuiPlugin
@ExecutionDataSamplerPlugin(id="BasicDataProfilingRowsExecutionDataSampler", name="Data profile output rows", description="Allow for some basic data profiling to be performed on transform output rows")
public class BasicDataProfilingDataSampler
implements IExecutionDataSampler<BasicDataProfilingDataSamplerStore> {
    private static final Class<?> PKG = BasicDataProfilingDataSampler.class;
    private String pluginId;
    private String pluginName;
    @GuiWidgetElement(order="100", type=GuiElementType.TEXT, parentId="ExecutionDataSamplerParent", label="i18n::BasicDataProfilingDataSampler.Label.SampleSize", toolTip="i18n::BasicDataProfilingDataSampler.Tooltip.SampleSize")
    @HopMetadataProperty
    protected String sampleSize;
    @GuiWidgetElement(order="105", type=GuiElementType.CHECKBOX, parentId="ExecutionDataSamplerParent", label="i18n::BasicDataProfilingDataSampler.Label.LastTransforms")
    @HopMetadataProperty
    protected boolean onlyProfilingLastTransforms;
    @GuiWidgetElement(order="110", type=GuiElementType.CHECKBOX, parentId="ExecutionDataSamplerParent", label="i18n::BasicDataProfilingDataSampler.Label.ProfilingMinimum")
    @HopMetadataProperty
    protected boolean profilingMinimum;
    @GuiWidgetElement(order="120", type=GuiElementType.CHECKBOX, parentId="ExecutionDataSamplerParent", label="i18n::BasicDataProfilingDataSampler.Label.ProfilingMaximum")
    @HopMetadataProperty
    protected boolean profilingMaximum;
    @GuiWidgetElement(order="140", type=GuiElementType.CHECKBOX, parentId="ExecutionDataSamplerParent", label="i18n::BasicDataProfilingDataSampler.Label.ProfilingNrNull")
    @HopMetadataProperty
    protected boolean profilingNrNull;
    @GuiWidgetElement(order="150", type=GuiElementType.CHECKBOX, parentId="ExecutionDataSamplerParent", label="i18n::BasicDataProfilingDataSampler.Label.ProfilingNrNonNull")
    @HopMetadataProperty
    protected boolean profilingNrNonNull;
    @GuiWidgetElement(order="160", type=GuiElementType.CHECKBOX, parentId="ExecutionDataSamplerParent", label="i18n::BasicDataProfilingDataSampler.Label.ProfilingMinimumLength")
    @HopMetadataProperty
    protected boolean profilingMinLength;
    @GuiWidgetElement(order="170", type=GuiElementType.CHECKBOX, parentId="ExecutionDataSamplerParent", label="i18n::BasicDataProfilingDataSampler.Label.ProfilingMaximumLength")
    @HopMetadataProperty
    protected boolean profilingMaxLength;

    public BasicDataProfilingDataSampler() {
        this.sampleSize = "25";
        this.onlyProfilingLastTransforms = true;
        this.profilingMinimum = true;
        this.profilingMaximum = true;
        this.profilingNrNull = true;
        this.profilingNrNonNull = true;
        this.profilingMinLength = true;
        this.profilingMaxLength = true;
    }

    public BasicDataProfilingDataSampler(BasicDataProfilingDataSampler sampler) {
        this.pluginId = sampler.pluginId;
        this.pluginName = sampler.pluginName;
        this.sampleSize = sampler.sampleSize;
        this.onlyProfilingLastTransforms = sampler.onlyProfilingLastTransforms;
        this.profilingMinimum = sampler.profilingMinimum;
        this.profilingMaximum = sampler.profilingMaximum;
        this.profilingNrNull = sampler.profilingNrNull;
        this.profilingNrNonNull = sampler.profilingNrNonNull;
        this.profilingMinLength = sampler.profilingMinLength;
        this.profilingMaxLength = sampler.profilingMaxLength;
    }

    public BasicDataProfilingDataSampler clone() {
        return new BasicDataProfilingDataSampler(this);
    }

    @Override
    public BasicDataProfilingDataSamplerStore createSamplerStore(ExecutionDataSamplerMeta samplerMeta) {
        return new BasicDataProfilingDataSamplerStore(this, samplerMeta);
    }

    @Override
    public void sampleRow(BasicDataProfilingDataSamplerStore store, IStream.StreamType streamType, IRowMeta rowMeta, Object[] row) throws HopException {
        if (streamType != IStream.StreamType.OUTPUT) {
            return;
        }
        if (this.onlyProfilingLastTransforms && !store.getSamplerMeta().isLastTransform()) {
            return;
        }
        try {
            for (int i = 0; i < rowMeta.size(); ++i) {
                int length;
                int compare;
                IValueMeta valueMeta = rowMeta.getValueMeta(i);
                Object valueData = row[i];
                String name = valueMeta.getName();
                if (valueMeta.isNull(valueData)) {
                    if (this.profilingNrNull) {
                        long counter = store.getNullCounters().getOrDefault(name, 0L);
                        store.getNullCounters().put(name, ++counter);
                        this.addSampleRow(store, name, ProfilingType.NrNulls, rowMeta, row);
                    }
                } else if (this.profilingNrNonNull) {
                    long counter = store.getNonNullCounters().getOrDefault(name, 0L);
                    store.getNonNullCounters().put(name, ++counter);
                    this.addSampleRow(store, name, ProfilingType.NrNonNulls, rowMeta, row);
                }
                if (this.profilingMinimum) {
                    Object oldMin = store.getMinValues().get(name);
                    if (oldMin == null) {
                        store.getMinValues().put(name, valueData);
                        store.getMinMeta().put(name, valueMeta);
                    } else {
                        compare = valueMeta.compare(valueData, oldMin);
                        if (compare < 0) {
                            store.getMinValues().put(name, valueData);
                            store.getMinMeta().put(name, valueMeta);
                            this.clearSampleRows(store, name, ProfilingType.MinValue);
                            this.addSampleRow(store, name, ProfilingType.MinValue, rowMeta, row);
                        } else if (compare == 0) {
                            this.addSampleRow(store, name, ProfilingType.MinValue, rowMeta, row);
                        }
                    }
                }
                if (this.profilingMaximum) {
                    Object oldMax = store.getMaxValues().get(name);
                    if (oldMax == null) {
                        store.getMaxValues().put(name, valueData);
                        store.getMaxMeta().put(name, valueMeta);
                    } else {
                        compare = valueMeta.compare(valueData, oldMax);
                        if (compare > 0) {
                            store.getMaxValues().put(name, valueData);
                            store.getMaxMeta().put(name, valueMeta);
                            this.clearSampleRows(store, name, ProfilingType.MaxValue);
                            this.addSampleRow(store, name, ProfilingType.MaxValue, rowMeta, row);
                        } else if (compare == 0) {
                            this.addSampleRow(store, name, ProfilingType.MaxValue, rowMeta, row);
                        }
                    }
                }
                if (!valueMeta.isString() || valueMeta.isNull(valueData)) continue;
                if (this.profilingMinLength) {
                    String string = valueMeta.getString(valueData);
                    length = string.length();
                    Integer oldMin = store.getMinLengths().get(name);
                    if (oldMin == null) {
                        store.getMinLengths().put(name, length);
                    } else if (length < oldMin) {
                        store.getMinLengths().put(name, length);
                        this.clearSampleRows(store, name, ProfilingType.MinLength);
                        this.addSampleRow(store, name, ProfilingType.MinLength, rowMeta, row);
                    } else if (length == oldMin) {
                        this.addSampleRow(store, name, ProfilingType.MinLength, rowMeta, row);
                    }
                }
                if (!this.profilingMaxLength) continue;
                String string = valueMeta.getString(valueData);
                length = string.length();
                Integer oldMax = store.getMaxLengths().get(name);
                if (oldMax == null) {
                    store.getMaxLengths().put(name, length);
                    continue;
                }
                if (length > oldMax) {
                    store.getMaxLengths().put(name, length);
                    this.clearSampleRows(store, name, ProfilingType.MaxLength);
                    this.addSampleRow(store, name, ProfilingType.MaxLength, rowMeta, row);
                    continue;
                }
                if (length != oldMax) continue;
                this.addSampleRow(store, name, ProfilingType.MaxLength, rowMeta, row);
            }
        }
        catch (Exception e) {
            throw new HopException("Error data profiling row " + rowMeta.toStringMeta(), (Throwable)e);
        }
    }

    private void clearSampleRows(BasicDataProfilingDataSamplerStore store, String name, ProfilingType profilingType) {
        Map<ProfilingType, RowBuffer> typeBufferMap = store.getProfileSamples().get(name);
        if (typeBufferMap != null) {
            typeBufferMap.remove((Object)profilingType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSampleRow(BasicDataProfilingDataSamplerStore store, String name, ProfilingType profilingType, IRowMeta rowMeta, Object[] row) {
        Map<String, Map<ProfilingType, RowBuffer>> map = store.getProfileSamples();
        synchronized (map) {
            Map typeBufferMap = store.getProfileSamples().computeIfAbsent(name, k -> new HashMap());
            RowBuffer rowBuffer = typeBufferMap.computeIfAbsent(profilingType, k -> new RowBuffer(rowMeta));
            if (rowBuffer.size() < store.getMaxRows()) {
                rowBuffer.addRow(row);
            }
        }
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(String sampleSize) {
        this.sampleSize = sampleSize;
    }

    public boolean isOnlyProfilingLastTransforms() {
        return this.onlyProfilingLastTransforms;
    }

    public void setOnlyProfilingLastTransforms(boolean onlyProfilingLastTransforms) {
        this.onlyProfilingLastTransforms = onlyProfilingLastTransforms;
    }

    public boolean isProfilingMinimum() {
        return this.profilingMinimum;
    }

    public void setProfilingMinimum(boolean profilingMinimum) {
        this.profilingMinimum = profilingMinimum;
    }

    public boolean isProfilingMaximum() {
        return this.profilingMaximum;
    }

    public void setProfilingMaximum(boolean profilingMaximum) {
        this.profilingMaximum = profilingMaximum;
    }

    public boolean isProfilingNrNull() {
        return this.profilingNrNull;
    }

    public void setProfilingNrNull(boolean profilingNrNull) {
        this.profilingNrNull = profilingNrNull;
    }

    public boolean isProfilingNrNonNull() {
        return this.profilingNrNonNull;
    }

    public void setProfilingNrNonNull(boolean profilingNrNonNull) {
        this.profilingNrNonNull = profilingNrNonNull;
    }

    public boolean isProfilingMinLength() {
        return this.profilingMinLength;
    }

    public void setProfilingMinLength(boolean profilingMinLength) {
        this.profilingMinLength = profilingMinLength;
    }

    public boolean isProfilingMaxLength() {
        return this.profilingMaxLength;
    }

    public void setProfilingMaxLength(boolean profilingMaxLength) {
        this.profilingMaxLength = profilingMaxLength;
    }

    public static enum ProfilingType {
        MinValue(BaseMessages.getString(PKG, (String)"BasicDataProfilingDataSampler.Label.MinValue", (String[])new String[0])),
        MaxValue(BaseMessages.getString(PKG, (String)"BasicDataProfilingDataSampler.Label.MaxValue", (String[])new String[0])),
        NrNulls(BaseMessages.getString(PKG, (String)"BasicDataProfilingDataSampler.Label.NrNulls", (String[])new String[0])),
        NrNonNulls(BaseMessages.getString(PKG, (String)"BasicDataProfilingDataSampler.Label.NrNonNulls", (String[])new String[0])),
        MinLength(BaseMessages.getString(PKG, (String)"BasicDataProfilingDataSampler.Label.MinLength", (String[])new String[0])),
        MaxLength(BaseMessages.getString(PKG, (String)"BasicDataProfilingDataSampler.Label.MaxLength", (String[])new String[0]));

        private final String description;

        private ProfilingType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

