/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.kafka.KafkaSourceDescriptor;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Experimental
class WatchForKafkaTopicPartitions
extends PTransform<PBegin, PCollection<KafkaSourceDescriptor>> {
    private static final Duration DEFAULT_CHECK_DURATION = Duration.standardHours((long)1L);
    private static final String COUNTER_NAMESPACE = "watch_kafka_topic_partition";
    private final Duration checkDuration;
    private final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> kafkaConsumerFactoryFn;
    private final Map<String, Object> kafkaConsumerConfig;
    private final @Nullable SerializableFunction<TopicPartition, Boolean> checkStopReadingFn;
    private final Set<String> topics;
    private final @Nullable Instant startReadTime;
    private final @Nullable Instant stopReadTime;

    public WatchForKafkaTopicPartitions(@Nullable Duration checkDuration, SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> kafkaConsumerFactoryFn, Map<String, Object> kafkaConsumerConfig, @Nullable SerializableFunction<TopicPartition, Boolean> checkStopReadingFn, Set<String> topics, @Nullable Instant startReadTime, @Nullable Instant stopReadTime) {
        this.checkDuration = (Duration)MoreObjects.firstNonNull((Object)checkDuration, (Object)DEFAULT_CHECK_DURATION);
        this.kafkaConsumerFactoryFn = kafkaConsumerFactoryFn;
        this.kafkaConsumerConfig = kafkaConsumerConfig;
        this.checkStopReadingFn = checkStopReadingFn;
        this.topics = topics;
        this.startReadTime = startReadTime;
        this.stopReadTime = stopReadTime;
    }

    public PCollection<KafkaSourceDescriptor> expand(PBegin input) {
        return (PCollection)((PCollection)((PCollection)input.apply((PTransform)Impulse.create())).apply("Match new TopicPartitions", (PTransform)Watch.growthOf((Watch.Growth.PollFn)new WatchPartitionFn(this.kafkaConsumerFactoryFn, this.kafkaConsumerConfig, this.topics)).withPollInterval(this.checkDuration))).apply((PTransform)ParDo.of((DoFn)new ConvertToDescriptor(this.checkStopReadingFn, this.startReadTime, this.stopReadTime)));
    }

    @VisibleForTesting
    static List<TopicPartition> getAllTopicPartitions(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> kafkaConsumerFactoryFn, Map<String, Object> kafkaConsumerConfig, Set<String> topics) {
        ArrayList<TopicPartition> current = new ArrayList<TopicPartition>();
        try (Consumer kafkaConsumer = (Consumer)kafkaConsumerFactoryFn.apply(kafkaConsumerConfig);){
            if (topics != null && !topics.isEmpty()) {
                for (String string : topics) {
                    for (PartitionInfo partition : kafkaConsumer.partitionsFor(string)) {
                        current.add(new TopicPartition(string, partition.partition()));
                    }
                }
            } else {
                for (Map.Entry entry : kafkaConsumer.listTopics().entrySet()) {
                    for (PartitionInfo partition : (List)entry.getValue()) {
                        current.add(new TopicPartition((String)entry.getKey(), partition.partition()));
                    }
                }
            }
        }
        return current;
    }

    private static class WatchPartitionFn
    extends Watch.Growth.PollFn<byte[], TopicPartition> {
        private final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> kafkaConsumerFactoryFn;
        private final Map<String, Object> kafkaConsumerConfig;
        private final Set<String> topics;

        private WatchPartitionFn(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> kafkaConsumerFactoryFn, Map<String, Object> kafkaConsumerConfig, Set<String> topics) {
            this.kafkaConsumerFactoryFn = kafkaConsumerFactoryFn;
            this.kafkaConsumerConfig = kafkaConsumerConfig;
            this.topics = topics;
        }

        public Watch.Growth.PollResult<TopicPartition> apply(byte[] element, Contextful.Fn.Context c) throws Exception {
            Instant now = Instant.now();
            return Watch.Growth.PollResult.incomplete((Instant)now, WatchForKafkaTopicPartitions.getAllTopicPartitions(this.kafkaConsumerFactoryFn, this.kafkaConsumerConfig, this.topics)).withWatermark(now);
        }
    }

    private static class ConvertToDescriptor
    extends DoFn<KV<byte[], TopicPartition>, KafkaSourceDescriptor> {
        private final @Nullable SerializableFunction<TopicPartition, Boolean> checkStopReadingFn;
        private final @Nullable Instant startReadTime;
        private final @Nullable Instant stopReadTime;

        private ConvertToDescriptor(@Nullable SerializableFunction<TopicPartition, Boolean> checkStopReadingFn, @Nullable Instant startReadTime, @Nullable Instant stopReadTime) {
            this.checkStopReadingFn = checkStopReadingFn;
            this.startReadTime = startReadTime;
            this.stopReadTime = stopReadTime;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element KV<byte[], TopicPartition> partition, DoFn.OutputReceiver<KafkaSourceDescriptor> receiver) {
            TopicPartition topicPartition = Objects.requireNonNull((TopicPartition)partition.getValue());
            if (this.checkStopReadingFn == null || !((Boolean)this.checkStopReadingFn.apply((Object)topicPartition)).booleanValue()) {
                Counter foundedTopicPartition = Metrics.counter((String)WatchForKafkaTopicPartitions.COUNTER_NAMESPACE, (String)topicPartition.toString());
                foundedTopicPartition.inc();
                receiver.output((Object)KafkaSourceDescriptor.of(topicPartition, null, this.startReadTime, null, this.stopReadTime, null));
            }
        }
    }
}

