/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SCS5256Writer;
import com.ibm.as400.access.SCSFontData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SCS5224Writer
extends SCS5256Writer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final byte[] SCD = new byte[]{43, -46, 4, 41, 0, 0};
    private static final byte[] SCGL = new byte[]{43, -47, 3, -127, -1};
    private static final byte[] SLD = new byte[]{43, -58, 2, 0};
    private byte LPI = (byte)6;
    static final boolean FONT_ = false;
    static final boolean CPI_ = true;
    boolean fontOrCPI = true;
    byte CPI = (byte)10;

    public SCS5224Writer(OutputStream outputStream) {
        super(outputStream);
    }

    public SCS5224Writer(OutputStream outputStream, int n) throws UnsupportedEncodingException {
        super(outputStream, n);
    }

    public SCS5224Writer(OutputStream outputStream, int n, AS400 aS400) throws UnsupportedEncodingException {
        super(outputStream, n, aS400);
    }

    public SCS5224Writer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
    }

    void initPage() throws IOException {
        super.initPage();
        if (this.fontOrCPI) {
            this.setCPI(this.CPI);
        }
        this.setLPI(this.LPI);
        this.setCodePage();
    }

    void setCodePage() throws IOException {
        byte[] byArray = SCGL;
        int n = this.getCcsid();
        int[] nArray = SCSFontData.codePage;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (n != nArray[i]) continue;
            byArray[byArray.length - 1] = SCSFontData.codePageID[i];
            break;
        }
        this.addToBuffer(byArray);
    }

    public void setCPI(int n) throws IOException {
        switch (n) {
            case 10: {
                this.CPI = (byte)10;
                break;
            }
            case 15: {
                this.CPI = (byte)15;
                break;
            }
            default: {
                String string = "CPI (" + String.valueOf(n) + ")";
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
        this.fontOrCPI = true;
        if (!this.pageStarted_) {
            this.initPage();
        } else {
            byte[] byArray = SCD;
            byArray[byArray.length - 1] = this.CPI;
            this.addToBuffer(byArray);
        }
    }

    public void setLPI(int n) throws IOException {
        int n2;
        switch (n) {
            case 4: {
                this.LPI = (byte)4;
                n2 = 18;
                break;
            }
            case 6: {
                this.LPI = (byte)6;
                n2 = 12;
                break;
            }
            case 8: {
                this.LPI = (byte)8;
                n2 = 9;
                break;
            }
            case 9: {
                this.LPI = (byte)9;
                n2 = 8;
                break;
            }
            case 12: {
                this.LPI = (byte)12;
                n2 = 6;
                break;
            }
            default: {
                String string = "LPI (" + String.valueOf(n) + ")";
                throw new ExtendedIllegalArgumentException(string, 2);
            }
        }
        if (!this.pageStarted_) {
            this.initPage();
        } else {
            byte[] byArray = SLD;
            byArray[byArray.length - 1] = n2;
            this.addToBuffer(byArray);
        }
    }
}

