/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.io.Serializable;
import java.util.Vector;

public abstract class FieldDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    String alias_ = "";
    boolean allowNull_ = false;
    String columnHeading_ = "";
    AS400DataType dataType_ = null;
    String ddsName_ = "";
    Object defaultValue_ = null;
    String[] keyFieldFunctions_ = null;
    int layoutLength_ = 0;
    int layoutAlignment_ = 0;
    int length_;
    String name_ = "";
    String refFil_ = "";
    String refFld_ = "";
    String refFmt_ = "";
    String refLib_ = "";
    String text_ = "";
    boolean isDFTCurrent_ = false;
    String DFTCurrentValue_ = null;
    boolean isDFTNull_ = false;

    protected FieldDescription() {
    }

    protected FieldDescription(AS400DataType aS400DataType, String string) {
        if (aS400DataType == null) {
            throw new NullPointerException("dataType");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.dataType_ = aS400DataType;
        this.name_ = string;
        this.ddsName_ = string.length() > 10 ? string.substring(0, 10).toUpperCase() : string.toUpperCase();
        this.length_ = aS400DataType.getByteLength();
    }

    protected FieldDescription(AS400DataType aS400DataType, String string, String string2) {
        if (aS400DataType == null) {
            throw new NullPointerException("dataType");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string2 == null) {
            throw new NullPointerException("ddsName");
        }
        if (string2.length() > 10) {
            throw new ExtendedIllegalArgumentException("ddsName", 1);
        }
        this.dataType_ = aS400DataType;
        this.name_ = string;
        this.ddsName_ = string2.toUpperCase();
        this.length_ = aS400DataType.getByteLength();
    }

    public String getALIAS() {
        return this.alias_;
    }

    public boolean getALWNULL() {
        return this.allowNull_;
    }

    public String getCOLHDG() {
        return this.columnHeading_;
    }

    public AS400DataType getDataType() {
        return this.dataType_;
    }

    public Object getDFT() {
        return this.defaultValue_;
    }

    public String getDFTCurrentValue() {
        return this.DFTCurrentValue_;
    }

    abstract String[] getDDSDescription();

    public String getDDSName() {
        return this.ddsName_;
    }

    String[] getFieldFunctions() {
        Vector<String> vector = new Vector<String>();
        if (!this.alias_.equals("")) {
            vector.addElement("ALIAS(" + this.alias_ + ") ");
        }
        if (this.allowNull_) {
            vector.addElement("ALWNULL ");
        }
        if (!this.columnHeading_.equals("")) {
            vector.addElement("COLHDG(" + this.columnHeading_ + ") ");
        }
        if (!this.refFld_.equals("")) {
            vector.addElement("REFFLD(" + this.refFld_ + ") ");
        }
        if (!this.refFil_.equals("")) {
            vector.addElement("REFFIL(" + this.refFil_ + ") ");
        }
        if (!this.refFmt_.equals("")) {
            vector.addElement("REFFMT(" + this.refFmt_ + ") ");
        }
        if (!this.refLib_.equals("")) {
            vector.addElement("REFLIB(" + this.refLib_ + ") ");
        }
        if (!this.text_.equals("")) {
            vector.addElement("TEXT('" + this.text_ + "') ");
        }
        if (vector.size() != 0) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String getFieldName() {
        return this.name_;
    }

    public String[] getKeyFieldFunctions() {
        return this.keyFieldFunctions_;
    }

    public int getLayoutAlignment() {
        return this.layoutAlignment_;
    }

    public int getLayoutLength() {
        return this.layoutLength_;
    }

    public int getLength() {
        return this.length_;
    }

    public String getREFFIL() {
        return this.refFil_;
    }

    public String getREFFLD() {
        return this.refFld_;
    }

    public String getREFFMT() {
        return this.refFmt_;
    }

    public String getREFLIB() {
        return this.refLib_;
    }

    public String getTEXT() {
        return this.text_;
    }

    public boolean isDFTCurrent() {
        return this.isDFTCurrent_;
    }

    public void setALIAS(String string) {
        if (string == null) {
            throw new NullPointerException("alias");
        }
        this.alias_ = string;
    }

    public void setALWNULL(boolean bl) {
        this.allowNull_ = bl;
    }

    public void setCOLHDG(String string) {
        if (string == null) {
            throw new NullPointerException("colHdg");
        }
        this.columnHeading_ = string;
    }

    protected void setDataType(AS400DataType aS400DataType) {
        if (aS400DataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = aS400DataType;
    }

    public void setDDSName(String string) {
        if (string == null) {
            throw new NullPointerException("ddsName");
        }
        if (string.length() > 10) {
            throw new ExtendedIllegalArgumentException("ddsName", 1);
        }
        this.ddsName_ = string.toUpperCase();
    }

    public void setFieldName(String string) {
        if (string == null) {
            throw new NullPointerException("fieldName");
        }
        this.name_ = string;
    }

    public void setKeyFieldFunctions(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("keyFunctions");
        }
        if (stringArray.length == 0) {
            throw new ExtendedIllegalArgumentException("keyFunctions", 1);
        }
        this.keyFieldFunctions_ = stringArray;
    }

    public void setLayoutAlignment(int n) {
        if (n != 1 && n != 2) {
            throw new ExtendedIllegalArgumentException("layoutAlignment", 2);
        }
        this.layoutAlignment_ = n;
    }

    public void setLayoutAttributes(int n, int n2) {
        if (n > 50 || n < 0) {
            throw new ExtendedIllegalArgumentException("layoutLength", 1);
        }
        if (n2 != 1 && n2 != 2) {
            throw new ExtendedIllegalArgumentException("layoutAlignment", 2);
        }
        this.layoutLength_ = n;
        this.layoutAlignment_ = n2;
    }

    public void setLayoutLength(int n) {
        if (n > 50 || n < 0) {
            throw new ExtendedIllegalArgumentException("layoutLength", 1);
        }
        this.layoutLength_ = n;
    }

    public void setREFFIL(String string) {
        if (string == null) {
            throw new NullPointerException("refFil");
        }
        this.refFil_ = string;
    }

    public void setREFFLD(String string) {
        if (string == null) {
            throw new NullPointerException("refFld");
        }
        this.refFld_ = string;
    }

    public void setREFFMT(String string) {
        if (string == null) {
            throw new NullPointerException("refFmt");
        }
        this.refFmt_ = string;
    }

    public void setREFLIB(String string) {
        if (string == null) {
            throw new NullPointerException("refLib");
        }
        this.refLib_ = string;
    }

    public void setTEXT(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (string.length() > 50) {
            throw new ExtendedIllegalArgumentException("text", 1);
        }
        this.text_ = string;
    }

    public boolean isDFTNull() {
        return this.isDFTNull_;
    }
}

