/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.validation.ConstraintDetails;
import org.apache.hop.neo4j.model.validation.IndexDetails;
import org.apache.hop.neo4j.model.validation.NodeProperty;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionWork;

public class ModelValidator {
    private List<NodeProperty> usedNodeProperties;
    private GraphModel graphModel;
    private List<IndexDetails> indexesList = new ArrayList<IndexDetails>();
    private List<ConstraintDetails> constraintsList = new ArrayList<ConstraintDetails>();

    public ModelValidator() {
        this.usedNodeProperties = new ArrayList<NodeProperty>();
    }

    public ModelValidator(GraphModel graphModel, List<NodeProperty> usedNodeProperties) {
        this();
        this.graphModel = graphModel;
        this.usedNodeProperties = usedNodeProperties;
    }

    public int validateBeforeLoad(ILogChannel log, Session session) {
        int nrErrors = 0;
        this.readIndexesData(session);
        this.readConstraintsData(session);
        for (NodeProperty nodeProperty : this.usedNodeProperties) {
            GraphNode node = this.graphModel.findNode(nodeProperty.getNodeName());
            if (node == null) {
                log.logError("Used node '" + nodeProperty.getNodeName() + "' could not be found in model '" + this.graphModel.getName());
                ++nrErrors;
                continue;
            }
            GraphProperty property = node.findProperty(nodeProperty.getPropertyName());
            if (property == null) {
                log.logError("Used node property " + nodeProperty.getNodeName() + "." + nodeProperty.getPropertyName() + " could not be found in model '" + this.graphModel.getName());
                ++nrErrors;
                continue;
            }
            if (property.isIndexed()) {
                nrErrors += this.validateNodePropertyIndexed(log, node, property, false);
            }
            if (!property.isUnique()) continue;
            nrErrors += this.validateNodePropertyIndexed(log, node, property, true);
        }
        return nrErrors += this.validateMandatoryFields(log);
    }

    private int validateMandatoryFields(ILogChannel log) {
        int nrErrors = 0;
        HashSet<String> nodeNames = new HashSet<String>();
        for (NodeProperty nodeProperty : this.usedNodeProperties) {
            nodeNames.add(nodeProperty.getNodeName());
        }
        for (String nodeName : nodeNames) {
            GraphNode node = this.graphModel.findNode(nodeName);
            if (node == null) continue;
            for (GraphProperty nodeProperty : node.getProperties()) {
                NodeProperty usedProperty;
                if (!nodeProperty.isMandatory() || (usedProperty = this.findUsedProperty(node.getName(), nodeProperty.getName())) != null) continue;
                log.logError("Node property " + node.getName() + "." + nodeProperty.getName() + " is mandatory but not used.");
                ++nrErrors;
            }
        }
        return nrErrors;
    }

    private NodeProperty findUsedProperty(String nodeName, String propertyName) {
        for (NodeProperty nodeProperty : this.usedNodeProperties) {
            if (!nodeProperty.getNodeName().equals(nodeName) || !nodeProperty.getPropertyName().equals(propertyName)) continue;
            return nodeProperty;
        }
        return null;
    }

    private int validateNodePropertyIndexed(ILogChannel log, GraphNode node, GraphProperty property, boolean unique) {
        int nrErrors = 0;
        boolean found = false;
        for (IndexDetails indexDetails : this.indexesList) {
            if (unique && !"UNIQUE".equalsIgnoreCase(indexDetails.getUniqueness())) continue;
            for (String label : node.getLabels()) {
                if (!indexDetails.getLabelsOrTypes().contains(label) || !indexDetails.getProperties().contains(property.getName())) continue;
                found = true;
            }
        }
        if (!found) {
            log.logError("Property '" + property.getName() + "' of node '" + node.getName() + "' doesn't seem to be " + (unique ? "uniquely " : "") + "indexed.");
            ++nrErrors;
        }
        return nrErrors;
    }

    private void readIndexesData(Session session) {
        this.indexesList = (List)session.readTransaction(transaction -> {
            ArrayList<IndexDetails> list = new ArrayList<IndexDetails>();
            Result result = transaction.run("call db.indexes()");
            while (result.hasNext()) {
                list.add(new IndexDetails(result.next()));
            }
            return list;
        });
    }

    private void readConstraintsData(Session session) {
        this.constraintsList = (List)session.readTransaction((TransactionWork)new TransactionWork<List<ConstraintDetails>>(){

            public List<ConstraintDetails> execute(Transaction transaction) {
                ArrayList<ConstraintDetails> list = new ArrayList<ConstraintDetails>();
                Result result = transaction.run("call db.constraints()");
                while (result.hasNext()) {
                    list.add(new ConstraintDetails(result.next()));
                }
                return list;
            }
        });
    }

    public List<NodeProperty> getUsedNodeProperties() {
        return this.usedNodeProperties;
    }

    public void setUsedNodeProperties(List<NodeProperty> usedNodeProperties) {
        this.usedNodeProperties = usedNodeProperties;
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    public List<IndexDetails> getIndexesList() {
        return this.indexesList;
    }

    public void setIndexesList(List<IndexDetails> indexesList) {
        this.indexesList = indexesList;
    }

    public List<ConstraintDetails> getConstraintsList() {
        return this.constraintsList;
    }

    public void setConstraintsList(List<ConstraintDetails> constraintsList) {
        this.constraintsList = constraintsList;
    }
}

