/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketLineIn {
    private static final Logger log = LoggerFactory.getLogger(PacketLineIn.class);
    public static final String END = new StringBuilder(0).toString();
    public static final String DELIM = new StringBuilder(0).toString();
    private final byte[] lineBuffer = new byte[1000];
    private final InputStream in;
    private long limit;

    public PacketLineIn(InputStream in) {
        this(in, 0L);
    }

    public PacketLineIn(InputStream in, long limit) {
        this.in = in;
        this.limit = limit;
    }

    AckNackResult readACK(MutableObjectId returnedId) throws IOException {
        String line = this.readString();
        if (line.length() == 0) {
            throw new PackProtocolException(JGitText.get().expectedACKNAKFoundEOF);
        }
        if ("NAK".equals(line)) {
            return AckNackResult.NAK;
        }
        if (line.startsWith("ACK ")) {
            returnedId.fromString(line.substring(4, 44));
            if (line.length() == 44) {
                return AckNackResult.ACK;
            }
            String arg = line.substring(44);
            if (arg.equals(" continue")) {
                return AckNackResult.ACK_CONTINUE;
            }
            if (arg.equals(" common")) {
                return AckNackResult.ACK_COMMON;
            }
            if (arg.equals(" ready")) {
                return AckNackResult.ACK_READY;
            }
        }
        if (line.startsWith("ERR ")) {
            throw new PackProtocolException(line.substring(4));
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedACKNAKGot, line));
    }

    public String readString() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            log.debug("git< 0000");
            return END;
        }
        if (len == 1) {
            log.debug("git< 0001");
            return DELIM;
        }
        if ((len -= 4) == 0) {
            log.debug("git< ");
            return "";
        }
        byte[] raw = len <= this.lineBuffer.length ? this.lineBuffer : new byte[len];
        IO.readFully(this.in, raw, 0, len);
        if (raw[len - 1] == 10) {
            --len;
        }
        String s = RawParseUtils.decode(StandardCharsets.UTF_8, raw, 0, len);
        log.debug("git< " + s);
        return s;
    }

    public String readStringRaw() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            log.debug("git< 0000");
            return END;
        }
        byte[] raw = (len -= 4) <= this.lineBuffer.length ? this.lineBuffer : new byte[len];
        IO.readFully(this.in, raw, 0, len);
        String s = RawParseUtils.decode(StandardCharsets.UTF_8, raw, 0, len);
        log.debug("git< " + s);
        return s;
    }

    void discardUntilEnd() throws IOException {
        int n;
        while ((n = this.readLength()) != 0) {
            IO.skipFully(this.in, n - 4);
        }
    }

    int readLength() throws IOException {
        int len;
        IO.readFully(this.in, this.lineBuffer, 0, 4);
        try {
            len = RawParseUtils.parseHexInt16(this.lineBuffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw this.invalidHeader();
        }
        if (len == 0) {
            return 0;
        }
        if (len == 1) {
            return 1;
        }
        if (len < 4) {
            throw this.invalidHeader();
        }
        if (this.limit != 0L) {
            int n = len - 4;
            if (this.limit < (long)n) {
                this.limit = -1L;
                try {
                    IO.skipFully(this.in, n);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new InputOverLimitIOException();
            }
            this.limit = (long)n < this.limit ? this.limit - (long)n : -1L;
        }
        return len;
    }

    private IOException invalidHeader() {
        return new IOException(MessageFormat.format(JGitText.get().invalidPacketLineHeader, "" + (char)this.lineBuffer[0] + (char)this.lineBuffer[1] + (char)this.lineBuffer[2] + (char)this.lineBuffer[3]));
    }

    static enum AckNackResult {
        NAK,
        ACK,
        ACK_CONTINUE,
        ACK_COMMON,
        ACK_READY;

    }

    public static class InputOverLimitIOException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }
}

