/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PartitioningWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Instant;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

public class CalendarWindows {
    private static final DateTime DEFAULT_START_DATE = new DateTime(0L, DateTimeZone.UTC);

    public static DaysWindows days(int number) {
        return new DaysWindows(number, DEFAULT_START_DATE, DateTimeZone.UTC);
    }

    public static DaysWindows weeks(int number, int startDayOfWeek) {
        return new DaysWindows(7 * number, DEFAULT_START_DATE.withDayOfWeek(startDayOfWeek), DateTimeZone.UTC);
    }

    public static MonthsWindows months(int number) {
        return new MonthsWindows(number, 1, DEFAULT_START_DATE, DateTimeZone.UTC);
    }

    public static YearsWindows years(int number) {
        return new YearsWindows(number, 1, 1, DEFAULT_START_DATE, DateTimeZone.UTC);
    }

    public static class YearsWindows
    extends PartitioningWindowFn<Object, IntervalWindow> {
        private int number;
        private int monthOfYear;
        private int dayOfMonth;
        private DateTime startDate;
        private DateTimeZone timeZone;

        public YearsWindows beginningOnDay(int monthOfYear, int dayOfMonth) {
            return new YearsWindows(this.number, monthOfYear, dayOfMonth, this.startDate, this.timeZone);
        }

        public YearsWindows withStartingYear(int year) {
            return new YearsWindows(this.number, this.monthOfYear, this.dayOfMonth, new DateTime(year, 1, 1, 0, 0, this.timeZone), this.timeZone);
        }

        public YearsWindows withTimeZone(DateTimeZone timeZone) {
            return new YearsWindows(this.number, this.monthOfYear, this.dayOfMonth, this.startDate.withZoneRetainFields(timeZone), timeZone);
        }

        private YearsWindows(int number, int monthOfYear, int dayOfMonth, DateTime startDate, DateTimeZone timeZone) {
            this.number = number;
            this.monthOfYear = monthOfYear;
            this.dayOfMonth = dayOfMonth;
            this.startDate = startDate;
            this.timeZone = timeZone;
        }

        @Override
        public IntervalWindow assignWindow(Instant timestamp) {
            DateTime datetime = new DateTime((Object)timestamp, this.timeZone);
            DateTime offsetStart = this.startDate.withMonthOfYear(this.monthOfYear).withDayOfMonth(this.dayOfMonth);
            int yearOffset = Years.yearsBetween((ReadableInstant)offsetStart, (ReadableInstant)datetime).getYears() / this.number * this.number;
            DateTime begin = offsetStart.plusYears(yearOffset);
            DateTime end = begin.plusYears(this.number);
            return new IntervalWindow(begin.toInstant(), end.toInstant());
        }

        @Override
        public Coder<IntervalWindow> windowCoder() {
            return IntervalWindow.getCoder();
        }

        @Override
        public boolean isCompatible(WindowFn<?, ?> other) {
            if (!(other instanceof YearsWindows)) {
                return false;
            }
            YearsWindows that = (YearsWindows)other;
            return this.number == that.number && this.monthOfYear == that.monthOfYear && this.dayOfMonth == that.dayOfMonth && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.timeZone, that.timeZone);
        }

        @Override
        public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
            if (!this.isCompatible(other)) {
                throw new IncompatibleWindowException(other, String.format("Only %s objects with the same number of years, month of year, day of month, start date and time zone are compatible.", YearsWindows.class.getSimpleName()));
            }
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numYears", this.number).withLabel("Window Years")).addIfNotDefault(DisplayData.item("startDate", new DateTime((Object)this.startDate, this.timeZone).toInstant()).withLabel("Window Start Date"), new DateTime((Object)DEFAULT_START_DATE, DateTimeZone.UTC).toInstant());
        }

        public DateTimeZone getTimeZone() {
            return this.timeZone;
        }

        public DateTime getStartDate() {
            return this.startDate;
        }

        public int getDayOfMonth() {
            return this.dayOfMonth;
        }

        public int getMonthOfYear() {
            return this.monthOfYear;
        }

        public int getNumber() {
            return this.number;
        }
    }

    public static class MonthsWindows
    extends PartitioningWindowFn<Object, IntervalWindow> {
        private int number;
        private int dayOfMonth;
        private DateTime startDate;
        private DateTimeZone timeZone;

        public MonthsWindows beginningOnDay(int dayOfMonth) {
            return new MonthsWindows(this.number, dayOfMonth, this.startDate, this.timeZone);
        }

        public MonthsWindows withStartingMonth(int year, int month) {
            return new MonthsWindows(this.number, this.dayOfMonth, new DateTime(year, month, 1, 0, 0, this.timeZone), this.timeZone);
        }

        public MonthsWindows withTimeZone(DateTimeZone timeZone) {
            return new MonthsWindows(this.number, this.dayOfMonth, this.startDate.withZoneRetainFields(timeZone), timeZone);
        }

        private MonthsWindows(int number, int dayOfMonth, DateTime startDate, DateTimeZone timeZone) {
            this.number = number;
            this.dayOfMonth = dayOfMonth;
            this.startDate = startDate;
            this.timeZone = timeZone;
        }

        @Override
        public IntervalWindow assignWindow(Instant timestamp) {
            DateTime datetime = new DateTime((Object)timestamp, this.timeZone);
            int monthOffset = Months.monthsBetween((ReadableInstant)this.startDate.withDayOfMonth(this.dayOfMonth), (ReadableInstant)datetime).getMonths() / this.number * this.number;
            DateTime begin = this.startDate.withDayOfMonth(this.dayOfMonth).plusMonths(monthOffset);
            DateTime end = begin.plusMonths(this.number);
            return new IntervalWindow(begin.toInstant(), end.toInstant());
        }

        @Override
        public Coder<IntervalWindow> windowCoder() {
            return IntervalWindow.getCoder();
        }

        @Override
        public boolean isCompatible(WindowFn<?, ?> other) {
            if (!(other instanceof MonthsWindows)) {
                return false;
            }
            MonthsWindows that = (MonthsWindows)other;
            return this.number == that.number && this.dayOfMonth == that.dayOfMonth && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.timeZone, that.timeZone);
        }

        @Override
        public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
            if (!this.isCompatible(other)) {
                throw new IncompatibleWindowException(other, String.format("Only %s objects with the same number of months, day of month, start date and time zone are compatible.", MonthsWindows.class.getSimpleName()));
            }
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numMonths", this.number).withLabel("Window Months")).addIfNotDefault(DisplayData.item("startDate", new DateTime((Object)this.startDate, this.timeZone).toInstant()).withLabel("Window Start Date"), new DateTime((Object)DEFAULT_START_DATE, DateTimeZone.UTC).toInstant());
        }

        public int getNumber() {
            return this.number;
        }

        public int getDayOfMonth() {
            return this.dayOfMonth;
        }

        public DateTime getStartDate() {
            return this.startDate;
        }

        public DateTimeZone getTimeZone() {
            return this.timeZone;
        }
    }

    public static class DaysWindows
    extends PartitioningWindowFn<Object, IntervalWindow> {
        private int number;
        private DateTime startDate;
        private DateTimeZone timeZone;

        public DaysWindows withStartingDay(int year, int month, int day) {
            return new DaysWindows(this.number, new DateTime(year, month, day, 0, 0, this.timeZone), this.timeZone);
        }

        public DaysWindows withTimeZone(DateTimeZone timeZone) {
            return new DaysWindows(this.number, this.startDate.withZoneRetainFields(timeZone), timeZone);
        }

        private DaysWindows(int number, DateTime startDate, DateTimeZone timeZone) {
            this.number = number;
            this.startDate = startDate;
            this.timeZone = timeZone;
        }

        @Override
        public IntervalWindow assignWindow(Instant timestamp) {
            DateTime datetime = new DateTime((Object)timestamp, this.timeZone);
            int dayOffset = Days.daysBetween((ReadableInstant)this.startDate, (ReadableInstant)datetime).getDays() / this.number * this.number;
            DateTime begin = this.startDate.plusDays(dayOffset);
            DateTime end = begin.plusDays(this.number);
            return new IntervalWindow(begin.toInstant(), end.toInstant());
        }

        @Override
        public Coder<IntervalWindow> windowCoder() {
            return IntervalWindow.getCoder();
        }

        @Override
        public boolean isCompatible(WindowFn<?, ?> other) {
            if (!(other instanceof DaysWindows)) {
                return false;
            }
            DaysWindows that = (DaysWindows)other;
            return this.number == that.number && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.timeZone, that.timeZone);
        }

        @Override
        public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
            if (!this.isCompatible(other)) {
                throw new IncompatibleWindowException(other, String.format("Only %s objects with the same number of days, start date and time zone are compatible.", DaysWindows.class.getSimpleName()));
            }
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numDays", this.number).withLabel("Windows Days")).addIfNotDefault(DisplayData.item("startDate", new DateTime((Object)this.startDate, this.timeZone).toInstant()).withLabel("Window Start Date"), new DateTime((Object)DEFAULT_START_DATE, DateTimeZone.UTC).toInstant());
        }

        public int getNumber() {
            return this.number;
        }

        public DateTime getStartDate() {
            return this.startDate;
        }

        public DateTimeZone getTimeZone() {
            return this.timeZone;
        }
    }
}

