/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.beam.runners.spark.stateful.SparkTimerInternals;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class TimerUtils {
    public static <W extends BoundedWindow> void dropExpiredTimers(SparkTimerInternals sparkTimerInternals, WindowingStrategy<?, W> windowingStrategy) {
        Collection expiredTimers = sparkTimerInternals.getTimers().stream().filter(timer -> timer.getTimestamp().plus((ReadableDuration)windowingStrategy.getAllowedLateness()).isBefore((ReadableInstant)sparkTimerInternals.currentInputWatermarkTime())).collect(Collectors.toList());
        expiredTimers.forEach(sparkTimerInternals::deleteTimer);
    }
}

