/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.services.dataflow.model.DataflowPackage;
import java.util.List;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.PackageUtil;
import org.apache.beam.runners.dataflow.util.Stager;
import org.apache.beam.sdk.extensions.gcp.storage.GcsCreateOptions;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GcsStager
implements Stager {
    private @UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options;

    private GcsStager(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        this.options = options;
    }

    public static @UnknownKeyFor @NonNull @Initialized GcsStager fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new GcsStager((DataflowPipelineOptions)options.as(DataflowPipelineOptions.class));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DataflowPackage> stageFiles(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PackageUtil.StagedFile> filesToStage) {
        try (PackageUtil packageUtil = PackageUtil.withDefaultThreadPool();){
            List<DataflowPackage> list = packageUtil.stageClasspathElements(filesToStage, this.options.getStagingLocation(), (CreateOptions)this.buildCreateOptions());
            return list;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DataflowPackage stageToFile(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes, @UnknownKeyFor @NonNull @Initialized String baseName) {
        try (PackageUtil packageUtil = PackageUtil.withDefaultThreadPool();){
            DataflowPackage dataflowPackage = packageUtil.stageToFile(bytes, baseName, this.options.getStagingLocation(), (CreateOptions)this.buildCreateOptions());
            return dataflowPackage;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized GcsCreateOptions buildCreateOptions() {
        int uploadSizeBytes = (Integer)MoreObjects.firstNonNull((Object)this.options.getGcsUploadBufferSizeBytes(), (Object)0x100000);
        Preconditions.checkArgument((uploadSizeBytes > 0 ? 1 : 0) != 0, (Object)"gcsUploadBufferSizeBytes must be > 0");
        return ((GcsCreateOptions.Builder)GcsCreateOptions.builder().setGcsUploadBufferSizeBytes(Integer.valueOf(uploadSizeBytes)).setMimeType("application/octet-stream")).build();
    }
}

