/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.ICompressor;

public class NoopCompressor
implements ICompressor {
    public static NoopCompressor create(Map<String, String> ignored) {
        return new NoopCompressor();
    }

    @Override
    public int initialCompressedBufferLength(int chunkLength) {
        return chunkLength;
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        System.arraycopy(input, inputOffset, output, outputOffset, inputLength);
        return inputLength;
    }

    @Override
    public void compress(ByteBuffer input, ByteBuffer output) throws IOException {
        output.put(input);
    }

    @Override
    public void uncompress(ByteBuffer input, ByteBuffer output) throws IOException {
        output.put(input);
    }

    @Override
    public BufferType preferredBufferType() {
        return BufferType.ON_HEAP;
    }

    @Override
    public boolean supports(BufferType bufferType) {
        return true;
    }

    @Override
    public Set<String> supportedOptions() {
        return Collections.emptySet();
    }
}

