/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public class DataRange {
    public static final Serializer serializer = new Serializer();
    protected final AbstractBounds<PartitionPosition> keyRange;
    protected final ClusteringIndexFilter clusteringIndexFilter;

    public DataRange(AbstractBounds<PartitionPosition> range, ClusteringIndexFilter clusteringIndexFilter) {
        this.keyRange = range;
        this.clusteringIndexFilter = clusteringIndexFilter;
    }

    public static DataRange allData(IPartitioner partitioner) {
        return DataRange.forTokenRange(new Range<Token>(partitioner.getMinimumToken(), partitioner.getMinimumToken()));
    }

    public static DataRange forTokenRange(Range<Token> tokenRange) {
        return DataRange.forKeyRange(Range.makeRowRange(tokenRange));
    }

    public static DataRange forKeyRange(Range<PartitionPosition> keyRange) {
        return new DataRange(keyRange, new ClusteringIndexSliceFilter(Slices.ALL, false));
    }

    public static DataRange allData(IPartitioner partitioner, ClusteringIndexFilter filter) {
        return new DataRange(Range.makeRowRange(new Range<Token>(partitioner.getMinimumToken(), partitioner.getMinimumToken())), filter);
    }

    public AbstractBounds<PartitionPosition> keyRange() {
        return this.keyRange;
    }

    public PartitionPosition startKey() {
        return (PartitionPosition)this.keyRange.left;
    }

    public PartitionPosition stopKey() {
        return (PartitionPosition)this.keyRange.right;
    }

    public boolean isNamesQuery() {
        return this.clusteringIndexFilter instanceof ClusteringIndexNamesFilter;
    }

    public boolean isPaging() {
        return false;
    }

    public boolean isWrapAround() {
        return this.keyRange instanceof Range && ((Range)this.keyRange).isWrapAround();
    }

    public boolean contains(PartitionPosition pos) {
        return this.keyRange.contains(pos);
    }

    public boolean isUnrestricted(TableMetadata metadata) {
        return this.startKey().isMinimum() && this.stopKey().isMinimum() && (this.clusteringIndexFilter.selectsAllPartition() || metadata.clusteringColumns().isEmpty());
    }

    public boolean selectsAllPartition() {
        return this.clusteringIndexFilter.selectsAllPartition();
    }

    public boolean isReversed() {
        return this.clusteringIndexFilter.isReversed();
    }

    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.clusteringIndexFilter;
    }

    public DataRange forPaging(AbstractBounds<PartitionPosition> range, ClusteringComparator comparator, Clustering<?> lastReturned, boolean inclusive) {
        return new Paging(range, this.clusteringIndexFilter, comparator, lastReturned, inclusive);
    }

    public DataRange forSubRange(AbstractBounds<PartitionPosition> range) {
        return new DataRange(range, this.clusteringIndexFilter);
    }

    public String toString(TableMetadata metadata) {
        return String.format("range=%s pfilter=%s", this.keyRange.getString(metadata.partitionKeyType), this.clusteringIndexFilter.toString(metadata));
    }

    public String toCQLString(TableMetadata metadata, RowFilter rowFilter) {
        String filterString;
        if (this.isUnrestricted(metadata)) {
            return rowFilter.toCQLString();
        }
        StringBuilder sb = new StringBuilder();
        boolean needAnd = false;
        if (!this.startKey().isMinimum()) {
            this.appendClause(this.startKey(), sb, metadata, true, this.keyRange.isStartInclusive());
            needAnd = true;
        }
        if (!this.stopKey().isMinimum()) {
            if (needAnd) {
                sb.append(" AND ");
            }
            this.appendClause(this.stopKey(), sb, metadata, false, this.keyRange.isEndInclusive());
            needAnd = true;
        }
        if (!(filterString = this.clusteringIndexFilter.toCQLString(metadata, rowFilter)).isEmpty()) {
            sb.append(needAnd ? " AND " : "").append(filterString);
        }
        return sb.toString();
    }

    private void appendClause(PartitionPosition pos, StringBuilder sb, TableMetadata metadata, boolean isStart, boolean isInclusive) {
        sb.append("token(");
        sb.append(ColumnMetadata.toCQLString(metadata.partitionKeyColumns()));
        sb.append(") ");
        if (pos instanceof DecoratedKey) {
            sb.append(DataRange.getOperator(isStart, isInclusive)).append(" ");
            sb.append("token(");
            DataRange.appendKeyString(sb, metadata.partitionKeyType, ((DecoratedKey)pos).getKey());
            sb.append(")");
        } else {
            Token.KeyBound keyBound = (Token.KeyBound)pos;
            sb.append(DataRange.getOperator(isStart, isStart == keyBound.isMinimumBound)).append(" ");
            sb.append(keyBound.getToken());
        }
    }

    private static String getOperator(boolean isStart, boolean isInclusive) {
        return isStart ? (isInclusive ? ">=" : ">") : (isInclusive ? "<=" : "<");
    }

    public static void appendKeyString(StringBuilder sb, AbstractType<?> type, ByteBuffer key) {
        if (type instanceof CompositeType) {
            CompositeType ct = (CompositeType)type;
            ByteBuffer[] values = ct.split(key);
            for (int i = 0; i < ct.types.size(); ++i) {
                sb.append(i == 0 ? "" : ", ").append(ct.types.get(i).toCQLString(values[i]));
            }
        } else {
            sb.append(type.toCQLString(key));
        }
    }

    public static class Serializer {
        public void serialize(DataRange range, DataOutputPlus out, int version, TableMetadata metadata) throws IOException {
            AbstractBounds.rowPositionSerializer.serialize(range.keyRange, out, version);
            ClusteringIndexFilter.serializer.serialize(range.clusteringIndexFilter, out, version);
            boolean isPaging = range instanceof Paging;
            out.writeBoolean(isPaging);
            if (isPaging) {
                Clustering.serializer.serialize(((Paging)range).lastReturned, out, version, metadata.comparator.subtypes());
                out.writeBoolean(((Paging)range).inclusive);
            }
        }

        public DataRange deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            AbstractBounds<PartitionPosition> range = AbstractBounds.rowPositionSerializer.deserialize(in, metadata.partitioner, version);
            ClusteringIndexFilter filter = ClusteringIndexFilter.serializer.deserialize(in, version, metadata);
            if (in.readBoolean()) {
                ClusteringComparator comparator = metadata.comparator;
                Clustering<byte[]> lastReturned = Clustering.serializer.deserialize(in, version, comparator.subtypes());
                boolean inclusive = in.readBoolean();
                return new Paging(range, filter, comparator, lastReturned, inclusive);
            }
            return new DataRange(range, filter);
        }

        public long serializedSize(DataRange range, int version, TableMetadata metadata) {
            long size = AbstractBounds.rowPositionSerializer.serializedSize(range.keyRange, version) + ClusteringIndexFilter.serializer.serializedSize(range.clusteringIndexFilter, version) + 1L;
            if (range instanceof Paging) {
                size += Clustering.serializer.serializedSize(((Paging)range).lastReturned, version, metadata.comparator.subtypes());
                ++size;
            }
            return size;
        }
    }

    public static class Paging
    extends DataRange {
        private final ClusteringComparator comparator;
        private final Clustering<?> lastReturned;
        private final boolean inclusive;

        private Paging(AbstractBounds<PartitionPosition> range, ClusteringIndexFilter filter, ClusteringComparator comparator, Clustering<?> lastReturned, boolean inclusive) {
            super(range, filter);
            assert (!(range instanceof Range) || !((Range)range).isWrapAround() || ((PartitionPosition)range.right).isMinimum()) : range;
            assert (lastReturned != null);
            this.comparator = comparator;
            this.lastReturned = lastReturned;
            this.inclusive = inclusive;
        }

        @Override
        public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
            return key.equals(this.startKey()) ? this.clusteringIndexFilter.forPaging(this.comparator, this.lastReturned, this.inclusive) : this.clusteringIndexFilter;
        }

        @Override
        public DataRange forSubRange(AbstractBounds<PartitionPosition> range) {
            return ((PartitionPosition)range.left).equals(this.keyRange().left) ? new Paging(range, this.clusteringIndexFilter, this.comparator, this.lastReturned, this.inclusive) : new DataRange(range, this.clusteringIndexFilter);
        }

        public Clustering<?> getLastReturned() {
            return this.lastReturned;
        }

        @Override
        public boolean isPaging() {
            return true;
        }

        @Override
        public boolean isUnrestricted(TableMetadata metadata) {
            return false;
        }

        @Override
        public String toString(TableMetadata metadata) {
            return String.format("range=%s (paging) pfilter=%s lastReturned=%s (%s)", this.keyRange.getString(metadata.partitionKeyType), this.clusteringIndexFilter.toString(metadata), this.lastReturned.toString(metadata), this.inclusive ? "included" : "excluded");
        }
    }
}

