/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ssh;

import com.trilead.ssh2.Connection;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.ssh.SshData;
import org.apache.hop.pipeline.transforms.ssh.SshMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SshDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SshMeta.class;
    private Label wlCommandField;
    private CCombo wCommandField;
    private LabelTextVar wTimeOut;
    private final SshMeta input;
    private Button wDynamicCommand;
    private LabelTextVar wPort;
    private LabelTextVar wUserName;
    private LabelTextVar wPassword;
    private Button wUseKey;
    private TextVar wPrivateKey;
    private LabelTextVar wPassphrase;
    private LabelTextVar wResultOutFieldName;
    private LabelTextVar wResultErrFieldName;
    private Label wlCommand;
    private StyledTextComp wCommand;
    private LabelTextVar wProxyHost;
    private LabelTextVar wProxyPort;
    private LabelTextVar wProxyUsername;
    private LabelTextVar wProxyPassword;
    private LabelTextVar wServerName;
    private boolean gotPreviousFields = false;

    public SshDialog(Shell parent, IVariables variables, SshMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SSHDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"SSHDialog.General.Tab", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)fileLayout);
        Group wSettingsGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"SSHDialog.wSettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingGroupLayout);
        this.wServerName = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.Server.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        FormData fdServerName = new FormData();
        fdServerName.left = new FormAttachment(0, 0);
        fdServerName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData((Object)fdServerName);
        this.wPort = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.Port.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wPort);
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(0, 0);
        fdPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        this.wTimeOut = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.TimeOut.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.TimeOut.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        FormData fdTimeOut = new FormData();
        fdTimeOut.left = new FormAttachment(0, 0);
        fdTimeOut.top = new FormAttachment((Control)this.wPort, margin);
        fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData((Object)fdTimeOut);
        this.wUserName = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.UserName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.UserName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(0, 0);
        fdUserName.top = new FormAttachment((Control)this.wTimeOut, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        this.wPassword = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.Password.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.Password.Tooltip", (String[])new String[0]), true);
        PropsUi.setLook((Widget)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(0, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        Label wlUseKey = new Label((Composite)wSettingsGroup, 131072);
        wlUseKey.setText(BaseMessages.getString(PKG, (String)"SSHDialog.UseKey.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseKey);
        FormData fdlUseKey = new FormData();
        fdlUseKey.left = new FormAttachment(0, 0);
        fdlUseKey.top = new FormAttachment((Control)this.wPassword, margin);
        fdlUseKey.right = new FormAttachment(middle, -margin);
        wlUseKey.setLayoutData((Object)fdlUseKey);
        this.wUseKey = new Button((Composite)wSettingsGroup, 32);
        PropsUi.setLook((Widget)this.wUseKey);
        this.wUseKey.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.UseKey.Tooltip", (String[])new String[0]));
        FormData fdUseKey = new FormData();
        fdUseKey.left = new FormAttachment(middle, margin);
        fdUseKey.top = new FormAttachment((Control)wlUseKey, 0, 0x1000000);
        fdUseKey.right = new FormAttachment(100, 0);
        this.wUseKey.setLayoutData((Object)fdUseKey);
        this.wUseKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SshDialog.this.input.setChanged();
                SshDialog.this.activateKey();
            }
        });
        Button wbFilename = new Button((Composite)wSettingsGroup, 0x1000008);
        PropsUi.setLook((Widget)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, -margin);
        fdbFilename.top = new FormAttachment((Control)this.wUseKey, 2 * margin);
        wbFilename.setLayoutData((Object)fdbFilename);
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPrivateKey, (IVariables)this.variables, (String[])new String[]{"*.pem", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.PEMFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        Label wlPrivateKey = new Label((Composite)wSettingsGroup, 131076);
        PropsUi.setLook((Widget)wlPrivateKey);
        wlPrivateKey.setText(BaseMessages.getString(PKG, (String)"SSHDialog.PrivateKey.Label", (String[])new String[0]));
        FormData fdlPrivateKey = new FormData();
        fdlPrivateKey.left = new FormAttachment(0, 0);
        fdlPrivateKey.right = new FormAttachment(middle, 0);
        fdlPrivateKey.top = new FormAttachment((Control)this.wUseKey, 2 * margin);
        wlPrivateKey.setLayoutData((Object)fdlPrivateKey);
        this.wPrivateKey = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.wPrivateKey.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.PrivateKey.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wPassword);
        this.wPrivateKey.addModifyListener(lsMod);
        FormData fdPrivateKey = new FormData();
        fdPrivateKey.left = new FormAttachment(middle, margin);
        fdPrivateKey.top = new FormAttachment((Control)this.wUseKey, 2 * margin);
        fdPrivateKey.right = new FormAttachment((Control)wbFilename, -margin);
        this.wPrivateKey.setLayoutData((Object)fdPrivateKey);
        this.wPassphrase = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.Passphrase.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.Passphrase.Tooltip", (String[])new String[0]), true);
        PropsUi.setLook((Widget)this.wPassphrase);
        this.wPassphrase.addModifyListener(lsMod);
        FormData fdPassphrase = new FormData();
        fdPassphrase.left = new FormAttachment(0, 0);
        fdPassphrase.top = new FormAttachment((Control)wbFilename, margin);
        fdPassphrase.right = new FormAttachment(100, 0);
        this.wPassphrase.setLayoutData((Object)fdPassphrase);
        this.wProxyHost = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ProxyHost.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wProxyHost);
        this.wProxyHost.addModifyListener(lsMod);
        FormData fdProxyHost = new FormData();
        fdProxyHost.left = new FormAttachment(0, 0);
        fdProxyHost.top = new FormAttachment((Control)this.wPassphrase, 2 * margin);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
        this.wProxyPort = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ProxyPort.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wProxyPort);
        this.wProxyPort.addModifyListener(lsMod);
        FormData fdProxyPort = new FormData();
        fdProxyPort.left = new FormAttachment(0, 0);
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
        this.wProxyUsername = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.ProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ProxyUsername.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wProxyUsername);
        this.wProxyUsername.addModifyListener(lsMod);
        FormData fdProxyUsername = new FormData();
        fdProxyUsername.left = new FormAttachment(0, 0);
        fdProxyUsername.top = new FormAttachment((Control)this.wProxyPort, margin);
        fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData((Object)fdProxyUsername);
        this.wProxyPassword = new LabelTextVar(this.variables, (Composite)wSettingsGroup, BaseMessages.getString(PKG, (String)"SSHDialog.ProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ProxyPassword.Tooltip", (String[])new String[0]), true);
        PropsUi.setLook((Widget)this.wProxyUsername);
        this.wProxyPassword.addModifyListener(lsMod);
        FormData fdProxyPassword = new FormData();
        fdProxyPassword.left = new FormAttachment(0, 0);
        fdProxyPassword.top = new FormAttachment((Control)this.wProxyUsername, margin);
        fdProxyPassword.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData((Object)fdProxyPassword);
        Button wTest = new Button((Composite)wSettingsGroup, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"SSHDialog.TestConnection.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wProxyPassword, 2 * margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        wTest.addListener(13, e -> this.test());
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wSettingsTab = new CTabItem(wTabFolder, 0);
        wSettingsTab.setFont(GuiResource.getInstance().getFontDefault());
        wSettingsTab.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Settings.Tab", (String[])new String[0]));
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        Composite wSettingsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wSettingsComp);
        wSettingsComp.setLayout((Layout)settingsLayout);
        Group wOutput = new Group(wSettingsComp, 32);
        PropsUi.setLook((Widget)wOutput);
        wOutput.setText(BaseMessages.getString(PKG, (String)"SSHDialog.wOutput.Label", (String[])new String[0]));
        FormLayout outputGroupLayout = new FormLayout();
        outputGroupLayout.marginWidth = 10;
        outputGroupLayout.marginHeight = 10;
        wOutput.setLayout((Layout)outputGroupLayout);
        this.wResultOutFieldName = new LabelTextVar(this.variables, (Composite)wOutput, BaseMessages.getString(PKG, (String)"SSHDialog.ResultOutFieldName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ResultOutFieldName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResultOutFieldName);
        this.wResultOutFieldName.addModifyListener(lsMod);
        FormData fdResultOutFieldName = new FormData();
        fdResultOutFieldName.left = new FormAttachment(0, 0);
        fdResultOutFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdResultOutFieldName.right = new FormAttachment(100, 0);
        this.wResultOutFieldName.setLayoutData((Object)fdResultOutFieldName);
        this.wResultErrFieldName = new LabelTextVar(this.variables, (Composite)wOutput, BaseMessages.getString(PKG, (String)"SSHDialog.ResultErrFieldName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.ResultErrFieldName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResultErrFieldName);
        this.wResultErrFieldName.addModifyListener(lsMod);
        FormData fdResultErrFieldName = new FormData();
        fdResultErrFieldName.left = new FormAttachment(0, 0);
        fdResultErrFieldName.top = new FormAttachment((Control)this.wResultOutFieldName, margin);
        fdResultErrFieldName.right = new FormAttachment(100, 0);
        this.wResultErrFieldName.setLayoutData((Object)fdResultErrFieldName);
        FormData fdOutput = new FormData();
        fdOutput.left = new FormAttachment(0, margin);
        fdOutput.top = new FormAttachment((Control)this.wTransformName, margin);
        fdOutput.right = new FormAttachment(100, -margin);
        wOutput.setLayoutData((Object)fdOutput);
        Group wCommands = new Group(wSettingsComp, 32);
        PropsUi.setLook((Widget)wCommands);
        wCommands.setText(BaseMessages.getString(PKG, (String)"SSHDialog.LogSettings.Group.Label", (String[])new String[0]));
        FormLayout logSettingsgroupLayout = new FormLayout();
        logSettingsgroupLayout.marginWidth = 10;
        logSettingsgroupLayout.marginHeight = 10;
        wCommands.setLayout((Layout)logSettingsgroupLayout);
        Label wlDynamicCommand = new Label((Composite)wCommands, 131072);
        wlDynamicCommand.setText(BaseMessages.getString(PKG, (String)"SSHDialog.dynamicCommand.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDynamicCommand);
        FormData fdlDynamicBase = new FormData();
        fdlDynamicBase.left = new FormAttachment(0, margin);
        fdlDynamicBase.top = new FormAttachment((Control)wOutput, margin);
        fdlDynamicBase.right = new FormAttachment(middle, -margin);
        wlDynamicCommand.setLayoutData((Object)fdlDynamicBase);
        this.wDynamicCommand = new Button((Composite)wCommands, 32);
        PropsUi.setLook((Widget)this.wDynamicCommand);
        this.wDynamicCommand.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.dynamicCommand.Tooltip", (String[])new String[0]));
        FormData fdDynamicCommand = new FormData();
        fdDynamicCommand.left = new FormAttachment(middle, margin);
        fdDynamicCommand.top = new FormAttachment((Control)wlDynamicCommand, 0, 0x1000000);
        this.wDynamicCommand.setLayoutData((Object)fdDynamicCommand);
        this.wDynamicCommand.addListener(13, e -> {
            this.activateDynamicCommand();
            this.input.setChanged();
        });
        this.wlCommandField = new Label((Composite)wCommands, 131072);
        this.wlCommandField.setText(BaseMessages.getString(PKG, (String)"SSHDialog.MessageNameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCommandField);
        FormData fdlCommandField = new FormData();
        fdlCommandField.left = new FormAttachment(0, margin);
        fdlCommandField.right = new FormAttachment(middle, -margin);
        fdlCommandField.top = new FormAttachment((Control)this.wDynamicCommand, margin);
        this.wlCommandField.setLayoutData((Object)fdlCommandField);
        this.wCommandField = new CCombo((Composite)wCommands, 2056);
        PropsUi.setLook((Widget)this.wCommandField);
        this.wCommandField.setEditable(true);
        this.wCommandField.addModifyListener(lsMod);
        FormData fdCommandField = new FormData();
        fdCommandField.left = new FormAttachment(middle, margin);
        fdCommandField.top = new FormAttachment((Control)this.wDynamicCommand, margin);
        fdCommandField.right = new FormAttachment(100, 0);
        this.wCommandField.setLayoutData((Object)fdCommandField);
        this.wCommandField.addListener(15, e -> this.get());
        this.wlCommand = new Label((Composite)wCommands, 131072);
        this.wlCommand.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Command.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCommand);
        FormData fdlCommand = new FormData();
        fdlCommand.left = new FormAttachment(0, margin);
        fdlCommand.top = new FormAttachment((Control)this.wCommandField, margin);
        fdlCommand.right = new FormAttachment(middle, -margin);
        this.wlCommand.setLayoutData((Object)fdlCommand);
        this.wCommand = new StyledTextComp(this.variables, (Composite)wCommands, 19202);
        this.wCommand.setToolTipText(BaseMessages.getString(PKG, (String)"SSHDialog.Command.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCommand);
        this.wCommand.addModifyListener(lsMod);
        FormData fdCommand = new FormData();
        fdCommand.left = new FormAttachment(middle, margin);
        fdCommand.top = new FormAttachment((Control)this.wCommandField, margin);
        fdCommand.right = new FormAttachment(100, -2 * margin);
        fdCommand.bottom = new FormAttachment(100, -margin);
        this.wCommand.setLayoutData((Object)fdCommand);
        FormData fdLogSettings = new FormData();
        fdLogSettings.left = new FormAttachment(0, margin);
        fdLogSettings.top = new FormAttachment((Control)wOutput, margin);
        fdLogSettings.right = new FormAttachment(100, -margin);
        fdLogSettings.bottom = new FormAttachment(100, -margin);
        wCommands.setLayoutData((Object)fdLogSettings);
        FormData fdSettingsComp = new FormData();
        fdSettingsComp.left = new FormAttachment(0, 0);
        fdSettingsComp.top = new FormAttachment(0, 0);
        fdSettingsComp.right = new FormAttachment(100, 0);
        fdSettingsComp.bottom = new FormAttachment(100, 0);
        wSettingsComp.setLayoutData((Object)fdSettingsComp);
        wSettingsComp.layout();
        wSettingsTab.setControl((Control)wSettingsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTabFolder.setSelection(0);
        this.getData();
        this.activateKey();
        this.activateDynamicCommand();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wDynamicCommand.setSelection(this.input.isDynamicCommandField());
        if (this.input.getCommand() != null) {
            this.wCommand.setText(this.input.getCommand());
        }
        if (this.input.getCommandFieldName() != null) {
            this.wCommandField.setText(this.input.getCommandFieldName());
        }
        if (this.input.getServerName() != null) {
            this.wServerName.setText(this.input.getServerName());
        }
        if (this.input.getPort() != null) {
            this.wPort.setText(this.input.getPort());
        }
        if (this.input.getUserName() != null) {
            this.wUserName.setText(this.input.getUserName());
        }
        if (this.input.getPassword() != null) {
            this.wPassword.setText(this.input.getPassword());
        }
        this.wUseKey.setSelection(this.input.isUsePrivateKey());
        if (this.input.getKeyFileName() != null) {
            this.wPrivateKey.setText(this.input.getKeyFileName());
        }
        if (this.input.getPassPhrase() != null) {
            this.wPassphrase.setText(this.input.getPassPhrase());
        }
        if (this.input.getStdOutFieldName() != null) {
            this.wResultOutFieldName.setText(this.input.getStdOutFieldName());
        }
        if (this.input.getStdErrFieldName() != null) {
            this.wResultErrFieldName.setText(this.input.getStdErrFieldName());
        }
        this.wTimeOut.setText(Const.NVL((String)this.input.getTimeOut(), (String)"0"));
        if (this.input.getProxyHost() != null) {
            this.wProxyHost.setText(this.input.getProxyHost());
        }
        if (this.input.getProxyPort() != null) {
            this.wProxyPort.setText(this.input.getProxyPort());
        }
        if (this.input.getProxyUsername() != null) {
            this.wProxyUsername.setText(this.input.getProxyUsername());
        }
        if (this.input.getProxyPassword() != null) {
            this.wProxyPassword.setText(this.input.getProxyPassword());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(SshMeta in) {
        in.setDynamicCommandField(this.wDynamicCommand.getSelection());
        in.setCommand(this.wCommand.getText());
        in.setCommandFieldName(this.wCommandField.getText());
        in.setServerName(this.wServerName.getText());
        in.setPort(this.wPort.getText());
        in.setUserName(this.wUserName.getText());
        in.setPassword(this.wPassword.getText());
        in.setUsePrivateKey(this.wUseKey.getSelection());
        in.setKeyFileName(this.wPrivateKey.getText());
        in.setPassPhrase(this.wPassphrase.getText());
        in.setStdOutFieldName(this.wResultOutFieldName.getText());
        in.setStdErrFieldName(this.wResultErrFieldName.getText());
        in.setTimeOut(this.wTimeOut.getText());
        in.setProxyHost(this.wProxyHost.getText());
        in.setProxyPort(this.wProxyPort.getText());
        in.setProxyUsername(this.wProxyUsername.getText());
        in.setProxyPassword(this.wProxyPassword.getText());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void activateKey() {
        this.wPrivateKey.setEnabled(this.wUseKey.getSelection());
        this.wPassphrase.setEnabled(this.wUseKey.getSelection());
    }

    private void activateDynamicCommand() {
        this.wlCommand.setEnabled(!this.wDynamicCommand.getSelection());
        this.wCommand.setEnabled(!this.wDynamicCommand.getSelection());
        this.wlCommandField.setEnabled(this.wDynamicCommand.getSelection());
        this.wCommandField.setEnabled(this.wDynamicCommand.getSelection());
        this.wPreview.setEnabled(!this.wDynamicCommand.getSelection());
    }

    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String source = this.wCommandField.getText();
                this.wCommandField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wCommandField.setItems(r.getFieldNames());
                    if (source != null) {
                        this.wCommandField.setText(source);
                    }
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SSHDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() {
        Exception exception = null;
        String errMsg = null;
        Connection connection = null;
        SshMeta meta = new SshMeta();
        this.getInfo(meta);
        try {
            connection = SshData.openConnection(this.variables, meta);
        }
        catch (Exception e) {
            exception = e;
            errMsg = e.getMessage();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        if (exception == null) {
            MessageBox messageBox = new MessageBox(this.shell, 34);
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"SSHDialog.Connected.OK", (String[])new String[]{meta.getServerName(), meta.getUserName()}) + Const.CR);
            messageBox.setText(BaseMessages.getString(PKG, (String)"SSHDialog.Connected.Title.Ok", (String[])new String[0]));
            messageBox.open();
        } else {
            new ErrorDialog(this.shell, "Error", BaseMessages.getString(PKG, (String)"SSHDialog.Connected.NOK.ConnectionBad", (String[])new String[]{meta.getServerName(), meta.getUserName()}) + Const.CR + errMsg + Const.CR, exception);
        }
    }

    private void preview() {
        SshMeta oneMeta = new SshMeta();
        this.getInfo(oneMeta);
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, 1, BaseMessages.getString(PKG, (String)"SSHDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SSHDialog.NumberRows.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                prd.open();
            }
        }
    }
}

