/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DialogAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VPrinterOutput;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class OutputMoveAction
extends DialogAction
implements ActionListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_MOVE");
    private static final String prtOutToMoveText_ = ResourceLoader.getPrintText("PRINTER_OUTPUT_TO_MOVE") + ":";
    private static final String moveOutputText_ = ResourceLoader.getPrintText("MOVE_OUTPUT") + ":";
    private static final String useLibListText_ = ResourceLoader.getPrintText("USE_LIBRARY_LIST");
    private static final String printerText_ = ResourceLoader.getPrintText("PRINTER");
    private static final String outQText_ = ResourceLoader.getPrintText("OUTPUT_QUEUE");
    private static final String outQLibText_ = ResourceLoader.getPrintText("LIBRARY");
    private SpooledFile splF_ = null;
    private JRadioButton printerButton_ = null;
    private JTextField printerField_ = null;
    private JRadioButton outQButton_ = null;
    private JTextField outQField_ = null;
    private JComboBox outQLibBox_ = null;
    private VPrinterOutput parent_ = null;

    public OutputMoveAction(VObject object, SpooledFile splF, VPrinterOutput parent) {
        super(object);
        this.splF_ = splF;
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == printerText_) {
            this.printerField_.setEnabled(true);
            this.outQField_.setEnabled(false);
            this.outQLibBox_.setEnabled(false);
        } else {
            this.outQField_.setEnabled(true);
            this.outQLibBox_.setEnabled(true);
            this.printerField_.setEnabled(false);
        }
    }

    @Override
    public JComponent getInputComponent() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            VUtilities.constrain(new JLabel(prtOutToMoveText_), panel, layout, 0, 0, 1, 1);
            JTextField text = new JTextField(this.getObject().toString());
            text.setEditable(false);
            VUtilities.constrain(text, panel, layout, 0, 1, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 2, 2, 1);
            VUtilities.constrain(new JLabel(moveOutputText_), panel, layout, 0, 3, 1, 1);
            this.printerButton_ = new JRadioButton(printerText_);
            this.printerButton_.setHorizontalAlignment(2);
            this.printerButton_.setSelected(true);
            this.outQButton_ = new JRadioButton(outQText_);
            this.outQButton_.setHorizontalAlignment(2);
            this.printerButton_.addActionListener(this);
            this.outQButton_.addActionListener(this);
            ButtonGroup group = new ButtonGroup();
            group.add(this.printerButton_);
            group.add(this.outQButton_);
            this.printerField_ = new JTextField(10);
            VUtilities.constrain(this.printerButton_, panel, layout, 0, 4, 1, 1);
            VUtilities.constrain(this.printerField_, panel, layout, 1, 4, 1, 1);
            this.outQField_ = new JTextField(10);
            this.outQField_.setEnabled(false);
            VUtilities.constrain(this.outQButton_, panel, layout, 0, 5, 1, 1);
            VUtilities.constrain(this.outQField_, panel, layout, 1, 5, 1, 1);
            this.outQLibBox_ = new JComboBox();
            this.outQLibBox_.setEditable(true);
            this.outQLibBox_.addItem(useLibListText_);
            this.outQLibBox_.setEnabled(false);
            VUtilities.constrain(new JLabel(outQLibText_), panel, layout, 0, 6, 1, 1);
            VUtilities.constrain(this.outQLibBox_, panel, layout, 1, 6, 1, 1);
        }
        catch (Exception e) {
            panel = null;
            this.fireError(e);
        }
        return panel;
    }

    @Override
    public String getText() {
        return displayName_;
    }

    @Override
    public void perform2() {
        try {
            if (this.printerButton_.isSelected()) {
                String ptr = this.printerField_.getText().trim();
                OutputQueue outQ = new OutputQueue(this.splF_.getSystem(), "/QSYS.LIB/QUSRSYS.LIB/" + ptr + ".OUTQ");
                this.fireStartWorking();
                this.splF_.move(outQ);
                this.fireStopWorking();
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Moved file [" + this.splF_.getName() + "].");
                }
            } else {
                String outputQ = this.outQField_.getText().trim();
                String outputQLib = (String)this.outQLibBox_.getSelectedItem();
                OutputQueue outQ = null;
                outQ = outputQLib.equals(useLibListText_) ? new OutputQueue(this.splF_.getSystem(), "/QSYS.LIB/%LIBL%.LIB/" + outputQ + ".OUTQ") : new OutputQueue(this.splF_.getSystem(), "/QSYS.LIB/" + outputQLib + ".LIB/" + outputQ + ".OUTQ");
                this.fireStartWorking();
                this.splF_.move(outQ);
                this.fireStopWorking();
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Moved file [" + this.splF_.getName() + "].");
                }
            }
            this.fireObjectChanged(this.parent_);
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR Moving file [" + this.splF_.getName() + "].");
            }
            this.fireError(e);
        }
    }
}

