/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.data.Descriptor;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;

class ProgramMapEntry
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final ResourceLevel defaultLevel_ = new ResourceLevel();
    private String programName_ = null;
    private String dataName_ = null;
    private int[] indices_ = null;
    private String countName_ = null;
    private ResourceLevel level_ = null;
    private ValueMap valueMap_ = null;

    public ProgramMapEntry(String programName, String dataName, int[] indices, ValueMap valueMap, ResourceLevel level) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.programName_ = programName;
        this.dataName_ = dataName;
        this.indices_ = indices;
        this.countName_ = null;
        this.valueMap_ = valueMap;
        this.level_ = level == null ? defaultLevel_ : level;
    }

    public ProgramMapEntry(String programName, String dataName, String countName, ValueMap valueMap, ResourceLevel level) {
        if (dataName == null) {
            throw new NullPointerException("dataName");
        }
        this.programName_ = programName;
        this.dataName_ = dataName;
        this.indices_ = null;
        this.countName_ = countName;
        this.valueMap_ = valueMap;
        this.level_ = level == null ? defaultLevel_ : level;
    }

    public String getProgramName() {
        return this.programName_;
    }

    public ResourceLevel getLevel() {
        return this.level_;
    }

    public Object getValue(AS400 system, ProgramCallDocument document, String programName, int[] indices, int bidiStringType) throws PcmlException {
        Object value;
        int[] indicesToUse;
        if (programName != null && this.programName_ != null) {
            throw new ExtendedIllegalArgumentException("programName", 2);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(programName == null ? this.programName_ : programName);
        buffer.append('.');
        buffer.append(this.dataName_);
        String programNameAndDataName = buffer.toString();
        if (indices != null && this.indices_ != null) {
            throw new ExtendedIllegalArgumentException("indices", 2);
        }
        int[] nArray = indicesToUse = indices == null ? this.indices_ : indices;
        if (indicesToUse == null && this.countName_ == null) {
            value = ProgramMapEntry.isStringValue(document, programNameAndDataName) ? document.getStringValue(programNameAndDataName, bidiStringType) : document.getValue(programNameAndDataName);
        } else if (this.countName_ == null) {
            value = ProgramMapEntry.isStringValue(document, programNameAndDataName) ? document.getStringValue(programNameAndDataName, indicesToUse, bidiStringType) : document.getValue(programNameAndDataName, indicesToUse);
        } else {
            buffer = new StringBuffer();
            buffer.append(programName == null ? this.programName_ : programName);
            buffer.append('.');
            buffer.append(this.countName_);
            String programNameAndCountName = buffer.toString();
            int count = document.getIntValue(programNameAndCountName);
            Object[] tempValue = new Object[count];
            for (int i = 0; i < count; ++i) {
                tempValue[i] = document.getValue(programNameAndDataName, new int[]{i});
            }
            value = tempValue;
        }
        if (this.valueMap_ != null) {
            value = this.valueMap_.ptol(value, system);
        }
        return value;
    }

    private static boolean isStringValue(ProgramCallDocument document, String programNameAndDataName) {
        Descriptor descriptor = document.getDescriptor().getDescriptor(programNameAndDataName);
        if (descriptor == null) {
            return false;
        }
        String type = descriptor.getAttributeValue("type");
        if (type == null) {
            return false;
        }
        return type.equals("string");
    }

    public void setValue(AS400 system, ProgramCallDocument document, String programName, int[] indices, Object value, int bidiStringType) throws PcmlException {
        int[] indicesToUse;
        if (programName != null && this.programName_ != null) {
            throw new ExtendedIllegalArgumentException("programName", 2);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(programName == null ? this.programName_ : programName);
        buffer.append('.');
        buffer.append(this.dataName_);
        String programNameAndDataName = buffer.toString();
        if (indices != null && this.indices_ != null) {
            throw new ExtendedIllegalArgumentException("indices", 2);
        }
        int[] nArray = indicesToUse = indices == null ? this.indices_ : indices;
        if (this.valueMap_ != null) {
            value = this.valueMap_.ltop(value, system);
        }
        if (indicesToUse == null) {
            if (value instanceof String) {
                document.setStringValue(programNameAndDataName, (String)value, bidiStringType);
            } else {
                document.setValue(programNameAndDataName, value);
            }
        } else if (value instanceof String) {
            document.setStringValue(programNameAndDataName, indicesToUse, (String)value, bidiStringType);
        } else {
            document.setValue(programNameAndDataName, indicesToUse, value);
        }
    }
}

