/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hop.core.SwingUniversalImageSvg;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.svg.SvgImage;
import org.apache.hop.core.svg.SvgSupport;

public class SwingGUIResource {
    private static ILogChannel log = LogChannel.GENERAL;
    private static SwingGUIResource instance;
    private Map<String, SwingUniversalImageSvg> transformImages = this.loadTransformImages();
    private Map<String, SwingUniversalImageSvg> actionImages = this.loadActionImages();

    private SwingGUIResource() {
    }

    public static SwingGUIResource getInstance() {
        if (instance == null) {
            instance = new SwingGUIResource();
        }
        return instance;
    }

    private Map<String, SwingUniversalImageSvg> loadTransformImages() {
        HashMap<String, SwingUniversalImageSvg> map = new HashMap<String, SwingUniversalImageSvg>();
        for (IPlugin plugin : PluginRegistry.getInstance().getPlugins(TransformPluginType.class)) {
            try {
                SwingUniversalImageSvg image = this.getUniversalImageIcon(plugin);
                for (String id : plugin.getIds()) {
                    map.put(id, image);
                }
            }
            catch (Exception e) {
                log.logError("Unable to load transform icon image for plugin: " + plugin.getName() + " (id=" + plugin.getIds()[0] + ")", (Throwable)e);
            }
        }
        return map;
    }

    private Map<String, SwingUniversalImageSvg> loadActionImages() {
        HashMap<String, SwingUniversalImageSvg> map = new HashMap<String, SwingUniversalImageSvg>();
        for (IPlugin plugin : PluginRegistry.getInstance().getPlugins(ActionPluginType.class)) {
            try {
                SwingUniversalImageSvg image = this.getUniversalImageIcon(plugin);
                if (image == null) {
                    throw new HopException("Unable to find image file: " + plugin.getImageFile() + " for plugin: " + String.valueOf(plugin));
                }
                map.put(plugin.getIds()[0], image);
            }
            catch (Exception e) {
                log.logError("Unable to load action icon image for plugin: " + plugin.getName() + " (id=" + plugin.getIds()[0] + ")", (Throwable)e);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwingUniversalImageSvg getUniversalImageIcon(IPlugin plugin) throws HopException {
        try {
            PluginRegistry registry = PluginRegistry.getInstance();
            String filename = plugin.getImageFile();
            ClassLoader classLoader = registry.getClassLoader(plugin);
            SwingUniversalImageSvg image = null;
            if (SvgSupport.isSvgEnabled() && SvgSupport.isSvgName((String)filename)) {
                InputStream inputStream = classLoader.getResourceAsStream(filename);
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream("/" + filename);
                }
                if (inputStream == null) {
                    inputStream = registry.getClass().getResourceAsStream(filename);
                }
                if (inputStream == null) {
                    inputStream = registry.getClass().getResourceAsStream("/" + filename);
                }
                if (inputStream == null) {
                    try {
                        inputStream = new FileInputStream(filename);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        SvgImage svg = SvgSupport.loadSvgImage((InputStream)inputStream);
                        image = new SwingUniversalImageSvg(svg);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                }
            }
            if (image == null) {
                throw new HopException("Unable to find file: " + plugin.getImageFile() + " for plugin: " + String.valueOf(plugin));
            }
            return image;
        }
        catch (Throwable e) {
            throw new HopException("Unable to load image from file : '" + plugin.getImageFile() + "' for plugin: " + String.valueOf(plugin), e);
        }
    }

    public Map<String, SwingUniversalImageSvg> getActionImages() {
        return this.actionImages;
    }

    public Map<String, SwingUniversalImageSvg> getTransformImages() {
        return this.transformImages;
    }
}

