/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionException;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElectionUtils;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationRegister;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLeaderElectionService
extends DefaultLeaderElection.ParentService
implements LeaderElectionService,
LeaderElectionDriver.Listener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLeaderElectionService.class);
    private static final String LEADER_ACQUISITION_EVENT_LOG_NAME = "Leader Acquisition";
    private static final String LEADER_REVOCATION_EVENT_LOG_NAME = "Leader Revocation";
    private final Object lock = new Object();
    private final LeaderElectionDriverFactory leaderElectionDriverFactory;
    @GuardedBy(value="lock")
    private final Map<String, LeaderContender> leaderContenderRegistry = new HashMap<String, LeaderContender>();
    @Nullable
    @GuardedBy(value="lock")
    private UUID issuedLeaderSessionID;
    @GuardedBy(value="lock")
    private LeaderInformationRegister confirmedLeaderInformation;
    @GuardedBy(value="lock")
    private boolean running;
    @GuardedBy(value="lock")
    private LeaderElectionDriver leaderElectionDriver;
    private final ExecutorService leadershipOperationExecutor;
    private final FatalErrorHandler fallbackErrorHandler;

    public DefaultLeaderElectionService(LeaderElectionDriverFactory leaderElectionDriverFactory) {
        this(leaderElectionDriverFactory, t -> LOG.debug("Ignoring error notification since there's no contender registered."));
    }

    @VisibleForTesting
    public DefaultLeaderElectionService(LeaderElectionDriverFactory leaderElectionDriverFactory, FatalErrorHandler fallbackErrorHandler) {
        this(leaderElectionDriverFactory, fallbackErrorHandler, Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("DefaultLeaderElectionService-leadershipOperationExecutor")));
    }

    @VisibleForTesting
    DefaultLeaderElectionService(LeaderElectionDriverFactory leaderElectionDriverFactory, FatalErrorHandler fallbackErrorHandler, ExecutorService leadershipOperationExecutor) {
        this.leaderElectionDriverFactory = (LeaderElectionDriverFactory)Preconditions.checkNotNull((Object)leaderElectionDriverFactory);
        this.fallbackErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fallbackErrorHandler);
        this.issuedLeaderSessionID = null;
        this.leaderElectionDriver = null;
        this.confirmedLeaderInformation = LeaderInformationRegister.empty();
        this.leadershipOperationExecutor = (ExecutorService)Preconditions.checkNotNull((Object)leadershipOperationExecutor);
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElection createLeaderElection(String componentId) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.leadershipOperationExecutor.isShutdown() ? 1 : 0) != 0, (Object)"The service was already closed and cannot be reused.");
            Preconditions.checkState((!this.leaderContenderRegistry.containsKey(componentId) ? 1 : 0) != 0, (String)"There shouldn't be any contender registered under the passed component '%s'.", (Object[])new Object[]{componentId});
            return new DefaultLeaderElection(this, componentId);
        }
    }

    @GuardedBy(value="lock")
    private void createLeaderElectionDriver() throws Exception {
        Preconditions.checkState((boolean)this.leaderContenderRegistry.isEmpty(), (Object)"No LeaderContender should have been registered, yet.");
        Preconditions.checkState((this.leaderElectionDriver == null ? 1 : 0) != 0, (Object)"This DefaultLeaderElectionService cannot be reused. Calling startLeaderElectionBackend can only be called once to establish the connection to the HA backend.");
        this.leaderElectionDriver = this.leaderElectionDriverFactory.create(this);
        LOG.info("A connection to the HA backend was established through LeaderElectionDriver {}.", (Object)this.leaderElectionDriver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void register(String componentId, LeaderContender contender) throws Exception {
        Preconditions.checkNotNull((Object)componentId, (String)"componentId must not be null.");
        Preconditions.checkNotNull((Object)contender, (String)"Contender must not be null.");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.running, (Object)"The DefaultLeaderElectionService should have established a connection to the backend before it's started.");
            if (this.leaderElectionDriver == null) {
                this.createLeaderElectionDriver();
            }
            Preconditions.checkState((this.leaderContenderRegistry.put(componentId, contender) == null ? 1 : 0) != 0, (String)"There shouldn't be any contender registered under the passed component '%s'.", (Object[])new Object[]{componentId});
            LOG.info("LeaderContender has been registered under component '{}' for {}.", (Object)componentId, (Object)this.leaderElectionDriver);
            if (this.issuedLeaderSessionID != null) {
                this.runInLeaderEventThread(LEADER_ACQUISITION_EVENT_LOG_NAME, () -> this.notifyLeaderContenderOfLeadership(componentId, this.issuedLeaderSessionID));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void remove(String componentId) throws Exception {
        AutoCloseable driverToClose = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.leaderContenderRegistry.containsKey(componentId)) {
                LOG.debug("There is no contender registered under component '{}' anymore. No action necessary.", (Object)componentId);
                return;
            }
            Preconditions.checkState((this.leaderElectionDriver != null ? 1 : 0) != 0, (Object)"The LeaderElectionDriver should be instantiated.");
            LOG.info("Deregistering contender with component '{}' from the DefaultLeaderElectionService.", (Object)componentId);
            LeaderContender leaderContender = this.leaderContenderRegistry.remove(componentId);
            Preconditions.checkNotNull((Object)leaderContender, (String)"There should be a LeaderContender registered under the given component '%s'.", (Object[])new Object[]{componentId});
            if (this.issuedLeaderSessionID != null) {
                this.notifyLeaderContenderOfLeadershipLoss(componentId, leaderContender);
                LOG.debug("The contender associated with component '{}' is deregistered while the service has the leadership acquired. The revoke event is forwarded to the LeaderContender.", (Object)componentId);
                if (this.leaderElectionDriver.hasLeadership()) {
                    this.leaderElectionDriver.deleteLeaderInformation(componentId);
                    LOG.debug("Leader information is cleaned up while deregistering the contender for component '{}' from the service.", (Object)componentId);
                }
            } else {
                Preconditions.checkState((boolean)this.confirmedLeaderInformation.hasNoLeaderInformation(), (Object)"The confirmed leader information should have been cleared during leadership revocation.");
                LOG.debug("Contender associated with component '{}' is deregistered while the service doesn't have the leadership acquired. No cleanup necessary.", (Object)componentId);
            }
            if (this.leaderContenderRegistry.isEmpty()) {
                driverToClose = this.deregisterDriver();
            }
        }
        if (driverToClose != null) {
            driverToClose.close();
        }
    }

    @GuardedBy(value="lock")
    private AutoCloseable deregisterDriver() {
        Preconditions.checkState((boolean)this.leaderContenderRegistry.isEmpty(), (Object)"No contender should be registered when deregistering the driver.");
        Preconditions.checkState((this.leaderElectionDriver != null ? 1 : 0) != 0, (Object)"There should be a driver instantiated that's ready to be closed.");
        this.issuedLeaderSessionID = null;
        LeaderElectionDriver driverToClose = this.leaderElectionDriver;
        this.leaderElectionDriver = null;
        return driverToClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.leaderContenderRegistry.isEmpty(), (Object)"The DefaultLeaderElectionService should have been stopped before closing the instance.");
            Preconditions.checkState((this.leaderElectionDriver == null ? 1 : 0) != 0, (Object)"The driver should have been closed.");
            if (!this.running) {
                LOG.debug("The HA backend connection isn't established. No actions taken.");
                return;
            }
            this.running = false;
        }
        List<Runnable> outstandingEventHandlingCalls = this.leadershipOperationExecutor.shutdownNow();
        if (!outstandingEventHandlingCalls.isEmpty()) {
            LOG.debug("The DefaultLeaderElectionService was closed with {} event(s) still not being processed. No further action necessary.", (Object)outstandingEventHandlingCalls.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void confirmLeadership(String componentId, UUID leaderSessionID, String leaderAddress) {
        Preconditions.checkArgument((boolean)this.leaderContenderRegistry.containsKey(componentId));
        LOG.debug("The leader session for component '{}' is confirmed with session ID {} and address {}.", new Object[]{componentId, leaderSessionID, leaderAddress});
        Preconditions.checkNotNull((Object)leaderSessionID);
        Object object = this.lock;
        synchronized (object) {
            if (this.hasLeadership(componentId, leaderSessionID)) {
                Preconditions.checkState((this.leaderElectionDriver != null ? 1 : 0) != 0, (Object)"The leadership check should only return true if a driver is instantiated.");
                Preconditions.checkState((!this.confirmedLeaderInformation.hasLeaderInformation(componentId) ? 1 : 0) != 0, (Object)"No confirmation should have happened, yet.");
                LeaderInformation newConfirmedLeaderInformation = LeaderInformation.known(leaderSessionID, leaderAddress);
                this.confirmedLeaderInformation = LeaderInformationRegister.merge(this.confirmedLeaderInformation, componentId, newConfirmedLeaderInformation);
                this.leaderElectionDriver.publishLeaderInformation(componentId, newConfirmedLeaderInformation);
            } else if (!leaderSessionID.equals(this.issuedLeaderSessionID)) {
                LOG.debug("Received an old confirmation call of leader session ID {} for component '{}' (current issued session ID is {}).", new Object[]{leaderSessionID, componentId, this.issuedLeaderSessionID});
            } else {
                LOG.warn("The leader session ID {} for component '{}' was confirmed even though the corresponding service was not elected as the leader or has been stopped already.", (Object)componentId, (Object)leaderSessionID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasLeadership(String componentId, UUID leaderSessionId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.leaderElectionDriver != null) {
                if (this.leaderContenderRegistry.containsKey(componentId)) {
                    return this.leaderElectionDriver.hasLeadership() && leaderSessionId.equals(this.issuedLeaderSessionID);
                }
                LOG.debug("hasLeadership is called for component '{}' while there is no contender registered under that ID in the service, returning false.", (Object)componentId);
                return false;
            }
            LOG.debug("hasLeadership is called after the service is closed, returning false.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @VisibleForTesting
    public UUID getLeaderSessionID(String componentId) {
        Object object = this.lock;
        synchronized (object) {
            return this.leaderContenderRegistry.containsKey(componentId) ? this.confirmedLeaderInformation.forComponentIdOrEmpty(componentId).getLeaderSessionID() : null;
        }
    }

    @GuardedBy(value="lock")
    private void onGrantLeadershipInternal(UUID newLeaderSessionId) {
        Preconditions.checkNotNull((Object)newLeaderSessionId);
        Preconditions.checkState((this.issuedLeaderSessionID == null ? 1 : 0) != 0, (Object)"The leadership should have been granted while not having the leadership acquired.");
        this.issuedLeaderSessionID = newLeaderSessionId;
        this.leaderContenderRegistry.keySet().forEach(componentId -> this.notifyLeaderContenderOfLeadership((String)componentId, this.issuedLeaderSessionID));
    }

    @GuardedBy(value="lock")
    private void notifyLeaderContenderOfLeadership(String componentId, UUID sessionID) {
        if (!this.leaderContenderRegistry.containsKey(componentId)) {
            LOG.debug("The grant leadership notification for session ID {} is not forwarded because the DefaultLeaderElectionService ({}) has no contender registered.", (Object)sessionID, (Object)this.leaderElectionDriver);
            return;
        }
        if (!sessionID.equals(this.issuedLeaderSessionID)) {
            LOG.debug("An out-dated leadership-acquired event with session ID {} was triggered. The current leader session ID is {}. The event will be ignored.", (Object)sessionID, (Object)this.issuedLeaderSessionID);
            return;
        }
        Preconditions.checkState((!this.confirmedLeaderInformation.hasLeaderInformation(componentId) ? 1 : 0) != 0, (Object)"The leadership should have been granted while not having the leadership acquired.");
        LOG.debug("Granting leadership to the contender registered under component '{}' with session ID {}.", (Object)componentId, (Object)this.issuedLeaderSessionID);
        this.leaderContenderRegistry.get(componentId).grantLeadership(this.issuedLeaderSessionID);
    }

    @GuardedBy(value="lock")
    private void onRevokeLeadershipInternal() {
        Preconditions.checkState((this.issuedLeaderSessionID != null ? 1 : 0) != 0, (Object)"The leadership should have been revoked while having the leadership acquired.");
        if (!this.leaderContenderRegistry.isEmpty()) {
            this.leaderContenderRegistry.forEach(this::notifyLeaderContenderOfLeadershipLoss);
        } else {
            LOG.debug("The revoke leadership notification for session {} is not forwarded because the DefaultLeaderElectionService({}) has no contender registered.", (Object)this.issuedLeaderSessionID, (Object)this.leaderElectionDriver);
        }
        this.issuedLeaderSessionID = null;
    }

    @GuardedBy(value="lock")
    private void notifyLeaderContenderOfLeadershipLoss(String componentId, LeaderContender leaderContender) {
        Preconditions.checkState((leaderContender != null ? 1 : 0) != 0, (Object)"The LeaderContender should be always set when calling this method.");
        if (!this.confirmedLeaderInformation.hasLeaderInformation(componentId)) {
            LOG.debug("Revoking leadership for component '{}' while a previous leadership grant wasn't confirmed, yet.", (Object)componentId);
        } else {
            LOG.debug("Revoking leadership to component '{}' for previously confirmed leader information {}.", (Object)componentId, (Object)LeaderElectionUtils.convertToString(this.confirmedLeaderInformation.forComponentIdOrEmpty(componentId)));
        }
        this.confirmedLeaderInformation = LeaderInformationRegister.clear(this.confirmedLeaderInformation, componentId);
        leaderContender.revokeLeadership();
    }

    @GuardedBy(value="lock")
    private void notifyLeaderInformationChangeInternal(String componentId, LeaderInformation externallyChangedLeaderInformation, LeaderInformation confirmedLeaderInformation) {
        if (this.leaderElectionDriver == null) {
            LOG.debug("The LeaderElectionDriver was disconnected. Any incoming events will be ignored.");
            return;
        }
        if (confirmedLeaderInformation.equals(externallyChangedLeaderInformation)) {
            LOG.trace("LeaderInformation change event received but changed LeaderInformation actually matches the locally confirmed one: {}", (Object)confirmedLeaderInformation);
            return;
        }
        if (confirmedLeaderInformation.isEmpty()) {
            LOG.trace("Leader information changed while there's no confirmation available by the contender for component '{}', yet. Changed leader information {} will be reset.", (Object)componentId, (Object)LeaderElectionUtils.convertToString(externallyChangedLeaderInformation));
        } else if (externallyChangedLeaderInformation.isEmpty()) {
            LOG.debug("Re-writing leader information ({}) for component '{}' to overwrite the empty leader information in the external storage.", (Object)LeaderElectionUtils.convertToString(confirmedLeaderInformation), (Object)componentId);
        } else {
            LOG.debug("Correcting leader information for component '{}' (local: {}, external storage: {}).", new Object[]{componentId, LeaderElectionUtils.convertToString(confirmedLeaderInformation), LeaderElectionUtils.convertToString(externallyChangedLeaderInformation)});
        }
        this.leaderElectionDriver.publishLeaderInformation(componentId, confirmedLeaderInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInLeaderEventThread(String leaderElectionEventName, Runnable callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                LOG.debug("'{}' event processing triggered.", (Object)leaderElectionEventName);
                FutureUtils.handleUncaughtException(CompletableFuture.runAsync(() -> {
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.running) {
                            LOG.debug("Processing '{}' event omitted due to the service not being in running state, anymore.", (Object)leaderElectionEventName);
                        } else if (this.leaderElectionDriver == null) {
                            Preconditions.checkState((boolean)this.leaderContenderRegistry.isEmpty(), (Object)"All contenders should be deregistered when the driver is removed.");
                            LOG.debug("All contenders have been deregistered and the driver was shut down. Any incoming leadership event will be ignored.");
                        } else {
                            LOG.debug("Processing '{}' event.", (Object)leaderElectionEventName);
                            callback.run();
                        }
                    }
                }, this.leadershipOperationExecutor), (thread, error) -> this.forwardErrorToLeaderContender(error));
            } else {
                LOG.debug("'{}' event processing was triggered while the DefaultLeaderElectionService is closed. The event will be ignored.", (Object)leaderElectionEventName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardErrorToLeaderContender(Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            if (this.leaderContenderRegistry.isEmpty()) {
                this.fallbackErrorHandler.onFatalError(t);
                return;
            }
            this.leaderContenderRegistry.values().forEach(leaderContender -> {
                if (t instanceof LeaderElectionException) {
                    leaderContender.handleError((Exception)((Object)((LeaderElectionException)((Object)((Object)t)))));
                } else {
                    leaderContender.handleError((Exception)((Object)new LeaderElectionException(t)));
                }
            });
        }
    }

    @Override
    public void onGrantLeadership(UUID leaderSessionID) {
        this.runInLeaderEventThread(LEADER_ACQUISITION_EVENT_LOG_NAME, () -> this.onGrantLeadershipInternal(leaderSessionID));
    }

    @Override
    public void onRevokeLeadership() {
        this.runInLeaderEventThread(LEADER_REVOCATION_EVENT_LOG_NAME, this::onRevokeLeadershipInternal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLeaderInformationChange(String componentId, LeaderInformation leaderInformation) {
        Object object = this.lock;
        synchronized (object) {
            this.notifyLeaderInformationChangeInternal(componentId, leaderInformation, this.confirmedLeaderInformation.forComponentIdOrEmpty(componentId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLeaderInformationChange(LeaderInformationRegister changedLeaderInformation) {
        Object object = this.lock;
        synchronized (object) {
            this.leaderContenderRegistry.forEach((componentId, leaderContender) -> {
                LeaderInformation externallyChangedLeaderInformationForContender = changedLeaderInformation.forComponentId((String)componentId).orElse(LeaderInformation.empty());
                LeaderInformation confirmedLeaderInformationForContender = this.confirmedLeaderInformation.forComponentIdOrEmpty((String)componentId);
                this.notifyLeaderInformationChangeInternal((String)componentId, externallyChangedLeaderInformationForContender, confirmedLeaderInformationForContender);
            });
        }
    }

    @Override
    public void onError(Throwable t) {
        this.forwardErrorToLeaderContender(t);
    }
}

