/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.jackson.DefaultPrettyPrinter;
import org.gridkit.jvmtool.jackson.Indenter;
import org.gridkit.jvmtool.jackson.JsonGenerationException;
import org.gridkit.jvmtool.jackson.PrettyPrinter;
import org.gridkit.jvmtool.spi.parsers.FileInputStreamSource;
import org.gridkit.jvmtool.spi.parsers.InputStreamSource;
import org.gridkit.jvmtool.spi.parsers.JsonEventDumpHelper;
import org.gridkit.jvmtool.spi.parsers.JsonEventSource;
import org.gridkit.jvmtool.util.json.JsonStreamWriter;
import org.gridkit.jvmtool.util.json.SmartJsonWriter;

public class Jfr2JsonCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "jfr2json";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new Jfr2Json(host);
    }

    @Parameters(commandDescription="[JFR 2 JSON] Flight decoder, command translates JFR files into JSON")
    public static class Jfr2Json
    implements Runnable {
        @Parameter(names={"-i", "--input"}, required=true)
        private String input;
        @Parameter(names={"-o", "--output"}, required=false)
        private String output;
        @Parameter(names={"-wl", "--whitelist"}, variableArity=true, required=false, description="Include only specified event types")
        private List<String> whileList;
        @Parameter(names={"-bl", "--blacklist"}, variableArity=true, required=false, description="Exclude listed event types")
        private List<String> blackList;
        @Parameter(names={"--max-depth"}, required=false)
        private int jsonMaxDepth = 32;
        @Parameter(names={"--force-jdk-parser"}, required=false)
        private boolean forceJdkParser = false;
        @Parameter(names={"--force-mc-parser"}, required=false)
        private boolean forceMcParser = false;
        @Parameter(names={"--list-types"}, required=false, description="Outputs list of distinct event types")
        private boolean listTypes = false;
        @ParametersDelegate
        private CommandLauncher host;

        public Jfr2Json(CommandLauncher host) {
            this.host = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StringBuilder sb;
                if (!new File(this.input).isFile()) {
                    this.host.fail(new String[]{"Input file is not found", new File(this.input).getAbsolutePath()});
                }
                FileInputStreamSource iss = new FileInputStreamSource(new File(this.input));
                HashMap<String, String> options = new HashMap<String, String>();
                if (this.forceJdkParser && this.forceMcParser) {
                    this.host.failAndPrintUsage(new String[]{"--force-jdk-parser and --force-mc-parser are mutually exclusive options"});
                }
                if (this.forceJdkParser) {
                    options.put("jfr.native_parser", "true");
                }
                if (this.forceMcParser) {
                    options.put("jfr.native_parser", "false");
                }
                options.put("json.max_depth", String.valueOf(this.jsonMaxDepth));
                if (this.whileList != null) {
                    sb = new StringBuilder();
                    for (String e : this.whileList) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(e);
                    }
                    options.put("jfr.whitelist", sb.toString());
                }
                if (this.blackList != null) {
                    sb = new StringBuilder();
                    for (String e : this.blackList) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(e);
                    }
                    options.put("jfr.blacklist", sb.toString());
                }
                OutputStreamWriter writer = this.output != null ? new FileWriter(new File(this.output)) : new OutputStreamWriter((OutputStream)System.out, Charset.forName("utf8"));
                SmartJsonWriter jsonGen = new SmartJsonWriter((Writer)writer);
                JsonEventSource jsource = JsonEventDumpHelper.open((InputStreamSource)iss, options);
                jsonGen.writeStartArray();
                try {
                    if (this.listTypes) {
                        DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
                        pp.indentArraysWith((Indenter)new DefaultPrettyPrinter.Lf2SpacesIndenter());
                        jsonGen.setPrettyPrinter((PrettyPrinter)pp);
                        final TreeSet types = new TreeSet();
                        StringWriter sw = new StringWriter();
                        SmartJsonWriter sink = new SmartJsonWriter(sw){

                            public void writeStringField(String fieldName, String value) throws IOException, JsonGenerationException {
                                if ("eventType".equals(fieldName)) {
                                    types.add(value);
                                }
                                super.writeStringField(fieldName, value);
                            }
                        };
                        while (jsource.readNext((JsonStreamWriter)sink)) {
                            sw.getBuffer().setLength(0);
                        }
                        for (String type : types) {
                            jsonGen.writeString(type);
                        }
                    } else {
                        while (jsource.readNext((JsonStreamWriter)jsonGen)) {
                        }
                    }
                }
                finally {
                    jsonGen.writeEndArray();
                    jsonGen.flush();
                    if (writer instanceof FileWriter) {
                        ((Writer)writer).close();
                    }
                }
            }
            catch (IOException e) {
                this.host.fail("", (Exception)e);
            }
        }
    }
}

