/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.nullif;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.nullif.NullIfData;
import org.apache.hop.pipeline.transforms.nullif.NullIfField;
import org.apache.hop.pipeline.transforms.nullif.NullIfMeta;

public class NullIf
extends BaseTransform<NullIfMeta, NullIfData> {
    private static final Class<?> PKG = NullIfMeta.class;

    public NullIf(TransformMeta transformMeta, NullIfMeta meta, NullIfData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((NullIfData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            int fieldsLength = ((NullIfMeta)this.meta).getFields().size();
            ((NullIfData)this.data).keynr = new int[fieldsLength];
            ((NullIfData)this.data).nullValue = new Object[fieldsLength];
            ((NullIfData)this.data).nullValueMeta = new IValueMeta[fieldsLength];
            for (int i = 0; i < fieldsLength; ++i) {
                NullIfField field = ((NullIfMeta)this.meta).getFields().get(i);
                ((NullIfData)this.data).keynr[i] = ((NullIfData)this.data).outputRowMeta.indexOfValue(field.getName());
                if (((NullIfData)this.data).keynr[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"NullIf.Log.CouldNotFindFieldInRow", (String[])new String[]{field.getName()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                ((NullIfData)this.data).nullValueMeta[i] = ((NullIfData)this.data).outputRowMeta.getValueMeta(((NullIfData)this.data).keynr[i]);
                ValueMetaString vms = new ValueMetaString();
                String value = field.getValue() == null ? "" : field.getValue();
                vms.setConversionMask(((NullIfData)this.data).nullValueMeta[i].getConversionMask());
                ((NullIfData)this.data).nullValue[i] = ((NullIfData)this.data).nullValueMeta[i].convertData((IValueMeta)vms, (Object)value);
            }
        }
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"NullIf.Log.ConvertFieldValuesToNullForRow", (String[])new String[0]) + ((NullIfData)this.data).outputRowMeta.getString(r));
        }
        for (int i = 0; i < ((NullIfMeta)this.meta).getFields().size(); ++i) {
            Object field = r[((NullIfData)this.data).keynr[i]];
            if (field == null || ((NullIfData)this.data).nullValueMeta[i].compare(field, ((NullIfData)this.data).nullValue[i]) != 0) continue;
            r[((NullIfData)this.data).keynr[i]] = null;
        }
        this.putRow(((NullIfData)this.data).outputRowMeta, r);
        return true;
    }

    public boolean init() {
        return super.init();
    }
}

